/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.nodes.looks;

import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.openide.TopManager;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class Look
implements Node.Cookie,
Serializable {
    public static final SystemAction[] NO_SYSTEM_ACTIONS = new SystemAction[0];
    public static final NewType[] NO_NEW_TYPES = new NewType[0];
    public static final PasteType[] NO_PASTE_TYPES = new PasteType[0];
    public static final Node.PropertySet[] NO_PROPERTY_SETS = new Node.PropertySet[0];
    public static final Object[] NO_KEYS = new Object[0];
    public static final String ATTR_NAME = "name";
    private static final String TAG_STANDALONE = "Standalone";
    private static final String ATTR_CLASS = "class";
    private String name;
    protected XMLDataObject lookDataObject;
    ArrayList standaloneClasses;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isLookStandalone(Object object) {
        if (this.standaloneClasses == null) {
            if (this.lookDataObject == null) {
                this.standaloneClasses = new ArrayList(0);
            } else {
                try {
                    Element element = this.lookDataObject.getDocument().getDocumentElement();
                    NodeList nodeList = element.getElementsByTagName(TAG_STANDALONE);
                    this.standaloneClasses = new ArrayList(nodeList.getLength());
                    int n = 0;
                    while (n < nodeList.getLength()) {
                        if (nodeList.item(n).getNodeType() == 1) {
                            Element element2 = (Element)nodeList.item(n);
                            String string = element2.getAttribute(ATTR_CLASS);
                            this.standaloneClasses.add(Class.forName(string, true, TopManager.getDefault().systemClassLoader()));
                        }
                        ++n;
                    }
                }
                catch (IOException iOException) {
                    System.out.println(this.name + iOException);
                    return false;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.out.println(this.name + classNotFoundException);
                    return false;
                }
                catch (SAXException sAXException) {
                    System.out.println(this.name + sAXException);
                    return false;
                }
            }
        }
        int n = 0;
        while (n < this.standaloneClasses.size()) {
            if (((Class)this.standaloneClasses.get(n)).isInstance(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void readPropertiesFromXML(XMLDataObject xMLDataObject) {
        this.lookDataObject = xMLDataObject;
        String string = xMLDataObject.getName();
        int n = string.indexOf(36);
        this.setName(string.substring(n + 1));
    }

    public abstract void attachTo(NodeSubstitute var1);

    public abstract Node.Cookie getCookie(NodeSubstitute var1, Class var2);

    public abstract Node.Handle getHandle(NodeSubstitute var1);

    public abstract String getDisplayName(NodeSubstitute var1);

    public abstract String getName(NodeSubstitute var1);

    public abstract void setName(NodeSubstitute var1, String var2);

    public abstract String getShortDescription(NodeSubstitute var1);

    public abstract Image getIcon(NodeSubstitute var1, int var2);

    public abstract Image getOpenedIcon(NodeSubstitute var1, int var2);

    public abstract HelpCtx getHelpCtx(NodeSubstitute var1);

    public abstract Object[] getChildObjects(NodeSubstitute var1);

    public abstract NewType[] getNewTypes(NodeSubstitute var1);

    public abstract SystemAction[] getActions(NodeSubstitute var1);

    public abstract SystemAction[] getContextActions(NodeSubstitute var1);

    public abstract SystemAction getDefaultAction(NodeSubstitute var1);

    public abstract Node.PropertySet[] getPropertySets(NodeSubstitute var1);

    public abstract Component getCustomizer(NodeSubstitute var1);

    public boolean hasCustomizer(NodeSubstitute nodeSubstitute) {
        return this.getCustomizer(nodeSubstitute) != null;
    }

    public abstract boolean canRename(NodeSubstitute var1);

    public abstract boolean canDestroy(NodeSubstitute var1);

    public abstract boolean canCopy(NodeSubstitute var1);

    public abstract boolean canCut(NodeSubstitute var1);

    public abstract PasteType[] getPasteTypes(NodeSubstitute var1, Transferable var2);

    public abstract PasteType getDropType(NodeSubstitute var1, Transferable var2, int var3, int var4);

    public abstract Transferable clipboardCopy(NodeSubstitute var1) throws IOException;

    public abstract Transferable clipboardCut(NodeSubstitute var1) throws IOException;

    public abstract Transferable drag(NodeSubstitute var1) throws IOException;

    public abstract void destroy(NodeSubstitute var1) throws IOException;

    public static abstract class NodeSubstitute {
        public abstract Object getRepresentedObject();

        public abstract void firePropertyChange(String var1, Object var2, Object var3);

        public abstract void fireNameChange(String var1, String var2);

        public abstract void fireDisplayNameChange(String var1, String var2);

        public abstract void fireShortDescriptionChange(String var1, String var2);

        public abstract void fireIconChange();

        public abstract void fireOpenedIconChange();

        public abstract void firePropertySetsChange(Node.PropertySet[] var1, Node.PropertySet[] var2);

        public abstract void fireCookieChange();

        public abstract void fireNodeDestroyed();

        public abstract void refreshChildren();

        public abstract CookieSet getCookieSet();
    }
}

