/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.Format;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.modules.xml.core.Util;
import org.netbeans.modules.xml.core.XMLDataObject;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.TreeName;
import org.netbeans.tax.TreeUtilities;
import org.openide.TopManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.UniFileLoader;
import org.openide.util.MapFormat;
import org.openide.util.actions.SystemAction;

public class XMLDataLoader
extends UniFileLoader {
    private static final long serialVersionUID = 3824119075670384804L;
    private static final String XML_EXT = "xml";
    private static final String XMLINFO_EXT = "xmlinfo";
    static /* synthetic */ Class class$org$openide$actions$EditAction;
    static /* synthetic */ Class class$org$openide$actions$OpenAction;
    static /* synthetic */ Class class$org$openide$actions$ViewAction;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
    static /* synthetic */ Class class$org$netbeans$modules$xml$core$actions$XMLUpdateDocumentAction;
    static /* synthetic */ Class class$org$netbeans$modules$xml$core$actions$CollectXMLAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$RenameAction;
    static /* synthetic */ Class class$org$openide$actions$SaveAsTemplateAction;
    static /* synthetic */ Class class$org$openide$actions$NewAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    public XMLDataLoader() {
        super("org.netbeans.modules.xml.core.XMLDataObject");
    }

    protected void initialize() {
        super.initialize();
        ExtensionList ext = this.getExtensions();
        ext.addExtension(XML_EXT);
        ext.addMimeType("text/xml");
        ext.addMimeType("application/xml");
        this.setExtensions(ext);
    }

    protected SystemAction[] defaultActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$EditAction == null ? (class$org$openide$actions$EditAction = XMLDataLoader.class$("org.openide.actions.EditAction")) : class$org$openide$actions$EditAction)), SystemAction.get((Class)(class$org$openide$actions$OpenAction == null ? (class$org$openide$actions$OpenAction = XMLDataLoader.class$("org.openide.actions.OpenAction")) : class$org$openide$actions$OpenAction)), SystemAction.get((Class)(class$org$openide$actions$ViewAction == null ? (class$org$openide$actions$ViewAction = XMLDataLoader.class$("org.openide.actions.ViewAction")) : class$org$openide$actions$ViewAction)), SystemAction.get((Class)(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = XMLDataLoader.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$xml$core$actions$XMLUpdateDocumentAction == null ? (class$org$netbeans$modules$xml$core$actions$XMLUpdateDocumentAction = XMLDataLoader.class$("org.netbeans.modules.xml.core.actions.XMLUpdateDocumentAction")) : class$org$netbeans$modules$xml$core$actions$XMLUpdateDocumentAction)), SystemAction.get((Class)(class$org$netbeans$modules$xml$core$actions$CollectXMLAction == null ? (class$org$netbeans$modules$xml$core$actions$CollectXMLAction = XMLDataLoader.class$("org.netbeans.modules.xml.core.actions.CollectXMLAction")) : class$org$netbeans$modules$xml$core$actions$CollectXMLAction)), null, SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = XMLDataLoader.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = XMLDataLoader.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = XMLDataLoader.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = XMLDataLoader.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = XMLDataLoader.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction)), null, SystemAction.get((Class)(class$org$openide$actions$SaveAsTemplateAction == null ? (class$org$openide$actions$SaveAsTemplateAction = XMLDataLoader.class$("org.openide.actions.SaveAsTemplateAction")) : class$org$openide$actions$SaveAsTemplateAction)), null, SystemAction.get((Class)(class$org$openide$actions$NewAction == null ? (class$org$openide$actions$NewAction = XMLDataLoader.class$("org.openide.actions.NewAction")) : class$org$openide$actions$NewAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = XMLDataLoader.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = XMLDataLoader.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    protected String defaultDisplayName() {
        return Util.THIS.getString("PROP_XmlLoader_Name");
    }

    protected FileObject findPrimaryFile(FileObject fo) {
        if (fo.isFolder()) {
            return null;
        }
        FileObject res = null;
        if (super.findPrimaryFile(fo) != null) {
            res = fo;
        } else if (XMLINFO_EXT.equals(fo.getExt())) {
            res = FileUtil.findBrother((FileObject)fo, (String)XML_EXT);
        } else if (fo.getMIMEType().endsWith("+xml")) {
            res = fo;
        }
        try {
            if (res != null && res.getFileSystem().isDefault() && DataLoaderPool.getPreferredLoader((FileObject)res) != this && !XMLDataLoader.isTemplate(res)) {
                res = null;
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return res;
    }

    private static boolean isTemplate(FileObject fo) {
        Object o = fo.getAttribute("template");
        boolean ret = false;
        if (o instanceof Boolean) {
            ret = (Boolean)o;
        }
        return ret;
    }

    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException {
        return new XMLDataObject(primaryFile, (MultiFileLoader)this);
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
        return new XMLFileEntry(obj, primaryFile);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject obj, FileObject secondaryFile) {
        return new FileEntry(obj, secondaryFile);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class XMLFileEntry
    extends FileEntry.Format {
        private static final long serialVersionUID = -7300320795693949470L;
        boolean disableInputStream;
        private Collection activeReaders;

        public XMLFileEntry(MultiDataObject obj, FileObject file) {
            super(obj, file);
        }

        protected Format createFormat(FileObject target, String name, String ext) {
            HashMap<String, String> map = new HashMap<String, String>();
            Date now = new Date();
            map.put("NAME", name + "." + ext);
            try {
                TreeName tn = new TreeName(name);
                map.put("ROOT", TreeUtilities.isValidElementTagName((TreeName)tn) ? name : "root");
            }
            catch (InvalidArgumentException ex) {
                map.put("ROOT", "root");
            }
            map.put("DATE", DateFormat.getDateInstance(1).format(now));
            map.put("TIME", DateFormat.getTimeInstance(3).format(now));
            map.put("USER", System.getProperty("user.name"));
            MapFormat format = new MapFormat(map);
            format.setLeftBrace("__");
            format.setRightBrace("__");
            format.setExactMatch(false);
            return format;
        }

        /*
         * WARNING - void declaration
         */
        public FileObject createFromTemplate(FileObject f, String name) throws IOException {
            String ext = this.getFile().getExt();
            if (name == null) {
                name = FileUtil.findFreeFileName((FileObject)f, (String)this.getFile().getName(), (String)ext);
            }
            FileObject fo = f.createData(name, ext);
            Format frm = this.createFormat(f, name, ext);
            BufferedReader r = new BufferedReader(new InputStreamReader(this.getFile().getInputStream(), "UTF8"));
            try {
                FileLock lock = fo.lock();
                try {
                    BufferedWriter w = new BufferedWriter(new OutputStreamWriter(fo.getOutputStream(lock), "UTF8"));
                    try {
                        String current;
                        String line = null;
                        while ((current = r.readLine()) != null) {
                            void var10_11;
                            line = frm.format(var10_11);
                            w.write(line);
                            w.newLine();
                        }
                        Object var12_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_13 = null;
                        w.close();
                        throw throwable;
                    }
                    w.close();
                    Object var14_15 = null;
                }
                catch (Throwable throwable) {
                    Object var14_16 = null;
                    lock.releaseLock();
                    throw throwable;
                }
                lock.releaseLock();
                Object var16_18 = null;
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                r.close();
                throw throwable;
            }
            r.close();
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fo);
            try {
                DataObject.find((FileObject)fo).setTemplate(false);
            }
            catch (DataObjectNotFoundException ex) {
                TopManager.getDefault().notifyException((Throwable)ex);
            }
            return fo;
        }

        private synchronized void addReader(InputStream r) {
            if (this.activeReaders == null) {
                this.activeReaders = new LinkedList();
            }
            this.activeReaders.add(r);
        }

        private synchronized void removeReader(InputStream r) {
            if (this.activeReaders == null) {
                return;
            }
            this.activeReaders.remove(r);
        }

        public void delete() throws IOException {
            XMLFileEntry xMLFileEntry = this;
            synchronized (xMLFileEntry) {
                if (this.activeReaders != null && this.activeReaders.size() > 0) {
                    Iterator it = this.activeReaders.iterator();
                    while (it.hasNext()) {
                        InputStream r = (InputStream)it.next();
                        r.close();
                        it.remove();
                    }
                }
                this.activeReaders = null;
                this.disableInputStream = true;
            }
            super.delete();
        }

        public InputStream getInputStream() throws FileNotFoundException {
            FileObject fob = this.getFile();
            XMLFileEntry xMLFileEntry = this;
            synchronized (xMLFileEntry) {
                if (this.disableInputStream) {
                    throw new FileNotFoundException("File is being deleted.");
                }
                NotifyInputStream s = new NotifyInputStream(fob.getInputStream());
                this.addReader(s);
                NotifyInputStream notifyInputStream = s;
                return notifyInputStream;
            }
        }

        public FileLock takeLock() throws IOException {
            FileLock lock = super.takeLock();
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("XMLDataLoader.XMLEntry.takeLock()/" + this.getFile().getPackageNameExt('/', '.') + "=" + lock);
            }
            return lock;
        }

        private class NotifyInputStream
        extends FilterInputStream {
            public NotifyInputStream(InputStream is) {
                super(is);
            }

            public void close() throws IOException {
                super.close();
                XMLFileEntry.this.removeReader(this);
            }
        }
    }
}

