/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.text;

import java.awt.Container;
import java.awt.Point;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.xml.core.sync.Synchronizator;
import org.netbeans.modules.xml.core.text.TextEditorSupport;
import org.netbeans.modules.xml.core.text.TextRepresentation;
import org.netbeans.modules.xml.core.text.Util;
import org.openide.TopManager;
import org.openide.text.NbDocument;

public class XMLTextRepresentation
extends TextRepresentation {
    public XMLTextRepresentation(TextEditorSupport editor, Synchronizator sync) {
        super(editor, sync);
    }

    public void updateText(Object input) {
        block10: {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("XMLTextRepresentation::updateText");
            }
            final String in = (String)input;
            try {
                TextEditorSupport es = this.editor;
                if (es == null) break block10;
                StyledDocument tmpdoc = es.getDocument();
                if (tmpdoc == null) {
                    tmpdoc = es.openDocument();
                }
                JEditorPane[] eps = es.getOpenedPanes();
                JEditorPane pane = null;
                JViewport port = null;
                int caretPosition = 0;
                Point viewPosition = null;
                if (eps != null) {
                    pane = eps[0];
                    caretPosition = pane.getCaretPosition();
                    port = this.getParentViewport(pane);
                    if (port != null) {
                        viewPosition = port.getViewPosition();
                    }
                }
                final Exception[] taskEx = new Exception[]{null};
                final StyledDocument sdoc = tmpdoc;
                Runnable task = new Runnable(){

                    public void run() {
                        try {
                            sdoc.remove(0, sdoc.getLength());
                            sdoc.insertString(0, in, null);
                        }
                        catch (Exception iex) {
                            taskEx[0] = iex;
                        }
                    }
                };
                NbDocument.runAtomicAsUser((StyledDocument)sdoc, (Runnable)task);
                if (eps != null) {
                    try {
                        pane.setCaretPosition(caretPosition);
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                    port.setViewPosition(viewPosition);
                }
                if (taskEx[0] != null) {
                    throw taskEx[0];
                }
            }
            catch (Exception e) {
                TopManager.getDefault().notifyException((Throwable)e);
            }
        }
    }

    public void update(Object change) {
        if (change instanceof String) {
            String update = (String)change;
            this.updateText(update);
        }
    }

    public boolean isModified() {
        return false;
    }

    private JViewport getParentViewport(JEditorPane component) {
        Container pc = component.getParent();
        return pc instanceof JViewport ? (JViewport)pc : null;
    }
}

