/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.openide.awt.JPopupMenuUtils;

public class JInlineMenu
extends JMenuItem {
    static final long serialVersionUID = -2310488127953523571L;
    private JSeparator north = new JSeparator();
    private JSeparator south = new JSeparator();
    private JComponent[] items = new JComponent[0];
    boolean upToDate;
    private List addedItems;

    public JInlineMenu() {
        this.setEnabled(false);
        this.upToDate = true;
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void setMenuItems(JMenuItem[] jMenuItemArray) {
        JComponent[] jComponentArray = new JComponent[jMenuItemArray.length];
        int n = 0;
        while (n < jMenuItemArray.length) {
            jComponentArray[n] = jMenuItemArray[n] != null ? jMenuItemArray[n] : new JSeparator();
            ++n;
        }
        this.items = jComponentArray;
        this.upToDate = false;
        Container container = this.getParent();
        while (container instanceof JInlineMenu) {
            ((JInlineMenu)container).upToDate = false;
            container = container.getParent();
        }
        if (this.isShowing()) {
            SwingUtilities.invokeLater(new Updater());
        }
    }

    public void addNotify() {
        super.addNotify();
        if (!this.upToDate) {
            SwingUtilities.invokeLater(new Updater());
        }
    }

    static void prepareItemsInContainer(Container container) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JInlineMenu) {
                ((JInlineMenu)componentArray[n]).doUpdate();
            }
            ++n;
        }
    }

    private void doUpdate() {
        Object object = this.getClientProperty("hack.preShowUpdater");
        if (object instanceof Runnable) {
            ((Runnable)object).run();
        }
        this.updateContents();
    }

    private void updateContents() {
        Container container = this.getParent();
        if (!this.upToDate && container != null) {
            if (!(container instanceof JInlineMenu)) {
                int n = 0;
                while (n < this.items.length) {
                    Object object = this.items[n].getClientProperty("hack.preShowUpdater");
                    if (object instanceof Runnable) {
                        ((Runnable)object).run();
                    }
                    ++n;
                }
                this.removeItems();
                this.addItems();
            }
            this.upToDate = true;
        }
    }

    private void removeItems() {
        JComponent jComponent = (JComponent)this.getParent();
        if (jComponent == null) {
            return;
        }
        if (jComponent instanceof JInlineMenu) {
            ((JInlineMenu)jComponent).removeItems();
            return;
        }
        if (this.addedItems != null) {
            Iterator iterator = this.addedItems.iterator();
            while (iterator.hasNext()) {
                jComponent.remove((Component)iterator.next());
            }
        }
        jComponent.remove(this.north);
        jComponent.remove(this.south);
        this.addedItems = null;
    }

    private void getAllInlineItems(List list) {
        int n = 0;
        while (n < this.items.length) {
            JComponent jComponent = this.items[n];
            if (jComponent instanceof JInlineMenu) {
                ((JInlineMenu)jComponent).getAllInlineItems(list);
            } else {
                list.add(jComponent);
            }
            ++n;
        }
    }

    private static int findIndex(Object object, Object[] objectArray) {
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (object == objectArray[n2]) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    void addItems() {
        JComponent jComponent = (JComponent)this.getParent();
        if (jComponent == null) {
            return;
        }
        boolean bl = false;
        if (jComponent instanceof JPopupMenu) {
            bl = JPopupMenuUtils.isPopupContained((JPopupMenu)jComponent);
        }
        ArrayList arrayList = new ArrayList(this.items.length);
        this.getAllInlineItems(arrayList);
        JComponent[] jComponentArray = arrayList.toArray(new JComponent[arrayList.size()]);
        this.addedItems = arrayList;
        Object[] objectArray = jComponent.getComponents();
        int n = JInlineMenu.findIndex(this, objectArray);
        if (n == -1) {
            return;
        }
        if (n > 0 && objectArray.length > 0 && !(objectArray[n - 1] instanceof JSeparator) && !(objectArray[n - 1] instanceof JInlineMenu)) {
            jComponent.add((Component)this.north, n++);
            objectArray = jComponent.getComponents();
        }
        if (n < objectArray.length - 1) {
            if (jComponentArray.length > 0 && !(objectArray[n + 1] instanceof JPopupMenu.Separator) && !(objectArray[n + 1] instanceof JSeparator)) {
                jComponent.add((Component)this.south, n + 1);
            } else if (jComponentArray.length == 0 && (objectArray[n + 1] instanceof JPopupMenu.Separator || objectArray[n + 1] instanceof JSeparator)) {
                jComponent.remove(n + 1);
                objectArray = jComponent.getComponents();
            }
        }
        if (n > objectArray.length) {
            int n2 = jComponentArray.length;
            int n3 = 0;
            while (n3 < n2) {
                jComponent.add(jComponentArray[n3]);
                ++n3;
            }
        } else {
            int n4 = jComponentArray.length;
            int n5 = 0;
            while (n5 < n4) {
                jComponent.add((Component)jComponentArray[n5], ++n);
                if (jComponentArray[n5] instanceof JInlineMenu) {
                    JInlineMenu jInlineMenu = (JInlineMenu)jComponentArray[n5];
                    n += jInlineMenu.items.length;
                }
                ++n5;
            }
        }
        if (jComponent instanceof JPopupMenu && jComponent.isShowing()) {
            JPopupMenuUtils.dynamicChange((JPopupMenu)jComponent, bl);
        } else {
            jComponent.invalidate();
        }
    }

    private class Updater
    implements Runnable {
        private Updater() {
        }

        public void run() {
            JInlineMenu.this.updateContents();
        }
    }
}

