/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.PasteAction;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ClipboardEvent;
import org.openide.util.datatransfer.ClipboardListener;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;

public class ExplorerActions {
    private ActionPerformer copyActionPerformer;
    private ActionPerformer cutActionPerformer;
    private ActionPerformer deleteActionPerformer;
    private ActionStateUpdater actionStateUpdater;
    private ExplorerManager manager;
    private boolean confirmDelete = true;
    private static CopyAction copy = null;
    private static CutAction cut = null;
    private static DeleteAction delete = null;
    private static PasteAction paste = null;
    private static boolean isConfirmed;
    private static String title;
    private static String message;
    private static ThreadLocal destroyRunnable;
    private static ThreadLocal selectedNodes;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$java$awt$datatransfer$Clipboard;

    public synchronized void attach(ExplorerManager explorerManager) {
        if (this.manager != null) {
            this.detach();
        }
        this.manager = explorerManager;
        if (this.actionStateUpdater == null) {
            this.actionStateUpdater = new ActionStateUpdater();
        }
        this.manager.addPropertyChangeListener(this.actionStateUpdater);
        Clipboard clipboard = ExplorerActions.getClipboard();
        if (clipboard instanceof ExClipboard) {
            ExClipboard exClipboard = (ExClipboard)clipboard;
            exClipboard.addClipboardListener(this.actionStateUpdater);
        }
        this.updateActions();
    }

    public synchronized void detach() {
        if (this.manager == null) {
            return;
        }
        this.manager.removePropertyChangeListener(this.actionStateUpdater);
        Clipboard clipboard = ExplorerActions.getClipboard();
        if (clipboard instanceof ExClipboard) {
            ExClipboard exClipboard = (ExClipboard)clipboard;
            exClipboard.removeClipboardListener(this.actionStateUpdater);
        }
        this.stopActions();
        this.manager = null;
    }

    ExplorerManager getAttachedManager() {
        return this.manager;
    }

    public final void setConfirmDelete(boolean bl) {
        this.confirmDelete = bl;
    }

    public final boolean isConfirmDelete() {
        return this.confirmDelete;
    }

    private void stopActions() {
        if (this.copyActionPerformer != null) {
            if (copy.getActionPerformer() instanceof CopyCutActionPerformer) {
                copy.setActionPerformer(null);
            }
            if (cut.getActionPerformer() instanceof CopyCutActionPerformer) {
                cut.setActionPerformer(null);
            }
            paste.setPasteTypes(null);
            if (delete.getActionPerformer() instanceof DeleteActionPerformer) {
                delete.setActionPerformer(null);
            }
        }
    }

    private void updateActions() {
        int n;
        if (this.manager == null) {
            return;
        }
        Node[] nodeArray = this.manager.getSelectedNodes();
        if (this.copyActionPerformer == null) {
            this.copyActionPerformer = new CopyCutActionPerformer(true);
            this.cutActionPerformer = new CopyCutActionPerformer(false);
            this.deleteActionPerformer = new DeleteActionPerformer();
            copy = (CopyAction)SharedClassObject.findObject(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = ExplorerActions.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction, true);
            cut = (CutAction)SharedClassObject.findObject(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = ExplorerActions.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction, true);
            paste = (PasteAction)SharedClassObject.findObject(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = ExplorerActions.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction, true);
            delete = (DeleteAction)SharedClassObject.findObject(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = ExplorerActions.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction, true);
        }
        int n2 = n = nodeArray != null ? nodeArray.length : 0;
        if (n > 0) {
            int n3;
            boolean bl = false;
            if (n > 1) {
                HashMap hashMap = new HashMap(101);
                n3 = 0;
                while (n3 < n) {
                    if (!this.checkParents(nodeArray[n3], hashMap)) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
            }
            n3 = 0;
            while (n3 < n) {
                if (bl || !nodeArray[n3].canCopy()) {
                    copy.setActionPerformer(null);
                    break;
                }
                ++n3;
            }
            if (n3 == n) {
                copy.setActionPerformer(this.copyActionPerformer);
            }
            n3 = 0;
            while (n3 < n) {
                if (bl || !nodeArray[n3].canCut()) {
                    cut.setActionPerformer(null);
                    break;
                }
                ++n3;
            }
            if (n3 == n) {
                cut.setActionPerformer(this.cutActionPerformer);
            }
            n3 = 0;
            while (n3 < n) {
                if (bl || !nodeArray[n3].canDestroy()) {
                    delete.setActionPerformer(null);
                    break;
                }
                ++n3;
            }
            if (n3 == n) {
                delete.setActionPerformer(this.deleteActionPerformer);
            }
        } else {
            copy.setActionPerformer(null);
            cut.setActionPerformer(null);
            delete.setActionPerformer(null);
        }
        this.updatePasteAction(nodeArray);
    }

    private boolean checkParents(Node node, HashMap hashMap) {
        if (hashMap.get(node) != null) {
            return false;
        }
        hashMap.put(node, this);
        do {
            if ((node = node.getParentNode()) != null) continue;
            return true;
        } while (hashMap.put(node, node) != this);
        return false;
    }

    private void updatePasteAction(Node[] nodeArray) {
        ExplorerManager explorerManager = this.manager;
        if (explorerManager == null) {
            paste.setPasteTypes(null);
            return;
        }
        if (nodeArray != null && nodeArray.length > 1) {
            paste.setPasteTypes(null);
            return;
        }
        Node node = explorerManager.getExploredContext();
        Node[] nodeArray2 = explorerManager.getSelectedNodes();
        if (nodeArray2 != null && nodeArray2.length == 1) {
            node = nodeArray2[0];
        }
        final Node node2 = node;
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                Clipboard clipboard = ExplorerActions.getClipboard();
                Transferable transferable = clipboard.getContents(this);
                SwingUtilities.invokeLater(new Runnable(this, transferable){
                    private final /* synthetic */ Transferable val$trans;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$trans = transferable;
                    }

                    public void run() {
                        ExplorerActions.access$400(1.access$300(this.this$1), this.val$trans, 1.access$200(this.this$1));
                    }
                });
            }

            static /* synthetic */ Node access$200(1 var0) {
                return var0.node2;
            }

            static /* synthetic */ ExplorerActions access$300(1 var0) {
                return var0.ExplorerActions.this;
            }
        });
    }

    private void updatePasteTypes(Transferable transferable, Node node) {
        if (transferable != null) {
            PasteType[] pasteTypeArray;
            PasteType[] pasteTypeArray2 = pasteTypeArray = node == null ? new PasteType[]{} : node.getPasteTypes(transferable);
            if (pasteTypeArray.length != 0) {
                paste.setPasteTypes(pasteTypeArray);
                return;
            }
            boolean bl = false;
            try {
                bl = transferable.isDataFlavorSupported(ExTransferable.multiFlavor);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                try {
                    MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
                    int n = multiTransferObject.getCount();
                    boolean bl2 = true;
                    Transferable[] transferableArray = new Transferable[n];
                    PasteType[] pasteTypeArray3 = new PasteType[n];
                    int n2 = 0;
                    while (n2 < n) {
                        transferableArray[n2] = multiTransferObject.getTransferableAt(n2);
                        PasteType[] pasteTypeArray4 = pasteTypeArray = node == null ? new PasteType[]{} : node.getPasteTypes(transferableArray[n2]);
                        if (pasteTypeArray.length == 0) {
                            bl2 = false;
                            break;
                        }
                        pasteTypeArray3[n2] = pasteTypeArray[0];
                        ++n2;
                    }
                    if (bl2) {
                        paste.setPasteTypes(new PasteType[]{new MultiPasteType(transferableArray, pasteTypeArray3)});
                        return;
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (paste != null) {
            paste.setPasteTypes(null);
        }
    }

    private static Clipboard getClipboard() {
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(class$java$awt$datatransfer$Clipboard == null ? (class$java$awt$datatransfer$Clipboard = ExplorerActions.class$("java.awt.datatransfer.Clipboard")) : class$java$awt$datatransfer$Clipboard);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return clipboard;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ void access$400(ExplorerActions explorerActions, Transferable transferable, Node node) {
        explorerActions.updatePasteTypes(transferable, node);
    }

    static {
        destroyRunnable = new ThreadLocal();
        selectedNodes = new ThreadLocal();
    }

    private class ActionStateUpdater
    implements PropertyChangeListener,
    ClipboardListener,
    ActionListener {
        private Timer timer = new Timer(150, this);

        ActionStateUpdater() {
            this.timer.setCoalesce(true);
            this.timer.setRepeats(false);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.timer.start();
        }

        public void clipboardChanged(ClipboardEvent clipboardEvent) {
            if (!clipboardEvent.isConsumed()) {
                ExplorerActions.this.updatePasteAction(ExplorerActions.this.manager.getSelectedNodes());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExplorerActions.this.updateActions();
            this.timer.stop();
        }
    }

    static class ConfirmationInvoker
    implements Runnable {
        static /* synthetic */ Class class$org$openide$loaders$DataShadow;
        static /* synthetic */ Class class$org$openide$explorer$ExplorerActions;
        static /* synthetic */ Class class$org$openide$loaders$DataFolder;

        ConfirmationInvoker() {
        }

        public void run() {
            Object object;
            Node[] nodeArray = (Node[])selectedNodes.get();
            selectedNodes.set(null);
            if (nodeArray == null) {
                throw new IllegalStateException("ConfirmationInvoker didn't get parameter sel.");
            }
            if (nodeArray.length == 1) {
                if (nodeArray[0].getCookie(class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = ConfirmationInvoker.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow) != null) {
                    title = NbBundle.getMessage(ConfirmationInvoker.class$org$openide$explorer$ExplorerActions == null ? (ConfirmationInvoker.class$org$openide$explorer$ExplorerActions = ConfirmationInvoker.class$("org.openide.explorer.ExplorerActions")) : ConfirmationInvoker.class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteShadowTitle");
                    object = (DataShadow)nodeArray[0].getCookie(class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = ConfirmationInvoker.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow);
                    message = NbBundle.getMessage(ConfirmationInvoker.class$org$openide$explorer$ExplorerActions == null ? (ConfirmationInvoker.class$org$openide$explorer$ExplorerActions = ConfirmationInvoker.class$("org.openide.explorer.ExplorerActions")) : ConfirmationInvoker.class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteShadow", new Object[]{((DataObject)object).getName(), nodeArray[0].getDisplayName(), this.fullName((DataObject)object), this.fullName(((DataShadow)object).getOriginal())});
                } else if (nodeArray[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = ConfirmationInvoker.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder) != null) {
                    message = NbBundle.getMessage(ConfirmationInvoker.class$org$openide$explorer$ExplorerActions == null ? (ConfirmationInvoker.class$org$openide$explorer$ExplorerActions = ConfirmationInvoker.class$("org.openide.explorer.ExplorerActions")) : ConfirmationInvoker.class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteFolder", nodeArray[0].getDisplayName());
                    title = NbBundle.getMessage(ConfirmationInvoker.class$org$openide$explorer$ExplorerActions == null ? (ConfirmationInvoker.class$org$openide$explorer$ExplorerActions = ConfirmationInvoker.class$("org.openide.explorer.ExplorerActions")) : ConfirmationInvoker.class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteFolderTitle");
                } else {
                    message = NbBundle.getMessage(ConfirmationInvoker.class$org$openide$explorer$ExplorerActions == null ? (ConfirmationInvoker.class$org$openide$explorer$ExplorerActions = ConfirmationInvoker.class$("org.openide.explorer.ExplorerActions")) : ConfirmationInvoker.class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteObject", nodeArray[0].getDisplayName());
                    title = NbBundle.getMessage(ConfirmationInvoker.class$org$openide$explorer$ExplorerActions == null ? (ConfirmationInvoker.class$org$openide$explorer$ExplorerActions = ConfirmationInvoker.class$("org.openide.explorer.ExplorerActions")) : ConfirmationInvoker.class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteObjectTitle");
                }
            } else {
                message = NbBundle.getMessage(ConfirmationInvoker.class$org$openide$explorer$ExplorerActions == null ? (ConfirmationInvoker.class$org$openide$explorer$ExplorerActions = ConfirmationInvoker.class$("org.openide.explorer.ExplorerActions")) : ConfirmationInvoker.class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteObjects", new Integer(nodeArray.length));
                title = NbBundle.getMessage(ConfirmationInvoker.class$org$openide$explorer$ExplorerActions == null ? (ConfirmationInvoker.class$org$openide$explorer$ExplorerActions = ConfirmationInvoker.class$("org.openide.explorer.ExplorerActions")) : ConfirmationInvoker.class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteObjectsTitle");
            }
            object = new NotifyDescriptor.Confirmation((Object)message, title, 0);
            isConfirmed = NotifyDescriptor.YES_OPTION.equals(TopManager.getDefault().notify((NotifyDescriptor)object));
        }

        private String fullName(DataObject dataObject) {
            FileObject fileObject = dataObject.getPrimaryFile();
            if (fileObject.isRoot()) {
                try {
                    return fileObject.getFileSystem().getDisplayName();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    return "";
                }
            }
            return fileObject.toString();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    static class DestroyInvoker
    implements Runnable {
        static /* synthetic */ Class class$org$openide$filesystems$FileSystem$AtomicAction;

        DestroyInvoker() {
        }

        public void run() {
            Object t = destroyRunnable.get();
            destroyRunnable.set(null);
            if (t == null) {
                throw new IllegalStateException("DestroyInvoker didn't get parameter dr.");
            }
            try {
                FileSystem.AtomicAction atomicAction = (FileSystem.AtomicAction)Proxy.newProxyInstance((class$org$openide$filesystems$FileSystem$AtomicAction == null ? (class$org$openide$filesystems$FileSystem$AtomicAction = DestroyInvoker.class$("org.openide.filesystems.FileSystem$AtomicAction")) : class$org$openide$filesystems$FileSystem$AtomicAction).getClassLoader(), new Class[]{class$org$openide$filesystems$FileSystem$AtomicAction == null ? (class$org$openide$filesystems$FileSystem$AtomicAction = DestroyInvoker.class$("org.openide.filesystems.FileSystem$AtomicAction")) : class$org$openide$filesystems$FileSystem$AtomicAction}, (InvocationHandler)t);
                TopManager.getDefault().getRepository().getDefaultFileSystem().runAtomicAction(atomicAction);
                return;
            }
            catch (IOException iOException) {
                IllegalStateException illegalStateException = new IllegalStateException();
                ErrorManager.getDefault().annotate((Throwable)illegalStateException, iOException);
                throw illegalStateException;
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private class DeleteActionPerformer
    implements ActionPerformer {
        private DeleteActionPerformer() {
        }

        public void performAction(SystemAction systemAction) {
            Node[] nodeArray = ExplorerActions.this.manager.getSelectedNodes();
            if (nodeArray == null || nodeArray.length == 0) {
                return;
            }
            isConfirmed = !ExplorerActions.this.confirmDelete;
            if (!isConfirmed) {
                selectedNodes.set(nodeArray);
                this.doConfirm();
            }
            if (isConfirmed) {
                try {
                    if (ExplorerActions.this.manager != null) {
                        ExplorerActions.this.manager.setSelectedNodes(new Node[0]);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this.doDestroy(nodeArray);
                delete.setActionPerformer(null);
            }
        }

        private void doConfirm() {
            try {
                Class<?> clazz = Class.forName("org.openide.explorer.ExplorerActions$ConfirmationInvoker");
                Runnable runnable = (Runnable)clazz.newInstance();
                runnable.run();
                return;
            }
            catch (Exception exception) {
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
            int n = JOptionPane.showConfirmDialog(null, message, title, 0);
            isConfirmed = n == 0;
        }

        private void doDestroy(Node[] nodeArray) {
            DestroyAtomic destroyAtomic = new DestroyAtomic();
            destroyAtomic.sel = nodeArray;
            destroyRunnable.set(destroyAtomic);
            try {
                Class<?> clazz = Class.forName("org.openide.explorer.ExplorerActions$DestroyInvoker");
                Runnable runnable = (Runnable)clazz.newInstance();
                runnable.run();
                return;
            }
            catch (IllegalStateException illegalStateException) {
                throw illegalStateException;
            }
            catch (Exception exception) {
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
            try {
                destroyAtomic.invoke(null, null, null);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(exception);
            }
        }

        private class DestroyAtomic
        implements InvocationHandler {
            Node[] sel;

            private DestroyAtomic() {
            }

            public Object invoke(Object object, Method method, Object[] objectArray) throws Exception {
                int n = 0;
                while (n < this.sel.length) {
                    try {
                        this.sel[n].destroy();
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(iOException);
                    }
                    ++n;
                }
                return null;
            }
        }
    }

    private class CopyCutActionPerformer
    implements ActionPerformer {
        private boolean copyCut;

        public CopyCutActionPerformer(boolean bl) {
            this.copyCut = bl;
        }

        public void performAction(SystemAction systemAction) {
            Transferable[] transferableArray;
            Transferable transferable = null;
            Node[] nodeArray = ExplorerActions.this.manager.getSelectedNodes();
            if (nodeArray.length != 1) {
                transferableArray = new Transferable[nodeArray.length];
                int n = 0;
                while (n < nodeArray.length) {
                    transferableArray[n] = this.getTransferableOwner(nodeArray[n]);
                    if (transferableArray[n] == null) {
                        return;
                    }
                    ++n;
                }
                transferable = new ExTransferable.Multi(transferableArray);
            } else {
                transferable = this.getTransferableOwner(nodeArray[0]);
            }
            if (transferable != null) {
                transferableArray = ExplorerActions.getClipboard();
                transferableArray.setContents(transferable, new StringSelection(""));
            }
        }

        private Transferable getTransferableOwner(Node node) {
            try {
                return this.copyCut ? node.clipboardCopy() : node.clipboardCut();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, iOException);
                return null;
            }
        }
    }

    private static class MultiPasteType
    extends PasteType {
        Transferable[] t;
        PasteType[] p;

        MultiPasteType(Transferable[] transferableArray, PasteType[] pasteTypeArray) {
            this.t = transferableArray;
            this.p = pasteTypeArray;
        }

        public Transferable paste() throws IOException {
            int n = this.p.length;
            Transferable[] transferableArray = new Transferable[n];
            int n2 = 0;
            while (n2 < n) {
                Transferable transferable = this.p[n2].paste();
                transferableArray[n2] = transferable != null ? transferable : this.t[n2];
                ++n2;
            }
            return new ExTransferable.Multi(transferableArray);
        }
    }
}

