/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.MessageFormat;
import org.openide.explorer.ExplorerActions;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.SafeException;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class ExplorerPanel
extends TopComponent
implements ExplorerManager.Provider {
    static final long serialVersionUID = 5522528786650751459L;
    private static MessageFormat formatExplorerTitle;
    private ExplorerManager manager;
    private transient PropertyChangeListener managerListener;
    private static final ExplorerActions actions;
    static /* synthetic */ Class class$org$openide$explorer$ExplorerPanel;

    static ExplorerActions getActions() {
        return actions;
    }

    public ExplorerPanel(ExplorerManager explorerManager) {
        this();
        this.manager = explorerManager;
    }

    public ExplorerPanel() {
        this.setLayout(new BorderLayout());
    }

    public void open() {
        this.open(WindowManager.getDefault().getCurrentWorkspace());
    }

    public void open(Workspace workspace) {
        super.open(workspace);
        if (this.managerListener == null) {
            this.managerListener = new PropL();
            this.getExplorerManager().addPropertyChangeListener(this.managerListener);
        }
        this.setActivatedNodes(this.getExplorerManager().getSelectedNodes());
        this.updateTitle();
    }

    public boolean canClose(Workspace workspace, boolean bl) {
        boolean bl2 = super.canClose(workspace, bl);
        if (bl2 && bl) {
            this.getExplorerManager().removePropertyChangeListener(this.managerListener);
            this.managerListener = null;
        }
        return bl2;
    }

    public ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            ExplorerPanel explorerPanel = this;
            synchronized (explorerPanel) {
                if (this.manager == null) {
                    this.manager = new ExplorerManager();
                }
            }
        }
        return this.manager;
    }

    protected void componentActivated() {
        actions.attach(this.getExplorerManager());
    }

    protected void componentDeactivated() {
        if (this.getExplorerManager() == actions.getAttachedManager()) {
            actions.detach();
        }
    }

    protected void updateTitle() {
        String string;
        Node node;
        String string2 = "";
        ExplorerManager explorerManager = this.getExplorerManager();
        if (explorerManager != null && (node = explorerManager.getExploredContext()) != null && (string = node.getDisplayName()) != null) {
            string2 = string;
        }
        if (formatExplorerTitle == null) {
            formatExplorerTitle = new MessageFormat(NbBundle.getMessage(class$org$openide$explorer$ExplorerPanel == null ? (class$org$openide$explorer$ExplorerPanel = ExplorerPanel.class$("org.openide.explorer.ExplorerPanel")) : class$org$openide$explorer$ExplorerPanel, "explorerTitle"));
        }
        this.setName(formatExplorerTitle.format(new Object[]{string2}));
    }

    public HelpCtx getHelpCtx() {
        return ExplorerPanel.getHelpCtx(this.getExplorerManager().getSelectedNodes(), new HelpCtx(class$org$openide$explorer$ExplorerPanel == null ? (class$org$openide$explorer$ExplorerPanel = ExplorerPanel.class$("org.openide.explorer.ExplorerPanel")) : class$org$openide$explorer$ExplorerPanel));
    }

    public static HelpCtx getHelpCtx(Node[] nodeArray, HelpCtx helpCtx) {
        HelpCtx helpCtx2 = null;
        int n = 0;
        while (n < nodeArray.length) {
            HelpCtx helpCtx3 = nodeArray[n].getHelpCtx();
            if (helpCtx3 != null && !helpCtx3.equals(HelpCtx.DEFAULT_HELP)) {
                if (helpCtx2 == null || helpCtx2.equals(helpCtx3)) {
                    helpCtx2 = helpCtx3;
                } else {
                    helpCtx2 = null;
                    break;
                }
            }
            ++n;
        }
        if (helpCtx2 != null) {
            return helpCtx2;
        }
        return helpCtx;
    }

    public static void setConfirmDelete(boolean bl) {
        actions.setConfirmDelete(bl);
    }

    public static boolean isConfirmDelete() {
        return actions.isConfirmDelete();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(new NbMarshalledObject(this.manager));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        Object object = objectInput.readObject();
        if (object instanceof ExplorerManager) {
            this.manager = (ExplorerManager)object;
            return;
        }
        NbMarshalledObject nbMarshalledObject = (NbMarshalledObject)object;
        try {
            this.manager = (ExplorerManager)nbMarshalledObject.get();
        }
        catch (SafeException safeException) {
            throw safeException;
        }
        catch (IOException iOException) {
            throw new SafeException(iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        actions = new ExplorerActions();
    }

    private final class PropL
    implements PropertyChangeListener {
        PropL() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                ExplorerPanel.this.setActivatedNodes(ExplorerPanel.this.manager.getSelectedNodes());
                return;
            }
            if ("exploredContext".equals(propertyChangeEvent.getPropertyName())) {
                ExplorerPanel.this.updateTitle();
                return;
            }
        }
    }
}

