/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import org.openide.ErrorManager;
import org.openide.awt.JPopupMenuPlus;
import org.openide.awt.MouseUtils;
import org.openide.awt.SplittedPanel;
import org.openide.explorer.propertysheet.EmptyPanel;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.NamesPanel;
import org.openide.explorer.propertysheet.PropertyDialogManager;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.explorer.propertysheet.PropertySheetTab;
import org.openide.explorer.propertysheet.ProxyNode;
import org.openide.explorer.propertysheet.SheetButton;
import org.openide.explorer.propertysheet.SheetButtonListener;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;

class PropertySheetTab
extends JPanel
implements PropertyChangeListener {
    private NamesPanel namesPanel;
    private NamesPanel valuesPanel;
    private Node.PropertySet properties;
    private Node node;
    private HashMap modelCache;
    private boolean changeInProgress;
    private SettingsListener settingsListener;
    private Comparator sorter;
    private int sortingMode;
    private PropertySheet mySheet;
    private PropertyChangeListener propertyChangeListener;
    private static final Comparator SORTER_TYPE = new Comparator(){

        public int compare(Object object, Object object2) {
            Class clazz;
            String string;
            if (!(object instanceof Node.Property)) {
                throw new IllegalArgumentException("Can compare only Node.Property instances.");
            }
            if (!(object2 instanceof Node.Property)) {
                throw new IllegalArgumentException("Can compare only Node.Property instances.");
            }
            Class clazz2 = ((Node.Property)object).getValueType();
            String string2 = clazz2 != null ? clazz2.getName() : "";
            int n = string2.compareToIgnoreCase(string = (clazz = ((Node.Property)object2).getValueType()) != null ? clazz.getName() : "");
            if (n != 0) {
                return n;
            }
            string2 = ((Node.Property)object).getDisplayName();
            string = ((Node.Property)object2).getDisplayName();
            return string2.compareToIgnoreCase(string);
        }
    };
    private static final Comparator SORTER_NAME = new Comparator(){

        public int compare(Object object, Object object2) {
            if (!(object instanceof Node.Property)) {
                throw new IllegalArgumentException("Can compare only Node.Property instances.");
            }
            if (!(object2 instanceof Node.Property)) {
                throw new IllegalArgumentException("Can compare only Node.Property instances.");
            }
            String string = ((Node.Property)object).getDisplayName();
            String string2 = ((Node.Property)object2).getDisplayName();
            return String.CASE_INSENSITIVE_ORDER.compare(string, string2);
        }
    };
    private JPopupMenu popupMenu;
    private boolean paneCreated;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$SetDefaultValueAction;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$PropertySheetTab;

    public PropertySheetTab(Node.PropertySet propertySet, Node node, PropertySheet propertySheet) {
        this.properties = propertySet;
        this.node = node;
        this.modelCache = new HashMap();
        this.mySheet = propertySheet;
        this.setLayout(new BorderLayout());
        this.add((Component)new EmptyPanel(propertySet.getDisplayName()), "Center");
        try {
            this.setSortingMode(propertySheet.getSortingMode());
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().notify(propertyVetoException);
        }
        this.settingsListener = new SettingsListener();
        propertySheet.addPropertyChangeListener(WeakListener.propertyChange(this.settingsListener, propertySheet));
        this.propertyChangeListener = WeakListener.propertyChange(this, node);
        node.addPropertyChangeListener(this.propertyChangeListener);
    }

    void detachPropertyChangeListener() {
        this.node.removePropertyChangeListener(this.propertyChangeListener);
    }

    void setActions(final Node.Property property) {
        final CallbackSystemAction callbackSystemAction = (CallbackSystemAction)SystemAction.get(class$org$openide$explorer$propertysheet$SetDefaultValueAction == null ? (class$org$openide$explorer$propertysheet$SetDefaultValueAction = PropertySheetTab.class$("org.openide.explorer.propertysheet.SetDefaultValueAction")) : class$org$openide$explorer$propertysheet$SetDefaultValueAction);
        if (property.supportsDefaultValue() && property.canWrite()) {
            callbackSystemAction.setActionPerformer(new ActionPerformer(){

                public void performAction(SystemAction systemAction) {
                    try {
                        property.restoreDefaultValue();
                        if (PropertySheetTab.this.propertyChangeListener != null) {
                            PropertySheetTab.this.propertyChangeListener.propertyChange(new PropertyChangeEvent(this, property.getName(), null, null));
                        }
                    }
                    catch (Exception exception) {
                        callbackSystemAction.setActionPerformer(null);
                    }
                }
            });
        } else {
            callbackSystemAction.setActionPerformer(null);
        }
    }

    void ensurePaneCreated() {
        if (!this.paneCreated) {
            this.createPane();
        }
    }

    private void createPane() {
        this.paneCreated = true;
        Component component = this.getComponent(0);
        if (this.properties.getProperties().length == 0) {
            if (component != null && component instanceof EmptyPanel) {
                return;
            }
            this.removeAll();
            this.add((Component)new EmptyPanel(this.properties.getDisplayName()), "Center");
            this.invalidate();
            this.validate();
            this.repaint();
            return;
        }
        if (this.namesPanel == null) {
            this.namesPanel = new NamesPanel();
            this.valuesPanel = new NamesPanel(this.namesPanel);
        } else {
            this.namesPanel.removeAll();
            this.valuesPanel.removeAll();
        }
        if (component == null || !(component instanceof JScrollPane)) {
            this.removeAll();
            JScrollPane jScrollPane = new JScrollPane();
            ScrollableSplittedPanel scrollableSplittedPanel = new ScrollableSplittedPanel(jScrollPane, this.namesPanel);
            scrollableSplittedPanel.add((Component)this.namesPanel, SplittedPanel.ADD_LEFT);
            scrollableSplittedPanel.add((Component)this.valuesPanel, SplittedPanel.ADD_RIGHT);
            scrollableSplittedPanel.setSplitAbsolute(true);
            jScrollPane.setViewportView(scrollableSplittedPanel);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(25);
            this.add((Component)jScrollPane, "Center");
        }
        this.fillProperties();
    }

    private void fillProperties() {
        Node.Property[] propertyArray = this.properties.getProperties();
        ArrayList<Node.Property> arrayList = new ArrayList<Node.Property>(propertyArray.length);
        int n = 0;
        while (n < propertyArray.length) {
            if (!this.mySheet.getDisplayWritableOnly() || propertyArray[n].canWrite()) {
                arrayList.add(propertyArray[n]);
            }
            ++n;
        }
        if (this.sorter != null) {
            Collections.sort(arrayList, this.sorter);
        }
        Object[] objectArray = new Object[]{this.node};
        if (this.node instanceof ProxyNode) {
            objectArray = ((ProxyNode)this.node).getOriginalNodes();
        }
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            final Node.Property property = (Node.Property)iterator.next();
            class LazyToolTipSheetButton
            extends SheetButton {
                private String toolTipText;
                private final /* synthetic */ Node.Property val$prop;
                private final /* synthetic */ PropertySheetTab this$0;

                public LazyToolTipSheetButton(PropertySheetTab propertySheetTab, Node.Property property) {
                    super(property.getDisplayName(), false, true);
                    this.this$0 = propertySheetTab;
                    this.val$prop = property;
                    this.toolTipText = null;
                    this.setToolTipText("dummy");
                }

                public String getToolTipText(MouseEvent mouseEvent) {
                    if (this.toolTipText == null) {
                        this.toolTipText = PropertySheetTab.access$100(this.val$prop);
                    }
                    return this.toolTipText;
                }
            }
            final LazyToolTipSheetButton lazyToolTipSheetButton = new LazyToolTipSheetButton(this, property);
            lazyToolTipSheetButton.setFocusTraversable(false);
            this.namesPanel.add(lazyToolTipSheetButton);
            PropertyPanel propertyPanel = new PropertyPanel(property, objectArray);
            this.modelCache.put(property.getName(), propertyPanel.getModel());
            this.valuesPanel.add(propertyPanel);
            ButtonListener buttonListener = new ButtonListener(lazyToolTipSheetButton, propertyPanel);
            propertyPanel.addSheetButtonListener(buttonListener);
            lazyToolTipSheetButton.addSheetButtonListener(buttonListener);
            lazyToolTipSheetButton.setPlastic(propertyPanel.getPlastic());
            if (property.canWrite()) {
                lazyToolTipSheetButton.setActiveForeground(this.mySheet.getValueColor());
            } else {
                lazyToolTipSheetButton.setActiveForeground(this.mySheet.getDisabledPropertyColor());
            }
            lazyToolTipSheetButton.addMouseListener(new MouseUtils.PopupMouseAdapter(){

                public void showPopup(MouseEvent mouseEvent) {
                    if (MouseUtils.isRightMouseButton(mouseEvent)) {
                        PropertySheetTab.this.setActions(property);
                        PropertySheetTab.this.createPopup();
                        PropertySheetTab.this.popupMenu.show(lazyToolTipSheetButton, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
            propertyPanel.addSheetButtonListener(new InstallPerformerListener(propertyPanel));
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    void setPlastic(boolean bl) {
        int n = this.namesPanel.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.namesPanel.getComponent(n2) instanceof SheetButton) {
                ((SheetButton)this.namesPanel.getComponent(n2)).setPlastic(bl);
            }
            ++n2;
        }
        n = this.valuesPanel.getComponentCount();
        int n3 = 0;
        while (n3 < n) {
            if (this.valuesPanel.getComponent(n3) instanceof PropertyPanel) {
                ((PropertyPanel)this.valuesPanel.getComponent(n3)).setPlastic(bl);
            }
            ++n3;
        }
    }

    void setForegroundColor(Color color) {
        int n = this.namesPanel.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.namesPanel.getComponent(n2) instanceof SheetButton) {
                ((SheetButton)this.namesPanel.getComponent(n2)).setActiveForeground(color);
            }
            ++n2;
        }
        n = this.valuesPanel.getComponentCount();
        int n3 = 0;
        while (n3 < n) {
            if (this.valuesPanel.getComponent(n3) instanceof PropertyPanel) {
                ((PropertyPanel)this.valuesPanel.getComponent(n3)).setForegroundColor(color);
            }
            ++n3;
        }
    }

    void setDisabledColor(Color color) {
        int n = this.namesPanel.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.namesPanel.getComponent(n2) instanceof SheetButton) {
                ((SheetButton)this.namesPanel.getComponent(n2)).setInactiveForeground(color);
            }
            ++n2;
        }
        n = this.valuesPanel.getComponentCount();
        int n3 = 0;
        while (n3 < n) {
            if (this.valuesPanel.getComponent(n3) instanceof PropertyPanel) {
                ((PropertyPanel)this.valuesPanel.getComponent(n3)).setDisabledColor(color);
            }
            ++n3;
        }
    }

    void setPaintingStyle(int n) {
        int n2 = this.valuesPanel.getComponentCount();
        int n3 = 0;
        while (n3 < n2) {
            if (this.valuesPanel.getComponent(n3) instanceof PropertyPanel) {
                ((PropertyPanel)this.valuesPanel.getComponent(n3)).setPaintingStyle(n);
            }
            ++n3;
        }
    }

    public void setSortingMode(int n) throws PropertyVetoException {
        switch (n) {
            case 0: {
                this.sorter = null;
                break;
            }
            case 1: {
                this.sorter = SORTER_NAME;
                break;
            }
            case 2: {
                this.sorter = SORTER_TYPE;
                break;
            }
            default: {
                throw new PropertyVetoException(PropertySheetTab.getString("EXC_Unknown_sorting_mode"), new PropertyChangeEvent(this, "sortingMode", new Integer(this.sortingMode), new Integer(n)));
            }
        }
        int n2 = this.sortingMode;
        this.sortingMode = n;
        this.firePropertyChange("sortingMode", n2, this.sortingMode);
    }

    public int getSortingMode() {
        return this.sortingMode;
    }

    String getHelpID() {
        return (String)this.properties.getValue("helpID");
    }

    private static String getString(String string) {
        return NbBundle.getBundle(class$org$openide$explorer$propertysheet$PropertySheetTab == null ? (class$org$openide$explorer$propertysheet$PropertySheetTab = PropertySheetTab.class$("org.openide.explorer.propertysheet.PropertySheetTab")) : class$org$openide$explorer$propertysheet$PropertySheetTab).getString(string);
    }

    private static String getToolTipTextForProperty(Node.Property property) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(property.canRead() ? PropertySheetTab.getString("CTL_Property_Read_Yes") : PropertySheetTab.getString("CTL_Property_Read_No"));
        stringBuffer.append(property.canWrite() ? PropertySheetTab.getString("CTL_Property_Write_Yes") : PropertySheetTab.getString("CTL_Property_Write_No"));
        stringBuffer.append(' ');
        String string = property.getShortDescription();
        stringBuffer.append(string != null ? string : property.getDisplayName());
        return stringBuffer.toString();
    }

    private void doPropertyChange(String string) {
        if (this.changeInProgress) {
            return;
        }
        PropertyModel propertyModel = (PropertyModel)this.modelCache.get(string);
        if (propertyModel == null) {
            return;
        }
        if (propertyModel instanceof PropertyPanel.SimpleModel) {
            PropertyPanel.SimpleModel simpleModel = (PropertyPanel.SimpleModel)propertyModel;
            try {
                this.changeInProgress = true;
                simpleModel.fireValueChanged();
                Object var5_4 = null;
                this.changeInProgress = false;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.changeInProgress = false;
                throw throwable;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() != null && propertyChangeEvent.getSource().equals(this.node)) {
            this.doPropertyChange(propertyChangeEvent.getPropertyName());
        } else {
            Node.Property[] propertyArray = this.properties.getProperties();
            int n = 0;
            while (n < propertyArray.length) {
                this.doPropertyChange(propertyArray[n].getName());
                ++n;
            }
        }
    }

    private void createPopup() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenuPlus();
            CallbackSystemAction callbackSystemAction = (CallbackSystemAction)SystemAction.get(class$org$openide$explorer$propertysheet$SetDefaultValueAction == null ? (class$org$openide$explorer$propertysheet$SetDefaultValueAction = PropertySheetTab.class$("org.openide.explorer.propertysheet.SetDefaultValueAction")) : class$org$openide$explorer$propertysheet$SetDefaultValueAction);
            this.popupMenu.add(callbackSystemAction.getPopupPresenter());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ String access$100(Node.Property property) {
        return PropertySheetTab.getToolTipTextForProperty(property);
    }

    private class ScrollableSplittedPanel
    extends SplittedPanel
    implements Scrollable {
        private Component scroll;
        private Container element;

        ScrollableSplittedPanel(Component component, Container container) {
            this.scroll = component;
            this.element = container;
            this.setSplitPosition(PropertySheetTab.this.mySheet.getSavedPosition());
        }

        public Dimension getPreferredScrollableViewportSize() {
            return super.getPreferredSize();
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            Component[] componentArray = this.element.getComponents();
            if (componentArray.length < 1) {
                return 1;
            }
            Dimension dimension = componentArray[0].getSize();
            if (n == 1) {
                return dimension.height;
            }
            return dimension.width;
        }

        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            if (n == 1) {
                return this.scroll.getSize().height;
            }
            return this.scroll.getSize().width;
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public void setSplitPosition(int n) {
            super.setSplitPosition(n);
            PropertySheetTab.this.mySheet.setSavedPosition(n);
        }
    }

    final class SettingsListener
    implements PropertyChangeListener {
        SettingsListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null) {
                return;
            }
            if (string.equals("sortingMode")) {
                try {
                    PropertySheetTab.this.setSortingMode((Integer)propertyChangeEvent.getNewValue());
                    if (PropertySheetTab.this.paneCreated) {
                        PropertySheetTab.this.createPane();
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    PropertyDialogManager.notify(propertyVetoException);
                }
            } else if (string.equals("displayWritableOnly")) {
                if (PropertySheetTab.this.paneCreated) {
                    PropertySheetTab.this.createPane();
                }
            } else if (string.equals("valueColor")) {
                PropertySheetTab.this.setForegroundColor((Color)propertyChangeEvent.getNewValue());
            } else if (string.equals("disabledPropertyColor")) {
                PropertySheetTab.this.setDisabledColor((Color)propertyChangeEvent.getNewValue());
            } else if (string.equals("plastic")) {
                PropertySheetTab.this.setPlastic((Boolean)propertyChangeEvent.getNewValue());
            } else if (string.equals("propertyPaintingStyle")) {
                PropertySheetTab.this.setPaintingStyle((Integer)propertyChangeEvent.getNewValue());
            }
        }
    }

    private final class ButtonListener
    implements SheetButtonListener {
        private SheetButton b;
        private PropertyPanel p;

        public ButtonListener(SheetButton sheetButton, PropertyPanel propertyPanel) {
            this.b = sheetButton;
            this.p = propertyPanel;
        }

        public void sheetButtonClicked(ActionEvent actionEvent) {
            if ("rightMouseActionCommand".equals(actionEvent.getActionCommand())) {
                if (this.p.isWriteState()) {
                    this.p.setReadState();
                }
                return;
            }
            if (actionEvent.getSource() == this.b) {
                if (actionEvent.getID() == 1003) {
                    this.p.tryToSelectNextTag();
                } else if (this.p.isWriteState()) {
                    this.p.setReadState();
                    this.p.requestDefaultFocus();
                } else {
                    this.p.setWriteState();
                }
            }
        }

        public void sheetButtonEntered(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.b) {
                if (this.p.getReadComponent() != null) {
                    this.p.getReadComponent().setPressed(true);
                }
            } else {
                this.b.setPressed(true);
            }
        }

        public void sheetButtonExited(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.b) {
                if (this.p.getReadComponent() != null) {
                    this.p.getReadComponent().setPressed(false);
                }
            } else {
                this.b.setPressed(false);
            }
        }
    }

    private final class InstallPerformerListener
    implements SheetButtonListener {
        private CallbackSystemAction csa;
        private PopupPerformer performer;
        private PropertyPanel panel;
        static /* synthetic */ Class class$org$openide$actions$PopupAction;

        public InstallPerformerListener(PropertyPanel propertyPanel) {
            this.panel = propertyPanel;
        }

        public void sheetButtonClicked(ActionEvent actionEvent) {
        }

        public void sheetButtonEntered(ActionEvent actionEvent) {
            if (this.csa == null) {
                this.csa = (CallbackSystemAction)SystemAction.get(class$org$openide$actions$PopupAction == null ? (class$org$openide$actions$PopupAction = InstallPerformerListener.class$("org.openide.actions.PopupAction")) : class$org$openide$actions$PopupAction);
                this.performer = new PopupPerformer(this.panel);
            }
            this.csa.setActionPerformer(this.performer);
        }

        public void sheetButtonExited(ActionEvent actionEvent) {
            if (this.csa != null && this.csa.getActionPerformer() instanceof PopupPerformer) {
                this.csa.setActionPerformer(null);
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private final class PopupPerformer
    implements ActionPerformer {
        private PropertyPanel panel;

        public PopupPerformer(PropertyPanel propertyPanel) {
            this.panel = propertyPanel;
        }

        public void performAction(SystemAction systemAction) {
            Mutex.EVENT.readAccess(new Runnable(this){
                private final /* synthetic */ PopupPerformer this$1;
                {
                    this.this$1 = popupPerformer;
                }

                public void run() {
                    ExPropertyModel exPropertyModel;
                    FeatureDescriptor featureDescriptor;
                    PropertyModel propertyModel = PopupPerformer.access$400(this.this$1).getModel();
                    if (propertyModel instanceof ExPropertyModel && (featureDescriptor = (exPropertyModel = (ExPropertyModel)propertyModel).getFeatureDescriptor()) instanceof Node.Property) {
                        Node.Property property = (Node.Property)featureDescriptor;
                        PopupPerformer.access$500(this.this$1).setActions(property);
                        PropertySheetTab.access$200(PopupPerformer.access$500(this.this$1));
                        PropertySheetTab.access$300(PopupPerformer.access$500(this.this$1)).show(PopupPerformer.access$400(this.this$1), 0, 0);
                    }
                }
            });
        }

        static /* synthetic */ PropertyPanel access$400(PopupPerformer popupPerformer) {
            return popupPerformer.panel;
        }

        static /* synthetic */ PropertySheetTab access$500(PopupPerformer popupPerformer) {
            return popupPerformer.PropertySheetTab.this;
        }
    }
}

