/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class NodeTableModel
extends AbstractTableModel {
    private static final String ATTR_INVISIBLE = "InvisibleInTreeTableView";
    static final String ATTR_COMPARABLE_COLUMN = "ComparableColumnTTV";
    static final String ATTR_SORTING_COLUMN = "SortingColumnTTV";
    static final String ATTR_DESCENDING_ORDER = "DescendingOrderTTV";
    private static final String ATTR_ORDER_NUMBER = "OrderNumberTTV";
    private static final String ATTR_TREE_COLUMN = "TreeColumnTTV";
    private ArrayColumn[] allPropertyColumns = new ArrayColumn[0];
    private int[] propertyColumns = new int[0];
    private Node[] nodeRows = new Node[0];
    private int sortColumn = -1;
    private boolean existsComparableColumn = false;
    private Node.Property treeColumnProperty = null;
    private PropertyChangeListener pcl = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            int n = NodeTableModel.this.rowForNode((Node)propertyChangeEvent.getSource());
            if (n == -1) {
                return;
            }
            int n2 = NodeTableModel.this.columnForProperty(propertyChangeEvent.getPropertyName());
            if (n2 == -1) {
                NodeTableModel.this.fireTableRowsUpdated(n, n);
            } else {
                NodeTableModel.this.fireTableCellUpdated(n, n2);
            }
        }
    };
    static /* synthetic */ Class class$org$openide$nodes$Node$Property;
    static /* synthetic */ Class class$org$openide$explorer$view$NodeTableModel;

    public void setNodes(Node[] nodeArray) {
        int n = 0;
        while (n < this.nodeRows.length) {
            this.nodeRows[n].removePropertyChangeListener(this.pcl);
            ++n;
        }
        this.nodeRows = nodeArray;
        int n2 = 0;
        while (n2 < this.nodeRows.length) {
            this.nodeRows[n2].addPropertyChangeListener(this.pcl);
            ++n2;
        }
        this.fireTableDataChanged();
    }

    public void setProperties(Node.Property[] propertyArray) {
        int n = propertyArray.length;
        int n2 = -1;
        int n3 = 0;
        while (n3 < propertyArray.length) {
            Object object = propertyArray[n3].getValue(ATTR_TREE_COLUMN);
            if (object != null && object instanceof Boolean && ((Boolean)object).booleanValue()) {
                this.treeColumnProperty = propertyArray[n3];
                --n;
                n2 = n3;
            }
            ++n3;
        }
        this.allPropertyColumns = new ArrayColumn[n];
        int n4 = 0;
        this.existsComparableColumn = false;
        TreeMap<Double, Integer> treeMap = new TreeMap<Double, Integer>();
        int n5 = 0;
        int n6 = 0;
        while (n5 < propertyArray.length) {
            if (n5 != n2) {
                Object object;
                this.allPropertyColumns[n6] = new ArrayColumn();
                this.allPropertyColumns[n6].setProperty(propertyArray[n5]);
                if (this.isVisible(propertyArray[n5])) {
                    ++n4;
                    object = propertyArray[n5].getValue(ATTR_ORDER_NUMBER);
                    if (object != null && object instanceof Integer) {
                        treeMap.put(new Double(((Integer)object).doubleValue()), new Integer(n6));
                    } else {
                        treeMap.put(new Double((double)n6 + 0.1), new Integer(n6));
                    }
                } else {
                    this.allPropertyColumns[n6].setVisibleIndex(-1);
                    object = propertyArray[n5].getValue(ATTR_SORTING_COLUMN);
                    if (object != null && object instanceof Boolean) {
                        propertyArray[n5].setValue(ATTR_SORTING_COLUMN, Boolean.FALSE);
                    }
                }
                if (!this.existsComparableColumn && (object = propertyArray[n5].getValue(ATTR_COMPARABLE_COLUMN)) != null && object instanceof Boolean) {
                    this.existsComparableColumn = (Boolean)object;
                }
                ++n6;
            }
            ++n5;
        }
        this.propertyColumns = new int[n4];
        int n7 = 0;
        Iterator iterator = treeMap.values().iterator();
        while (iterator.hasNext()) {
            n5 = (Integer)iterator.next();
            this.allPropertyColumns[n5].setVisibleIndex(n7);
            this.propertyColumns[n7] = n5;
            ++n7;
        }
        this.fireTableStructureChanged();
    }

    private void computeVisiblePorperties(int n) {
        int n2;
        this.propertyColumns = new int[n];
        TreeMap<Double, Integer> treeMap = new TreeMap<Double, Integer>();
        int n3 = 0;
        while (n3 < this.allPropertyColumns.length) {
            n2 = this.allPropertyColumns[n3].getVisibleIndex();
            if (n2 == -1) {
                treeMap.put(new Double((double)n3 - 0.1), new Integer(n3));
            } else {
                treeMap.put(new Double(n2), new Integer(n3));
            }
            ++n3;
        }
        n2 = 0;
        Iterator iterator = treeMap.values().iterator();
        while (iterator.hasNext()) {
            int n4 = (Integer)iterator.next();
            Node.Property property = this.allPropertyColumns[n4].getProperty();
            if (this.isVisible(property)) {
                this.propertyColumns[n2] = n4;
                this.allPropertyColumns[n4].setVisibleIndex(n2);
                ++n2;
                continue;
            }
            this.allPropertyColumns[n4].setVisibleIndex(-1);
            Object object = property.getValue(ATTR_SORTING_COLUMN);
            if (object == null || !(object instanceof Boolean) || !((Boolean)object).booleanValue()) continue;
            property.setValue(ATTR_SORTING_COLUMN, Boolean.FALSE);
            property.setValue(ATTR_DESCENDING_ORDER, Boolean.FALSE);
        }
        this.fireTableStructureChanged();
    }

    int getVisibleColumnWidth(int n) {
        return this.allPropertyColumns[this.propertyColumns[n]].getWidth();
    }

    int getArrayColumnWidth(int n) {
        return this.allPropertyColumns[n].getWidth();
    }

    void setVisibleColumnWidth(int n, int n2) {
        this.allPropertyColumns[this.propertyColumns[n]].setWidth(n2);
    }

    void setArrayColumnWidth(int n, int n2) {
        this.allPropertyColumns[n].setWidth(n2);
    }

    int getVisibleIndex(int n) {
        return this.allPropertyColumns[n].getVisibleIndex();
    }

    int getArrayIndex(int n) {
        int n2 = 0;
        while (n2 < this.allPropertyColumns.length) {
            if (this.allPropertyColumns[n2].getVisibleIndex() == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    boolean isComparableColumn(int n) {
        Node.Property property = this.allPropertyColumns[this.propertyColumns[n]].getProperty();
        Object object = property.getValue(ATTR_COMPARABLE_COLUMN);
        if (object != null && object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    boolean existsComparableColumn() {
        return this.existsComparableColumn;
    }

    boolean isSortingColumn(int n) {
        Node.Property property = this.allPropertyColumns[this.propertyColumns[n]].getProperty();
        Object object = property.getValue(ATTR_SORTING_COLUMN);
        if (object != null && object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    void setSortingColumn(int n) {
        Node.Property property;
        if (this.sortColumn != -1) {
            property = this.allPropertyColumns[this.sortColumn].getProperty();
            property.setValue(ATTR_SORTING_COLUMN, Boolean.FALSE);
            property.setValue(ATTR_DESCENDING_ORDER, Boolean.FALSE);
        }
        if (n != -1) {
            this.sortColumn = this.propertyColumns[n];
            property = this.allPropertyColumns[this.sortColumn].getProperty();
            property.setValue(ATTR_SORTING_COLUMN, Boolean.TRUE);
        } else {
            this.sortColumn = -1;
        }
    }

    int getVisibleSortingColumn() {
        if (this.sortColumn == -1) {
            int n = 0;
            while (n < this.propertyColumns.length) {
                if (this.isSortingColumn(n)) {
                    this.sortColumn = this.propertyColumns[n];
                    return n;
                }
                ++n;
            }
        } else {
            if (this.isVisible(this.allPropertyColumns[this.sortColumn].getProperty())) {
                return this.getVisibleIndex(this.sortColumn);
            }
            this.sortColumn = -1;
        }
        return -1;
    }

    boolean isSortOrderDescending() {
        if (this.sortColumn == -1) {
            return false;
        }
        Node.Property property = this.allPropertyColumns[this.sortColumn].getProperty();
        Object object = property.getValue(ATTR_DESCENDING_ORDER);
        if (object != null && object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    void setSortOrderDescending(boolean bl) {
        if (this.sortColumn != -1) {
            Node.Property property = this.allPropertyColumns[this.sortColumn].getProperty();
            property.setValue(ATTR_DESCENDING_ORDER, new Boolean(bl));
        }
    }

    protected Node.Property getPropertyFor(Node node, Node.Property property) {
        Node.PropertySet[] propertySetArray = node.getPropertySets();
        int n = 0;
        while (n < propertySetArray.length) {
            Node.Property[] propertyArray = propertySetArray[n].getProperties();
            int n2 = 0;
            while (n2 < propertyArray.length) {
                if (property.equals(propertyArray[n2])) {
                    return propertyArray[n2];
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    Node nodeForRow(int n) {
        return this.nodeRows[n];
    }

    Node.Property propertyForColumn(int n) {
        if (n == -1) {
            return this.treeColumnProperty;
        }
        return this.allPropertyColumns[this.propertyColumns[n]].getProperty();
    }

    int getArrayColumnCount() {
        return this.allPropertyColumns.length;
    }

    private int rowForNode(Node node) {
        int n = 0;
        while (n < this.nodeRows.length) {
            if (node.equals(this.nodeRows[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int columnForProperty(String string) {
        int n = 0;
        while (n < this.propertyColumns.length) {
            if (this.allPropertyColumns[this.propertyColumns[n]].getProperty().getName().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private boolean isVisible(Node.Property property) {
        Object object = property.getValue(ATTR_INVISIBLE);
        if (object != null && object instanceof Boolean) {
            return (Boolean)object == false;
        }
        return true;
    }

    private void setVisible(Node.Property property, boolean bl) {
        property.setValue(ATTR_INVISIBLE, new Boolean(!bl));
    }

    public int getRowCount() {
        return this.nodeRows.length;
    }

    public int getColumnCount() {
        return this.propertyColumns.length;
    }

    public Object getValueAt(int n, int n2) {
        return this.getPropertyFor(this.nodeRows[n], this.allPropertyColumns[this.propertyColumns[n2]].getProperty());
    }

    public boolean isCellEditable(int n, int n2) {
        return this.getValueAt(n, n2) != null;
    }

    public Class getColumnClass(int n) {
        return class$org$openide$nodes$Node$Property == null ? (class$org$openide$nodes$Node$Property = NodeTableModel.class$("org.openide.nodes.Node$Property")) : class$org$openide$nodes$Node$Property;
    }

    public String getColumnName(int n) {
        return this.allPropertyColumns[this.propertyColumns[n]].getProperty().getDisplayName();
    }

    boolean selectVisibleColumns(String string, String string2, String string3) {
        Object object;
        String string4;
        boolean bl = false;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        ArrayList<Object> arrayList = new ArrayList<Object>(this.allPropertyColumns.length);
        boolean[] blArray = new boolean[this.allPropertyColumns.length];
        int[] nArray = new int[this.allPropertyColumns.length];
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(12, 12, 0, 12);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        JLabel jLabel = new JLabel(NbBundle.getBundle(class$org$openide$explorer$view$NodeTableModel == null ? (class$org$openide$explorer$view$NodeTableModel = NodeTableModel.class$("org.openide.explorer.view.NodeTableModel")) : class$org$openide$explorer$view$NodeTableModel).getString("LBL_ColumnDialogDesc"));
        jPanel.add((Component)jLabel, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(12, 12, 0, 12);
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.weightx = 1.0;
        JCheckBox jCheckBox = new JCheckBox(string2 + ": " + string3, true);
        jCheckBox.setEnabled(false);
        jPanel.add((Component)jCheckBox, gridBagConstraints3);
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        int n = 0;
        while (n < this.allPropertyColumns.length) {
            blArray[n] = this.isVisible(this.allPropertyColumns[n].getProperty());
            string4 = this.allPropertyColumns[n].getProperty().getDisplayName() + ": " + this.allPropertyColumns[n].getProperty().getShortDescription();
            treeMap.put(string4, new Integer(n));
            ++n;
        }
        Iterator iterator = treeMap.keySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            string4 = (String)iterator.next();
            int n3 = (Integer)treeMap.get(string4);
            object = new JCheckBox(string4, blArray[n3]);
            nArray[n2] = n3;
            jPanel.add((Component)object, gridBagConstraints);
            arrayList.add(object);
            ++n2;
        }
        String string5 = NbBundle.getBundle(class$org$openide$explorer$view$NodeTableModel == null ? (class$org$openide$explorer$view$NodeTableModel = NodeTableModel.class$("org.openide.explorer.view.NodeTableModel")) : class$org$openide$explorer$view$NodeTableModel).getString("LBL_ColumnDialogTitle");
        if (string != null && string.length() > 0) {
            string5 = string + " - " + string5;
        }
        object = new DialogDescriptor((Object)jPanel, string5, true, 2, NotifyDescriptor.OK_OPTION, 0, null, null);
        Dialog dialog = TopManager.getDefault().createDialog((DialogDescriptor)object);
        dialog.show();
        if (((NotifyDescriptor)object).getValue().equals(NotifyDescriptor.OK_OPTION)) {
            int n4 = arrayList.size();
            int n5 = 0;
            int n6 = 0;
            while (n6 < n4) {
                JCheckBox jCheckBox2 = (JCheckBox)arrayList.get(n6);
                n2 = nArray[n6];
                if (jCheckBox2.isSelected() != blArray[n2]) {
                    this.setVisible(this.allPropertyColumns[n2].getProperty(), jCheckBox2.isSelected());
                    bl = true;
                }
                if (jCheckBox2.isSelected()) {
                    ++n5;
                }
                ++n6;
            }
            if (bl) {
                this.computeVisiblePorperties(n5);
            }
        }
        return bl;
    }

    void moveColumn(int n, int n2) {
        int n3;
        int n4 = this.propertyColumns[n];
        this.propertyColumns[n] = n3 = this.propertyColumns[n2];
        this.propertyColumns[n2] = n4;
        this.allPropertyColumns[n4].setVisibleIndex(n2);
        this.allPropertyColumns[n3].setVisibleIndex(n);
        this.sortColumn = -1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ArrayColumn {
        private Node.Property property;
        private int width;
        private int visibleIndex;

        private ArrayColumn() {
        }

        public Node.Property getProperty() {
            return this.property;
        }

        public void setProperty(Node.Property property) {
            this.property = property;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int n) {
            this.width = n;
        }

        public int getVisibleIndex() {
            return this.visibleIndex;
        }

        public void setVisibleIndex(int n) {
            this.visibleIndex = n;
            this.property.setValue(NodeTableModel.ATTR_ORDER_NUMBER, new Integer(n));
        }
    }
}

