/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.tree.TreePath;
import org.openide.ErrorManager;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.DropGlassPane;
import org.openide.explorer.view.ExplorerDnDManager;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.TreeViewCellEditor;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.datatransfer.PasteType;

final class TreeViewDropSupport
implements DropTargetListener,
Runnable {
    boolean active = false;
    boolean dropTargetPopupAllowed;
    DropTarget dropTarget;
    Rectangle lastNodeArea;
    int toIndex = -1;
    Timer timer;
    DropGlassPane dropPane;
    private Component oldGlassPane;
    protected static final int FUSSY_POINTING = 3;
    private static final int DELAY_TIME_FOR_EXPAND = 1000;
    private static final int SHIFT_DOWN = -1;
    private static final int SHIFT_RIGHT = 10;
    private static final int SHIFT_LEFT = 15;
    private int pointAt = 0;
    protected TreeView view;
    protected JTree tree;
    static /* synthetic */ Class class$org$openide$nodes$Index;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public TreeViewDropSupport(TreeView treeView, JTree jTree, boolean bl) {
        this.view = treeView;
        this.tree = jTree;
        this.dropTargetPopupAllowed = bl;
    }

    public void setDropTargetPopupAllowed(boolean bl) {
        this.dropTargetPopupAllowed = bl;
    }

    public boolean isDropTargetPopupAllowed() {
        return this.dropTargetPopupAllowed;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (this.oldGlassPane == null) {
            this.oldGlassPane = this.tree.getRootPane().getGlassPane();
        }
        this.dropPane = DropGlassPane.getDefault(this.tree);
        this.tree.getRootPane().setGlassPane(this.dropPane);
        this.dropPane.setOpaque(false);
        this.dropPane.setVisible(true);
        this.doDragOver(dropTargetDragEvent);
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.doDragOver(dropTargetDragEvent);
    }

    private void doDragOver(DropTargetDragEvent dropTargetDragEvent) {
        Object object;
        Object object2;
        TreePath treePath = this.getTreePath(dropTargetDragEvent);
        if (treePath == null) {
            dropTargetDragEvent.rejectDrag();
            this.stopDragging();
            return;
        }
        Point point = dropTargetDragEvent.getLocation();
        Node node = this.getNodeForDrop(point);
        if (node == null) {
            dropTargetDragEvent.rejectDrag();
            this.stopDragging();
            return;
        }
        Rectangle rectangle = this.tree.getPathBounds(treePath);
        int n = rectangle.x + rectangle.width;
        int n2 = this.tree.getRowForPath(treePath);
        if (rectangle != null) {
            this.pointAt = 0;
            if (point.y <= rectangle.y + 3) {
                if (n2 != 0) {
                    this.pointAt = -1;
                    object2 = this.tree.getPathForRow(n2 - 1);
                    if (object2 != null && !((TreePath)object2).equals(treePath)) {
                        n = Math.max(rectangle.x + rectangle.width, this.tree.getPathBounds((TreePath)object2).x + this.tree.getPathBounds((TreePath)object2).width);
                    }
                    if (node.getParentNode() != null) {
                        node = node.getParentNode();
                        treePath = null;
                    }
                }
            } else if (point.y >= rectangle.y + rectangle.height - 3 && !this.view.isExpanded(node)) {
                this.pointAt = 1;
                object2 = this.tree.getPathForRow(n2 + 1);
                if (object2 != null && !((TreePath)object2).equals(treePath)) {
                    n = Math.max(rectangle.x + rectangle.width, this.tree.getPathBounds((TreePath)object2).x + this.tree.getPathBounds((TreePath)object2).width);
                }
                if (node.getParentNode() != null) {
                    node = node.getParentNode();
                    treePath = null;
                }
            }
        }
        n += 10;
        object2 = (Index)node.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = TreeViewDropSupport.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
        this.toIndex = -1;
        if (object2 != null) {
            if (this.pointAt == -1) {
                this.toIndex = object2.indexOf(this.getNodeForDrop(point));
            } else if (this.pointAt == 1) {
                this.toIndex = object2.indexOf(this.getNodeForDrop(point)) + 1;
            }
        }
        if (!(this.timer != null && this.timer.isRunning() || node == null || node.isLeaf() || this.view.isExpanded(node))) {
            object = node;
            this.removeTimer();
            this.timer = new Timer(1000, new ActionListener((Node)object){
                private final /* synthetic */ Node val$cn;
                {
                    this.val$cn = node;
                }

                public final void actionPerformed(ActionEvent actionEvent) {
                    TreeViewDropSupport.this.view.expandNode(this.val$cn);
                }
            });
            this.timer.setRepeats(false);
            this.timer.start();
        }
        if (this.pointAt == 0) {
            this.dropPane.setDropLine(null);
        } else if (this.pointAt == -1) {
            object = new Line2D.Double(rectangle.x - 15, rectangle.y + -1, n, rectangle.y + -1);
            this.convertBoundsAndSetDropLine((Line2D)object);
            Rectangle rectangle2 = new Rectangle(rectangle.x - 15, rectangle.y + -1 - 3, n - rectangle.x + 15, 5);
            rectangle = (Rectangle)rectangle.createUnion(rectangle2);
        } else {
            object = new Line2D.Double(rectangle.x - 15, rectangle.y + rectangle.height + -1, n, rectangle.y + rectangle.height + -1);
            this.convertBoundsAndSetDropLine((Line2D)object);
            Rectangle rectangle3 = new Rectangle(rectangle.x - 15, rectangle.y + rectangle.height, n - rectangle.x + 15, 2);
            rectangle = (Rectangle)rectangle.createUnion(rectangle3);
        }
        if (this.lastNodeArea != null && !this.lastNodeArea.equals(rectangle)) {
            NodeRenderer.dragExit();
            this.repaint(this.lastNodeArea);
        }
        if (!rectangle.equals(this.lastNodeArea)) {
            if (treePath != null) {
                NodeRenderer.dragEnter(treePath.getLastPathComponent());
            }
            this.repaint(rectangle);
            this.lastNodeArea = rectangle;
            this.removeTimer();
        }
        if (this.canDrop(node, dropTargetDragEvent.getDropAction())) {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        } else if (this.canReorder(node, ExplorerDnDManager.getDefault().getDraggedNodes())) {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    private void repaint(Rectangle rectangle) {
        this.tree.repaint(rectangle.x - 5, rectangle.y - 5, rectangle.width + 10, rectangle.height + 10);
    }

    private void convertBoundsAndSetDropLine(Line2D line2D) {
        int n = (int)line2D.getX1();
        int n2 = (int)line2D.getX2();
        int n3 = (int)line2D.getY1();
        int n4 = (int)line2D.getY2();
        Point point = SwingUtilities.convertPoint(this.tree, n, n3, this.tree.getRootPane());
        Point point2 = SwingUtilities.convertPoint(this.tree, n2, n4, this.tree.getRootPane());
        line2D.setLine(point, point2);
        this.dropPane.setDropLine(line2D);
    }

    private void removeTimer() {
        if (this.timer != null) {
            ActionListener[] actionListenerArray = (ActionListener[])this.timer.getListeners(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = TreeViewDropSupport.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
            int n = 0;
            while (n < actionListenerArray.length) {
                this.timer.removeActionListener(actionListenerArray[n]);
                ++n;
            }
            this.timer.stop();
            this.timer = null;
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        Node[] nodeArray = ExplorerDnDManager.getDefault().getDraggedNodes();
        int n = dropTargetDragEvent.getDropAction();
        int n2 = 0;
        while (n2 < nodeArray.length) {
            if (!DragDropUtilities.checkNodeForAction(nodeArray[n2], n)) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
            ++n2;
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.oldGlassPane != null) {
            final Component component = this.oldGlassPane;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TreeViewDropSupport.this.tree.getRootPane().setGlassPane(component);
                }
            });
            this.oldGlassPane = null;
        }
        DropGlassPane.getDefault(this.tree).setVisible(false);
        this.stopDragging();
    }

    private void stopDragging() {
        this.dropPane.setDropLine(null);
        this.removeTimer();
        if (this.lastNodeArea != null) {
            NodeRenderer.dragExit();
            this.repaint(this.lastNodeArea);
            this.lastNodeArea = null;
        }
    }

    private Node getNodeForDrop(Point point) {
        TreePath treePath;
        if (point != null && (treePath = this.tree.getPathForLocation(point.x, point.y)) != null) {
            return DragDropUtilities.secureFindNode(treePath.getLastPathComponent());
        }
        return null;
    }

    private boolean canReorder(Node node, Node[] nodeArray) {
        if (ExplorerDnDManager.getDefault().getAllowedDragActions() != 2) {
            return false;
        }
        if (node == null || nodeArray.length == 0) {
            return false;
        }
        Index index = (Index)node.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = TreeViewDropSupport.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
        if (index == null) {
            return false;
        }
        int n = 0;
        while (n < nodeArray.length) {
            if (nodeArray[n] == null) {
                return false;
            }
            if (nodeArray[n].getParentNode() == null) {
                return false;
            }
            if (!nodeArray[n].getParentNode().equals(node)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void performReorder(Node node, Node[] nodeArray, int n) {
        try {
            if (n != -1) {
                Index index = (Index)node.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = TreeViewDropSupport.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
                int n2 = 0;
                while (n2 < nodeArray.length) {
                    int n3 = index.indexOf(nodeArray[n2]);
                    if (n3 < (n += n2)) {
                        --n;
                    }
                    if (n3 != n) {
                        index.move(n3, n);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, exception);
        }
    }

    private Node[] findDropedNodes(Node node, Node[] nodeArray) {
        if (node == null || nodeArray.length == 0) {
            return null;
        }
        Node[] nodeArray2 = new Node[nodeArray.length];
        Children children = node.getChildren();
        int n = 0;
        while (n < nodeArray.length) {
            nodeArray2[n] = children.findChild(nodeArray[n].getName());
            ++n;
        }
        return nodeArray2;
    }

    private boolean canDrop(Node node, int n) {
        Object object;
        if (node == null) {
            return false;
        }
        if (2 == n) {
            object = ExplorerDnDManager.getDefault().getDraggedNodes();
            int n2 = 0;
            while (n2 < ((Node[])object).length) {
                if (node.equals(object[n2].getParentNode())) {
                    return false;
                }
                ++n2;
            }
        }
        if ((object = ExplorerDnDManager.getDefault().getDraggedTransferable(2 == n)) == null) {
            return false;
        }
        PasteType[] pasteTypeArray = DragDropUtilities.getPasteTypes(node, (Transferable)object);
        return pasteTypeArray != null && pasteTypeArray.length != 0;
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Object object;
        this.stopDragging();
        Node node = this.getNodeForDrop(dropTargetDropEvent.getLocation());
        Node[] nodeArray = ExplorerDnDManager.getDefault().getDraggedNodes();
        TreePath treePath = this.tree.getPathForLocation(dropTargetDropEvent.getLocation().x, dropTargetDropEvent.getLocation().y);
        if (this.pointAt != 0) {
            node = node.getParentNode();
        }
        if (!this.canDrop(node, dropTargetDropEvent.getDropAction())) {
            if (this.canReorder(node, nodeArray)) {
                this.performReorder(node, nodeArray, this.toIndex);
            }
            dropTargetDropEvent.rejectDrop();
            return;
        }
        int n = dropTargetDropEvent.getDropAction();
        dropTargetDropEvent.acceptDrop(n);
        if (0x40000000 == n) {
            object = new PasteType[]{};
            PasteType[] pasteTypeArray = new PasteType[]{};
            if (ExplorerDnDManager.getDefault().getAllowedDragActions() == 2) {
                object = DragDropUtilities.getPasteTypes(node, ExplorerDnDManager.getDefault().getDraggedTransferable(true));
            }
            if (ExplorerDnDManager.getDefault().getAllowedDragActions() >= 1) {
                pasteTypeArray = DragDropUtilities.getPasteTypes(node, ExplorerDnDManager.getDefault().getDraggedTransferable(false));
            }
            TreeSet<PasteType> treeSet = new TreeSet<PasteType>(new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((PasteType)object).getName().compareTo(((PasteType)object2).getName());
                }
            });
            int n2 = 0;
            while (n2 < ((PasteType[])object).length) {
                treeSet.add(object[n2]);
                ++n2;
            }
            int n3 = 0;
            while (n3 < pasteTypeArray.length) {
                treeSet.add(pasteTypeArray[n3]);
                ++n3;
            }
            DragDropUtilities.createDropFinishPopup(treeSet).show(this.tree, Math.max(dropTargetDropEvent.getLocation().x - 5, 0), Math.max(dropTargetDropEvent.getLocation().y - 5, 0));
            if (this.canReorder(node, nodeArray)) {
                final Node node2 = node;
                final int n4 = this.toIndex;
                final Node[] nodeArray2 = nodeArray;
                DragDropUtilities.setPostDropRun(new Runnable(){

                    public void run() {
                        TreeViewDropSupport.this.performReorder(node2, TreeViewDropSupport.this.findDropedNodes(node2, nodeArray2), n4);
                    }
                });
            }
        } else {
            object = DragDropUtilities.getPasteTypes(node, ExplorerDnDManager.getDefault().getDraggedTransferable(2 == n));
            DragDropUtilities.performDrop(object[0]);
            if (this.canReorder(node, this.findDropedNodes(node, nodeArray))) {
                this.performReorder(node, this.findDropedNodes(node, nodeArray), this.toIndex);
            }
        }
        if ((object = this.tree.getCellEditor()) instanceof TreeViewCellEditor) {
            ((TreeViewCellEditor)object).setDnDActive(false);
        }
        dropTargetDropEvent.dropComplete(true);
    }

    public void activate(boolean bl) {
        if (this.active == bl) {
            return;
        }
        this.active = bl;
        this.getDropTarget().setActive(bl);
    }

    public void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this);
            return;
        }
        DragDropUtilities.dropNotSuccesfull();
    }

    TreePath getTreePath(DropTargetDragEvent dropTargetDragEvent) {
        int n = dropTargetDragEvent.getDropAction();
        Point point = dropTargetDragEvent.getLocation();
        TreePath treePath = this.tree.getPathForLocation(point.x, point.y);
        return treePath != null && DragDropUtilities.secureFindNode(treePath.getLastPathComponent()) != null ? treePath : null;
    }

    DropTarget getDropTarget() {
        if (this.dropTarget == null) {
            this.dropTarget = new DropTarget(this.tree, this.view.getAllowedDropActions(), this, false);
        }
        return this.dropTarget;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

