/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.EventListenerList;
import org.openide.filesystems.AbstractFileObject;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.enum.ArrayEnumeration;
import org.openide.util.enum.EmptyEnumeration;
import org.openide.util.enum.FilterEnumeration;
import org.openide.util.enum.QueueEnumeration;

abstract class AbstractFolder
extends FileObject {
    private static final AbstractFolder[] EMPTY_ARRAY = new AbstractFolder[0];
    private static final char EXT_SEP = '.';
    private static final HashMap EMPTY = new HashMap(0);
    private FileSystem system;
    protected String name;
    protected final AbstractFolder parent;
    boolean validFlag;
    private AbstractFolder validRoot = null;
    private String[] children;
    private HashMap map;
    private EventListenerList listeners;
    static /* synthetic */ Class class$org$openide$filesystems$FileChangeListener;

    public AbstractFolder(FileSystem fileSystem, AbstractFolder abstractFolder, String string) {
        this.system = fileSystem;
        this.parent = abstractFolder;
        this.name = string;
        this.validFlag = true;
        if (abstractFolder != null) {
            this.validRoot = (AbstractFolder)fileSystem.getRoot();
        }
    }

    public final String getName() {
        int n = this.name.lastIndexOf(46);
        return n <= 0 ? this.name : this.name.substring(0, n);
    }

    public final String getExt() {
        int n = this.name.lastIndexOf(46) + 1;
        return n <= 1 || n == this.name.length() ? "" : this.name.substring(n);
    }

    public final String getNameExt() {
        return this.name;
    }

    final boolean isHasExtOverride() {
        return true;
    }

    boolean hasExtOverride(String string) {
        if (string == null) {
            return false;
        }
        if (this.name.length() - string.length() <= 1) {
            return false;
        }
        boolean bl = this.name.endsWith(string);
        if (!bl) {
            return false;
        }
        return this.name.charAt(this.name.length() - string.length() - 1) == '.';
    }

    public final String getPackageNameExt(char c, char c2) {
        String[] stringArray;
        String[] stringArray2 = new String[11];
        int n = 0;
        AbstractFolder abstractFolder = this.parent;
        while (abstractFolder != null && abstractFolder.parent != null) {
            if (n >= stringArray2.length) {
                stringArray = new String[stringArray2.length * 2 + 1];
                System.arraycopy(stringArray2, 0, stringArray, 0, n);
                stringArray2 = stringArray;
            }
            stringArray2[n++] = abstractFolder.name;
            abstractFolder = abstractFolder.parent;
        }
        stringArray = new StringBuffer(150);
        if ('.' == c2) {
            int n2 = n - 1;
            while (n2 >= 0) {
                stringArray.append(stringArray2[n2]);
                stringArray.append(c);
                --n2;
            }
            stringArray.append(this.name);
        } else {
            int n3 = n - 1;
            while (n3 >= 0) {
                stringArray.append(stringArray2[n3].replace('.', c2));
                stringArray.append(c);
                --n3;
            }
            stringArray.append(this.name.replace('.', c2));
        }
        return stringArray.toString();
    }

    public final FileSystem getFileSystem() {
        return this.system;
    }

    public final boolean isRoot() {
        return this.parent == null;
    }

    public final boolean isValid() {
        if (this.parent == null) {
            return true;
        }
        boolean bl = this.getFileSystem().getRoot() == this.validRoot;
        return this.validFlag && bl;
    }

    public final FileObject getParent() {
        return this.parent;
    }

    public final synchronized FileObject[] getChildren() {
        this.check();
        if (this.children == null) {
            return new FileObject[0];
        }
        int n = this.children.length;
        FileObject[] fileObjectArray = new FileObject[n];
        int n2 = 0;
        while (n2 < n) {
            fileObjectArray[n2] = this.getChild(this.children[n2]);
            ++n2;
        }
        return fileObjectArray;
    }

    final FileObject find(Enumeration enumeration) {
        AbstractFolder abstractFolder;
        for (abstractFolder = this; abstractFolder != null && enumeration.hasMoreElements(); abstractFolder = abstractFolder.getChild((String)enumeration.nextElement())) {
            AbstractFolder abstractFolder2 = abstractFolder;
            synchronized (abstractFolder2) {
                abstractFolder.check();
                continue;
            }
        }
        return abstractFolder;
    }

    final FileObject findIfExists(Enumeration enumeration) {
        Reference reference = this.findRefIfExists(enumeration);
        return reference == null ? null : (FileObject)reference.get();
    }

    final Reference findRefIfExists(Enumeration enumeration) {
        String string;
        for (AbstractFolder abstractFolder = this; abstractFolder != null && enumeration.hasMoreElements(); abstractFolder = abstractFolder.getChild(string)) {
            if (abstractFolder.map == null) {
                return null;
            }
            AbstractFolder abstractFolder2 = abstractFolder;
            synchronized (abstractFolder2) {
                string = (String)enumeration.nextElement();
                if (!enumeration.hasMoreElements()) {
                    Reference reference = (Reference)abstractFolder.map.get(string);
                    return reference;
                }
                continue;
            }
        }
        return null;
    }

    protected final AbstractFolder getChild(String string) {
        Reference reference = (Reference)this.map.get(string);
        if (reference == null) {
            return null;
        }
        AbstractFolder abstractFolder = (AbstractFolder)reference.get();
        if (abstractFolder == null) {
            abstractFolder = this.createFile(string);
            this.map.put(string, this.createReference(abstractFolder));
        }
        return abstractFolder;
    }

    final String[] getChildrenArray() {
        return this.children;
    }

    protected Reference createReference(FileObject fileObject) {
        return new WeakReference<FileObject>(fileObject);
    }

    final synchronized AbstractFolder[] subfiles() {
        if (this.map == null) {
            return EMPTY_ARRAY;
        }
        Iterator iterator = this.map.values().iterator();
        ArrayList<AbstractFolder> arrayList = new ArrayList<AbstractFolder>(this.map.size() + 2);
        while (iterator.hasNext()) {
            AbstractFolder abstractFolder;
            Reference reference = (Reference)iterator.next();
            if (reference == null || (abstractFolder = (AbstractFolder)reference.get()) == null) continue;
            arrayList.add(abstractFolder);
        }
        return arrayList.toArray(EMPTY_ARRAY);
    }

    final boolean isInitialized() {
        return this.map != null;
    }

    final Enumeration existingSubFiles(boolean bl) {
        if (!bl) {
            return new ArrayEnumeration(this.subfiles());
        }
        QueueEnumeration queueEnumeration = new QueueEnumeration(){

            public void process(Object object) {
                AbstractFolder abstractFolder = (AbstractFolder)object;
                this.put(abstractFolder.subfiles());
            }
        };
        queueEnumeration.put(this);
        return queueEnumeration;
    }

    abstract void setAttribute(String var1, Object var2, boolean var3) throws IOException;

    public final synchronized FileObject getFileObject(String string, String string2) {
        this.check();
        if (string2 == null || string2.equals("")) {
            return this.getChild(string);
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 1 + (string2 == null ? 0 : string2.length()));
        stringBuffer.append(string).append('.').append(string2);
        return this.getChild(stringBuffer.toString());
    }

    public void refresh(boolean bl) {
        if (!this.isInitialized() && this.isFolder()) {
            return;
        }
        this.refresh(null, null, true, bl);
    }

    public final void addFileChangeListener(FileChangeListener fileChangeListener) {
        AbstractFolder[] abstractFolderArray = EMPTY_ARRAY;
        synchronized (abstractFolderArray) {
            if (this.listeners == null) {
                this.listeners = new EventListenerList();
            }
        }
        this.listeners.add(class$org$openide$filesystems$FileChangeListener == null ? (class$org$openide$filesystems$FileChangeListener = AbstractFolder.class$("org.openide.filesystems.FileChangeListener")) : class$org$openide$filesystems$FileChangeListener, fileChangeListener);
    }

    public final void removeFileChangeListener(FileChangeListener fileChangeListener) {
        if (this.listeners != null) {
            this.listeners.remove(class$org$openide$filesystems$FileChangeListener == null ? (class$org$openide$filesystems$FileChangeListener = AbstractFolder.class$("org.openide.filesystems.FileChangeListener")) : class$org$openide$filesystems$FileChangeListener, fileChangeListener);
        }
    }

    protected final void fileDeleted0(FileEvent fileEvent) {
        super.fireFileDeletedEvent(this.listeners(), fileEvent);
        if (fileEvent.getFile().equals(this) && this.parent != null) {
            FileEvent fileEvent2 = new FileEvent((FileObject)this.parent, fileEvent.getFile(), fileEvent.isExpected());
            this.parent.fileDeleted0(fileEvent2);
        }
    }

    protected final void fileCreated0(FileEvent fileEvent, boolean bl) {
        if (bl) {
            super.fireFileDataCreatedEvent(this.listeners(), fileEvent);
        } else {
            super.fireFileFolderCreatedEvent(this.listeners(), fileEvent);
        }
        if (fileEvent.getFile().equals(this) && this.parent != null) {
            FileEvent fileEvent2 = new FileEvent((FileObject)this.parent, fileEvent.getFile(), fileEvent.isExpected());
            this.parent.fileCreated0(fileEvent2, bl);
        }
    }

    protected final void fileCreated0(FileObject fileObject, FileObject fileObject2, boolean bl) {
        FileEvent fileEvent = new FileEvent(fileObject, fileObject2, bl);
        this.fileCreated0(fileEvent, false);
    }

    protected final void fileChanged0(FileEvent fileEvent) {
        super.fireFileChangedEvent(this.listeners(), fileEvent);
        if (fileEvent.getFile().equals(this) && this.parent != null) {
            FileEvent fileEvent2 = new FileEvent((FileObject)this.parent, fileEvent.getFile(), fileEvent.isExpected());
            this.parent.fileChanged0(fileEvent2);
        }
    }

    final void fileChanged1(FileEvent fileEvent) {
        super.fireFileChangedEvent(this.listeners(), fileEvent);
    }

    protected final void fileRenamed0(FileRenameEvent fileRenameEvent) {
        super.fireFileRenamedEvent(this.listeners(), fileRenameEvent);
        if (fileRenameEvent.getFile().equals(this) && this.parent != null) {
            FileRenameEvent fileRenameEvent2 = new FileRenameEvent(this.parent, fileRenameEvent.getFile(), fileRenameEvent.getName(), fileRenameEvent.getExt(), fileRenameEvent.isExpected());
            this.parent.fileRenamed0(fileRenameEvent2);
        }
    }

    protected final void fileAttributeChanged0(FileAttributeEvent fileAttributeEvent) {
        super.fireFileAttributeChangedEvent(this.listeners(), fileAttributeEvent);
        if (fileAttributeEvent.getFile().equals(this) && this.parent != null) {
            FileAttributeEvent fileAttributeEvent2 = new FileAttributeEvent(this.parent, fileAttributeEvent.getFile(), fileAttributeEvent.getName(), fileAttributeEvent.getOldValue(), fileAttributeEvent.getNewValue(), fileAttributeEvent.isExpected());
            this.parent.fileAttributeChanged0(fileAttributeEvent2);
        }
    }

    protected final boolean hasListeners() {
        boolean bl = this.getFileSystem().getFCLSupport().hasListeners();
        boolean bl2 = false;
        Repository repository = this.getFileSystem().getRepository();
        if (repository != null) {
            bl2 = repository.getFCLSupport().hasListeners();
        }
        return this.listeners != null && this.listeners.getListenerList().length != 0 || bl2 || bl;
    }

    protected final boolean hasAtLeastOneListeners() {
        return this.hasListeners() || this.parent != null && this.parent.hasListeners();
    }

    private final Enumeration listeners() {
        if (this.listeners == null) {
            return EmptyEnumeration.EMPTY;
        }
        return new FilterEnumeration(new ArrayEnumeration(this.listeners.getListenerList())){
            static /* synthetic */ Class class$org$openide$filesystems$FileChangeListener;

            public boolean accept(Object object) {
                return object != (class$org$openide$filesystems$FileChangeListener == null ? (class$org$openide$filesystems$FileChangeListener = 2.class$("org.openide.filesystems.FileChangeListener")) : class$org$openide$filesystems$FileChangeListener);
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        };
    }

    private final void check() {
        if (this.map == null) {
            this.refresh(null, null, false, false);
            if (this.map == null) {
                this.map = EMPTY;
            }
        }
    }

    protected final void refresh(String string, String string2) {
        this.refresh(string, string2, false);
    }

    protected final void refresh(String string, String string2, boolean bl) {
        if (bl && string2 != null) {
            String[] stringArray = new String[this.children.length];
            System.arraycopy(this.children, 0, stringArray, 0, this.children.length);
            int n = stringArray.length;
            while (--n >= 0) {
                if (!string2.equals(stringArray[n])) continue;
                stringArray[n] = null;
                break;
            }
            this.refresh(string, string2, true, false, stringArray);
        } else {
            this.refresh(string, string2, true, false, null);
        }
    }

    protected abstract String[] list();

    protected abstract AbstractFolder createFile(String var1);

    protected void refresh(String string, String string2, boolean bl, boolean bl2) {
        this.refresh(string, string2, bl, bl2, null);
    }

    protected final void refreshFolder(String string, String string2, boolean bl, boolean bl2, String[] stringArray) {
        try {
            this.getFileSystem().beginAtomicAction();
            AbstractFolder abstractFolder = this;
            synchronized (abstractFolder) {
                Object object;
                HashSet<String> hashSet;
                HashMap<String, Object> hashMap;
                String[] stringArray2;
                if (stringArray == null) {
                    stringArray = this.list();
                }
                if ((stringArray2 = stringArray) == null && this.parent == null) {
                    stringArray2 = new String[]{};
                }
                if (this.children == null && stringArray2 == null) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 23] lbl11 : MonitorExitStatement: MONITOREXIT : var6_6
                    Object var19_8 = null;
                    this.getFileSystem().finishAtomicAction();
                    return;
                }
                int n = 0;
                if (stringArray2 != null) {
                    int n2 = stringArray2.length;
                    hashMap = new HashMap(n2 * 4 / 3 + 1, 0.75f);
                    hashSet = new HashSet<String>(n2 * 4 / 3 + 1, 0.75f);
                    object = this.map != null ? this.map.get(string2) : null;
                    int n3 = 0;
                    while (n3 < n2) {
                        String string3 = stringArray2[n3];
                        if (string3 == null) {
                            ++n;
                        } else {
                            boolean bl3;
                            WeakReference<Object> weakReference = this.map == null ? null : (WeakReference<Object>)this.map.remove(string3);
                            boolean bl4 = bl3 = string != null && string3.equals(string2);
                            if (weakReference == null || bl3) {
                                weakReference = new WeakReference<Object>(null);
                                hashSet.add(string3);
                            }
                            hashMap.put(string3, weakReference);
                        }
                        ++n3;
                    }
                    if (string != null && object != null) {
                        hashMap.put(string, object);
                    }
                } else {
                    hashMap = new HashMap<String, Object>(0);
                    hashSet = Collections.EMPTY_SET;
                }
                HashMap hashMap2 = null;
                if (bl) {
                    if (string != null) {
                        hashSet.remove(string);
                    }
                    if (this.map != null) {
                        hashMap2 = this.map;
                        object = this.map.entrySet().iterator();
                        while (object.hasNext()) {
                            Map.Entry entry = (Map.Entry)object.next();
                            entry.setValue(this.getChild((String)entry.getKey()));
                        }
                        if (string2 != null) {
                            hashMap2.remove(string2);
                        }
                        if (hashMap2.isEmpty()) {
                            hashMap2 = null;
                        }
                    }
                }
                this.map = hashMap;
                if (n != 0) {
                    object = new String[stringArray2.length - n];
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < stringArray2.length) {
                        if (stringArray2[n5] != null) {
                            object[n4++] = stringArray2[n5];
                        }
                        ++n5;
                    }
                    this.children = object;
                } else {
                    this.children = stringArray2;
                }
                if (bl && !hashSet.isEmpty() && this.hasAtLeastOneListeners()) {
                    object = hashSet.iterator();
                    while (object.hasNext()) {
                        String string4 = (String)object.next();
                        AbstractFolder abstractFolder2 = this.getChild(string4);
                        if (abstractFolder2 == null) continue;
                        this.fileCreated0(this, abstractFolder2, bl2);
                    }
                }
                if (bl && hashMap2 != null) {
                    object = hashMap2.values().iterator();
                    while (object.hasNext()) {
                        AbstractFolder abstractFolder3 = (AbstractFolder)object.next();
                        abstractFolder3.validFlag = false;
                        if (!this.hasAtLeastOneListeners() && !abstractFolder3.hasAtLeastOneListeners()) continue;
                        FileEvent fileEvent = new FileEvent((FileObject)abstractFolder3, (FileObject)abstractFolder3, bl2);
                        abstractFolder3.fileDeleted0(fileEvent);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var19_10 = null;
            this.getFileSystem().finishAtomicAction();
            throw throwable;
        }
        Object var19_9 = null;
        this.getFileSystem().finishAtomicAction();
    }

    protected void refresh(String string, String string2, boolean bl, boolean bl2, String[] stringArray) {
        if (this.isFolder()) {
            this.refreshFolder(string, string2, bl, bl2, stringArray);
        }
    }

    protected void outputStreamClosed(boolean bl) {
        if (bl) {
            this.fileChanged0(new FileEvent(this));
        }
    }

    public final Object writeReplace() {
        return new AbstractFileObject.Replace(this.getFileSystem().getSystemName(), this.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

