/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FolderList;
import org.openide.loaders.OperationEvent;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;

final class DataObjectPool
implements ChangeListener,
RepositoryListener,
PropertyChangeListener,
Runnable {
    private static final Validator VALIDATOR = new Validator();
    private HashMap map = new HashMap();
    private WeakSet knownFileSystems = new WeakSet();
    private static DataObjectPool POOL;
    private static Object lockPOOL;
    private HashSet toNotify = new HashSet();
    private ThreadLocal last = new ThreadLocal();
    private long toNotifyModified;
    private static final int SAFE_NOTIFY_DELAY = 500;
    private static final Integer ONE;
    private RequestProcessor.Task task;
    private final Map registrationCounts = new WeakHashMap();

    static DataObjectPool getPOOL() {
        Object object = lockPOOL;
        synchronized (object) {
            if (POOL != null) {
                DataObjectPool dataObjectPool = POOL;
                return dataObjectPool;
            }
            POOL = new DataObjectPool();
        }
        TopManager.getDefault().getLoaderPool().addChangeListener(POOL);
        TopManager.getDefault().getRepository().addRepositoryListener(POOL);
        return POOL;
    }

    private DataObjectPool() {
        this.task = RequestProcessor.createRequest(this);
        this.task.setPriority(1);
    }

    public DataObject find(FileObject fileObject) {
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            Item item = (Item)this.map.get(fileObject);
            if (item == null) {
                DataObject dataObject = null;
                return dataObject;
            }
            if (this.toNotify.contains(item) && this.last.get() != item) {
                DataObject dataObject = null;
                return dataObject;
            }
            DataObject dataObject = item.getDataObjectOrNull();
            return dataObject;
        }
    }

    void countRegistration(FileObject fileObject) {
        Integer n = (Integer)this.registrationCounts.get(fileObject);
        Integer n2 = n == null ? ONE : new Integer(n + 1);
        this.registrationCounts.put(fileObject, n2);
    }

    int registrationCount(FileObject fileObject) {
        Integer n = (Integer)this.registrationCounts.get(fileObject);
        if (n == null) {
            return 0;
        }
        return n;
    }

    private void refreshAllFolders() {
        HashSet hashSet;
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            hashSet = new HashSet(this.map.keySet());
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            DataObject dataObject;
            FileObject fileObject = (FileObject)iterator.next();
            if (!fileObject.isFolder() || !((dataObject = this.find(fileObject)) instanceof DataFolder)) continue;
            DataFolder dataFolder = (DataFolder)dataObject;
            FileObject fileObject2 = dataFolder.getPrimaryFile();
            DataObjectPool dataObjectPool2 = this;
            synchronized (dataObjectPool2) {
                if (this.toNotify.isEmpty() || !this.toNotify.contains((Item)this.map.get(fileObject2))) {
                    FolderList.changedDataSystem(fileObject2);
                }
            }
        }
    }

    public Set revalidate(Set set) {
        return VALIDATOR.revalidate(set);
    }

    public Set revalidate() {
        Set set;
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            set = DataObjectPool.createSetOfAllFiles(this.map.values());
        }
        return this.revalidate(set);
    }

    public void notifyCreation(DataObject dataObject) {
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            if (this.toNotify.isEmpty()) {
                return;
            }
            if (!this.toNotify.remove(dataObject.item)) {
                return;
            }
            if (this.toNotify.isEmpty()) {
                this.task.cancel();
            }
            this.notifyAll();
        }
        DataLoaderPool dataLoaderPool = TopManager.getDefault().getLoaderPool();
        dataLoaderPool.fireOperationEvent(new OperationEvent(dataObject), 7);
    }

    public void waitNotified(DataObject dataObject) {
        try {
            DataObjectPool dataObjectPool = this;
            synchronized (dataObjectPool) {
                if (this.toNotify.isEmpty()) {
                    return;
                }
                if (dataObject.item == this.last.get()) {
                    return;
                }
                if (!this.toNotify.contains(dataObject.item)) {
                    return;
                }
                this.wait(500L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        Item[] itemArray;
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            if (this.toNotify.isEmpty()) {
                return;
            }
            if (System.currentTimeMillis() < this.toNotifyModified + 500L) {
                this.task.schedule(500);
                return;
            }
            itemArray = ((AbstractCollection)this.toNotify).toArray(new Item[this.toNotify.size()]);
        }
        int n = 0;
        while (n < itemArray.length) {
            DataObject dataObject = itemArray[n].getDataObjectOrNull();
            if (dataObject != null) {
                this.notifyCreation(dataObject);
            } else {
                DataObjectPool dataObjectPool2 = this;
                synchronized (dataObjectPool2) {
                    this.toNotify.remove(itemArray[n]);
                }
            }
            ++n;
        }
    }

    private void notifyAdd(Item item) {
        if (this.toNotify.isEmpty()) {
            this.task.schedule(500);
        }
        this.toNotify.add(item);
        this.last.set(item);
        this.toNotifyModified = System.currentTimeMillis();
    }

    public Item register(FileObject fileObject, DataLoader dataLoader) throws DataObjectExistsException {
        Serializable serializable;
        Object object;
        try {
            object = fileObject.getFileSystem();
            serializable = this.knownFileSystems;
            synchronized (serializable) {
                if (!this.knownFileSystems.contains(object)) {
                    ((FileSystem)object).addFileChangeListener(new FSListener());
                    this.knownFileSystems.add(object);
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            object = (Item)this.map.get(fileObject);
            if (object == null) {
                object = new Item(fileObject);
                this.map.put(fileObject, object);
                this.countRegistration(fileObject);
                this.notifyAdd((Item)object);
                VALIDATOR.notifyRegistered(fileObject);
                Object object2 = object;
                return object2;
            }
            serializable = ((Item)object).getDataObjectOrNull();
            if (serializable == null) {
                object = new Item(fileObject);
                this.map.put(fileObject, object);
                this.countRegistration(fileObject);
                this.notifyAdd((Item)object);
                Object object3 = object;
                return object3;
            }
            if (!VALIDATOR.reregister((DataObject)serializable, dataLoader)) {
                throw new DataObjectExistsException((DataObject)serializable);
            }
        }
        try {
            ((DataObject)serializable).setValid(false);
            DataObjectPool dataObjectPool2 = this;
            synchronized (dataObjectPool2) {
                Item item = (Item)this.map.get(fileObject);
                if (item == null) {
                    object = new Item(fileObject);
                    this.map.put(fileObject, object);
                    this.countRegistration(fileObject);
                    this.notifyAdd((Item)object);
                    Object object4 = object;
                    return object4;
                }
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            VALIDATOR.refusingObjects.add(serializable);
        }
        throw new DataObjectExistsException((DataObject)serializable);
    }

    private synchronized void deregister(Item item, boolean bl) {
        DataFolder dataFolder;
        Item item2;
        FileObject fileObject = item.primaryFile;
        Item item3 = (Item)this.map.remove(fileObject);
        if (item3 != null && item3 != item) {
            this.map.put(fileObject, item3);
            this.countRegistration(fileObject);
            if (this.toNotify.remove(item)) {
                if (this.toNotify.isEmpty()) {
                    this.task.cancel();
                }
                this.notifyAll();
            }
            return;
        }
        if (bl && (fileObject = fileObject.getParent()) != null && (item2 = (Item)this.map.get(fileObject)) != null && (dataFolder = (DataFolder)item2.getDataObjectOrNull()) != null) {
            VALIDATOR.refreshFolderOf(dataFolder);
        }
    }

    private synchronized void changePrimaryFile(Item item, FileObject fileObject) {
        this.map.remove(item.primaryFile);
        item.primaryFile = fileObject;
        this.map.put(fileObject, item);
        this.countRegistration(fileObject);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Set<Object> set;
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            set = new HashSet(this.map.values());
        }
        set = DataObjectPool.createSetOfAllFiles(set);
        this.revalidate(set);
    }

    private static Set createSetOfAllFiles(Collection collection) {
        HashSet hashSet = new HashSet(collection.size() * 7);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Item item = (Item)iterator.next();
            DataObject dataObject = item.getDataObjectOrNull();
            if (dataObject == null) continue;
            hashSet.addAll(dataObject.files());
        }
        return hashSet;
    }

    private void removeInvalidObjects() {
        Set<Object> set;
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            set = new HashSet(this.map.values());
        }
        set = DataObjectPool.createSetOfAllFiles(set);
        VALIDATOR.removeInvalidObject(set);
    }

    public void fileSystemAdded(RepositoryEvent repositoryEvent) {
        repositoryEvent.getFileSystem().addPropertyChangeListener(DataObjectPool.getPOOL());
    }

    public void fileSystemRemoved(RepositoryEvent repositoryEvent) {
        repositoryEvent.getFileSystem().removePropertyChangeListener(DataObjectPool.getPOOL());
        this.removeInvalidObjects();
    }

    public void fileSystemPoolReordered(RepositoryReorderedEvent repositoryReorderedEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("systemName".equals(propertyChangeEvent.getPropertyName())) {
            this.removeInvalidObjects();
        }
        if ("root".equals(propertyChangeEvent.getPropertyName())) {
            this.removeInvalidObjects();
        }
    }

    Iterator getActiveDataObjects() {
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            ArrayList arrayList = new ArrayList(this.map.values());
            Iterator iterator = ((AbstractList)arrayList).iterator();
            return iterator;
        }
    }

    static {
        lockPOOL = new Object();
        ONE = new Integer(1);
    }

    private static final class Validator
    implements DataLoader.RecognizedFiles {
        private Set files;
        private Thread current;
        private int waiters;
        private HashSet recognizedFiles;
        private HashSet refusingObjects;
        private HashSet createdFiles;

        Validator() {
        }

        private synchronized Set enter(Set set) {
            ++this.waiters;
            while (this.current != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.current = Thread.currentThread();
            --this.waiters;
            if (this.files == null) {
                this.files = set;
            } else {
                this.files.addAll(set);
            }
            return this.files;
        }

        private synchronized void exit() {
            this.current = null;
            if (this.waiters == 0) {
                this.files = null;
            }
            this.notify();
        }

        private synchronized boolean goOn() {
            return this.waiters == 0;
        }

        public void refreshFolderOf(DataFolder dataFolder) {
            if (this.createdFiles == null) {
                FolderList.changedDataSystem(dataFolder.getPrimaryFile());
            }
        }

        public void markRecognized(FileObject fileObject) {
            this.recognizedFiles.add(fileObject);
        }

        public void notifyRegistered(FileObject fileObject) {
            if (this.createdFiles != null) {
                this.createdFiles.add(fileObject);
            }
        }

        public boolean reregister(DataObject dataObject, DataLoader dataLoader) {
            if (this.recognizedFiles == null) {
                return false;
            }
            if (dataObject.getLoader() == dataLoader) {
                return false;
            }
            if (this.createdFiles.contains(dataObject.getPrimaryFile())) {
                return false;
            }
            return !this.refusingObjects.contains(dataObject);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Set revalidate(Set set) {
            Serializable serializable;
            LinkedList<DataObject> linkedList = new LinkedList<DataObject>();
            try {
                set = this.enter(set);
                this.recognizedFiles = new HashSet();
                this.refusingObjects = new HashSet();
                this.createdFiles = new HashSet();
                HashSet<FileSystem> hashSet = new HashSet<FileSystem>(Arrays.asList(TopManager.getDefault().getRepository().toArray()));
                DataLoaderPool dataLoaderPool = TopManager.getDefault().getLoaderPool();
                Iterator iterator = set.iterator();
                while (iterator.hasNext() && this.goOn()) {
                    boolean bl;
                    Serializable serializable2;
                    serializable = (FileObject)iterator.next();
                    if (this.recognizedFiles.contains(serializable)) continue;
                    try {
                        serializable2 = ((FileObject)serializable).getFileSystem();
                        bl = !hashSet.contains(serializable2);
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        bl = true;
                    }
                    try {
                        serializable2 = DataObjectPool.getPOOL().find((FileObject)serializable);
                        if (serializable2 == null) continue;
                        if (!bl) {
                            DataObject dataObject = dataLoaderPool.findDataObject((FileObject)serializable, this);
                            linkedList.add(dataObject);
                            boolean bl2 = bl = dataObject != serializable2;
                        }
                        if (!bl) continue;
                        iterator.remove();
                        try {
                            ((DataObject)serializable2).setValid(false);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            this.refusingObjects.add(serializable2);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                serializable = this.refusingObjects;
                Object var11_13 = null;
                this.recognizedFiles = null;
                this.refusingObjects = null;
                this.createdFiles = null;
                this.exit();
                if (set.size() <= 1) return serializable;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                this.recognizedFiles = null;
                this.refusingObjects = null;
                this.createdFiles = null;
                this.exit();
                if (set.size() <= 1) throw throwable;
                DataObjectPool.getPOOL().refreshAllFolders();
                throw throwable;
            }
            DataObjectPool.getPOOL().refreshAllFolders();
            return serializable;
        }

        /*
         * Handled impossible loop by adding 'first' condition
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void removeInvalidObject(Set set) {
            try {
                set = this.enter(set);
                HashSet<FileSystem> hashSet = new HashSet<FileSystem>();
                FileSystem[] fileSystemArray = TopManager.getDefault().getRepository().toArray();
                int n = 0;
                while (n < fileSystemArray.length) {
                    hashSet.add(fileSystemArray[n]);
                    ++n;
                }
                Iterator iterator = set.iterator();
                boolean bl = true;
                do {
                    if (!bl || (bl = false) || !true) {
                        Serializable serializable;
                        boolean bl2;
                        FileObject fileObject = (FileObject)iterator.next();
                        boolean bl3 = bl2 = !fileObject.isValid();
                        if (!bl2) {
                            try {
                                serializable = fileObject.getFileSystem();
                                bl2 = !hashSet.contains(serializable);
                            }
                            catch (FileStateInvalidException fileStateInvalidException) {
                                bl2 = true;
                            }
                        }
                        serializable = null;
                        DataObjectPool dataObjectPool = DataObjectPool.getPOOL();
                        synchronized (dataObjectPool) {
                            Item item = (Item)DataObjectPool.getPOOL().map.get(fileObject);
                            if (item == null) {
                            } else {
                                serializable = item.getDataObjectOrNull();
                                // MONITOREXIT @DISABLED, blocks:[0, 4, 9, 12, 14] lbl32 : MonitorExitStatement: MONITOREXIT : var9_10
                                if (bl2 && serializable != null) {
                                    iterator.remove();
                                    try {
                                        ((DataObject)serializable).setValid(false);
                                    }
                                    catch (PropertyVetoException propertyVetoException) {
                                        ErrorManager.getDefault().notify(1, propertyVetoException);
                                    }
                                }
                            }
                        }
                    }
                    if (!iterator.hasNext()) break;
                } while (this.goOn());
                Object var13_13 = null;
                this.exit();
                return;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                this.exit();
                throw throwable;
            }
        }
    }

    static final class ReferenceHandler
    implements Runnable {
        ReferenceHandler() {
        }

        static void start() {
            RequestProcessor.postRequest(new ReferenceHandler(), 5000);
        }

        private void restart() {
            RequestProcessor.postRequest(this, 5000);
        }

        public void run() {
            ItemReference.checkQueue();
            this.restart();
        }
    }

    static final class ItemReference
    extends WeakReference {
        private static ReferenceQueue refqueue;
        private Item item;

        private static synchronized ReferenceQueue getRefqueue() {
            if (refqueue == null) {
                refqueue = new ReferenceQueue();
                ReferenceHandler.start();
            }
            return refqueue;
        }

        static void checkQueue() {
            if (refqueue == null) {
                return;
            }
            ItemReference itemReference = (ItemReference)refqueue.poll();
            while (itemReference != null) {
                itemReference.deregister();
                itemReference = (ItemReference)refqueue.poll();
            }
        }

        ItemReference(DataObject dataObject, Item item) {
            super(dataObject, ItemReference.getRefqueue());
            this.item = item;
            ItemReference.checkQueue();
        }

        private void deregister() {
            this.item.deregister(false);
            this.item = null;
        }
    }

    static final class Item {
        private static final Reference REFERENCE_NOT_SET = new WeakReference<Object>(null);
        private Reference obj = REFERENCE_NOT_SET;
        FileObject primaryFile;

        public Item(FileObject fileObject) {
            this.primaryFile = fileObject;
        }

        public void setDataObject(DataObject dataObject) {
            this.obj = new ItemReference(dataObject, this);
            if (dataObject != null && !dataObject.getPrimaryFile().isValid()) {
                this.deregister(false);
            }
            DataObjectPool dataObjectPool = DataObjectPool.getPOOL();
            synchronized (dataObjectPool) {
                DataObjectPool.getPOOL().notifyAll();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        DataObject getDataObjectOrNull() {
            DataObjectPool dataObjectPool = DataObjectPool.getPOOL();
            // MONITORENTER : dataObjectPool
            while (this.obj == REFERENCE_NOT_SET) {
                try {
                    DataObjectPool.getPOOL().wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            // MONITOREXIT : dataObjectPool
            if (this.obj == null) {
                return null;
            }
            DataObject dataObject = (DataObject)this.obj.get();
            return dataObject;
        }

        public DataObject getDataObject() {
            DataObject dataObject = this.getDataObjectOrNull();
            if (dataObject == null) {
                throw new IllegalStateException();
            }
            return dataObject;
        }

        public void deregister(boolean bl) {
            DataObjectPool.getPOOL().deregister(this, bl);
        }

        public void changePrimaryFile(FileObject fileObject) {
            DataObjectPool.getPOOL().changePrimaryFile(this, fileObject);
        }

        public boolean isValid() {
            if (DataObjectPool.getPOOL().map.get(this.primaryFile) == this) {
                return this.primaryFile.isValid();
            }
            return false;
        }

        public String toString() {
            DataObject dataObject = (DataObject)this.obj.get();
            if (dataObject == null) {
                return "nothing[" + this.primaryFile + "]";
            }
            return dataObject.toString();
        }
    }

    private final class FSListener
    extends FileChangeAdapter {
        private FSListener() {
        }

        private Iterator getTargets(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            LinkedList<Item> linkedList = new LinkedList<Item>();
            DataObjectPool dataObjectPool = DataObjectPool.this;
            synchronized (dataObjectPool) {
                Item item = (Item)DataObjectPool.this.map.get(fileObject);
                if (item != null) {
                    linkedList.add(item);
                } else {
                    FileObject fileObject2 = fileObject.getParent();
                    if (fileObject2 != null) {
                        FileObject[] fileObjectArray = fileObject2.getChildren();
                        int n = 0;
                        while (n < fileObjectArray.length) {
                            item = (Item)DataObjectPool.this.map.get(fileObjectArray[n]);
                            if (item != null) {
                                linkedList.add(item);
                            }
                            ++n;
                        }
                    }
                }
            }
            return linkedList.iterator();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            Iterator iterator = this.getTargets(fileRenameEvent);
            while (iterator.hasNext()) {
                DataObject dataObject = ((Item)iterator.next()).getDataObjectOrNull();
                if (dataObject == null) continue;
                dataObject.notifyFileRenamed(fileRenameEvent);
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            Iterator iterator = this.getTargets(fileEvent);
            while (iterator.hasNext()) {
                DataObject dataObject = ((Item)iterator.next()).getDataObjectOrNull();
                if (dataObject == null) continue;
                dataObject.notifyFileDeleted(fileEvent);
            }
        }

        public void fileDataCreated(FileEvent fileEvent) {
            Iterator iterator = this.getTargets(fileEvent);
            while (iterator.hasNext()) {
                DataObject dataObject = ((Item)iterator.next()).getDataObjectOrNull();
                if (dataObject == null) continue;
                dataObject.notifyFileDataCreated(fileEvent);
            }
        }
    }
}

