/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.openide.ErrorManager;
import org.openide.actions.PasteAction;
import org.openide.awt.UndoRedo;
import org.openide.loaders.DataObject;
import org.openide.loaders.InstanceSupport;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.EditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.QuietEditorPane;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class CloneableEditor
extends CloneableTopComponent {
    protected JEditorPane pane;
    private PropertyChangeListener copyL;
    private PropertyChangeListener cutL;
    private PropertyChangeListener deleteL;
    private PropertyChangeListener pasteL;
    private CloneableEditorSupport support;
    private boolean initialized;
    private int cursorPosition;
    private Component customComponent;
    private static final String HELP_ID = "editing.editorwindow";
    static final long serialVersionUID = -185739563792410059L;
    private Map kitActions;
    static /* synthetic */ Class class$org$openide$text$CloneableEditor;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$text$CloneableEditorSupport;
    static /* synthetic */ Class class$org$openide$text$EditorSupport;

    public CloneableEditor() {
        this((CloneableEditorSupport)null);
    }

    public CloneableEditor(CloneableEditorSupport cloneableEditorSupport) {
        this.support = cloneableEditorSupport;
        this.putClientProperty("PersistenceType", "OnlyOpened");
        this.updateName();
    }

    protected CloneableEditorSupport cloneableEditorSupport() {
        return this.support;
    }

    public HelpCtx getHelpCtx() {
        HelpCtx helpCtx = InstanceSupport.findHelp(new InstanceSupport.Instance(this.support.kit()));
        if (helpCtx != null) {
            return helpCtx;
        }
        return new HelpCtx(HELP_ID);
    }

    public boolean canClose(Workspace workspace, boolean bl) {
        boolean bl2 = super.canClose(workspace, bl);
        if (bl2) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (CloneableEditor.this.pane != null) {
                        StyledDocument styledDocument = CloneableEditor.this.support.createStyledDocument(CloneableEditor.this.pane.getEditorKit());
                        CloneableEditor.this.pane.setDocument(styledDocument);
                        CloneableEditor.this.pane.setEditorKit(null);
                    }
                    CloneableEditor.this.removeAll();
                }
            });
        }
        return bl2;
    }

    protected void componentShowing() {
        super.componentShowing();
        if (this.initialized || this.discard()) {
            return;
        }
        this.initialized = true;
        this.initialize();
    }

    private void initialize() {
        final Task task = this.support.prepareDocument();
        this.setCloseOperation(0);
        this.setLayout(new BorderLayout());
        final QuietEditorPane quietEditorPane = new QuietEditorPane();
        quietEditorPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(class$org$openide$text$CloneableEditor == null ? (class$org$openide$text$CloneableEditor = CloneableEditor.class$("org.openide.text.CloneableEditor")) : class$org$openide$text$CloneableEditor, "ACS_CloneableEditor_QuietEditorPane", this.getName()));
        quietEditorPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(class$org$openide$text$CloneableEditor == null ? (class$org$openide$text$CloneableEditor = CloneableEditor.class$("org.openide.text.CloneableEditor")) : class$org$openide$text$CloneableEditor, "ACSD_CloneableEditor_QuietEditorPane", this.getAccessibleContext().getAccessibleDescription()));
        this.pane = quietEditorPane;
        quietEditorPane.setEditorKit(this.support.kit());
        StyledDocument styledDocument = this.support.getDocumentHack();
        quietEditorPane.setDocument(styledDocument);
        if (styledDocument instanceof NbDocument.CustomEditor) {
            NbDocument.CustomEditor customEditor = (NbDocument.CustomEditor)((Object)styledDocument);
            this.customComponent = customEditor.createEditor(quietEditorPane);
            if (this.customComponent == null) {
                throw new IllegalStateException("Document:" + styledDocument + " implementing NbDocument.CustomEditor may not" + " return null component");
            }
            this.add(this.customComponent, "Center");
        } else {
            this.add((Component)new JScrollPane(quietEditorPane), "Center");
        }
        quietEditorPane.setWorking(3);
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task2) {
                quietEditorPane.getCaret().setDot(CloneableEditor.this.cursorPosition);
                task.removeTaskListener(this);
            }
        });
    }

    protected CloneableTopComponent createClonedObject() {
        return this.support.createCloneableTopComponent();
    }

    public void open(Workspace workspace) {
        if (!this.discard()) {
            Workspace workspace2 = workspace == null ? WindowManager.getDefault().getCurrentWorkspace() : workspace;
            this.dockIfNeeded(workspace2);
            boolean bl = false;
            TopComponent[] topComponentArray = this.editorMode(workspace2).getTopComponents();
            int n = 0;
            while (n < topComponentArray.length) {
                if (topComponentArray[n].isOpened(workspace2)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                this.openOtherEditors(workspace2);
            }
            super.open(workspace);
            this.openOnOtherWorkspaces(workspace2);
        }
    }

    protected boolean closeLast() {
        if (!this.support.canClose()) {
            return false;
        }
        this.support.notifyClosed();
        if (this.support.lastSelected == this) {
            this.support.lastSelected = null;
        }
        return true;
    }

    public UndoRedo getUndoRedo() {
        return this.support.getUndoRedo();
    }

    public SystemAction[] getSystemActions() {
        SystemAction[] systemActionArray = super.getSystemActions();
        return SystemAction.linkActions(systemActionArray, new SystemAction[]{null, SystemAction.get(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = CloneableEditor.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction)});
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.customComponent != null && !SwingUtilities.isDescendingFrom(this.pane, this.customComponent)) {
            this.customComponent.requestFocus();
        } else if (this.pane != null) {
            this.pane.requestFocus();
        }
    }

    public Dimension getPreferredSize() {
        Rectangle rectangle = WindowManager.getDefault().getCurrentWorkspace().getBounds();
        return new Dimension(rectangle.width / 2, rectangle.height / 2);
    }

    private Action getAction(String string) {
        Object object;
        Reference reference;
        if (string == null) {
            return null;
        }
        if (this.kitActions == null) {
            this.kitActions = new HashMap(5);
        }
        if ((reference = (Reference)this.kitActions.get(string)) != null && (object = (Action)reference.get()) != null) {
            return object;
        }
        object = this.support.kit();
        if (object == null) {
            return null;
        }
        Action[] actionArray = ((EditorKit)object).getActions();
        int n = 0;
        while (n < actionArray.length) {
            if (string.equals(actionArray[n].getValue("Name"))) {
                this.kitActions.put(actionArray[n].getValue("Name"), new WeakReference<Action>(actionArray[n]));
                return actionArray[n];
            }
            ++n;
        }
        return null;
    }

    protected void componentActivated() {
        this.copyL = this.setEditorActionListening(this.copyL, this.getAction("copy-to-clipboard"), (CallbackSystemAction)SystemAction.get(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = CloneableEditor.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction), true);
        this.cutL = this.setEditorActionListening(this.cutL, this.getAction("cut-to-clipboard"), (CallbackSystemAction)SystemAction.get(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = CloneableEditor.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction), true);
        this.deleteL = this.setEditorActionListening(this.deleteL, this.getAction("delete-next"), (CallbackSystemAction)SystemAction.get(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = CloneableEditor.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction), false);
        Action action = this.getAction("paste-from-clipboard");
        final PasteAction pasteAction = (PasteAction)SystemAction.get(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = CloneableEditor.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction);
        if (action != null && pasteAction != null && action != pasteAction) {
            if (this.pasteL != null) {
                action.removePropertyChangeListener(this.pasteL);
            }
            this.pasteL = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                        if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                            CloneableEditor.this.updatePasteAction();
                        } else {
                            pasteAction.setPasteTypes(null);
                        }
                    }
                }
            };
            action.addPropertyChangeListener(this.pasteL);
        }
        this.updatePasteAction();
        this.support.lastSelected = this;
    }

    protected void componentDeactivated() {
        this.removeEditorActionListening(this.copyL, this.getAction("copy-to-clipboard"), true);
        this.removeEditorActionListening(this.cutL, this.getAction("cut-to-clipboard"), true);
        this.removeEditorActionListening(this.deleteL, this.getAction("delete-next"), false);
        this.removeEditorActionListening(this.pasteL, this.getAction("paste-from-clipboard"), false);
    }

    private PropertyChangeListener setEditorActionListening(PropertyChangeListener propertyChangeListener, Action action, CallbackSystemAction callbackSystemAction, boolean bl) {
        if (action != null && callbackSystemAction != null && action != callbackSystemAction) {
            if (propertyChangeListener != null) {
                action.removePropertyChangeListener(propertyChangeListener);
            }
            if (bl && action == this.pane.getActionMap().get(action)) {
                SubstituteAction substituteAction = new SubstituteAction(action);
                this.pane.getActionMap().put(action, substituteAction);
                action = substituteAction;
            }
            propertyChangeListener = new Bridge(action, callbackSystemAction);
            action.addPropertyChangeListener(propertyChangeListener);
        }
        return propertyChangeListener;
    }

    private void removeEditorActionListening(PropertyChangeListener propertyChangeListener, Action action, boolean bl) {
        if (propertyChangeListener != null && action != null) {
            action.removePropertyChangeListener(propertyChangeListener);
            if (bl && action != this.pane.getActionMap().get(action)) {
                this.pane.getActionMap().put(action, action);
            }
        }
    }

    private void updatePasteAction() {
        final Action action = this.getAction("paste-from-clipboard");
        if (action == null) {
            return;
        }
        final PasteAction pasteAction = (PasteAction)SystemAction.get(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = CloneableEditor.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction);
        RequestProcessor.postRequest(new Runnable(){
            static /* synthetic */ Class class$java$awt$datatransfer$Clipboard;

            public void run() {
                Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(class$java$awt$datatransfer$Clipboard == null ? (class$java$awt$datatransfer$Clipboard = 4.class$("java.awt.datatransfer.Clipboard")) : class$java$awt$datatransfer$Clipboard);
                Transferable transferable = clipboard != null ? clipboard.getContents(null) : null;
                SwingUtilities.invokeLater(new Runnable(this, transferable){
                    private final /* synthetic */ Transferable val$tr;
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$tr = transferable;
                    }

                    public void run() {
                        if (this.val$tr != null && this.val$tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            4.access$600(this.this$1).setPasteTypes(new PasteType[]{new PasteType(this){
                                private final /* synthetic */ 5 this$2;
                                {
                                    this.this$2 = var1_1;
                                }

                                public Transferable paste() {
                                    4.access$500(5.access$300(this.this$2)).actionPerformed(new ActionEvent(4.access$400(5.access$300(this.this$2)), 0, ""));
                                    return null;
                                }
                            }});
                        } else {
                            4.access$600(this.this$1).setPasteTypes(null);
                        }
                    }

                    static /* synthetic */ 4 access$300(5 var0) {
                        return var0.this$1;
                    }
                });
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }

            static /* synthetic */ CloneableEditor access$400(4 var0) {
                return var0.CloneableEditor.this;
            }

            static /* synthetic */ Action access$500(4 var0) {
                return var0.action;
            }

            static /* synthetic */ PasteAction access$600(4 var0) {
                return var0.pasteAction;
            }
        });
    }

    protected void updateName() {
        CloneableEditorSupport cloneableEditorSupport = this.cloneableEditorSupport();
        if (cloneableEditorSupport != null) {
            this.setName(cloneableEditorSupport.messageName());
            this.setToolTipText(cloneableEditorSupport.messageToolTip());
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.support != null ? this.support.env() : null);
        int n = 0;
        JEditorPane jEditorPane = this.pane;
        if (jEditorPane != null) {
            Caret caret = jEditorPane.getCaret();
            if (caret != null) {
                n = caret.getDot();
            } else if (jEditorPane instanceof QuietEditorPane) {
                int n2 = ((QuietEditorPane)jEditorPane).getLastPosition();
                if (n2 == -1) {
                    ErrorManager.getDefault().notify(1, new IllegalStateException("Pane=" + jEditorPane + "was not initialized yet!"));
                } else {
                    n = n2;
                }
            } else {
                StyledDocument styledDocument;
                StyledDocument styledDocument2 = styledDocument = this.support != null ? this.support.getDocument() : null;
                if (styledDocument != null) {
                    ErrorManager.getDefault().notify(1, new IllegalStateException("Caret is null in editor pane=" + jEditorPane + "\nsupport=" + this.support + "\ndoc=" + styledDocument));
                }
            }
        }
        objectOutput.writeObject(new Integer(n));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        super.readExternal(objectInput);
        Object object = objectInput.readObject();
        if (object instanceof DataObject) {
            DataObject dataObject = (DataObject)object;
            n = (Integer)objectInput.readObject();
            Object object2 = objectInput.readObject();
            if (object2 instanceof CloneableEditorSupport) {
                this.support = (CloneableEditorSupport)object2;
            } else {
                EditorSupport editorSupport;
                this.support = (CloneableEditorSupport)((Object)dataObject.getCookie(class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = CloneableEditor.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport));
                if (this.support == null && (editorSupport = (EditorSupport)dataObject.getCookie(class$org$openide$text$EditorSupport == null ? (class$org$openide$text$EditorSupport = CloneableEditor.class$("org.openide.text.EditorSupport")) : class$org$openide$text$EditorSupport)) != null) {
                    this.support = editorSupport.del;
                }
            }
        } else {
            if (object instanceof CloneableOpenSupport.Env) {
                CloneableOpenSupport.Env env = (CloneableOpenSupport.Env)object;
                CloneableOpenSupport cloneableOpenSupport = env.findCloneableOpenSupport();
                this.support = cloneableOpenSupport instanceof EditorSupport ? ((EditorSupport)cloneableOpenSupport).del : (CloneableEditorSupport)cloneableOpenSupport;
            }
            n = (Integer)objectInput.readObject();
        }
        if (!this.discard()) {
            this.cursorPosition = n;
        }
        this.updateName();
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.discard()) {
            throw new NotSerializableException("Serializing component is invalid: " + this);
        }
        return super.writeReplace();
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.discard()) {
            throw new InvalidObjectException("Deserialized component is invalid: " + this);
        }
        this.support.initializeCloneableEditor(this);
        return this;
    }

    private boolean discard() {
        return this.support == null || !this.support.env().isValid();
    }

    private void dockIfNeeded(Workspace workspace) {
        Mode mode = workspace.findMode(this);
        if (mode == null) {
            this.editorMode(workspace).dockInto(this);
        }
    }

    private Mode editorMode(Workspace workspace) {
        Mode mode = workspace.findMode(this);
        if (mode == null) {
            mode = workspace.createMode("editor", this.getName(), (class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = CloneableEditor.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport).getResource("/org/openide/resources/editorMode.gif"));
        }
        return mode;
    }

    private void openOnOtherWorkspaces(Workspace workspace) {
        Workspace[] workspaceArray = WindowManager.getDefault().getWorkspaces();
        Mode mode = null;
        Mode mode2 = null;
        int n = 0;
        while (n < workspaceArray.length) {
            if (!workspaceArray[n].equals(workspace)) {
                mode = workspaceArray[n].findMode("editor");
                mode2 = workspaceArray[n].findMode(this);
                if (!this.isOpened(workspaceArray[n]) && mode != null && (mode2 == null || mode2.equals(mode))) {
                    TopComponent[] topComponentArray = mode.getTopComponents();
                    int n2 = 0;
                    while (n2 < topComponentArray.length) {
                        if (topComponentArray[n2].isOpened(workspaceArray[n])) {
                            this.pureOpen(this, workspaceArray[n]);
                            break;
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
    }

    private void openOtherEditors(Workspace workspace) {
        HashSet<TopComponent> hashSet = new HashSet<TopComponent>(15);
        Workspace[] workspaceArray = WindowManager.getDefault().getWorkspaces();
        Mode mode = null;
        TopComponent[] topComponentArray = null;
        int n = 0;
        while (n < workspaceArray.length) {
            mode = workspaceArray[n].findMode("editor");
            if (mode != null) {
                topComponentArray = mode.getTopComponents();
                int n2 = 0;
                while (n2 < topComponentArray.length) {
                    if (topComponentArray[n2].isOpened(workspaceArray[n])) {
                        hashSet.add(topComponentArray[n2]);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.pureOpen((TopComponent)iterator.next(), workspace);
        }
    }

    private void pureOpen(TopComponent topComponent, Workspace workspace) {
        if (topComponent instanceof CloneableEditor) {
            ((CloneableEditor)topComponent).dockIfNeeded(workspace);
            ((CloneableEditor)topComponent).superOpen(workspace);
        } else {
            topComponent.open(workspace);
        }
    }

    private void superOpen(Workspace workspace) {
        super.open(workspace);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SubstituteAction
    implements Action {
        private Action substitutee;

        public SubstituteAction(Action action) {
            this.substitutee = action;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.substitutee.actionPerformed(actionEvent);
            CloneableEditor.this.updatePasteAction();
        }

        public Object getValue(String string) {
            return this.substitutee.getValue(string);
        }

        public void putValue(String string, Object object) {
            this.substitutee.putValue(string, object);
        }

        public void setEnabled(boolean bl) {
            this.substitutee.setEnabled(bl);
        }

        public boolean isEnabled() {
            return this.substitutee.isEnabled();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.substitutee.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.substitutee.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private class Bridge
    implements PropertyChangeListener,
    ActionPerformer {
        private Action action;
        private CallbackSystemAction sys;

        Bridge(Action action, CallbackSystemAction callbackSystemAction) {
            this.action = action;
            this.sys = callbackSystemAction;
            if (this.action.isEnabled()) {
                callbackSystemAction.setActionPerformer(this);
            } else {
                callbackSystemAction.setActionPerformer(null);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                    this.sys.setActionPerformer(this);
                } else if (this.sys.getActionPerformer() == this) {
                    this.sys.setActionPerformer(null);
                }
            }
        }

        public void performAction(SystemAction systemAction) {
            this.action.actionPerformed(new ActionEvent(CloneableEditor.this, 0, ""));
        }
    }
}

