/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.openide.ErrorManager;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.EditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class PositionRef
implements Serializable {
    static final long serialVersionUID = -4931337398907426948L;
    private transient Manager.Kind kind;
    private Manager manager;
    private boolean insertAfter;

    PositionRef(Manager manager, int n, Position.Bias bias) {
        this(manager, manager.new Manager.OffsetKind(n), bias);
    }

    PositionRef(Manager manager, int n, int n2, Position.Bias bias) {
        this(manager, manager.new Manager.LineKind(n, n2), bias);
    }

    private PositionRef(Manager manager, Manager.Kind kind, Position.Bias bias) {
        this.manager = manager;
        this.kind = kind;
        this.insertAfter = bias == Position.Bias.Backward;
        this.init();
    }

    private void init() {
        this.kind = this.manager.addPosition(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeBoolean(this.insertAfter);
        objectOutputStream.writeObject(this.manager);
        this.kind.write(objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.insertAfter = objectInputStream.readBoolean();
        this.manager = (Manager)objectInputStream.readObject();
        this.kind = this.manager.readKind(objectInputStream);
        this.init();
    }

    public CloneableEditorSupport getCloneableEditorSupport() {
        return this.manager.getCloneableEditorSupport();
    }

    public EditorSupport getEditorSupport() {
        return EditorSupport.extract(this.getCloneableEditorSupport());
    }

    public Position.Bias getPositionBias() {
        return this.insertAfter ? Position.Bias.Backward : Position.Bias.Forward;
    }

    public Position getPosition() throws IOException {
        if (this.manager.getCloneableEditorSupport().getDocument() == null) {
            this.manager.getCloneableEditorSupport().openDocument();
        }
        Manager manager = this.manager;
        synchronized (manager) {
            Manager.PositionKind positionKind = (Manager.PositionKind)this.kind;
            Position position = positionKind.pos;
            return position;
        }
    }

    public int getOffset() {
        return this.kind.getOffset();
    }

    public int getLine() throws IOException {
        return this.kind.getLine();
    }

    public int getColumn() throws IOException {
        return this.kind.getColumn();
    }

    public String toString() {
        return "Pos[" + this.getOffset() + "]";
    }

    static final class Manager
    implements Runnable,
    Serializable {
        private transient ChainItem head;
        private transient ReferenceQueue queue;
        private transient int counter;
        private transient RequestProcessor.Task sweepTask;
        private transient CloneableEditorSupport support;
        private transient StyledDocument doc;
        static final long serialVersionUID = -4374030124265110801L;
        static /* synthetic */ Class class$org$openide$text$CloneableEditorSupport;
        static /* synthetic */ Class class$org$openide$text$PositionRef;

        public Manager(CloneableEditorSupport cloneableEditorSupport) {
            this.support = cloneableEditorSupport;
            this.init();
        }

        protected void init() {
            this.queue = new ReferenceQueue();
            this.head = new ChainItem(null, null, null);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            Object object = objectInputStream.readObject();
            if (object instanceof DataObject) {
                DataObject dataObject = (DataObject)object;
                this.support = (CloneableEditorSupport)((Object)dataObject.getCookie(class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = Manager.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport));
            } else {
                CloneableEditorSupport.Env env = (CloneableEditorSupport.Env)object;
                this.support = (CloneableEditorSupport)env.findCloneableOpenSupport();
            }
            if (this.support == null) {
                throw new IOException();
            }
        }

        final Object readResolve() {
            return this.support.getPositionManager();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this.support.env());
        }

        public CloneableEditorSupport getCloneableEditorSupport() {
            return this.support;
        }

        void documentOpened(StyledDocument styledDocument) {
            this.doc = styledDocument;
            this.processPositions(true);
        }

        void documentClosed() {
            this.processPositions(false);
            this.doc = null;
        }

        private void processPositions(boolean bl) {
            while (this.queue.poll() != null) {
            }
            this.counter = 0;
            Manager manager = this;
            synchronized (manager) {
                ChainItem chainItem = this.head;
                ChainItem chainItem2 = chainItem.next;
                while (chainItem2 != null) {
                    PositionRef positionRef = (PositionRef)chainItem2.get();
                    if (positionRef == null) {
                        chainItem.next = chainItem2.next;
                    } else {
                        if (bl) {
                            positionRef.kind = positionRef.kind.toMemory(positionRef.insertAfter);
                        } else {
                            positionRef.kind = positionRef.kind.fromMemory();
                        }
                        chainItem = chainItem2;
                    }
                    chainItem2 = chainItem2.next;
                }
            }
        }

        private void checkQueue() {
            while (this.queue.poll() != null) {
                ++this.counter;
            }
            if (this.counter > 100) {
                this.counter = 0;
                if (this.sweepTask == null) {
                    this.sweepTask = RequestProcessor.getDefault().post(this);
                } else if (this.sweepTask.isFinished()) {
                    this.sweepTask.schedule(0);
                }
            }
        }

        public synchronized void run() {
            ChainItem chainItem = this.head;
            ChainItem chainItem2 = chainItem.next;
            while (chainItem2 != null) {
                if (chainItem2.get() == null) {
                    chainItem.next = chainItem2.next;
                } else {
                    chainItem = chainItem2;
                }
                chainItem2 = chainItem2.next;
            }
        }

        Kind addPosition(PositionRef positionRef) {
            Kind kind;
            Manager manager = this;
            synchronized (manager) {
                this.head.next = new ChainItem(positionRef, this.queue, this.head.next);
                kind = this.doc == null ? positionRef.kind : positionRef.kind.toMemory(positionRef.insertAfter);
            }
            this.checkQueue();
            return kind;
        }

        Kind readKind(DataInput dataInput) throws IOException {
            int n = dataInput.readInt();
            int n2 = dataInput.readInt();
            int n3 = dataInput.readInt();
            if (n == -1) {
                return new LineKind(n2, n3);
            }
            if (n2 == -1 || n3 == -1) {
                return new OffsetKind(n);
            }
            return new OutKind(n, n2, n3);
        }

        private static void annotateException(Exception exception, String string) {
            ErrorManager.getDefault().annotate(exception, 4096, string, NbBundle.getMessage(class$org$openide$text$PositionRef == null ? (class$org$openide$text$PositionRef = Manager.class$("org.openide.text.PositionRef")) : class$org$openide$text$PositionRef, "EXC_PositionOffset"), null, null);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private final class LineKind
        extends Kind {
            private int line;
            private int column;

            public LineKind(int n, int n2) {
                if (n < 0 || n2 < 0) {
                    IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
                    Manager.annotateException(indexOutOfBoundsException, "Illegal LineKind[line=" + n + ",column=" + n2 + "] in " + Manager.this.doc + " used by " + Manager.this.support + ".");
                    throw indexOutOfBoundsException;
                }
                this.line = n;
                this.column = n2;
            }

            public int getOffset() {
                try {
                    StyledDocument styledDocument = Manager.this.getCloneableEditorSupport().getDocument();
                    if (styledDocument == null) {
                        styledDocument = Manager.this.getCloneableEditorSupport().openDocument();
                    }
                    return NbDocument.findLineOffset(styledDocument, this.line) + this.column;
                }
                catch (IOException iOException) {
                    return 0;
                }
            }

            public int getLine() throws IOException {
                return this.line;
            }

            public int getColumn() throws IOException {
                return this.column;
            }

            public void write(DataOutput dataOutput) throws IOException {
                if (this.line < 0 || this.column < 0) {
                    IOException iOException = new IOException();
                    Manager.annotateException(iOException, "Illegal LineKind[line=" + this.line + ",column=" + this.column + "] in " + Manager.this.doc + " used by " + Manager.this.support + ".");
                    throw iOException;
                }
                dataOutput.writeInt(-1);
                dataOutput.writeInt(this.line);
                dataOutput.writeInt(this.column);
            }

            public PositionKind toMemory(boolean bl) {
                Position position;
                try {
                    position = NbDocument.createPosition(Manager.this.doc, NbDocument.findLineOffset(Manager.this.doc, this.line) + this.column, bl ? Position.Bias.Forward : Position.Bias.Backward);
                }
                catch (BadLocationException badLocationException) {
                    position = Manager.this.doc.getEndPosition();
                }
                return new PositionKind(position);
            }
        }

        private final class OffsetKind
        extends Kind {
            private int offset;

            public OffsetKind(int n) {
                if (n < 0) {
                    IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
                    Manager.annotateException(indexOutOfBoundsException, "Illegal OffsetKind[offset=" + n + "] in " + Manager.this.doc + " used by " + Manager.this.support + ".");
                    throw indexOutOfBoundsException;
                }
                this.offset = n;
            }

            public int getOffset() {
                return this.offset;
            }

            public int getLine() throws IOException {
                return NbDocument.findLineNumber(Manager.this.getCloneableEditorSupport().openDocument(), this.offset);
            }

            public int getColumn() throws IOException {
                return NbDocument.findLineColumn(Manager.this.getCloneableEditorSupport().openDocument(), this.offset);
            }

            public void write(DataOutput dataOutput) throws IOException {
                if (this.offset < 0) {
                    IOException iOException = new IOException();
                    Manager.annotateException(iOException, "Illegal OffsetKind[offset=" + this.offset + "] in " + Manager.this.doc + " used by " + Manager.this.support + ".");
                    throw iOException;
                }
                dataOutput.writeInt(this.offset);
                dataOutput.writeInt(-1);
                dataOutput.writeInt(-1);
            }
        }

        private final class OutKind
        extends Kind {
            private int offset;
            private int line;
            private int column;

            public OutKind(PositionKind positionKind) {
                int n = positionKind.getOffset();
                int n2 = positionKind.getLine();
                int n3 = positionKind.getColumn();
                if (n < 0 || n2 < 0 || n3 < 0) {
                    IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
                    Manager.annotateException(indexOutOfBoundsException, "Illegal OutKind[offset=" + n + ",line=" + n2 + ",column=" + n3 + "] in " + Manager.this.doc + " used by " + Manager.this.support + ".");
                    throw indexOutOfBoundsException;
                }
                this.offset = n;
                this.line = n2;
                this.column = n3;
            }

            OutKind(int n, int n2, int n3) {
                this.offset = n;
                this.line = n2;
                this.column = n3;
            }

            public int getOffset() {
                return this.offset;
            }

            public int getLine() {
                return this.line;
            }

            public int getColumn() {
                return this.column;
            }

            public void write(DataOutput dataOutput) throws IOException {
                if (this.offset < 0 || this.line < 0 || this.column < 0) {
                    IOException iOException = new IOException();
                    Manager.annotateException(iOException, "Illegal OutKind[offset=" + this.offset + ",line=" + this.line + ",column=" + this.column + "] in " + Manager.this.doc + " used by " + Manager.this.support + ".");
                    throw iOException;
                }
                dataOutput.writeInt(this.offset);
                dataOutput.writeInt(this.line);
                dataOutput.writeInt(this.column);
            }
        }

        private final class PositionKind
        extends Kind {
            private Position pos;

            public PositionKind(Position position) {
                this.pos = position;
            }

            public int getOffset() {
                return this.pos.getOffset();
            }

            public int getLine() {
                return NbDocument.findLineNumber(Manager.this.doc, this.getOffset());
            }

            public int getColumn() {
                return NbDocument.findLineColumn(Manager.this.doc, this.getOffset());
            }

            public void write(DataOutput dataOutput) throws IOException {
                int n = this.getOffset();
                int n2 = this.getLine();
                int n3 = this.getColumn();
                if (n < 0 || n2 < 0 || n3 < 0) {
                    IOException iOException = new IOException();
                    Manager.annotateException(iOException, "Illegal PositionKind: " + this.pos + "[offset=" + n + ",line=" + n2 + ",column=" + n3 + "] in " + Manager.this.doc + " used by " + Manager.this.support + ".");
                    throw iOException;
                }
                dataOutput.writeInt(n);
                dataOutput.writeInt(n2);
                dataOutput.writeInt(n3);
            }

            public PositionKind toMemory(boolean bl) {
                return this;
            }

            public Kind fromMemory() {
                return new OutKind(this);
            }
        }

        private abstract class Kind {
            Kind() {
            }

            public abstract int getOffset();

            public abstract int getLine() throws IOException;

            public abstract int getColumn() throws IOException;

            public abstract void write(DataOutput var1) throws IOException;

            public PositionKind toMemory(boolean bl) {
                Position position;
                try {
                    position = NbDocument.createPosition(Manager.this.doc, this.getOffset(), bl ? Position.Bias.Forward : Position.Bias.Backward);
                }
                catch (BadLocationException badLocationException) {
                    position = Manager.this.doc.getEndPosition();
                }
                return new PositionKind(position);
            }

            public Kind fromMemory() {
                return this;
            }
        }

        private static class ChainItem
        extends WeakReference {
            ChainItem next;

            public ChainItem(PositionRef positionRef, ReferenceQueue referenceQueue, ChainItem chainItem) {
                super(positionRef, referenceQueue);
                this.next = chainItem;
            }
        }
    }
}

