/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class TopComponent
extends JComponent
implements Externalizable,
Accessible {
    static final long serialVersionUID = -3022538025284122942L;
    private static Registry registry;
    public static final int CLOSE_EACH = 0;
    public static final int CLOSE_LAST = 1;
    private static SystemAction[] systemActions;
    private NodeName nodeName;
    private final WindowManager.Component manager;
    private int closeOperation = 1;
    private boolean processingRequestFocus = false;
    short serialVersion = 1;
    private static Method helpCtxMethod;
    static /* synthetic */ Class class$org$openide$actions$SaveAction;
    static /* synthetic */ Class class$org$openide$actions$CloneViewAction;
    static /* synthetic */ Class class$org$openide$actions$CloseViewAction;
    static /* synthetic */ Class class$org$openide$windows$TopComponent;

    public TopComponent() {
        this.enableEvents(8L);
        this.putClientProperty("HelpIDMethod", TopComponent.getHelpCtxMethod());
        this.setRequestFocusEnabled(false);
        this.manager = WindowManager.getDefault().createTopComponentManager(this);
    }

    public TopComponent(DataObject dataObject) {
        this();
        Node node = dataObject.getNodeDelegate();
        this.nodeName = new NodeName(this);
        this.nodeName.attach(node);
        this.getAccessibleContext().setAccessibleDescription(node.getDisplayName());
    }

    public static final Registry getRegistry() {
        return WindowManager.getDefault().getRegistry();
    }

    public final Node[] getActivatedNodes() {
        return this.getManager().getActivatedNodes();
    }

    public final void setActivatedNodes(Node[] nodeArray) {
        this.getManager().setActivatedNodes(nodeArray);
        this.firePropertyChange("activatedNodes", null, null);
    }

    public UndoRedo getUndoRedo() {
        return UndoRedo.NONE;
    }

    public void open() {
        this.open(null);
    }

    public void open(Workspace workspace) {
        this.getManager().open(workspace);
    }

    public final boolean isOpened() {
        return this.getManager().whereOpened().size() > 0;
    }

    public final boolean isOpened(Workspace workspace) {
        return this.getManager().whereOpened().contains(workspace);
    }

    public final boolean close() {
        return this.close(WindowManager.getDefault().getCurrentWorkspace());
    }

    public final boolean close(Workspace workspace) {
        boolean bl;
        Set set = this.getManager().whereOpened();
        if (this.closeOperation != 0 && !set.contains(workspace)) {
            return true;
        }
        switch (this.closeOperation) {
            case 1: {
                bl = this.canClose(workspace, set.size() == 1);
                break;
            }
            case 0: {
                bl = this.canClose(null, true);
                break;
            }
            default: {
                throw new IllegalStateException("closeOperation=" + this.closeOperation);
            }
        }
        if (bl) {
            this.getManager().close(workspace);
        }
        return bl;
    }

    public boolean canClose(Workspace workspace, boolean bl) {
        return true;
    }

    protected void openNotify() {
    }

    protected void closeNotify() {
    }

    public SystemAction[] getSystemActions() {
        if (systemActions == null) {
            systemActions = new SystemAction[]{SystemAction.get(class$org$openide$actions$SaveAction == null ? (class$org$openide$actions$SaveAction = TopComponent.class$("org.openide.actions.SaveAction")) : class$org$openide$actions$SaveAction), SystemAction.get(class$org$openide$actions$CloneViewAction == null ? (class$org$openide$actions$CloneViewAction = TopComponent.class$("org.openide.actions.CloneViewAction")) : class$org$openide$actions$CloneViewAction), null, SystemAction.get(class$org$openide$actions$CloseViewAction == null ? (class$org$openide$actions$CloseViewAction = TopComponent.class$("org.openide.actions.CloseViewAction")) : class$org$openide$actions$CloseViewAction)};
        }
        return systemActions;
    }

    public final void setCloseOperation(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException(NbBundle.getBundle(class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = TopComponent.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent).getString("EXC_UnknownOperation"));
        }
        if (this.closeOperation == n) {
            return;
        }
        this.closeOperation = n;
        this.firePropertyChange("closeOperation", null, null);
    }

    public final int getCloseOperation() {
        return this.closeOperation;
    }

    protected void componentOpened() {
        this.openNotify();
    }

    protected void componentClosed() {
        this.closeNotify();
    }

    protected void componentShowing() {
    }

    protected void componentHidden() {
    }

    protected void componentActivated() {
    }

    protected void componentDeactivated() {
    }

    public void requestFocus() {
        if (this.processingRequestFocus) {
            return;
        }
        this.processingRequestFocus = true;
        this.getManager().requestFocus();
        super.requestFocus();
        this.processingRequestFocus = false;
    }

    public void requestVisible() {
        this.getManager().requestVisible();
    }

    public void setName(String string) {
        if (string != null && string.equals(this.getName())) {
            return;
        }
        super.setName(string);
        this.getManager().nameChanged();
    }

    public void setIcon(Image image) {
        this.getManager().setIcon(image);
        this.firePropertyChange("icon", null, null);
    }

    public Image getIcon() {
        return this.getManager().getIcon();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = TopComponent.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent);
    }

    public List availableModes(List list) {
        return list;
    }

    final WindowManager.Component getManager() {
        return this.manager;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(new Short(this.serialVersion));
        objectOutput.writeInt(this.closeOperation);
        objectOutput.writeObject(this.getName());
        objectOutput.writeObject(this.getToolTipText());
        Node.Handle handle = this.nodeName == null ? null : this.nodeName.node.getHandle();
        objectOutput.writeObject(handle);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object = objectInput.readObject();
        if (object instanceof Integer) {
            this.serialVersion = 0;
            this.closeOperation = (Integer)object;
            DataObject dataObject = (DataObject)objectInput.readObject();
            super.setName((String)objectInput.readObject());
            this.setToolTipText((String)objectInput.readObject());
            if (dataObject != null) {
                this.nodeName = new NodeName(this);
                this.nodeName.attach(dataObject.getNodeDelegate());
            }
        } else {
            this.serialVersion = (Short)object;
            this.closeOperation = objectInput.readInt();
            super.setName((String)objectInput.readObject());
            this.setToolTipText((String)objectInput.readObject());
            Node.Handle handle = (Node.Handle)objectInput.readObject();
            if (handle != null) {
                Node node = handle.getNode();
                this.nodeName = new NodeName(this);
                this.nodeName.attach(node);
            }
        }
        if (this.closeOperation != 0 && this.closeOperation != 1) {
            throw new IOException("invalid closeOperation: " + this.closeOperation);
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new Replacer(this);
    }

    private static Method getHelpCtxMethod() {
        if (helpCtxMethod != null) {
            return helpCtxMethod;
        }
        try {
            helpCtxMethod = (class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = TopComponent.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent).getMethod("getHelpCtx", new Class[0]);
            return helpCtxMethod;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InternalError();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }

                public String getAccessibleName() {
                    if (this.accessibleName != null) {
                        return this.accessibleName;
                    }
                    return TopComponent.this.getName();
                }

                public String getToolTipText() {
                    return TopComponent.this.getToolTipText();
                }
            };
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class Replacer
    implements Serializable {
        static final long serialVersionUID = -8897067133215740572L;
        transient TopComponent tc;
        static /* synthetic */ Class class$java$lang$ClassLoader;
        static /* synthetic */ Class class$java$io$ObjectStreamException;
        static /* synthetic */ Class class$java$lang$Object;

        public Replacer(TopComponent topComponent) {
            this.tc = topComponent;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
            objectOutputStream.writeObject(this.tc.getClass().getName());
            this.tc.writeExternal(objectOutputStream);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            block11: {
                String string = (String)objectInputStream.readObject();
                string = Utilities.translate(string);
                try {
                    Class<?>[] classArray;
                    Class<?> clazz = Class.forName(string, true, (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Replacer.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader));
                    Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                    ((AccessibleObject)constructor).setAccessible(true);
                    try {
                        this.tc = (TopComponent)constructor.newInstance(new Object[0]);
                        classArray = null;
                        ((AccessibleObject)constructor).setAccessible(false);
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        ((AccessibleObject)constructor).setAccessible(false);
                        throw throwable;
                    }
                    this.tc.readExternal(objectInputStream);
                    Method method = Replacer.findReadResolveMethod(clazz);
                    if (method == null || (classArray = method.getExceptionTypes()).length != 1 || !(class$java$io$ObjectStreamException == null ? (class$java$io$ObjectStreamException = Replacer.class$("java.io.ObjectStreamException")) : class$java$io$ObjectStreamException).equals(classArray[0]) || !(class$java$lang$Object == null ? (class$java$lang$Object = Replacer.class$("java.lang.Object")) : class$java$lang$Object).equals(method.getReturnType())) break block11;
                    ((AccessibleObject)method).setAccessible(true);
                    try {
                        TopComponent topComponent = this.tc;
                        this.tc = (TopComponent)method.invoke((Object)this.tc, (Object[])new Class[0]);
                        if (this.tc == null) {
                            throw new InvalidObjectException("Resolved component is invalid: " + topComponent);
                        }
                        Object var9_15 = null;
                        ((AccessibleObject)method).setAccessible(false);
                    }
                    catch (Throwable throwable) {
                        Object var9_16 = null;
                        ((AccessibleObject)method).setAccessible(false);
                        throw throwable;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (classNotFoundException.getMessage().indexOf("org.netbeans.modules.objectbrowser") != -1 || classNotFoundException.getMessage().indexOf("org.netbeans.modules.icebrowser") != -1) {
                        this.tc = null;
                    }
                    IOException iOException = new IOException(classNotFoundException.getMessage());
                    ErrorManager.getDefault().annotate((Throwable)iOException, classNotFoundException);
                    throw iOException;
                }
                catch (Exception exception) {
                    Throwable throwable = exception;
                    if (throwable instanceof InvocationTargetException) {
                        throwable = ((InvocationTargetException)throwable).getTargetException();
                    }
                    if (throwable instanceof IOException) {
                        throw (IOException)throwable;
                    }
                    IOException iOException = new IOException(throwable.getMessage());
                    ErrorManager.getDefault().annotate((Throwable)iOException, throwable);
                    throw iOException;
                }
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return this.tc;
        }

        private static Method findReadResolveMethod(Class clazz) {
            Method method = null;
            try {
                method = clazz.getMethod("readResolve", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            Class clazz2 = clazz;
            while (clazz2 != null) {
                try {
                    method = clazz2.getDeclaredMethod("readResolve", new Class[0]);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    clazz2 = clazz2.getSuperclass();
                }
            }
            return method;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static interface Registry {
        public static final String PROP_OPENED = "opened";
        public static final String PROP_ACTIVATED = "activated";
        public static final String PROP_CURRENT_NODES = "currentNodes";
        public static final String PROP_ACTIVATED_NODES = "activatedNodes";

        public Set getOpened();

        public TopComponent getActivated();

        public Node[] getCurrentNodes();

        public Node[] getActivatedNodes();

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }

    public static class NodeName
    extends NodeAdapter {
        private transient Reference top;
        private transient Node node;

        public NodeName(TopComponent topComponent) {
            this.top = new WeakReference<TopComponent>(topComponent);
        }

        final void attach(Node node) {
            TopComponent topComponent = (TopComponent)this.top.get();
            if (topComponent != null) {
                TopComponent topComponent2 = topComponent;
                synchronized (topComponent2) {
                    if (node == this.node) {
                        return;
                    }
                    if (this.node != null) {
                        this.node.removeNodeListener(this);
                    }
                    this.node = node;
                    if (node != null) {
                        node.addNodeListener(this);
                        topComponent.setActivatedNodes(new Node[]{node});
                        topComponent.setName(node.getDisplayName());
                    }
                }
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TopComponent topComponent = (TopComponent)this.top.get();
            if (topComponent == null) {
                if (propertyChangeEvent.getSource() instanceof Node) {
                    Node node = (Node)propertyChangeEvent.getSource();
                    node.removeNodeListener(this);
                }
                return;
            }
            this.attach(this.node);
            if (propertyChangeEvent.getPropertyName().equals("displayName")) {
                topComponent.setName(this.node.getDisplayName());
            }
        }
    }

    public static interface Cloneable {
        public TopComponent cloneComponent();
    }
}

