/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ajp;

import java.io.UnsupportedEncodingException;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;

public class Ajp13Packet {
    public static final String DEFAULT_CHAR_ENCODING = "8859_1";
    public static final int AJP13_WS_HEADER = 4660;
    public static final int AJP13_SW_HEADER = 16706;
    String encoding = "8859_1";
    byte[] buff;
    int pos;
    int len;

    public Ajp13Packet(int size) {
        this.buff = new byte[size];
    }

    public Ajp13Packet(byte[] b) {
        this.buff = b;
    }

    public MessageBytes addHeader(MimeHeaders headers) {
        int length = this.getInt();
        if (length == 65535 || length == -1) {
            return null;
        }
        MessageBytes vMB = headers.addValue(this.buff, this.pos, length);
        this.pos += length;
        ++this.pos;
        return vMB;
    }

    public void appendBool(boolean val) {
        this.buff[this.pos++] = (byte)(val ? 1 : 0);
    }

    public void appendByte(byte val) {
        this.buff[this.pos++] = val;
    }

    public void appendBytes(byte[] b, int off, int numBytes) {
        this.appendInt(numBytes);
        if (this.pos + numBytes >= this.buff.length) {
            System.out.println("Buffer overflow " + this.buff.length + " " + this.pos + " " + numBytes);
        }
        System.arraycopy(b, off, this.buff, this.pos, numBytes);
        this.buff[this.pos + numBytes] = 0;
        this.pos += numBytes + 1;
    }

    public void appendInt(int val) {
        this.setInt(this.pos, val);
        this.pos += 2;
    }

    public void appendLongInt(int val) {
        this.setLongInt(this.pos, val);
        this.pos += 4;
    }

    public void appendString(String str) throws UnsupportedEncodingException {
        if (str == null) {
            this.setInt(this.pos, 0);
            this.buff[this.pos + 2] = 0;
            this.pos += 3;
            return;
        }
        byte[] bytes = str.getBytes(this.encoding);
        this.appendBytes(bytes, 0, bytes.length);
    }

    public void appendXBytes(byte[] b, int off, int numBytes) {
        if (this.pos + numBytes > this.buff.length) {
            System.out.println("appendXBytes - Buffer overflow " + this.buff.length + " " + this.pos + " " + numBytes);
        }
        System.arraycopy(b, off, this.buff, this.pos, numBytes);
        this.pos += numBytes;
    }

    public int checkIn() {
        this.pos = 0;
        int mark = this.getInt();
        this.len = this.getInt();
        if (mark != 4660) {
            System.out.println("BAD packet " + mark);
            this.dump("In: ");
            return -1;
        }
        return this.len;
    }

    public void dump(String msg) {
        System.out.println(String.valueOf(msg) + ": " + this.buff + " " + this.pos + "/" + (this.len + 4));
        int j = 0;
        while (j < this.len + 4) {
            this.hexLine(j);
            j += 16;
        }
        System.out.println();
    }

    public void end() {
        this.len = this.pos;
        this.setInt(2, this.len - 4);
    }

    public boolean getBool() {
        return this.getByte() == 1;
    }

    public byte[] getBuff() {
        return this.buff;
    }

    public byte getByte() {
        byte res = this.buff[this.pos];
        ++this.pos;
        return res;
    }

    public int getByteOff() {
        return this.pos;
    }

    public int getBytes(byte[] dest) {
        int length = this.getInt();
        if (length > this.buff.length) {
            System.out.println("XXX Assert failed, buff too small ");
        }
        if (length == 65535 || length == -1) {
            System.out.println("null string " + length);
            return 0;
        }
        System.arraycopy(this.buff, this.pos, dest, 0, length);
        this.pos += length;
        ++this.pos;
        return length;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getInt() {
        int result = this.peekInt();
        this.pos += 2;
        return result;
    }

    public int getLen() {
        return this.len;
    }

    public int getLongInt() {
        int result = this.peekLongInt();
        this.pos += 4;
        return result;
    }

    public void getMessageBytes(MessageBytes mb) {
        int length = this.getInt();
        if (length == 65535 || length == -1) {
            mb.setString(null);
            return;
        }
        mb.setBytes(this.buff, this.pos, length);
        this.pos += length;
        ++this.pos;
    }

    public String getString() throws UnsupportedEncodingException {
        int length = this.getInt();
        if (length == 65535 || length == -1) {
            return null;
        }
        String s = new String(this.buff, this.pos, length, this.encoding);
        this.pos += length;
        ++this.pos;
        return s;
    }

    public int getXBytes(byte[] dest, int length) {
        if (length > this.buff.length) {
            System.out.println("XXX Assert failed, buff too small ");
        }
        System.arraycopy(this.buff, this.pos, dest, 0, length);
        this.pos += length;
        return length;
    }

    private String hex(int x) {
        String h = Integer.toHexString(x);
        if (h.length() == 1) {
            h = "0" + h;
        }
        return h.substring(h.length() - 2);
    }

    private void hexLine(int start) {
        int pkgEnd = this.len + 4;
        if (pkgEnd > this.buff.length) {
            pkgEnd = this.buff.length;
        }
        int i = start;
        while (i < start + 16) {
            if (i < pkgEnd) {
                System.out.print(String.valueOf(this.hex(this.buff[i])) + " ");
            } else {
                System.out.print("   ");
            }
            ++i;
        }
        System.out.print(" | ");
        int i2 = start;
        while (i2 < start + 16 && i2 < pkgEnd) {
            if (Character.isLetterOrDigit((char)this.buff[i2])) {
                System.out.print(new Character((char)this.buff[i2]));
            } else {
                System.out.print(".");
            }
            ++i2;
        }
        System.out.println();
    }

    public byte peekByte() {
        return this.buff[this.pos];
    }

    public int peekInt() {
        int b1 = this.buff[this.pos] & 0xFF;
        int b2 = this.buff[this.pos + 1] & 0xFF;
        return (b1 << 8) + b2;
    }

    public int peekLongInt() {
        int b1 = this.buff[this.pos] & 0xFF;
        b1 <<= 8;
        b1 |= this.buff[this.pos + 1] & 0xFF;
        b1 <<= 8;
        b1 |= this.buff[this.pos + 2] & 0xFF;
        b1 <<= 8;
        return b1 |= this.buff[this.pos + 3] & 0xFF;
    }

    public void reset() {
        this.len = 4;
        this.pos = 4;
        this.buff[0] = 65;
        this.buff[1] = 66;
    }

    public void setByteOff(int c) {
        this.pos = c;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    private void setInt(int bPos, int val) {
        this.buff[bPos] = (byte)(val >>> 8 & 0xFF);
        this.buff[bPos + 1] = (byte)(val & 0xFF);
    }

    private void setLongInt(int bPos, int val) {
        this.buff[bPos] = (byte)(val >>> 24 & 0xFF);
        this.buff[bPos + 1] = (byte)(val >>> 16 & 0xFF);
        this.buff[bPos + 2] = (byte)(val >>> 8 & 0xFF);
        this.buff[bPos + 3] = (byte)(val & 0xFF);
    }
}

