/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.netbeans.modules.form.FormCookie;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponentCookie;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.actions.FormEditorAction;
import org.netbeans.modules.form.actions.ReloadAction;
import org.netbeans.modules.form.actions.TestAction;
import org.netbeans.modules.form.palette.CPManager;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.PasteAction;
import org.openide.awt.SplittedPanel;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.propertysheet.PropertySheetView;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ClipboardEvent;
import org.openide.util.datatransfer.ClipboardListener;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;

public class ComponentInspector
extends ExplorerPanel
implements Serializable {
    private TestAction testAction = (TestAction)SharedClassObject.findObject((Class)(class$org$netbeans$modules$form$actions$TestAction == null ? (class$org$netbeans$modules$form$actions$TestAction = ComponentInspector.class$("org.netbeans.modules.form.actions.TestAction")) : class$org$netbeans$modules$form$actions$TestAction), (boolean)true);
    private FormEditorAction inspectorAction = (FormEditorAction)SharedClassObject.findObject((Class)(class$org$netbeans$modules$form$actions$FormEditorAction == null ? (class$org$netbeans$modules$form$actions$FormEditorAction = ComponentInspector.class$("org.netbeans.modules.form.actions.FormEditorAction")) : class$org$netbeans$modules$form$actions$FormEditorAction), (boolean)true);
    private ReloadAction reloadAction = (ReloadAction)SharedClassObject.findObject((Class)(class$org$netbeans$modules$form$actions$ReloadAction == null ? (class$org$netbeans$modules$form$actions$ReloadAction = ComponentInspector.class$("org.netbeans.modules.form.actions.ReloadAction")) : class$org$netbeans$modules$form$actions$ReloadAction), (boolean)true);
    private DeleteAction deleteAction = (DeleteAction)SharedClassObject.findObject((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = ComponentInspector.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction), (boolean)true);
    private CopyAction copyAction = (CopyAction)SharedClassObject.findObject((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = ComponentInspector.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction), (boolean)true);
    private CutAction cutAction = (CutAction)SharedClassObject.findObject((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = ComponentInspector.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction), (boolean)true);
    private PasteAction pasteAction = (PasteAction)SharedClassObject.findObject((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = ComponentInspector.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction), (boolean)true);
    private ActionPerformer copyActionPerformer = new CopyCutActionPerformer(true);
    private ActionPerformer cutActionPerformer = new CopyCutActionPerformer(false);
    private ActionPerformer deleteActionPerformer = new DeleteActionPerformer();
    private boolean actionsAttached = false;
    private ClipboardListener clipboardListener;
    private FormEditorSupport focusedForm;
    private boolean dontSynchronizeSelectedNodes = false;
    private SplittedPanel split;
    private PropertySheetView sheet;
    private static EmptyInspectorNode emptyInspectorNode;
    private static final String EMPTY_INSPECTOR_ICON_BASE = "org/netbeans/modules/form/resources/emptyInspector";
    private static final String iconURL = "org/netbeans/modules/form/resources/inspector.gif";
    private static String INSPECTOR_TITLE;
    private static ComponentInspector instance;
    static /* synthetic */ Class class$org$netbeans$modules$form$actions$TestAction;
    static /* synthetic */ Class class$org$netbeans$modules$form$actions$FormEditorAction;
    static /* synthetic */ Class class$org$netbeans$modules$form$actions$ReloadAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$java$awt$datatransfer$Clipboard;

    public static ComponentInspector getInstance() {
        if (instance == null) {
            instance = new ComponentInspector();
        }
        return instance;
    }

    private ComponentInspector() {
        ExplorerManager explorerManager = this.getExplorerManager();
        emptyInspectorNode = new EmptyInspectorNode();
        explorerManager.setRootContext((Node)emptyInspectorNode);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.createSplit();
        this.setIcon(Utilities.loadImage((String)iconURL));
        if (INSPECTOR_TITLE == null) {
            INSPECTOR_TITLE = FormUtils.getBundleString("CTL_InspectorTitle");
        }
        this.setName(INSPECTOR_TITLE);
        ((JComponent)((Object)this)).putClientProperty("TabPolicy", "HideWhenAlone");
        ((JComponent)((Object)this)).setToolTipText(FormUtils.getBundleString("HINT_ComponentInspector"));
        explorerManager.addPropertyChangeListener((PropertyChangeListener)new NodeSelectionListener());
    }

    private void createSplit() {
        this.split = new SplittedPanel();
        BeanTreeView beanTreeView = new BeanTreeView();
        this.sheet = new PropertySheetView();
        this.split.add((Component)beanTreeView, SplittedPanel.ADD_FIRST);
        this.split.add((Component)this.sheet, SplittedPanel.ADD_SECOND);
        this.split.setSplitType(1);
        this.split.setSplitPosition(30);
        this.sheet.setDisplayWritableOnly(FormEditor.getFormSettings().getDisplayWritableOnly());
        this.sheet.addPropertyChangeListener(new PropertiesDisplayListener());
        ((Container)((Object)this)).add("Center", (Component)this.split);
        beanTreeView.getAccessibleContext().setAccessibleName(FormUtils.getBundleString("ACS_ComponentTree"));
        beanTreeView.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_ComponentTree"));
    }

    protected void componentActivated() {
        this.attachActions();
    }

    protected void componentDeactivated() {
        this.detachActions();
    }

    synchronized void attachActions() {
        this.actionsAttached = true;
        this.updateActions();
        Clipboard clipboard = this.getClipboard();
        if (clipboard instanceof ExClipboard) {
            ExClipboard exClipboard = (ExClipboard)clipboard;
            if (this.clipboardListener == null) {
                this.clipboardListener = new ClipboardChangesListener();
            }
            exClipboard.addClipboardListener(this.clipboardListener);
        }
    }

    synchronized void detachActions() {
        this.actionsAttached = false;
        Clipboard clipboard = this.getClipboard();
        if (clipboard instanceof ExClipboard) {
            ExClipboard exClipboard = (ExClipboard)clipboard;
            exClipboard.removeClipboardListener(this.clipboardListener);
        }
        if (this.deleteActionPerformer == this.deleteAction.getActionPerformer()) {
            this.deleteAction.setActionPerformer(null);
        }
        if (this.copyActionPerformer == this.copyAction.getActionPerformer()) {
            this.copyAction.setActionPerformer(null);
            this.pasteAction.setPasteTypes(null);
        }
        if (this.cutActionPerformer == this.cutAction.getActionPerformer()) {
            this.cutAction.setActionPerformer(null);
        }
    }

    boolean getActionsAttached() {
        return this.actionsAttached;
    }

    public void focusForm(FormEditorSupport formEditorSupport) {
        if (this.focusedForm != formEditorSupport) {
            this.focusFormInAwtThread(formEditorSupport, 0);
        }
    }

    public void focusForm(FormEditorSupport formEditorSupport, boolean bl) {
        if (this.focusedForm != formEditorSupport) {
            this.focusFormInAwtThread(formEditorSupport, bl ? 1 : -1);
        }
    }

    private void focusFormInAwtThread(final FormEditorSupport formEditorSupport, final int n) {
        if (EventQueue.isDispatchThread()) {
            this.focusFormImpl(formEditorSupport, n);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ComponentInspector.this.focusFormImpl(formEditorSupport, n);
                }
            });
        }
    }

    private void focusFormImpl(FormEditorSupport formEditorSupport, int n) {
        this.focusedForm = formEditorSupport;
        if (formEditorSupport == null) {
            this.testAction.setFormModel(null);
            this.inspectorAction.setEnabled(false);
            this.reloadAction.setForm(null);
            ((Container)((Object)this)).remove((Component)this.split);
            this.createSplit();
            this.getExplorerManager().setRootContext((Node)emptyInspectorNode);
        } else {
            this.testAction.setFormModel(formEditorSupport.getFormModel());
            this.inspectorAction.setEnabled(true);
            this.reloadAction.setForm(formEditorSupport);
            Node node = formEditorSupport.getFormRootNode();
            if (node == null) {
                System.err.println("Warning: FormEditorSupport.getFormRootNode() returns null");
                this.getExplorerManager().setRootContext((Node)emptyInspectorNode);
            } else {
                this.sheet.setDisplayWritableOnly(!formEditorSupport.getFormModel().isReadOnly() && FormEditor.getFormSettings().getDisplayWritableOnly());
                this.dontSynchronizeSelectedNodes = true;
                this.getExplorerManager().setRootContext(node);
                this.dontSynchronizeSelectedNodes = false;
            }
        }
        this.setName(INSPECTOR_TITLE);
        if (n > 0) {
            this.open();
            this.setCloseOperation(1);
        } else if (n < 0) {
            this.setCloseOperation(0);
            this.close();
        }
    }

    protected void updateTitle() {
        this.setName(INSPECTOR_TITLE);
    }

    FormEditorSupport getFocusedForm() {
        return this.focusedForm;
    }

    void setSelectedNodes(Node[] nodeArray, FormEditorSupport formEditorSupport) throws PropertyVetoException {
        if (formEditorSupport == this.focusedForm) {
            this.dontSynchronizeSelectedNodes = true;
            this.getExplorerManager().setSelectedNodes(nodeArray);
            this.dontSynchronizeSelectedNodes = false;
        }
    }

    Node[] getSelectedNodes() {
        return this.getExplorerManager().getSelectedNodes();
    }

    private void updateActions() {
        int n;
        boolean bl = false;
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        int n2 = n = nodeArray != null ? nodeArray.length : 0;
        if (n > 0) {
            int n3;
            if (n > 1) {
                HashMap hashMap = new HashMap(101);
                n3 = 0;
                while (n3 < n) {
                    if (!this.checkNodeParents(nodeArray[n3], hashMap)) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
            }
            if (!bl) {
                n3 = 0;
                while (n3 < n) {
                    if (!nodeArray[n3].canCopy()) {
                        this.copyAction.setActionPerformer(null);
                        break;
                    }
                    ++n3;
                }
                if (n3 == n) {
                    this.copyAction.setActionPerformer(this.copyActionPerformer);
                }
                n3 = 0;
                while (n3 < n) {
                    if (!nodeArray[n3].canCut()) {
                        this.cutAction.setActionPerformer(null);
                        break;
                    }
                    ++n3;
                }
                if (n3 == n) {
                    this.cutAction.setActionPerformer(this.cutActionPerformer);
                }
                n3 = 0;
                while (n3 < n) {
                    if (!nodeArray[n3].canDestroy()) {
                        this.deleteAction.setActionPerformer(null);
                        break;
                    }
                    ++n3;
                }
                if (n3 == n) {
                    this.deleteAction.setActionPerformer(this.deleteActionPerformer);
                }
            }
        } else {
            bl = true;
        }
        if (bl) {
            this.deleteAction.setActionPerformer(null);
            this.copyAction.setActionPerformer(null);
            this.cutAction.setActionPerformer(null);
        }
        this.updatePasteAction();
    }

    private void updatePasteAction() {
        block9: {
            Clipboard clipboard;
            Transferable transferable;
            Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
            if (nodeArray != null && nodeArray.length == 1 && (transferable = (clipboard = this.getClipboard()).getContents(this)) != null) {
                Node node = nodeArray[0];
                PasteType[] pasteTypeArray = node.getPasteTypes(transferable);
                if (pasteTypeArray.length != 0) {
                    this.pasteAction.setPasteTypes(pasteTypeArray);
                    return;
                }
                boolean bl = false;
                try {
                    bl = transferable.isDataFlavorSupported(ExTransferable.multiFlavor);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (bl) {
                    try {
                        MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
                        int n = multiTransferObject.getCount();
                        Transferable[] transferableArray = new Transferable[n];
                        PasteType[] pasteTypeArray2 = new PasteType[n];
                        int n2 = 0;
                        while (n2 < n) {
                            transferableArray[n2] = multiTransferObject.getTransferableAt(n2);
                            pasteTypeArray = node.getPasteTypes(transferableArray[n2]);
                            if (pasteTypeArray.length == 0) break;
                            pasteTypeArray2[n2] = pasteTypeArray[0];
                            ++n2;
                        }
                        if (n2 == n) {
                            this.pasteAction.setPasteTypes(new PasteType[]{new MultiPasteType(transferableArray, pasteTypeArray2)});
                            return;
                        }
                    }
                    catch (Exception exception) {
                        if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block9;
                        exception.printStackTrace();
                    }
                }
            }
        }
        this.pasteAction.setPasteTypes(null);
    }

    private boolean checkNodeParents(Node node, Map map) {
        if (map.get(node) != null) {
            return false;
        }
        map.put(node, this);
        node = node.getParentNode();
        while (node != null) {
            if (map.put(node, node) == this) {
                return false;
            }
            node = node.getParentNode();
        }
        return true;
    }

    public UndoRedo getUndoRedo() {
        UndoRedo.Manager manager = this.focusedForm != null ? this.focusedForm.getFormUndoRedoManager() : null;
        return manager != null ? manager : super.getUndoRedo();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.component-inspector");
    }

    public Dimension getPreferredSize() {
        return new Dimension(250, 400);
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    private Clipboard getClipboard() {
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(class$java$awt$datatransfer$Clipboard == null ? (class$java$awt$datatransfer$Clipboard = ComponentInspector.class$("java.awt.datatransfer.Clipboard")) : class$java$awt$datatransfer$Clipboard);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return clipboard;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class ResolvableHelper
    implements Serializable {
        static final long serialVersionUID = 7424646018839457544L;

        public Object readResolve() {
            return ComponentInspector.getInstance();
        }
    }

    private static class EmptyInspectorNode
    extends AbstractNode {
        public EmptyInspectorNode() {
            super(Children.LEAF);
            this.setIconBase(ComponentInspector.EMPTY_INSPECTOR_ICON_BASE);
        }

        public boolean canRename() {
            return false;
        }
    }

    private class MultiPasteType
    extends PasteType
    implements Mutex.ExceptionAction {
        private Transferable[] transIn;
        private PasteType[] pasteTypes;

        MultiPasteType(Transferable[] transferableArray, PasteType[] pasteTypeArray) {
            this.transIn = transferableArray;
            this.pasteTypes = pasteTypeArray;
        }

        public Transferable paste() throws IOException {
            if (EventQueue.isDispatchThread()) {
                return this.doPaste();
            }
            try {
                return (Transferable)Mutex.EVENT.readAccess((Mutex.ExceptionAction)this);
            }
            catch (MutexException mutexException) {
                Exception exception = mutexException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                exception.printStackTrace();
                return ExTransferable.EMPTY;
            }
        }

        public Object run() throws Exception {
            return this.doPaste();
        }

        private Transferable doPaste() throws IOException {
            Transferable[] transferableArray = new Transferable[this.transIn.length];
            int n = 0;
            while (n < this.pasteTypes.length) {
                Transferable transferable = this.pasteTypes[n].paste();
                transferableArray[n] = transferable != null ? transferable : this.transIn[n];
                ++n;
            }
            return new ExTransferable.Multi(transferableArray);
        }
    }

    private class CopyCutActionPerformer
    implements ActionPerformer {
        private boolean copy;

        public CopyCutActionPerformer(boolean bl) {
            this.copy = bl;
        }

        public void performAction(SystemAction systemAction) {
            Transferable[] transferableArray;
            Transferable transferable;
            Node[] nodeArray = ComponentInspector.this.getExplorerManager().getSelectedNodes();
            if (nodeArray == null || nodeArray.length == 0) {
                transferable = null;
            } else if (nodeArray.length == 1) {
                transferable = this.getTransferableOwner(nodeArray[0]);
            } else {
                transferableArray = new Transferable[nodeArray.length];
                int n = 0;
                while (n < nodeArray.length) {
                    transferableArray[n] = this.getTransferableOwner(nodeArray[n]);
                    if (transferableArray[n] == null) {
                        return;
                    }
                    ++n;
                }
                transferable = new ExTransferable.Multi(transferableArray);
            }
            if (transferable != null) {
                transferableArray = ComponentInspector.this.getClipboard();
                transferableArray.setContents(transferable, new StringSelection(""));
            }
        }

        private Transferable getTransferableOwner(Node node) {
            try {
                return this.copy ? node.clipboardCopy() : node.clipboardCut();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                return null;
            }
        }
    }

    private class DeleteActionPerformer
    implements ActionPerformer,
    Mutex.Action {
        private Node[] nodesToDestroy;
        static /* synthetic */ Class class$org$openide$explorer$ExplorerActions;

        private DeleteActionPerformer() {
        }

        public void performAction(SystemAction systemAction) {
            Node[] nodeArray = ComponentInspector.this.getExplorerManager().getSelectedNodes();
            if (nodeArray == null || nodeArray.length == 0) {
                return;
            }
            if (ExplorerPanel.isConfirmDelete() && !this.confirmDelete(nodeArray)) {
                return;
            }
            try {
                ComponentInspector.this.getExplorerManager().setSelectedNodes(new Node[0]);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.nodesToDestroy = nodeArray;
            if (EventQueue.isDispatchThread()) {
                this.doDelete();
            } else {
                Mutex.EVENT.readAccess((Mutex.Action)this);
            }
        }

        public Object run() {
            this.doDelete();
            return null;
        }

        private void doDelete() {
            if (this.nodesToDestroy != null) {
                int n = 0;
                while (n < this.nodesToDestroy.length) {
                    try {
                        this.nodesToDestroy[n].destroy();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    ++n;
                }
                this.nodesToDestroy = null;
            }
        }

        private boolean confirmDelete(Node[] nodeArray) {
            String string;
            String string2;
            if (nodeArray.length == 1) {
                string2 = NbBundle.getMessage((Class)(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = DeleteActionPerformer.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions), (String)"MSG_ConfirmDeleteObject", (Object)nodeArray[0].getDisplayName());
                string = NbBundle.getMessage((Class)(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = DeleteActionPerformer.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions), (String)"MSG_ConfirmDeleteObjectTitle");
            } else {
                string2 = NbBundle.getMessage((Class)(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = DeleteActionPerformer.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions), (String)"MSG_ConfirmDeleteObjects", (Object)new Integer(nodeArray.length));
                string = NbBundle.getMessage((Class)(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = DeleteActionPerformer.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions), (String)"MSG_ConfirmDeleteObjectsTitle");
            }
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string2, string, 0);
            return NotifyDescriptor.YES_OPTION.equals(TopManager.getDefault().notify((NotifyDescriptor)confirmation));
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private class PropertiesDisplayListener
    implements PropertyChangeListener {
        private PropertiesDisplayListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("displayWritableOnly".equals(propertyChangeEvent.getPropertyName())) {
                FormEditor.getFormSettings().setDisplayWritableOnly(ComponentInspector.this.sheet.getDisplayWritableOnly());
            }
        }
    }

    private class ClipboardChangesListener
    implements ClipboardListener {
        private ClipboardChangesListener() {
        }

        public void clipboardChanged(ClipboardEvent clipboardEvent) {
            if (!clipboardEvent.isConsumed()) {
                ComponentInspector.this.updatePasteAction();
            }
        }
    }

    private class NodeSelectionListener
    implements PropertyChangeListener,
    ActionListener {
        private Timer timer = new Timer(150, this);
        static /* synthetic */ Class class$org$netbeans$modules$form$RADComponentCookie;
        static /* synthetic */ Class class$org$netbeans$modules$form$FormCookie;

        NodeSelectionListener() {
            this.timer.setCoalesce(true);
            this.timer.setRepeats(false);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!"selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            this.timer.start();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ComponentInspector.this.actionsAttached) {
                ComponentInspector.this.updateActions();
            }
            if (ComponentInspector.this.focusedForm == null) {
                return;
            }
            FormDesigner formDesigner = ComponentInspector.this.focusedForm.getFormDesigner();
            if (formDesigner == null) {
                return;
            }
            Node[] nodeArray = ComponentInspector.this.getExplorerManager().getSelectedNodes();
            if (CPManager.getDefault().getMode() == 1) {
                if (nodeArray.length == 0) {
                    return;
                }
                RADComponentCookie rADComponentCookie = (RADComponentCookie)nodeArray[0].getCookie(class$org$netbeans$modules$form$RADComponentCookie == null ? (class$org$netbeans$modules$form$RADComponentCookie = NodeSelectionListener.class$("org.netbeans.modules.form.RADComponentCookie")) : class$org$netbeans$modules$form$RADComponentCookie);
                if (rADComponentCookie != null && rADComponentCookie.getRADComponent() == formDesigner.getConnectionSource() && nodeArray.length > 1) {
                    rADComponentCookie = (RADComponentCookie)nodeArray[nodeArray.length - 1].getCookie(class$org$netbeans$modules$form$RADComponentCookie == null ? (class$org$netbeans$modules$form$RADComponentCookie = NodeSelectionListener.class$("org.netbeans.modules.form.RADComponentCookie")) : class$org$netbeans$modules$form$RADComponentCookie);
                }
                if (rADComponentCookie != null) {
                    formDesigner.connectBean(rADComponentCookie.getRADComponent(), true);
                }
            } else if (!ComponentInspector.this.dontSynchronizeSelectedNodes) {
                formDesigner.clearSelectionImpl();
                int n = 0;
                while (n < nodeArray.length) {
                    Node node;
                    FormCookie formCookie = (FormCookie)nodeArray[n].getCookie(class$org$netbeans$modules$form$FormCookie == null ? NodeSelectionListener.class$("org.netbeans.modules.form.FormCookie") : class$org$netbeans$modules$form$FormCookie);
                    if (formCookie != null && (node = formCookie.getOriginalNode()) instanceof RADComponentNode) {
                        formDesigner.addComponentToSelectionImpl(((RADComponentNode)node).getRADComponent());
                    }
                    ++n;
                }
                formDesigner.repaintSelection();
            }
            this.timer.stop();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

