/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.fakepeer.FakePeerContainer;
import org.netbeans.modules.form.fakepeer.FakePeerSupport;

class ComponentLayer
extends JPanel {
    private static FormLoaderSettings formSettings = FormEditor.getFormSettings();
    private static final int HORIZONTAL_MARGIN = 12;
    private static final int VERTICAL_MARGIN = 12;
    private Container componentContainer = new FakePeerContainer();
    private DesignerPanel designerPanel;

    ComponentLayer() {
        this.componentContainer.setLayout(new BorderLayout());
        this.componentContainer.setBackground(Color.white);
        this.componentContainer.setFont(FakePeerSupport.getDefaultAWTFont());
        this.designerPanel = new DesignerPanel();
        this.designerPanel.setLayout(new BorderLayout());
        this.designerPanel.add((Component)this.componentContainer, "Center");
        this.setLayout(new FlowLayout(0, 12, 12));
        this.add(this.designerPanel);
        this.updateBackground();
    }

    Container getComponentContainer() {
        return this.componentContainer;
    }

    Rectangle getDesignerBounds() {
        Rectangle rectangle = new Rectangle(this.designerPanel.getDesignerSize());
        Insets insets = this.designerPanel.getInsets();
        rectangle.x = 12 + insets.left;
        rectangle.y = 12 + insets.top;
        return rectangle;
    }

    Dimension getDesignerSize() {
        return this.designerPanel.getDesignerSize();
    }

    Insets getDesignerOutsets() {
        return this.designerPanel.getInsets();
    }

    void updateDesignerSize(Dimension dimension) {
        if (dimension != null && !dimension.equals(this.designerPanel.getDesignerSize())) {
            this.designerPanel.setDesignerSize(dimension);
            this.revalidate();
            this.repaint();
        }
    }

    void setTopDesignComponent(Component component) {
        if (this.componentContainer.getComponentCount() > 0) {
            this.componentContainer.removeAll();
        }
        this.componentContainer.add(component, "Center");
    }

    void updateVisualSettings() {
        this.updateBackground();
        this.designerPanel.updateBorder();
    }

    private void updateBackground() {
        this.setBackground(formSettings.getFormDesignerBackgroundColor());
    }

    private static class DesignerPanel
    extends JPanel {
        private static int BORDER_THICKNESS = 5;
        private Dimension designerSize = new Dimension(400, 300);

        DesignerPanel() {
            this.updateBorder();
        }

        void updateBorder() {
            this.setBorder(new LineBorder(formSettings.getFormDesignerBorderColor(), BORDER_THICKNESS));
        }

        Dimension getDesignerSize() {
            return this.designerSize;
        }

        void setDesignerSize(Dimension dimension) {
            this.designerSize = dimension;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension(this.designerSize);
            Insets insets = this.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }
    }
}

