/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.ComponentLayer;
import org.netbeans.modules.form.ConnectionWizard;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.HandleLayer;
import org.netbeans.modules.form.InPlaceEditLayer;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.RADVisualFormContainer;
import org.netbeans.modules.form.VisualReplicator;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.netbeans.modules.form.palette.CPManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public class FormDesigner
extends TopComponent {
    static final String FORM_MODE_NAME = "Form";
    static final String PROP_DESIGNER_SIZE = "designerSize";
    private JLayeredPane layeredPane;
    private ComponentLayer componentLayer;
    private HandleLayer handleLayer;
    private InPlaceEditLayer textEditLayer;
    private FormProperty editedProperty;
    private RADVisualComponent topDesignComponent;
    private FormModel formModel;
    private FormModelListener formModelListener;
    private FormEditorSupport formEditorSupport;
    private VisualReplicator replicator = new VisualReplicator(null, new Class[]{class$java$awt$Window == null ? (class$java$awt$Window = FormDesigner.class$("java.awt.Window")) : class$java$awt$Window, class$java$applet$Applet == null ? (class$java$applet$Applet = FormDesigner.class$("java.applet.Applet")) : class$java$applet$Applet, class$java$awt$MenuComponent == null ? (class$java$awt$MenuComponent = FormDesigner.class$("java.awt.MenuComponent")) : class$java$awt$MenuComponent}, 3);
    private final ArrayList selectedComponents = new ArrayList();
    private RADComponent connectionSource;
    private RADComponent connectionTarget;
    private static String iconURL = "org/netbeans/modules/form/resources/formDesigner.gif";
    static /* synthetic */ Class class$java$awt$Window;
    static /* synthetic */ Class class$java$applet$Applet;
    static /* synthetic */ Class class$java$awt$MenuComponent;
    static /* synthetic */ Class class$javax$swing$JComponent;
    static /* synthetic */ Class class$javax$swing$RootPaneContainer;

    public FormDesigner() {
        this(null);
    }

    FormDesigner(FormModel formModel) {
        ((JComponent)((Object)this)).putClientProperty("PersistenceType", "OnlyOpened");
        this.setIcon(Utilities.loadImage((String)iconURL));
        this.formModelListener = new FormListener();
        this.componentLayer = new ComponentLayer();
        this.handleLayer = new HandleLayer(this);
        this.layeredPane = new JLayeredPane();
        this.layeredPane.setLayout(new OverlayLayout(this.layeredPane));
        this.layeredPane.add((Component)this.componentLayer, new Integer(1000));
        this.layeredPane.add((Component)this.handleLayer, new Integer(1001));
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add(new JScrollPane(this.layeredPane), "Center");
        this.setModel(formModel);
    }

    public void initialize() {
        this.updateWholeDesigner();
    }

    void setModel(FormModel formModel) {
        if (this.formModel != null) {
            this.formModel.removeFormModelListener(this.formModelListener);
            this.topDesignComponent = null;
        }
        this.formModel = formModel;
        if (this.formModel != null) {
            this.formModel.addFormModelListener(this.formModelListener);
            this.formEditorSupport = FormEditorSupport.getSupport(this.formModel);
            this.resetTopDesignComponent(false);
            this.updateName(this.formModel.getName());
            this.handleLayer.setViewOnly(this.formModel.isReadOnly());
            this.componentLayer.updateDesignerSize(this.getStoredDesignerSize());
        } else {
            this.formEditorSupport = null;
        }
    }

    FormModel getModel() {
        return this.formModel;
    }

    FormEditorSupport getFormEditorSupport() {
        return this.formEditorSupport;
    }

    public Object getComponent(RADComponent rADComponent) {
        return this.replicator.getClonedComponent(rADComponent);
    }

    public RADComponent getMetaComponent(Object object) {
        return this.replicator.getMetaComponent(object);
    }

    ComponentLayer getComponentLayer() {
        return this.componentLayer;
    }

    public RADVisualComponent getTopDesignComponent() {
        return this.topDesignComponent;
    }

    public void setTopDesignComponent(RADVisualComponent rADVisualComponent, boolean bl) {
        this.topDesignComponent = rADVisualComponent;
        if (bl) {
            this.setSelectedComponent(this.topDesignComponent);
            this.updateWholeDesigner();
        }
    }

    public void resetTopDesignComponent(boolean bl) {
        this.topDesignComponent = this.formModel.getTopRADComponent() instanceof RADVisualComponent ? (RADVisualComponent)this.formModel.getTopRADComponent() : null;
        if (bl) {
            this.setSelectedComponent(this.topDesignComponent);
            this.updateWholeDesigner();
        }
    }

    public boolean isInDesignedTree(RADComponent rADComponent) {
        return this.topDesignComponent != null && (this.topDesignComponent == rADComponent || this.topDesignComponent.isParentComponent(rADComponent));
    }

    void updateWholeDesigner() {
        if (this.formModelListener != null) {
            this.formModelListener.formChanged(null);
        }
        this.updateName(this.formModel.getName());
    }

    public static Container createFormView(final RADVisualComponent rADVisualComponent, final Class clazz) throws Exception {
        return (Container)FormLAF.executeWithLookAndFeel(UIManager.getLookAndFeel().getClass().getName(), new Mutex.ExceptionAction(){

            public Object run() throws Exception {
                VisualReplicator visualReplicator = new VisualReplicator(clazz, null, 0);
                visualReplicator.setTopMetaComponent(rADVisualComponent);
                return visualReplicator.createClone();
            }
        });
    }

    Dimension getStoredDesignerSize() {
        RADComponent rADComponent = this.formModel.getTopRADComponent();
        if (rADComponent == null) {
            return null;
        }
        return (Dimension)rADComponent.getAuxValue(PROP_DESIGNER_SIZE);
    }

    void setStoredDesignerSize(Dimension dimension) {
        RADComponent rADComponent = this.formModel.getTopRADComponent();
        if (rADComponent instanceof RADVisualFormContainer) {
            ((RADVisualFormContainer)rADComponent).setDesignerSize(dimension);
        } else if (rADComponent != null) {
            rADComponent.setAuxValue(PROP_DESIGNER_SIZE, dimension);
        }
    }

    List getSelectedComponents() {
        return this.selectedComponents;
    }

    boolean isComponentSelected(RADComponent rADComponent) {
        return this.selectedComponents.contains(rADComponent);
    }

    void setSelectedComponent(RADComponent rADComponent) {
        this.clearSelectionImpl();
        this.addComponentToSelectionImpl(rADComponent);
        this.repaintSelection();
        this.updateActivatedNodes();
    }

    void setSelectedComponents(RADComponent[] rADComponentArray) {
        this.clearSelectionImpl();
        int n = 0;
        while (n < rADComponentArray.length) {
            this.addComponentToSelectionImpl(rADComponentArray[n]);
            ++n;
        }
        this.repaintSelection();
        this.updateActivatedNodes();
    }

    void setSelectedNode(FormNode formNode) {
        if (formNode instanceof RADComponentNode) {
            this.setSelectedComponent(((RADComponentNode)formNode).getRADComponent());
        } else {
            this.clearSelectionImpl();
            this.repaintSelection();
            ComponentInspector componentInspector = ComponentInspector.getInstance();
            if (componentInspector.getFocusedForm() != this.formEditorSupport) {
                return;
            }
            Node[] nodeArray = new Node[]{formNode};
            try {
                componentInspector.setSelectedNodes(nodeArray, this.formEditorSupport);
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
            this.setActivatedNodes(nodeArray);
        }
    }

    void addComponentToSelection(RADComponent rADComponent) {
        this.addComponentToSelectionImpl(rADComponent);
        this.repaintSelection();
        this.updateActivatedNodes();
    }

    void addComponentsToSelection(RADComponent[] rADComponentArray) {
        int n = 0;
        while (n < rADComponentArray.length) {
            this.addComponentToSelectionImpl(rADComponentArray[n]);
            ++n;
        }
        this.repaintSelection();
        this.updateActivatedNodes();
    }

    void removeComponentFromSelection(RADComponent rADComponent) {
        this.removeComponentFromSelectionImpl(rADComponent);
        this.repaintSelection();
        this.updateActivatedNodes();
    }

    public void clearSelection() {
        this.clearSelectionImpl();
        this.repaintSelection();
        this.updateActivatedNodes();
    }

    void addComponentToSelectionImpl(RADComponent rADComponent) {
        if (rADComponent != null) {
            this.selectedComponents.add(rADComponent);
            if (rADComponent instanceof RADVisualComponent) {
                this.ensureComponentIsShown((RADVisualComponent)rADComponent);
            }
        }
    }

    void removeComponentFromSelectionImpl(RADComponent rADComponent) {
        ((AbstractCollection)this.selectedComponents).remove(rADComponent);
    }

    void clearSelectionImpl() {
        this.selectedComponents.clear();
    }

    void repaintSelection() {
        this.handleLayer.repaint();
    }

    RADVisualComponent getNextVisualComponent(boolean bl) {
        RADVisualComponent rADVisualComponent = null;
        int n = this.selectedComponents.size();
        if (n > 0) {
            if (n > 1) {
                return null;
            }
            Object e = this.selectedComponents.get(0);
            if (e instanceof RADVisualComponent) {
                rADVisualComponent = (RADVisualComponent)e;
            } else {
                return null;
            }
        }
        return this.getNextVisualComponent(rADVisualComponent, bl);
    }

    RADVisualComponent getNextVisualComponent(RADVisualComponent rADVisualComponent, boolean bl) {
        RADVisualComponent[] rADVisualComponentArray;
        if (rADVisualComponent == null) {
            return this.topDesignComponent;
        }
        if (this.getComponent(rADVisualComponent) == null) {
            return null;
        }
        if (bl) {
            RADVisualComponent[] rADVisualComponentArray2;
            if (rADVisualComponent instanceof RADVisualContainer && (rADVisualComponentArray2 = ((RADVisualContainer)rADVisualComponent).getSubComponents()).length > 0) {
                return rADVisualComponentArray2[0];
            }
            if (rADVisualComponent == this.topDesignComponent) {
                return this.topDesignComponent;
            }
            RADVisualContainer rADVisualContainer = rADVisualComponent.getParentContainer();
            if (rADVisualContainer == null) {
                return null;
            }
            int n = rADVisualContainer.getIndexOf(rADVisualComponent);
            while (n >= 0) {
                rADVisualComponentArray2 = rADVisualContainer.getSubComponents();
                if (n + 1 < rADVisualComponentArray2.length) {
                    return rADVisualComponentArray2[n + 1];
                }
                if (rADVisualContainer == this.topDesignComponent) break;
                rADVisualComponent = rADVisualContainer;
                if ((rADVisualContainer = rADVisualComponent.getParentContainer()) == null) {
                    return null;
                }
                n = rADVisualContainer.getIndexOf(rADVisualComponent);
            }
            return this.topDesignComponent;
        }
        if (rADVisualComponent != this.topDesignComponent) {
            RADVisualContainer rADVisualContainer = rADVisualComponent.getParentContainer();
            if (rADVisualContainer == null) {
                return null;
            }
            int n = rADVisualContainer.getIndexOf(rADVisualComponent);
            if (n >= 0) {
                if (n == 0) {
                    return rADVisualContainer;
                }
                rADVisualComponentArray = rADVisualContainer.getSubComponents();
                rADVisualComponent = rADVisualComponentArray[n - 1];
            } else {
                rADVisualComponent = this.topDesignComponent;
            }
        }
        while (rADVisualComponent instanceof RADVisualContainer && (rADVisualComponentArray = ((RADVisualContainer)rADVisualComponent).getSubComponents()).length > 0) {
            rADVisualComponent = rADVisualComponentArray[rADVisualComponentArray.length - 1];
        }
        return rADVisualComponent;
    }

    void updateActivatedNodes() {
        ComponentInspector componentInspector = ComponentInspector.getInstance();
        if (componentInspector.getFocusedForm() != this.formEditorSupport) {
            return;
        }
        Node[] nodeArray = new Node[this.selectedComponents.size()];
        Iterator iterator = ((AbstractList)this.selectedComponents).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            RADComponent rADComponent = (RADComponent)iterator.next();
            nodeArray[n++] = rADComponent.getNodeReference();
        }
        try {
            componentInspector.setSelectedNodes(nodeArray, this.formEditorSupport);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        this.setActivatedNodes(nodeArray);
    }

    void updateName(String string) {
        if (this.topDesignComponent != null && this.topDesignComponent != this.formModel.getTopRADComponent()) {
            string = string + " / " + this.topDesignComponent.getName();
        }
        if (this.formModel.isReadOnly()) {
            string = string + " " + FormUtils.getBundleString("CTL_FormTitle_RO");
        }
        this.setName(string);
        ((JComponent)((Object)this)).setToolTipText(string);
    }

    void updateVisualSettings() {
        this.componentLayer.updateVisualSettings();
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
    }

    private void ensureComponentIsShown(RADVisualComponent rADVisualComponent) {
        Component component = (Component)this.getComponent(rADVisualComponent);
        RADVisualContainer rADVisualContainer = rADVisualComponent.getParentContainer();
        if (component == null) {
            if (rADVisualContainer != null) {
                rADVisualContainer.getLayoutSupport().selectComponent(rADVisualContainer.getIndexOf(rADVisualComponent));
            }
            return;
        }
        if (component.isShowing()) {
            return;
        }
        if (!this.isInDesignedTree(rADVisualComponent)) {
            return;
        }
        Component component2 = (Component)this.getComponent(this.topDesignComponent);
        if (component2 == null || !component2.isShowing()) {
            return;
        }
        RADVisualComponent rADVisualComponent2 = rADVisualComponent;
        while (rADVisualContainer != null) {
            Container container = (Container)this.getComponent(rADVisualContainer);
            LayoutSupportManager layoutSupportManager = rADVisualContainer.getLayoutSupport();
            Container container2 = rADVisualContainer.getContainerDelegate(container);
            layoutSupportManager.selectComponent(rADVisualComponent2.getComponentIndex());
            layoutSupportManager.arrangeContainer(container, container2);
            if (rADVisualContainer == this.topDesignComponent || container.isShowing()) break;
            rADVisualComponent2 = rADVisualContainer;
            rADVisualContainer = rADVisualContainer.getParentContainer();
        }
    }

    void connectBean(RADComponent rADComponent, boolean bl) {
        if (this.connectionSource == null) {
            this.connectionSource = rADComponent;
            this.handleLayer.repaint();
        } else {
            if (rADComponent == this.connectionSource) {
                if (this.connectionTarget != null) {
                    this.resetConnection();
                    CPManager.getDefault().setMode(0);
                }
                return;
            }
            this.connectionTarget = rADComponent;
            this.handleLayer.repaint();
            if (bl) {
                if (this.connectionTarget != null) {
                    this.createConnection(this.connectionSource, this.connectionTarget);
                }
                CPManager.getDefault().setMode(0);
            }
        }
    }

    public RADComponent getConnectionSource() {
        return this.connectionSource;
    }

    public RADComponent getConnectionTarget() {
        return this.connectionTarget;
    }

    public void resetConnection() {
        if (this.connectionSource != null || this.connectionTarget != null) {
            this.connectionSource = null;
            this.connectionTarget = null;
            this.handleLayer.repaint();
        }
    }

    private void createConnection(RADComponent rADComponent, RADComponent rADComponent2) {
        ConnectionWizard connectionWizard = new ConnectionWizard(this.formModel, rADComponent, rADComponent2);
        if (connectionWizard.show()) {
            Event event = connectionWizard.getSelectedEvent();
            String string = connectionWizard.getEventName();
            String string2 = connectionWizard.getGeneratedCode();
            this.formModel.getFormEventHandlers().addEventHandler(event, string, string2);
        }
    }

    public void startInPlaceEditing(RADComponent rADComponent) {
        if (this.formModel.isReadOnly()) {
            return;
        }
        if (this.textEditLayer != null && this.textEditLayer.isVisible()) {
            return;
        }
        if (!this.isEditableInPlace(rADComponent)) {
            return;
        }
        Component component = (Component)this.getComponent(rADComponent);
        if (component == null) {
            this.notifyCannotEditInPlace();
            return;
        }
        FormProperty formProperty = rADComponent.getPropertyByName("text");
        if (formProperty == null) {
            return;
        }
        String string = null;
        try {
            Object object = formProperty.getRealValue();
            if (!(object instanceof String)) {
                object = "";
            }
            string = (String)object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.editedProperty = formProperty;
        if (this.textEditLayer == null) {
            this.textEditLayer = new InPlaceEditLayer();
            this.textEditLayer.setVisible(false);
            this.textEditLayer.addFinishListener(new InPlaceEditLayer.FinishListener(){

                public void editingFinished(boolean bl) {
                    FormDesigner.this.finishInPlaceEditing(FormDesigner.this.textEditLayer.isTextChanged());
                }
            });
            this.layeredPane.add((Component)this.textEditLayer, new Integer(2001));
        }
        try {
            this.textEditLayer.setEditedComponent(component, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.notifyCannotEditInPlace();
            return;
        }
        this.handleLayer.setVisible(false);
        this.textEditLayer.setVisible(true);
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
        this.requestFocus();
        this.componentActivated();
    }

    private void finishInPlaceEditing(boolean bl) {
        if (bl) {
            try {
                this.editedProperty.setValue(this.textEditLayer.getEditedText());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.textEditLayer.setVisible(false);
        this.handleLayer.setVisible(true);
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
        this.handleLayer.requestFocus();
        this.editedProperty = null;
    }

    public boolean isEditableInPlace(RADComponent rADComponent) {
        Component component = (Component)this.getComponent(rADComponent);
        if (component == null) {
            return false;
        }
        RADComponent rADComponent2 = rADComponent.getParentComponent();
        while (rADComponent2 != null) {
            if (!(class$javax$swing$JComponent == null ? FormDesigner.class$("javax.swing.JComponent") : class$javax$swing$JComponent).isAssignableFrom(rADComponent2.getBeanClass()) && !(class$javax$swing$RootPaneContainer == null ? FormDesigner.class$("javax.swing.RootPaneContainer") : class$javax$swing$RootPaneContainer).isAssignableFrom(rADComponent2.getBeanClass())) {
                return false;
            }
            rADComponent2 = rADComponent2.getParentComponent();
        }
        return InPlaceEditLayer.supportsEditingFor(rADComponent.getBeanClass(), false);
    }

    private void notifyCannotEditInPlace() {
        TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)FormUtils.getBundleString("MSG_ComponentNotShown"), 2));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.formeditor");
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.formEditorSupport == null) {
            return;
        }
        super.writeExternal(objectOutput);
        objectOutput.writeObject((Object)this.formEditorSupport.getFormDataObject());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        Object object = objectInput.readObject();
        if (object instanceof FormDataObject) {
            this.formEditorSupport = ((FormDataObject)((Object)object)).getFormEditor();
            this.formEditorSupport.setFormDesigner(this);
            if (!this.formEditorSupport.isOpened()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (FormDesigner.this.formEditorSupport.loadForm()) {
                            FormDesigner.this.setModel(FormDesigner.this.formEditorSupport.getFormModel());
                            FormDesigner.this.initialize();
                            ComponentInspector.getInstance().focusForm(FormDesigner.this.formEditorSupport);
                            if (FormDesigner.this.formEditorSupport.getOpenedPanes() == null) {
                                FormDesigner.this.formEditorSupport.open();
                            }
                        }
                    }
                });
            }
        }
    }

    public void open(Workspace workspace) {
        if (workspace == null) {
            workspace = TopManager.getDefault().getWindowManager().getCurrentWorkspace();
        }
        if (this.isOpened(workspace)) {
            return;
        }
        Mode mode = workspace.findMode(FORM_MODE_NAME);
        if (mode != null) {
            mode.dockInto((TopComponent)this);
        }
        super.open(workspace);
    }

    public boolean canClose(Workspace workspace, boolean bl) {
        boolean bl2 = super.canClose(workspace, bl);
        if (bl2 && this.isOpened() && this.formEditorSupport != null) {
            this.formEditorSupport.designerToBeClosed(workspace);
        }
        return bl2;
    }

    protected void componentActivated() {
        super.componentActivated();
        if (this.formModel == null) {
            return;
        }
        ComponentInspector componentInspector = ComponentInspector.getInstance();
        if (componentInspector.getFocusedForm() != this.formEditorSupport) {
            ComponentInspector.getInstance().focusForm(this.formEditorSupport);
            if (CPManager.getDefault().getMode() == 1) {
                this.clearSelection();
            } else {
                this.updateActivatedNodes();
            }
        }
        componentInspector.attachActions();
        if (this.textEditLayer == null || !this.textEditLayer.isVisible()) {
            this.handleLayer.requestFocus();
        } else {
            this.textEditLayer.requestFocus();
        }
    }

    protected void componentDeactivated() {
        if (this.formModel == null) {
            return;
        }
        if (this.textEditLayer != null && this.textEditLayer.isVisible()) {
            this.textEditLayer.finishEditing(false);
        }
        ComponentInspector.getInstance().detachActions();
        this.resetConnection();
        super.componentDeactivated();
    }

    public UndoRedo getUndoRedo() {
        UndoRedo.Manager manager = this.formModel != null ? this.formModel.getUndoRedoManager() : null;
        return manager != null ? manager : super.getUndoRedo();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class FormListener
    implements FormModelListener,
    Runnable {
        private FormModelEvent[] events;

        private FormListener() {
        }

        public void formChanged(FormModelEvent[] formModelEventArray) {
            boolean bl;
            this.events = formModelEventArray;
            if (formModelEventArray == null) {
                bl = true;
            } else {
                bl = false;
                boolean bl2 = false;
                int n = 0;
                while (n < formModelEventArray.length) {
                    FormModelEvent formModelEvent = formModelEventArray[n];
                    if (formModelEvent.isModifying()) {
                        bl2 = true;
                    }
                    if (formModelEvent.getChangeType() == 7 && formModelEvent.getCreatedDeleted()) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (!bl2) {
                    return;
                }
            }
            if (bl) {
                try {
                    FormLAF.executeWithLookAndFeel(UIManager.getLookAndFeel().getClass().getName(), new Mutex.ExceptionAction(this){
                        private final /* synthetic */ FormListener this$1;
                        {
                            this.this$1 = formListener;
                        }

                        public Object run() throws Exception {
                            FormListener.access$400(this.this$1);
                            return null;
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (!EventQueue.isDispatchThread()) {
                try {
                    EventQueue.invokeAndWait(this);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.performUpdates();
            }
        }

        public void run() {
            this.performUpdates();
        }

        private void performUpdates() {
            Serializable serializable;
            if (this.events == null) {
                FormDesigner.this.replicator.setTopMetaComponent(FormDesigner.this.topDesignComponent);
                Component component = (Component)FormDesigner.this.replicator.createClone();
                if (component != null) {
                    component.setVisible(true);
                    FormDesigner.this.componentLayer.setTopDesignComponent(component);
                }
                FormDesigner.this.updateName(FormDesigner.this.formModel.getName());
                return;
            }
            FormModelEvent[] formModelEventArray = this.events;
            this.events = null;
            int n = 0;
            ComponentContainer componentContainer = null;
            boolean bl = false;
            int n2 = 0;
            while (n2 < formModelEventArray.length) {
                serializable = formModelEventArray[n2];
                int n3 = ((FormModelEvent)serializable).getChangeType();
                ComponentContainer componentContainer2 = ((FormModelEvent)serializable).getContainer();
                if (n3 == 4 || n3 == 5 || n3 == 6) {
                    if (n != 4 && n != 5 && n != 6 || componentContainer != componentContainer2) {
                        FormDesigner.this.replicator.updateContainerLayout((RADVisualContainer)componentContainer2);
                        bl = true;
                    }
                } else if (n3 == 7) {
                    if (n != 7 || componentContainer != componentContainer2) {
                        FormDesigner.this.replicator.updateAddedComponents(componentContainer2);
                        bl = true;
                    }
                } else if (n3 == 8) {
                    RADComponent rADComponent = ((FormModelEvent)serializable).getComponent();
                    if (rADComponent instanceof RADVisualComponent && (rADComponent == FormDesigner.this.topDesignComponent || rADComponent.isParentComponent(FormDesigner.this.topDesignComponent))) {
                        FormDesigner.this.resetTopDesignComponent(false);
                        FormDesigner.this.updateWholeDesigner();
                        return;
                    }
                    FormDesigner.this.replicator.removeComponent(((FormModelEvent)serializable).getComponent(), ((FormModelEvent)serializable).getContainer());
                    bl = true;
                } else if (n3 == 9) {
                    if (n != 9 || componentContainer != componentContainer2) {
                        FormDesigner.this.replicator.reorderComponents(componentContainer2);
                        bl = true;
                    }
                } else if (n3 == 10) {
                    FormDesigner.this.replicator.updateComponentProperty(((FormModelEvent)serializable).getComponentProperty());
                    bl = true;
                } else if (n3 == 11 && FormDesigner.PROP_DESIGNER_SIZE.equals(((FormModelEvent)serializable).getPropertyName())) {
                    FormDesigner.this.componentLayer.updateDesignerSize(FormDesigner.this.getStoredDesignerSize());
                }
                n = n3;
                componentContainer = componentContainer2;
                ++n2;
            }
            if (bl && (serializable = (Component)FormDesigner.this.getComponent(FormDesigner.this.topDesignComponent)) != null) {
                ((Component)serializable).invalidate();
                ((Component)serializable).validate();
                ((Component)serializable).repaint();
            }
        }

        static /* synthetic */ void access$400(FormListener formListener) {
            formListener.performUpdates();
        }
    }
}

