/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.FocusManager;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.ComponentDragger;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.ComponentLayer;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormRootNode;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.netbeans.modules.form.palette.CPManager;
import org.netbeans.modules.form.palette.PaletteItem;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.awt.MouseUtils;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

class HandleLayer
extends JPanel {
    static final int COMP_DEEPEST = 0;
    static final int COMP_SELECTED = 1;
    static final int COMP_ABOVE_SELECTED = 2;
    static final int COMP_UNDER_SELECTED = 3;
    private static final int DESIGNER_RESIZING = 256;
    private static final MessageFormat resizingHintFormat = new MessageFormat(FormUtils.getBundleString("FMT_HINT_DesignerResizing"));
    private FormDesigner formDesigner;
    private boolean viewOnly;
    private ComponentDragger componentDragger;
    private Point lastLeftMousePoint;
    private Point prevLeftMousePoint;
    private boolean draggingCanceled = false;
    private int resizeType;
    private SelectionDragger selectionDragger;
    private DesignerResizer designerResizer;
    private static FormLoaderSettings formSettings = FormEditor.getFormSettings();
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$javax$swing$JComponent;

    HandleLayer(FormDesigner formDesigner) {
        this.formDesigner = formDesigner;
        this.addMouseListener(new HandleLayerMouseListener());
        this.addMouseMotionListener(new HandleLayerMouseMotionListener());
        this.setLayout(null);
        Method method = null;
        try {
            method = this.getClass().getMethod("setFocusTraversalKeys", Integer.TYPE, class$java$util$Set == null ? (class$java$util$Set = HandleLayer.class$("java.util.Set")) : class$java$util$Set);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method != null) {
            HashSet<Object> hashSet = new HashSet<Object>();
            try {
                Class<?> clazz = Class.forName("java.awt.AWTKeyStroke");
                Method method2 = clazz.getMethod("getAWTKeyStroke", Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                hashSet.add(method2.invoke(null, new Integer(9), new Integer(128), Boolean.TRUE));
                method.invoke((Object)this, new Integer(0), hashSet);
                hashSet.clear();
                hashSet.add(method2.invoke(null, new Integer(9), new Integer(192), Boolean.TRUE));
                method.invoke((Object)this, new Integer(1), hashSet);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.getAccessibleContext().setAccessibleName(FormUtils.getBundleString("ACSN_HandleLayer"));
        this.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_HandleLayer"));
    }

    void setViewOnly(boolean bl) {
        this.viewOnly = bl;
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(formSettings.getSelectionBorderSize()));
        RADComponent rADComponent = this.formDesigner.getConnectionSource();
        RADComponent rADComponent2 = this.formDesigner.getConnectionTarget();
        if (rADComponent != null || rADComponent2 != null) {
            graphics2D.setColor(formSettings.getConnectionBorderColor());
            if (rADComponent != null) {
                this.paintSelection(graphics2D, rADComponent);
            }
            if (rADComponent2 != null) {
                this.paintSelection(graphics2D, rADComponent2);
            }
        } else {
            graphics2D.setColor(formSettings.getSelectionBorderColor());
            Iterator iterator = this.formDesigner.getSelectedComponents().iterator();
            while (iterator.hasNext()) {
                this.paintSelection(graphics2D, (RADComponent)iterator.next());
            }
        }
        if (this.componentDragger != null) {
            this.componentDragger.paintDragFeedback(graphics2D);
        }
        if (this.selectionDragger != null) {
            this.selectionDragger.paintDragFeedback(graphics2D);
        }
    }

    private void paintSelection(Graphics2D graphics2D, RADComponent rADComponent) {
        Object object = this.formDesigner.getComponent(rADComponent);
        if (!(object instanceof Component)) {
            return;
        }
        Component component = (Component)object;
        Container container = component.getParent();
        if (container != null && component.isShowing()) {
            Rectangle rectangle = component.getBounds();
            rectangle = SwingUtilities.convertRectangle(container, rectangle, this);
            Rectangle rectangle2 = new Rectangle(new Point(0, 0), container.getSize());
            rectangle2 = SwingUtilities.convertRectangle(container, rectangle2, this);
            Rectangle2D rectangle2D = rectangle.createIntersection(rectangle2);
            int n = formSettings.getSelectionBorderSize() % 2;
            graphics2D.draw(new Rectangle2D.Double(rectangle2D.getX() - (double)n, rectangle2D.getY() - (double)n, rectangle2D.getWidth() + (double)n, rectangle2D.getHeight() + (double)n));
        }
    }

    public boolean isOpaque() {
        return false;
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 9 || keyEvent.getKeyChar() == '\t') {
            if (keyEvent.getID() == 401) {
                if (keyEvent.isControlDown()) {
                    if (!keyEvent.isShiftDown()) {
                        FocusManager.getCurrentManager().focusNextComponent(this);
                    } else {
                        FocusManager.getCurrentManager().focusPreviousComponent(this);
                    }
                } else {
                    RADVisualComponent rADVisualComponent = this.formDesigner.getNextVisualComponent(!keyEvent.isShiftDown());
                    if (rADVisualComponent != null) {
                        this.formDesigner.setSelectedComponent(rADVisualComponent);
                    }
                }
            }
            keyEvent.consume();
        } else if (n == 32) {
            Iterator iterator;
            if (!this.viewOnly && keyEvent.getID() == 402 && (iterator = this.formDesigner.getSelectedComponents().iterator()).hasNext()) {
                RADComponent rADComponent = (RADComponent)iterator.next();
                if (!iterator.hasNext()) {
                    CPManager cPManager = CPManager.getDefault();
                    if (cPManager.getMode() == 0) {
                        this.formDesigner.startInPlaceEditing(rADComponent);
                    } else if (cPManager.getMode() == 2) {
                        PaletteItem paletteItem = cPManager.getSelectedItem();
                        this.formDesigner.getModel().getComponentCreator().createComponent(paletteItem.getInstanceCookie(), rADComponent, null);
                        cPManager.setMode(0);
                    }
                }
            }
            keyEvent.consume();
        } else if (n == 27) {
            if (this.endDragging(null)) {
                keyEvent.consume();
            }
        } else if (n == 121) {
            if (keyEvent.isShiftDown()) {
                Point point = null;
                Iterator iterator = this.formDesigner.getSelectedComponents().iterator();
                if (iterator.hasNext()) {
                    RADComponent rADComponent = (RADComponent)iterator.next();
                    Component component = (Component)this.formDesigner.getComponent(rADComponent);
                    if (component instanceof Component) {
                        Component component2 = component;
                        point = SwingUtilities.convertPoint(component2.getParent(), component2.getLocation(), this);
                    } else {
                        point = new Point(0, 0);
                    }
                    this.showContextMenu(point);
                    keyEvent.consume();
                }
            }
        } else {
            super.processKeyEvent(keyEvent);
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    private RADComponent getMetaComponentAt(Point point, int n) {
        Component[] componentArray = HandleLayer.getDeepestComponentsAt(this.formDesigner.getComponentLayer(), point);
        if (componentArray.length == 0) {
            return null;
        }
        int n2 = n == 0 ? componentArray.length - 1 : 0;
        Component component = componentArray[n2];
        RADVisualComponent rADVisualComponent = this.formDesigner.getTopDesignComponent();
        RADComponent rADComponent = null;
        RADComponent rADComponent2 = null;
        do {
            RADComponent rADComponent3;
            if ((rADComponent3 = this.formDesigner.getMetaComponent(component)) == null) continue;
            if (rADComponent == null) {
                rADComponent = rADComponent3;
            }
            switch (n) {
                case 0: {
                    return rADComponent3;
                }
                case 1: {
                    if (this.formDesigner.isComponentSelected(rADComponent3)) {
                        return rADComponent3;
                    }
                    if (rADComponent3 != rADVisualComponent) break;
                    return rADComponent;
                }
                case 2: {
                    if (rADComponent2 != null && this.formDesigner.isComponentSelected(rADComponent2)) {
                        return rADComponent3;
                    }
                    if (rADComponent3 != rADVisualComponent) break;
                    return rADComponent;
                }
                case 3: {
                    if (this.formDesigner.isComponentSelected(rADComponent3)) {
                        return rADComponent2 != null ? rADComponent2 : rADVisualComponent;
                    }
                    if (rADComponent3 != rADVisualComponent) break;
                    return rADVisualComponent;
                }
            }
            rADComponent2 = rADComponent3;
        } while ((component = n2 + 1 < componentArray.length ? componentArray[++n2] : component.getParent()) != null);
        return rADComponent;
    }

    private static Component[] getDeepestComponentsAt(Container container, Point point) {
        Component component = SwingUtilities.getDeepestComponentAt(container, point.x, point.y);
        if (component == null) {
            return new Component[0];
        }
        Container container2 = component.getParent();
        Component[] componentArray = container2.getComponents();
        Point point2 = SwingUtilities.convertPoint(container, point, container2);
        Component[] componentArray2 = new Component[1];
        ArrayList<Component> arrayList = null;
        int n = 0;
        while (n < componentArray.length) {
            component = componentArray[n];
            Point point3 = component.getLocation();
            if (component.isVisible() && component.contains(point2.x - point3.x, point2.y - point3.y)) {
                if (componentArray2[0] == null) {
                    componentArray2[0] = component;
                } else {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Component>();
                        arrayList.add(componentArray2[0]);
                    }
                    arrayList.add(component);
                }
            }
            ++n;
        }
        if (arrayList == null) {
            return componentArray2[0] != null ? componentArray2 : new Component[]{};
        }
        componentArray2 = new Component[arrayList.size()];
        arrayList.toArray(componentArray2);
        return componentArray2;
    }

    RADVisualContainer getMetaContainerAt(Point point) {
        RADComponent rADComponent = this.getMetaComponentAt(point, 0);
        if (rADComponent == null) {
            return null;
        }
        if (rADComponent instanceof RADVisualContainer) {
            return (RADVisualContainer)rADComponent;
        }
        if (rADComponent instanceof RADVisualComponent) {
            return (RADVisualContainer)rADComponent.getParentComponent();
        }
        return null;
    }

    private RADComponent selectComponent(MouseEvent mouseEvent) {
        int n = !mouseEvent.isAltDown() ? 0 : (!mouseEvent.isShiftDown() ? 2 : 3);
        RADComponent rADComponent = this.getMetaComponentAt(mouseEvent.getPoint(), n);
        if (mouseEvent.isControlDown()) {
            if (rADComponent != null) {
                if (this.formDesigner.isComponentSelected(rADComponent)) {
                    this.formDesigner.removeComponentFromSelection(rADComponent);
                } else {
                    this.formDesigner.addComponentToSelection(rADComponent);
                }
            }
        } else if (mouseEvent.isShiftDown() && !mouseEvent.isAltDown()) {
            if (rADComponent != null && !this.formDesigner.isComponentSelected(rADComponent)) {
                if (this.formDesigner.getSelectedComponents().size() > 0) {
                    RADComponent[] rADComponentArray = this.getComponentsIntervalToSelect(rADComponent, false);
                    if (rADComponentArray == null) {
                        rADComponentArray = this.getComponentsIntervalToSelect(rADComponent, true);
                    }
                    if (rADComponentArray != null) {
                        this.formDesigner.setSelectedComponents(rADComponentArray);
                    } else {
                        this.formDesigner.setSelectedComponent(rADComponent);
                    }
                } else {
                    this.formDesigner.setSelectedComponent(rADComponent);
                }
            }
        } else if (rADComponent != null) {
            if (!this.formDesigner.isComponentSelected(rADComponent)) {
                this.formDesigner.setSelectedComponent(rADComponent);
            }
        } else {
            this.formDesigner.clearSelection();
        }
        this.repaint();
        return rADComponent;
    }

    private RADComponent[] getComponentsIntervalToSelect(RADComponent rADComponent, boolean bl) {
        if (!(rADComponent instanceof RADVisualComponent)) {
            return null;
        }
        LinkedList<RADVisualComponent> linkedList = new LinkedList<RADVisualComponent>();
        RADVisualComponent rADVisualComponent = (RADVisualComponent)rADComponent;
        boolean bl2 = false;
        do {
            if (bl) {
                linkedList.add(rADVisualComponent);
                continue;
            }
            linkedList.add(0, rADVisualComponent);
        } while ((rADVisualComponent = this.formDesigner.getNextVisualComponent(rADVisualComponent, bl)) != null && rADVisualComponent != rADComponent && !(bl2 = this.formDesigner.isComponentSelected(rADVisualComponent)) && rADVisualComponent != this.formDesigner.getTopDesignComponent());
        if (bl2) {
            if (rADVisualComponent == this.formDesigner.getTopDesignComponent()) {
                if (!bl) {
                    linkedList.add(0, rADVisualComponent);
                }
            } else {
                bl2 = false;
                do {
                    if (bl) {
                        linkedList.add(rADVisualComponent);
                        continue;
                    }
                    linkedList.add(0, rADVisualComponent);
                } while ((rADVisualComponent = this.formDesigner.getNextVisualComponent(rADVisualComponent, bl)) != null && (bl2 = this.formDesigner.isComponentSelected(rADVisualComponent)) && rADVisualComponent != this.formDesigner.getTopDesignComponent());
                if (bl2 && !bl) {
                    linkedList.add(0, rADVisualComponent);
                }
            }
            RADComponent[] rADComponentArray = new RADComponent[linkedList.size()];
            linkedList.toArray(rADComponentArray);
            return rADComponentArray;
        }
        return null;
    }

    private void selectOtherComponentsNode() {
        FormEditorSupport formEditorSupport = this.formDesigner.getFormEditorSupport();
        ComponentInspector componentInspector = ComponentInspector.getInstance();
        Node[] nodeArray = new Node[]{((FormRootNode)formEditorSupport.getFormRootNode()).getOthersNode()};
        try {
            componentInspector.setSelectedNodes(nodeArray, formEditorSupport);
            this.formDesigner.clearSelectionImpl();
            this.repaint();
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        this.formDesigner.setActivatedNodes(nodeArray);
    }

    private boolean processDoubleClick(MouseEvent mouseEvent) {
        SystemAction systemAction;
        RADComponentNode rADComponentNode;
        if (mouseEvent.isShiftDown() || mouseEvent.isControlDown()) {
            return false;
        }
        RADComponent rADComponent = this.getMetaComponentAt(mouseEvent.getPoint(), 1);
        if (rADComponent == null) {
            return true;
        }
        if (mouseEvent.isAltDown()) {
            if (rADComponent == this.formDesigner.getTopDesignComponent()) {
                if ((rADComponent = rADComponent.getParentComponent()) == null) {
                    return true;
                }
            } else {
                return false;
            }
        }
        if ((rADComponentNode = rADComponent.getNodeReference()) != null && (systemAction = rADComponentNode.getDefaultAction()) != null) {
            systemAction.actionPerformed(new ActionEvent(rADComponentNode, 1001, ""));
        }
        return true;
    }

    private void processMouseClickInLayoutSupport(RADComponent rADComponent, MouseEvent mouseEvent) {
        RADVisualContainer rADVisualContainer;
        if (!(rADComponent instanceof RADVisualComponent)) {
            return;
        }
        if (rADComponent instanceof RADVisualContainer) {
            rADVisualContainer = (RADVisualContainer)rADComponent;
        } else {
            rADVisualContainer = (RADVisualContainer)rADComponent.getParentComponent();
            if (rADVisualContainer == null) {
                return;
            }
        }
        Container container = (Container)this.formDesigner.getComponent(rADVisualContainer);
        Container container2 = rADVisualContainer.getContainerDelegate(container);
        Point point = SwingUtilities.convertPoint(this, mouseEvent.getPoint(), container2);
        rADVisualContainer.getLayoutSupport().processMouseClick(point, container, container2);
    }

    private void showContextMenu(Point point) {
        ComponentInspector componentInspector = ComponentInspector.getInstance();
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent != this.formDesigner && topComponent != componentInspector) {
            return;
        }
        this.formDesigner.componentActivated();
        Node[] nodeArray = componentInspector.getSelectedNodes();
        JPopupMenu jPopupMenu = NodeOp.findContextMenu((Node[])nodeArray);
        if (jPopupMenu != null) {
            jPopupMenu.show(this, point.x, point.y);
        }
    }

    boolean anyDragger() {
        return this.componentDragger != null || this.selectionDragger != null || this.designerResizer != null;
    }

    private ComponentDragger createComponentDragger(Point point, int n) {
        RADComponent rADComponent;
        Object object;
        RADVisualComponent[] rADVisualComponentArray;
        Serializable serializable;
        List list = this.formDesigner.getSelectedComponents();
        if (list.size() == 0) {
            return null;
        }
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            serializable = (RADComponent)iterator.next();
            if (!(serializable instanceof RADVisualComponent)) continue;
            if (serializable != this.formDesigner.getTopDesignComponent()) {
                arrayList.add(serializable);
                continue;
            }
            return null;
        }
        serializable = new HashSet();
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            rADVisualComponentArray = (RADVisualComponent[])iterator.next();
            object = arrayList.iterator();
            while (object.hasNext()) {
                rADComponent = (RADComponent)object.next();
                if (rADComponent == rADVisualComponentArray || !rADVisualComponentArray.isParentComponent(rADComponent)) continue;
                serializable.add(rADComponent);
            }
        }
        arrayList.removeAll((Collection<?>)((Object)serializable));
        if (arrayList.isEmpty()) {
            return null;
        }
        rADVisualComponentArray = new RADVisualComponent[arrayList.size()];
        arrayList.toArray(rADVisualComponentArray);
        if (this.resizeType == 0) {
            object = null;
            if ((n & 8) != 0) {
                rADComponent = rADVisualComponentArray[0].getParentContainer();
                if ((n & 1) != 0 || this.formDesigner.getTopDesignComponent() == rADComponent) {
                    int n2 = 1;
                    while (n2 < rADVisualComponentArray.length) {
                        if (rADVisualComponentArray[n2].getParentContainer() != rADComponent) {
                            rADComponent = null;
                            break;
                        }
                        ++n2;
                    }
                    object = rADComponent;
                } else if ((rADComponent = ((RADVisualComponent)rADComponent).getParentContainer()) != null) {
                    int n3 = 1;
                    while (n3 < rADVisualComponentArray.length) {
                        if (rADVisualComponentArray[n3].getParentContainer().getParentContainer() != rADComponent) {
                            rADComponent = null;
                            break;
                        }
                        ++n3;
                    }
                    object = rADComponent;
                }
            }
            return new ComponentDragger(this.formDesigner, this, rADVisualComponentArray, point, (RADVisualContainer)object);
        }
        return new ComponentDragger(this.formDesigner, this, rADVisualComponentArray, point, this.resizeType);
    }

    private boolean endDragging(Point point) {
        if (this.anyDragger()) {
            Serializable serializable;
            if (this.resizeType != 0) {
                this.resizeType = 0;
                serializable = this.getCursor();
                if (serializable != null && serializable.getType() != 0) {
                    this.setCursor(Cursor.getDefaultCursor());
                }
                if (this.getToolTipText() != null) {
                    this.setToolTipText(null);
                }
            }
            if (this.designerResizer != null) {
                if (point != null) {
                    this.designerResizer.drop(point);
                } else {
                    serializable = this.formDesigner.getStoredDesignerSize();
                    if (!this.formDesigner.getComponentLayer().getDesignerSize().equals(serializable)) {
                        this.formDesigner.getComponentLayer().updateDesignerSize((Dimension)serializable);
                    }
                }
                this.designerResizer = null;
            }
            if (this.componentDragger != null) {
                if (point != null) {
                    this.componentDragger.dropComponents(point);
                }
                this.componentDragger = null;
                this.repaint();
            }
            if (this.selectionDragger != null) {
                if (point != null) {
                    this.selectionDragger.drop(point);
                }
                this.selectionDragger = null;
                this.repaint();
            }
            this.draggingCanceled = point == null;
            return true;
        }
        return false;
    }

    private void checkResizing(MouseEvent mouseEvent) {
        Serializable serializable;
        int n = this.checkComponentsResizing(mouseEvent);
        if (n == 0) {
            n = this.checkDesignerResizing(mouseEvent);
            if (n == 0) {
                if (this.getToolTipText() != null) {
                    this.setToolTipText(null);
                }
            } else if (this.getToolTipText() == null) {
                serializable = this.formDesigner.getComponentLayer().getDesignerSize();
                String string = resizingHintFormat.format(new Object[]{new Integer(((Dimension)serializable).width), new Integer(((Dimension)serializable).height)});
                this.setToolTipText(string);
                ToolTipManager.sharedInstance().mouseEntered(mouseEvent);
            }
        } else if (this.getToolTipText() != null) {
            this.setToolTipText(null);
        }
        if (n != 0) {
            this.setResizingCursor(n);
        } else {
            serializable = this.getCursor();
            if (serializable != null && serializable.getType() != 0) {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private int checkDesignerResizing(MouseEvent mouseEvent) {
        if (!(mouseEvent.isAltDown() || mouseEvent.isControlDown() || mouseEvent.isShiftDown())) {
            ComponentLayer componentLayer = this.formDesigner.getComponentLayer();
            int n = this.getSelectionResizable(mouseEvent.getPoint(), componentLayer.getComponentContainer(), componentLayer.getDesignerOutsets().right + 2);
            this.resizeType = this.validDesignerResizing(n) ? n | 0x100 : 0;
        } else {
            this.resizeType = 0;
        }
        return this.resizeType;
    }

    private boolean validDesignerResizing(int n) {
        return n == 10 || n == 2 || n == 8;
    }

    private int checkComponentsResizing(MouseEvent mouseEvent) {
        Serializable serializable;
        if (mouseEvent.isAltDown() || mouseEvent.isControlDown() || mouseEvent.isShiftDown()) {
            this.resizeType = 0;
            return this.resizeType;
        }
        RADComponent rADComponent = null;
        Iterator iterator = this.formDesigner.getSelectedComponents().iterator();
        while (iterator.hasNext()) {
            serializable = (RADComponent)iterator.next();
            if (!(serializable instanceof RADVisualComponent) || !(rADComponent == null ? (rADComponent = ((RADComponent)serializable).getParentComponent()) == null : ((RADComponent)serializable).getParentComponent() != rADComponent)) continue;
            return 0;
        }
        serializable = mouseEvent.getPoint();
        RADComponent rADComponent2 = this.getMetaComponentAt((Point)serializable, 1);
        if (rADComponent2 instanceof RADVisualComponent) {
            RADVisualComponent rADVisualComponent = (RADVisualComponent)rADComponent2;
            if (!this.formDesigner.isComponentSelected(rADVisualComponent)) {
                RADVisualComponent[] rADVisualComponentArray;
                int n = 0;
                if (rADVisualComponent instanceof RADVisualContainer) {
                    rADVisualComponentArray = ((RADVisualContainer)rADVisualComponent).getSubComponents();
                } else {
                    RADVisualContainer rADVisualContainer = rADVisualComponent.getParentContainer();
                    if (rADVisualContainer != null) {
                        rADVisualComponentArray = rADVisualContainer.getSubComponents();
                    } else {
                        return 0;
                    }
                }
                int n2 = 0;
                while (n2 < rADVisualComponentArray.length) {
                    rADVisualComponent = rADVisualComponentArray[n2];
                    n = this.getComponentResizable((Point)serializable, rADVisualComponent);
                    if (n != 0) break;
                    ++n2;
                }
                this.resizeType = n;
            } else {
                this.resizeType = this.getComponentResizable((Point)serializable, rADVisualComponent);
            }
        } else {
            this.resizeType = 0;
        }
        return this.resizeType;
    }

    private int getComponentResizable(Point point, RADVisualComponent rADVisualComponent) {
        Component component;
        Container container;
        if (!this.formDesigner.isComponentSelected(rADVisualComponent)) {
            return 0;
        }
        RADVisualContainer rADVisualContainer = (RADVisualContainer)rADVisualComponent.getParentComponent();
        if (rADVisualContainer == null || rADVisualComponent == this.formDesigner.getTopDesignComponent()) {
            return 0;
        }
        LayoutSupportManager layoutSupportManager = rADVisualContainer.getLayoutSupport();
        if (layoutSupportManager == null) {
            return 0;
        }
        Container container2 = (Container)this.formDesigner.getComponent(rADVisualContainer);
        int n = layoutSupportManager.getResizableDirections(container2, container = rADVisualContainer.getContainerDelegate(container2), component = (Component)this.formDesigner.getComponent(rADVisualComponent), rADVisualContainer.getIndexOf(rADVisualComponent));
        if (n != 0) {
            n &= this.getSelectionResizable(point, component, 2);
        }
        return n;
    }

    private int getSelectionResizable(Point point, Component component, int n) {
        if (component == null) {
            return 0;
        }
        Rectangle rectangle = component.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        rectangle = SwingUtilities.convertRectangle(component, rectangle, this);
        Rectangle rectangle2 = new Rectangle(rectangle);
        Rectangle rectangle3 = new Rectangle(rectangle);
        rectangle2.grow(n, n);
        rectangle3.grow(-3, -3);
        if (rectangle3.width < 0) {
            rectangle3.width = 0;
        }
        if (rectangle3.height < 0) {
            rectangle3.height = 0;
        }
        int n2 = 0;
        if (rectangle2.contains(point)) {
            if (point.y >= rectangle3.y + rectangle3.height) {
                n2 |= 2;
            } else if (point.y < rectangle3.y) {
                n2 |= 1;
            }
            if (point.x >= rectangle3.x + rectangle3.width) {
                n2 |= 8;
            } else if (point.x < rectangle3.x) {
                n2 |= 4;
            }
        }
        return n2;
    }

    private void setResizingCursor(int n) {
        Cursor cursor = null;
        if ((n & 1) != 0) {
            cursor = (n & 4) != 0 ? Cursor.getPredefinedCursor(6) : ((n & 8) != 0 ? Cursor.getPredefinedCursor(7) : Cursor.getPredefinedCursor(8));
        } else if ((n & 2) != 0) {
            cursor = (n & 4) != 0 ? Cursor.getPredefinedCursor(4) : ((n & 8) != 0 ? Cursor.getPredefinedCursor(5) : Cursor.getPredefinedCursor(9));
        } else if ((n & 4) != 0) {
            cursor = Cursor.getPredefinedCursor(10);
        } else if ((n & 8) != 0) {
            cursor = Cursor.getPredefinedCursor(11);
        }
        if (cursor == null) {
            cursor = Cursor.getDefaultCursor();
        }
        this.setCursor(cursor);
    }

    private void setUserDesignerSize() {
        String string;
        int n;
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(FormUtils.getBundleString("CTL_SetDesignerSize_Label"), FormUtils.getBundleString("CTL_SetDesignerSize_Title"));
        Dimension dimension = this.formDesigner.getComponentLayer().getDesignerSize();
        inputLine.setInputText(Integer.toString(dimension.width) + ", " + Integer.toString(dimension.height));
        if (TopManager.getDefault().notify((NotifyDescriptor)inputLine) == NotifyDescriptor.OK_OPTION && (n = (string = inputLine.getInputText()).indexOf(44)) > 0) {
            int n2 = string.length();
            try {
                int n3 = Integer.parseInt(string.substring(0, n));
                while (++n < n2 && string.charAt(n) == ' ') {
                }
                int n4 = Integer.parseInt(string.substring(n, n2));
                if (n3 >= 0 && n4 >= 0) {
                    dimension = new Dimension(n3, n4);
                    this.formDesigner.setStoredDesignerSize(dimension);
                    this.formDesigner.getComponentLayer().updateDesignerSize(dimension);
                    this.setToolTipText(null);
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private LayoutConstraints getConstraintsAtPoint(RADComponent rADComponent, Point point) {
        RADVisualContainer rADVisualContainer;
        if (!(rADComponent instanceof RADVisualComponent)) {
            return null;
        }
        RADVisualContainer rADVisualContainer2 = rADVisualContainer = rADComponent instanceof RADVisualContainer ? (RADVisualContainer)rADComponent : (RADVisualContainer)rADComponent.getParentComponent();
        if (rADVisualContainer == null) {
            return null;
        }
        Container container = (Container)this.formDesigner.getComponent(rADVisualContainer);
        Container container2 = rADVisualContainer.getContainerDelegate(container);
        Point point2 = SwingUtilities.convertPoint(this, point, container2);
        return rADVisualContainer.getLayoutSupport().getNewConstraints(container, container2, null, -1, point2, null);
    }

    private void showAddHint(RADComponent rADComponent, Point point, PaletteItem paletteItem) {
        RADVisualContainer rADVisualContainer;
        if (!(rADComponent instanceof RADVisualComponent) && rADComponent != null || paletteItem.getItemClass() == null) {
            TopManager.getDefault().setStatusText("");
            return;
        }
        if (rADComponent == null) {
            HandleLayer.setStatusText("FMT_MSG_AddToOthers", new Object[]{paletteItem.getDisplayName()});
            return;
        }
        RADVisualContainer rADVisualContainer2 = rADVisualContainer = rADComponent instanceof RADVisualContainer ? (RADVisualContainer)rADComponent : (RADVisualContainer)rADComponent.getParentComponent();
        if (paletteItem.isLayout()) {
            if (rADVisualContainer != null) {
                if (!rADVisualContainer.getLayoutSupport().isDedicated()) {
                    HandleLayer.setStatusText("FMT_MSG_SetLayout", new Object[]{paletteItem.getDisplayName(), rADVisualContainer.getName()});
                } else {
                    HandleLayer.setStatusText("FMT_MSG_CannotSetLayout", new Object[]{rADVisualContainer.getName()});
                }
            } else {
                HandleLayer.setStatusText("FMT_MSG_CannotSetLayout", new Object[]{rADComponent.getName()});
            }
        } else if (paletteItem.isBorder()) {
            if ((class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = HandleLayer.class$("javax.swing.JComponent")) : class$javax$swing$JComponent).isAssignableFrom(rADComponent.getBeanClass())) {
                HandleLayer.setStatusText("FMT_MSG_SetBorder", new Object[]{paletteItem.getDisplayName(), rADComponent.getName()});
            } else {
                HandleLayer.setStatusText("FMT_MSG_CannotSetBorder", new Object[]{rADComponent.getName()});
            }
        } else if (rADVisualContainer != null && (paletteItem.isMenu() && rADVisualContainer.getContainerMenu() == null && rADVisualContainer.canHaveMenu(paletteItem.getItemClass()) || paletteItem.isVisual() && !paletteItem.isMenu())) {
            HandleLayer.setStatusText("FMT_MSG_AddComponent", new Object[]{paletteItem.getDisplayName(), rADVisualContainer.getName()});
        } else {
            HandleLayer.setStatusText("FMT_MSG_AddToOthers", new Object[]{paletteItem.getDisplayName()});
        }
    }

    private static void setStatusText(String string, Object[] objectArray) {
        TopManager.getDefault().setStatusText(FormUtils.getFormattedBundleString(string, objectArray));
    }

    boolean mouseOnVisual(Point point) {
        Rectangle rectangle = this.formDesigner.getComponentLayer().getDesignerBounds();
        return rectangle.contains(point);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SelectionDragger {
        private Point startPoint;
        private Point lastPoint;

        public SelectionDragger(Point point) {
            this.startPoint = point;
        }

        public void paintDragFeedback(Graphics graphics) {
            if (this.startPoint != null && this.lastPoint != null) {
                Rectangle rectangle = this.getRectangle();
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void drag(Point point) {
            this.lastPoint = point;
        }

        public void drop(Point point) {
            if (this.startPoint != null && point != null) {
                this.lastPoint = point;
                ArrayList arrayList = new ArrayList();
                this.collectSelectedComponents(this.getRectangle(), HandleLayer.this.formDesigner.getComponentLayer().getComponentContainer(), arrayList);
                RADComponent[] rADComponentArray = new RADComponent[arrayList.size()];
                arrayList.toArray(rADComponentArray);
                HandleLayer.this.formDesigner.setSelectedComponents(rADComponentArray);
            }
        }

        private Rectangle getRectangle() {
            int n;
            int n2 = this.startPoint.x <= this.lastPoint.x ? this.startPoint.x : this.lastPoint.x;
            int n3 = this.startPoint.y <= this.lastPoint.y ? this.startPoint.y : this.lastPoint.y;
            int n4 = this.lastPoint.x - this.startPoint.x;
            if (n4 < 0) {
                n4 = -n4;
            }
            if ((n = this.lastPoint.y - this.startPoint.y) < 0) {
                n = -n;
            }
            return new Rectangle(n2, n3, n4, n);
        }

        private boolean collectSelectedComponents(Rectangle rectangle, Container container, List list) {
            Component component;
            ArrayList<Component> arrayList = new ArrayList<Component>();
            Component[] componentArray = container.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                block11: {
                    boolean bl;
                    block10: {
                        component = componentArray[n];
                        Rectangle rectangle2 = SwingUtilities.convertRectangle(container, componentArray[n].getBounds(), HandleLayer.this);
                        bl = rectangle.intersects(rectangle2);
                        RADComponent rADComponent = HandleLayer.this.formDesigner.getMetaComponent(component);
                        if (!(rADComponent instanceof RADComponent)) break block10;
                        if (bl) {
                            list.add(rADComponent);
                        }
                        if (!(rADComponent instanceof ComponentContainer)) break block11;
                    }
                    if (bl && component instanceof Container) {
                        arrayList.add(component);
                    }
                }
                ++n;
            }
            if (list.size() > 1 || list.size() == 1 && arrayList.size() == 0) {
                return true;
            }
            component = list.size() == 1 ? list.get(0) : null;
            int n2 = 0;
            while (n2 < arrayList.size()) {
                list.clear();
                if (this.collectSelectedComponents(rectangle, (Container)arrayList.get(n2), list)) {
                    return true;
                }
                ++n2;
            }
            if (component != null) {
                list.add(component);
                return true;
            }
            return false;
        }
    }

    private class DesignerResizer {
        boolean dragged = false;

        private DesignerResizer() {
        }

        public void drag(Point point) {
            Dimension dimension = this.computeDesignerSize(point);
            HandleLayer.this.formDesigner.getComponentLayer().updateDesignerSize(dimension);
            if (!dimension.equals(HandleLayer.this.formDesigner.getStoredDesignerSize())) {
                this.dragged = true;
            }
        }

        public void drop(Point point) {
            if (this.dragged) {
                Dimension dimension = this.computeDesignerSize(point);
                HandleLayer.this.formDesigner.setStoredDesignerSize(dimension);
            }
        }

        private Dimension computeDesignerSize(Point point) {
            Rectangle rectangle = HandleLayer.this.formDesigner.getComponentLayer().getDesignerBounds();
            int n = rectangle.width;
            int n2 = rectangle.height;
            if ((HandleLayer.this.resizeType & 2) != 0 && (n2 = point.y - rectangle.y) < 0) {
                n2 = 0;
            }
            if ((HandleLayer.this.resizeType & 8) != 0 && (n = point.x - rectangle.x) < 0) {
                n = 0;
            }
            return new Dimension(n, n2);
        }
    }

    private class HandleLayerMouseMotionListener
    implements MouseMotionListener {
        private HandleLayerMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            if (HandleLayer.this.designerResizer != null) {
                HandleLayer.this.designerResizer.drag(mouseEvent.getPoint());
            } else if (CPManager.getDefault().getMode() == 0 && !HandleLayer.this.anyDragger() && !HandleLayer.this.draggingCanceled) {
                if (!(HandleLayer.this.viewOnly || mouseEvent.isControlDown() || mouseEvent.isShiftDown() && !mouseEvent.isAltDown() || HandleLayer.this.lastLeftMousePoint == null || HandleLayer.this.resizeType == 0 && !(HandleLayer.this.lastLeftMousePoint.distance(point) > 8.0))) {
                    HandleLayer.this.componentDragger = HandleLayer.this.createComponentDragger(HandleLayer.this.lastLeftMousePoint, mouseEvent.getModifiers());
                } else if (HandleLayer.this.formDesigner.getTopDesignComponent() instanceof RADVisualContainer && !mouseEvent.isAltDown() && !mouseEvent.isControlDown() && mouseEvent.isShiftDown() && HandleLayer.this.lastLeftMousePoint != null && HandleLayer.this.lastLeftMousePoint.distance(point) > 4.0) {
                    HandleLayer.this.selectionDragger = new SelectionDragger(HandleLayer.this.lastLeftMousePoint);
                }
            }
            if (HandleLayer.this.componentDragger != null) {
                HandleLayer.this.componentDragger.drag(point);
                HandleLayer.this.repaint();
            }
            if (HandleLayer.this.selectionDragger != null) {
                HandleLayer.this.selectionDragger.drag(point);
                HandleLayer.this.repaint();
            }
            mouseEvent.consume();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            CPManager cPManager = CPManager.getDefault();
            if (cPManager.getMode() == 2) {
                RADComponent rADComponent = HandleLayer.this.getMetaComponentAt(mouseEvent.getPoint(), mouseEvent.isControlDown() || mouseEvent.isAltDown() ? 1 : 0);
                HandleLayer.this.showAddHint(rADComponent, mouseEvent.getPoint(), cPManager.getSelectedItem());
            } else if (cPManager.getMode() == 0) {
                HandleLayer.this.checkResizing(mouseEvent);
            }
        }
    }

    private class HandleLayerMouseListener
    implements MouseListener {
        private HandleLayerMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (MouseUtils.isRightMouseButton((MouseEvent)mouseEvent) && !HandleLayer.this.anyDragger()) {
                if (!HandleLayer.this.draggingCanceled) {
                    HandleLayer.this.showContextMenu(mouseEvent.getPoint());
                } else {
                    HandleLayer.this.draggingCanceled = false;
                }
            }
            mouseEvent.consume();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!HandleLayer.this.isVisible()) {
                return;
            }
            if (MouseUtils.isLeftMouseButton((MouseEvent)mouseEvent)) {
                CPManager cPManager = CPManager.getDefault();
                if (cPManager.getMode() == 0 && !HandleLayer.this.endDragging(mouseEvent.getPoint())) {
                    if (HandleLayer.this.draggingCanceled) {
                        HandleLayer.this.draggingCanceled = false;
                    } else if (!((HandleLayer.this.resizeType & 0x100) == 0 || mouseEvent.getClickCount() != 2 || mouseEvent.isShiftDown() || mouseEvent.isControlDown() || mouseEvent.isAltDown())) {
                        HandleLayer.this.setUserDesignerSize();
                    } else if (HandleLayer.this.prevLeftMousePoint != null && mouseEvent.getClickCount() == 1 && HandleLayer.this.prevLeftMousePoint.distance(mouseEvent.getPoint()) <= 2.0 && !mouseEvent.isShiftDown() && !mouseEvent.isControlDown() && !mouseEvent.isAltDown()) {
                        HandleLayer.this.formDesigner.startInPlaceEditing(HandleLayer.this.getMetaComponentAt(mouseEvent.getPoint(), 1));
                    } else if (mouseEvent.getClickCount() == 1 && !mouseEvent.isAltDown() && !mouseEvent.isControlDown() && mouseEvent.isShiftDown()) {
                        HandleLayer.this.selectComponent(mouseEvent);
                    }
                }
                HandleLayer.this.prevLeftMousePoint = HandleLayer.this.lastLeftMousePoint;
                HandleLayer.this.lastLeftMousePoint = null;
            }
            mouseEvent.consume();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            TopManager.getDefault().setStatusText("");
        }

        public void mousePressed(MouseEvent mouseEvent) {
            HandleLayer.this.formDesigner.componentActivated();
            if (!HandleLayer.this.isVisible()) {
                return;
            }
            if (MouseUtils.isRightMouseButton((MouseEvent)mouseEvent)) {
                if (!HandleLayer.this.anyDragger()) {
                    if (!HandleLayer.this.mouseOnVisual(mouseEvent.getPoint())) {
                        HandleLayer.this.selectOtherComponentsNode();
                    } else {
                        RADComponent rADComponent = HandleLayer.this.getMetaComponentAt(mouseEvent.getPoint(), 1);
                        if (rADComponent != null && !HandleLayer.this.formDesigner.isComponentSelected(rADComponent)) {
                            HandleLayer.this.formDesigner.setSelectedComponent(rADComponent);
                        }
                    }
                } else {
                    HandleLayer.this.endDragging(null);
                }
                mouseEvent.consume();
            } else if (MouseUtils.isLeftMouseButton((MouseEvent)mouseEvent)) {
                HandleLayer.this.lastLeftMousePoint = mouseEvent.getPoint();
                boolean bl = mouseEvent.isControlDown() || mouseEvent.isAltDown() || mouseEvent.isShiftDown();
                CPManager cPManager = CPManager.getDefault();
                int n = cPManager.getMode();
                if (n == 0) {
                    HandleLayer.this.checkResizing(mouseEvent);
                    if (!mouseEvent.isShiftDown() || mouseEvent.isAltDown() || mouseEvent.isControlDown()) {
                        RADComponent rADComponent;
                        if (HandleLayer.this.designerResizer == null && !bl && (HandleLayer.this.resizeType & 0x100) != 0) {
                            if (mouseEvent.getClickCount() != 2) {
                                HandleLayer.this.designerResizer = new DesignerResizer();
                            }
                        } else if (!HandleLayer.this.mouseOnVisual(HandleLayer.this.lastLeftMousePoint)) {
                            if (HandleLayer.this.resizeType == 0) {
                                HandleLayer.this.selectOtherComponentsNode();
                            }
                        } else if (!(HandleLayer.this.resizeType != 0 || mouseEvent.getClickCount() == 2 && HandleLayer.this.processDoubleClick(mouseEvent) || (rADComponent = HandleLayer.this.selectComponent(mouseEvent)) == null || bl)) {
                            HandleLayer.this.processMouseClickInLayoutSupport(rADComponent, mouseEvent);
                        }
                    }
                    HandleLayer.this.draggingCanceled = false;
                } else if (!HandleLayer.this.viewOnly) {
                    if (n == 1) {
                        HandleLayer.this.selectComponent(mouseEvent);
                    } else if (n == 2) {
                        RADComponent rADComponent = HandleLayer.this.getMetaComponentAt(HandleLayer.this.lastLeftMousePoint, mouseEvent.isAltDown() ? 1 : 0);
                        PaletteItem paletteItem = cPManager.getSelectedItem();
                        LayoutConstraints layoutConstraints = !paletteItem.isMenu() && paletteItem.isVisual() ? HandleLayer.this.getConstraintsAtPoint(rADComponent, HandleLayer.this.lastLeftMousePoint) : null;
                        if (!HandleLayer.this.mouseOnVisual(HandleLayer.this.lastLeftMousePoint)) {
                            HandleLayer.this.formDesigner.getModel().getComponentCreator().createComponent(paletteItem.getInstanceCookie(), null, null);
                        } else {
                            HandleLayer.this.formDesigner.getModel().getComponentCreator().createComponent(paletteItem.getInstanceCookie(), rADComponent, (Object)layoutConstraints);
                        }
                        if (!mouseEvent.isShiftDown()) {
                            cPManager.setMode(0);
                            HandleLayer.this.draggingCanceled = true;
                        }
                    }
                }
                mouseEvent.consume();
            }
        }
    }
}

