/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.beans.MethodDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.ParametersPicker;
import org.netbeans.modules.form.RADComponent;

public class MethodPicker
extends JPanel {
    static final long serialVersionUID = 7355140527892160804L;
    private JLabel listLabel;
    private JLabel componentLabel;
    private JList methodList;
    private JComboBox componentsCombo;
    private JScrollPane propertiesScrollPane;
    private FormModel formModel;
    private boolean pickerValid = false;
    private RADComponent[] components;
    private Class requiredType;
    private MethodDescriptor[] descriptors;
    private RADComponent selectedComponent;
    private MethodDescriptor selectedMethod;

    public MethodPicker(FormModel formModel, RADComponent rADComponent, Class clazz) {
        this.formModel = formModel;
        this.requiredType = clazz;
        this.initComponents();
        List list = formModel.getMetaComponents();
        Collections.sort(list, new ParametersPicker.ComponentComparator());
        this.components = new RADComponent[list.size()];
        list.toArray(this.components);
        int n = -1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RADComponent rADComponent2 = (RADComponent)iterator.next();
            if (rADComponent != null && rADComponent == rADComponent2) {
                n = this.componentsCombo.getItemCount();
            }
            if (rADComponent2 == formModel.getTopRADComponent()) {
                this.componentsCombo.addItem(FormUtils.getBundleString("CTL_FormTopContainerName"));
                continue;
            }
            this.componentsCombo.addItem(rADComponent2.getName());
        }
        if (n >= 0) {
            this.componentsCombo.setSelectedIndex(n);
        }
        this.updateMethodList();
        this.componentLabel.setText(FormUtils.getBundleString("CTL_CW_Component"));
        this.listLabel.setText(FormUtils.getBundleString("CTL_CW_MethodList"));
        this.componentLabel.setDisplayedMnemonic(FormUtils.getBundleString("CTL_CW_Component_Mnemonic").charAt(0));
        this.listLabel.setDisplayedMnemonic(FormUtils.getBundleString("CTL_CW_MethodList_Mnemonic").charAt(0));
        this.componentsCombo.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_Component"));
        this.methodList.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_MethodList"));
        this.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_MethodPicker"));
    }

    public boolean isPickerValid() {
        return this.pickerValid;
    }

    private void setPickerValid(boolean bl) {
        boolean bl2 = this.pickerValid;
        this.pickerValid = bl;
        this.firePropertyChange("pickerValid", bl2, this.pickerValid);
    }

    RADComponent getSelectedComponent() {
        return this.selectedComponent;
    }

    void setSelectedComponent(RADComponent rADComponent) {
        if (rADComponent != null) {
            this.componentsCombo.setSelectedItem(rADComponent.getName());
        }
    }

    MethodDescriptor getSelectedMethod() {
        if (this.selectedComponent == null || this.methodList.getSelectedIndex() == -1) {
            return null;
        }
        return this.descriptors[this.methodList.getSelectedIndex()];
    }

    void setSelectedMethod(MethodDescriptor methodDescriptor) {
        if (methodDescriptor == null) {
            this.methodList.setSelectedIndex(-1);
        } else {
            this.methodList.setSelectedValue(FormUtils.getMethodName(methodDescriptor), true);
        }
    }

    private void addComponentsRecursively(ComponentContainer componentContainer, Vector vector) {
        RADComponent[] rADComponentArray = componentContainer.getSubBeans();
        int n = 0;
        while (n < rADComponentArray.length) {
            vector.addElement(rADComponentArray[n]);
            if (rADComponentArray[n] instanceof ComponentContainer) {
                this.addComponentsRecursively((ComponentContainer)((Object)rADComponentArray[n]), vector);
            }
            ++n;
        }
    }

    private void updateMethodList() {
        RADComponent rADComponent = this.getSelectedComponent();
        if (rADComponent == null) {
            this.methodList.setListData(new Object[0]);
            this.methodList.revalidate();
            this.methodList.repaint();
        } else {
            MethodDescriptor[] methodDescriptorArray = rADComponent.getBeanInfo().getMethodDescriptors();
            ArrayList<MethodDescriptor> arrayList = new ArrayList<MethodDescriptor>();
            int n = 0;
            while (n < methodDescriptorArray.length) {
                if (this.requiredType.isAssignableFrom(methodDescriptorArray[n].getMethod().getReturnType()) && methodDescriptorArray[n].getMethod().getParameterTypes().length == 0) {
                    arrayList.add(methodDescriptorArray[n]);
                }
                ++n;
            }
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((MethodDescriptor)object).getName().compareTo(((MethodDescriptor)object2).getName());
                }
            });
            this.descriptors = new MethodDescriptor[arrayList.size()];
            arrayList.toArray(this.descriptors);
            String[] stringArray = new String[this.descriptors.length];
            int n2 = 0;
            while (n2 < this.descriptors.length) {
                stringArray[n2] = FormUtils.getMethodName(this.descriptors[n2]);
                ++n2;
            }
            this.methodList.setListData(stringArray);
            this.methodList.revalidate();
            this.methodList.repaint();
        }
    }

    private void updateState() {
        if (this.getSelectedComponent() == null || this.getSelectedMethod() == null) {
            this.setPickerValid(false);
        } else {
            this.setPickerValid(this.getSelectedMethod().getMethod().getParameterTypes().length == 0);
        }
    }

    private void initComponents() {
        this.componentLabel = new JLabel();
        this.componentsCombo = new JComboBox();
        this.listLabel = new JLabel();
        this.propertiesScrollPane = new JScrollPane();
        this.methodList = new JList();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
        this.componentLabel.setLabelFor(this.componentsCombo);
        this.componentLabel.setText(FormUtils.getBundleString("CTL_Component"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 6);
        this.add((Component)this.componentLabel, gridBagConstraints);
        this.componentsCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                MethodPicker.this.componentsComboItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.componentsCombo, gridBagConstraints);
        this.listLabel.setLabelFor(this.methodList);
        this.listLabel.setText(FormUtils.getBundleString("CTL_Component"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.listLabel, gridBagConstraints);
        this.methodList.setSelectionMode(0);
        this.methodList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                MethodPicker.this.methodListValueChanged(listSelectionEvent);
            }
        });
        this.propertiesScrollPane.setViewportView(this.methodList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.propertiesScrollPane, gridBagConstraints);
    }

    private void methodListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.selectedMethod = this.methodList.getSelectedIndex() == -1 ? null : this.descriptors[this.methodList.getSelectedIndex()];
        this.updateState();
    }

    private void componentsComboItemStateChanged(ItemEvent itemEvent) {
        this.selectedComponent = this.componentsCombo.getSelectedIndex() == -1 ? null : this.components[this.componentsCombo.getSelectedIndex()];
        this.updateMethodList();
    }

    private void closeDialog(WindowEvent windowEvent) {
    }
}

