/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.ParametersPicker;
import org.netbeans.modules.form.RADComponent;

public class PropertyPicker
extends JPanel {
    public static final int CANCEL = 0;
    public static final int OK = 1;
    static final long serialVersionUID = 5689122601606238081L;
    private JList propertyList;
    private JLabel listLabel;
    private JLabel componentLabel;
    private JComboBox componentsCombo;
    private JScrollPane propertiesScrollPane;
    private FormModel formModel;
    private boolean pickerValid = false;
    private RADComponent[] components;
    private Class requiredType;
    private PropertyDescriptor[] descriptors;
    private RADComponent selectedComponent;
    private PropertyDescriptor selectedProperty;

    public PropertyPicker(FormModel formModel, RADComponent rADComponent, Class clazz) {
        this.formModel = formModel;
        this.requiredType = clazz;
        this.initComponents();
        List list = formModel.getMetaComponents();
        Collections.sort(list, new ParametersPicker.ComponentComparator());
        this.components = new RADComponent[list.size()];
        list.toArray(this.components);
        int n = -1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RADComponent rADComponent2 = (RADComponent)iterator.next();
            if (rADComponent != null && rADComponent == rADComponent2) {
                n = this.componentsCombo.getItemCount();
            }
            if (rADComponent2 == formModel.getTopRADComponent()) {
                this.componentsCombo.addItem(FormUtils.getBundleString("CTL_FormTopContainerName"));
                continue;
            }
            this.componentsCombo.addItem(rADComponent2.getName());
        }
        if (n >= 0) {
            this.componentsCombo.setSelectedIndex(n);
        }
        this.propertyList.setSelectionMode(0);
        this.updatePropertyList();
        this.componentLabel.setDisplayedMnemonic(FormUtils.getBundleString("CTL_CW_Component_Mnemonic").charAt(0));
        this.listLabel.setDisplayedMnemonic(FormUtils.getBundleString("CTL_CW_PropertyList_Mnemonic").charAt(0));
        this.componentsCombo.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_Component"));
        this.propertyList.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_PropertyList"));
        this.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_PropertyPicker"));
    }

    public boolean isPickerValid() {
        return this.pickerValid;
    }

    private void setPickerValid(boolean bl) {
        boolean bl2 = this.pickerValid;
        this.pickerValid = bl;
        this.firePropertyChange("pickerValid", bl2, this.pickerValid);
    }

    RADComponent getSelectedComponent() {
        return this.selectedComponent;
    }

    void setSelectedComponent(RADComponent rADComponent) {
        if (rADComponent != null) {
            this.componentsCombo.setSelectedItem(rADComponent.getName());
        }
    }

    PropertyDescriptor getSelectedProperty() {
        if (this.selectedComponent == null || this.propertyList.getSelectedIndex() == -1) {
            return null;
        }
        return this.descriptors[this.propertyList.getSelectedIndex()];
    }

    void setSelectedProperty(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            this.propertyList.setSelectedIndex(-1);
        } else {
            this.propertyList.setSelectedValue(propertyDescriptor.getName(), true);
        }
    }

    private void updatePropertyList() {
        RADComponent rADComponent = this.getSelectedComponent();
        if (rADComponent == null) {
            this.propertyList.setListData(new Object[0]);
            this.propertyList.revalidate();
            this.propertyList.repaint();
        } else {
            PropertyDescriptor[] propertyDescriptorArray = rADComponent.getBeanInfo().getPropertyDescriptors();
            ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                if (propertyDescriptorArray[n].getReadMethod() != null && propertyDescriptorArray[n].getPropertyType() != null && this.requiredType.isAssignableFrom(propertyDescriptorArray[n].getPropertyType())) {
                    arrayList.add(propertyDescriptorArray[n]);
                }
                ++n;
            }
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((PropertyDescriptor)object).getName().compareTo(((PropertyDescriptor)object2).getName());
                }
            });
            this.descriptors = new PropertyDescriptor[arrayList.size()];
            arrayList.toArray(this.descriptors);
            String[] stringArray = new String[this.descriptors.length];
            int n2 = 0;
            while (n2 < this.descriptors.length) {
                stringArray[n2] = this.descriptors[n2].getName();
                ++n2;
            }
            this.propertyList.setListData(stringArray);
            this.propertyList.revalidate();
            this.propertyList.repaint();
        }
    }

    private void updateState() {
        this.setPickerValid(this.getSelectedComponent() != null && this.getSelectedProperty() != null);
    }

    private void initComponents() {
        this.componentsCombo = new JComboBox();
        this.propertiesScrollPane = new JScrollPane();
        this.propertyList = new JList();
        this.componentLabel = new JLabel();
        this.listLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
        this.componentsCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PropertyPicker.this.componentsComboItemStateChanged(itemEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.componentsCombo, gridBagConstraints);
        this.propertyList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PropertyPicker.this.propertyListValueChanged(listSelectionEvent);
            }
        });
        this.propertiesScrollPane.setViewportView(this.propertyList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.propertiesScrollPane, gridBagConstraints);
        this.componentLabel.setLabelFor(this.componentsCombo);
        this.componentLabel.setText(FormUtils.getBundleString("CTL_Component"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 6);
        this.add((Component)this.componentLabel, gridBagConstraints);
        this.listLabel.setLabelFor(this.propertyList);
        this.listLabel.setText(FormUtils.getBundleString("CTL_CW_PropertyList"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.listLabel, gridBagConstraints);
    }

    private void propertyListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.selectedProperty = this.propertyList.getSelectedIndex() == -1 ? null : this.descriptors[this.propertyList.getSelectedIndex()];
        this.updateState();
    }

    private void componentsComboItemStateChanged(ItemEvent itemEvent) {
        this.selectedComponent = this.componentsCombo.getSelectedIndex() == -1 ? null : this.components[this.componentsCombo.getSelectedIndex()];
        this.updatePropertyList();
    }

    private void closeDialog(WindowEvent windowEvent) {
    }
}

