/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.form.GlobalJarFileSystem;
import org.netbeans.modules.form.palette.CPManager;
import org.netbeans.modules.form.palette.PaletteNode;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public final class BeanInstaller {
    private static File lastDirectory;
    static String JAR_EXT;
    static /* synthetic */ Class class$org$netbeans$modules$form$palette$BeanInstaller;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

    public static void installBean() {
        String string;
        File file = BeanInstaller.selectJarModule();
        if (file == null) {
            return;
        }
        JarFileSystem jarFileSystem = BeanInstaller.createJarForFile(file);
        if (jarFileSystem == null) {
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)CPManager.getBundle().getString("MSG_ErrorInFile"), 0));
            return;
        }
        Collection collection = BeanInstaller.findJavaBeans(jarFileSystem);
        if (collection.size() == 0) {
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)CPManager.getBundle().getString("MSG_noBeansInJar"), 1));
            return;
        }
        BeanSelector beanSelector = new BeanSelector(collection);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)beanSelector, CPManager.getBundle().getString("CTL_SelectJB"), true, null);
        dialogDescriptor.setHelpCtx(new HelpCtx((class$org$netbeans$modules$form$palette$BeanInstaller == null ? (class$org$netbeans$modules$form$palette$BeanInstaller = BeanInstaller.class$("org.netbeans.modules.form.palette.BeanInstaller")) : class$org$netbeans$modules$form$palette$BeanInstaller).getName() + ".installBean"));
        TopManager.getDefault().createDialog(dialogDescriptor).show();
        if (dialogDescriptor.getValue() == NotifyDescriptor.OK_OPTION && (string = BeanInstaller.selectPaletteCategory()) != null) {
            BeanInstaller.installBeans(jarFileSystem, beanSelector.getSelectedBeans(), string);
        }
    }

    public static void installBeans(Node[] nodeArray) {
        String string = BeanInstaller.selectPaletteCategory();
        if (string == null) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(nodeArray.length);
        int n = 0;
        while (n < nodeArray.length) {
            DataObject dataObject = (DataObject)nodeArray[n].getCookie(class$org$openide$loaders$DataObject == null ? BeanInstaller.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            InstanceCookie instanceCookie = (InstanceCookie)nodeArray[n].getCookie(class$org$openide$cookies$InstanceCookie == null ? BeanInstaller.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
            if (dataObject != null && instanceCookie != null) {
                FileObject fileObject = dataObject.getPrimaryFile();
                if ("instance".equals(fileObject.getExt()) || "java".equals(fileObject.getExt()) || "class".equals(fileObject.getExt())) {
                    arrayList.add(instanceCookie);
                } else {
                    arrayList.add(fileObject);
                }
            }
            ++n;
        }
        BeanInstaller.installBeans(null, arrayList, string);
    }

    private static Collection findJavaBeans(JarFileSystem jarFileSystem) {
        LinkedList<FileObject> linkedList = new LinkedList<FileObject>();
        Manifest manifest = jarFileSystem.getManifest();
        Map<String, Attributes> map = manifest.getEntries();
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = iterator.next();
            if (!string2.endsWith(".class") && !string2.endsWith(".ser") || (string = map.get(string2).getValue("Java-Bean")) == null || !string.equalsIgnoreCase("True")) continue;
            String[] stringArray = new String[]{".class", ".ser"};
            int n = 0;
            while (n < stringArray.length) {
                String string3;
                FileObject fileObject;
                String string4 = stringArray[n];
                if (string2.endsWith(string4) && (fileObject = jarFileSystem.findResource(string3 = string2.replace('\\', '/'))) != null) {
                    linkedList.add(fileObject);
                }
                ++n;
            }
        }
        return linkedList;
    }

    private static void installBeans(JarFileSystem jarFileSystem, Collection collection, String string) {
        FileSystem fileSystem;
        FileObject fileObject;
        FileObject fileObject2;
        if (jarFileSystem != null) {
            BeanInstaller.addJarFileSystem(jarFileSystem);
        }
        if (string == null) {
            string = "Beans";
        }
        if ((fileObject2 = (fileObject = (fileSystem = TopManager.getDefault().getRepository().getDefaultFileSystem()).getRoot()).getFileObject("Palette")) == null) {
            return;
        }
        FileObject fileObject3 = fileObject2.getFileObject(string);
        if (fileObject3 == null) {
            try {
                fileObject3 = fileObject2.createFolder(string);
            }
            catch (IOException iOException) {
                if (System.getProperty("netbeans.debug.exceptions") != null) {
                    iOException.printStackTrace();
                }
                return;
            }
        }
        final FileObject fileObject4 = fileObject3;
        final Iterator iterator = collection.iterator();
        LinkedList linkedList = new LinkedList();
        try {
            fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() {
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        String string = null;
                        if (e instanceof FileObject) {
                            if ("class".equals(((FileObject)e).getExt())) {
                                string = ((FileObject)e).getPackageName('.');
                                if (string == null) continue;
                                BeanInstaller.createInstance(fileObject4, string);
                                continue;
                            }
                            BeanInstaller.createShadow(fileObject4, (FileObject)e);
                            continue;
                        }
                        if (!(e instanceof InstanceCookie) || (string = ((InstanceCookie)e).instanceName()) == null) continue;
                        BeanInstaller.createInstance(fileObject4, string);
                    }
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addJarFileSystem(JarFileSystem jarFileSystem) {
        boolean bl = false;
        if (jarFileSystem != null) {
            Repository repository = TopManager.getDefault().getRepository();
            JarFileSystem jarFileSystem2 = (JarFileSystem)repository.findFileSystem(jarFileSystem.getSystemName());
            if (jarFileSystem2 != null) {
                bl = true;
                jarFileSystem = jarFileSystem2;
            }
            if (!bl) {
                jarFileSystem.setHidden(true);
                repository.addFileSystem((FileSystem)jarFileSystem);
            }
        }
    }

    static void createShadow(FileObject fileObject, FileObject fileObject2) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject2);
            if (dataObject != null) {
                DataShadow.create((DataFolder)DataFolder.findFolder((FileObject)fileObject), (DataObject)dataObject);
            }
        }
        catch (IOException iOException) {
            TopManager.getDefault().getErrorManager().notify((Throwable)iOException);
        }
    }

    static void createInstance(FileObject fileObject, String string) {
        try {
            Class.forName(string, true, TopManager.getDefault().currentClassLoader());
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            ErrorManager errorManager = TopManager.getDefault().getErrorManager();
            String string2 = MessageFormat.format(CPManager.getBundle().getString("FMT_ERR_CannotLoadClass"), string);
            errorManager.annotate(throwable, 16, null, string2, null, null);
            errorManager.notify(throwable);
            return;
        }
        String string3 = BeanInstaller.formatName(string);
        try {
            FileObject fileObject2;
            DataObject dataObject;
            if (fileObject.getFileObject(string3 + ".instance") == null && (dataObject = DataObject.find((FileObject)(fileObject2 = fileObject.createData(string3, "instance")))) != null) {
                dataObject.getNodeDelegate();
            }
        }
        catch (IOException iOException) {
            if (System.getProperty("netbeans.debug.exceptions") != null) {
                iOException.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            throwable.printStackTrace();
        }
    }

    private static String formatName(String string) {
        return string.replace('.', '-');
    }

    private static String selectPaletteCategory() {
        CategorySelector categorySelector = new CategorySelector();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)categorySelector, CPManager.getBundle().getString("CTL_SelectPalette"), true, null);
        dialogDescriptor.setHelpCtx(new HelpCtx((class$org$netbeans$modules$form$palette$BeanInstaller == null ? (class$org$netbeans$modules$form$palette$BeanInstaller = BeanInstaller.class$("org.netbeans.modules.form.palette.BeanInstaller")) : class$org$netbeans$modules$form$palette$BeanInstaller).getName() + ".selectPaletteCategory"));
        TopManager.getDefault().createDialog(dialogDescriptor).show();
        if (dialogDescriptor.getValue() == NotifyDescriptor.OK_OPTION) {
            return categorySelector.getSelectedCategory();
        }
        return null;
    }

    private static File selectJarModule() {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        final ResourceBundle resourceBundle = CPManager.getBundle();
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(JAR_EXT);
            }

            public String getDescription() {
                return resourceBundle.getString("CTL_JarArchivesMask");
            }
        });
        if (lastDirectory == null) {
            try {
                file = new File(System.getProperty("user.home"));
                if (Utilities.isUnix()) {
                    lastDirectory = file;
                } else if (Utilities.isWindows()) {
                    while ((file = file.getParentFile()) != null && file.getParentFile() != null) {
                    }
                    if (file != null) {
                        lastDirectory = file;
                    }
                }
            }
            catch (Exception exception) {
                lastDirectory = null;
            }
        }
        if (lastDirectory != null) {
            jFileChooser.setCurrentDirectory(lastDirectory);
        }
        jFileChooser.setDialogTitle(resourceBundle.getString("CTL_SelectJar"));
        while (jFileChooser.showDialog(TopManager.getDefault().getWindowManager().getMainWindow(), resourceBundle.getString("CTL_Select_Approve_Button")) == 0) {
            file = jFileChooser.getSelectedFile();
            lastDirectory = jFileChooser.getCurrentDirectory();
            if (file != null && file.isFile() && file.getName().endsWith(JAR_EXT)) {
                return file;
            }
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)resourceBundle.getString("MSG_noValidFile"), 2));
        }
        return null;
    }

    private static JarFileSystem createJarForFile(File file) {
        try {
            GlobalJarFileSystem globalJarFileSystem = new GlobalJarFileSystem();
            globalJarFileSystem.setJarFile(file);
            return globalJarFileSystem;
        }
        catch (PropertyVetoException propertyVetoException) {
            if (System.getProperty("netbeans.debug.exceptions") != null) {
                propertyVetoException.printStackTrace();
            }
            return null;
        }
        catch (IOException iOException) {
            if (System.getProperty("netbeans.debug.exceptions") != null) {
                iOException.printStackTrace();
            }
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        JAR_EXT = ".jar";
    }

    private static class FileObjectRenderer
    extends JLabel
    implements ListCellRenderer {
        static final long serialVersionUID = 832555965217675765L;
        private static final Border hasFocusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public FileObjectRenderer() {
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (!(object instanceof FileObject)) {
                return this;
            }
            FileObject fileObject = (FileObject)object;
            this.setText(fileObject.getName());
            if (bl) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setBorder(bl2 ? hasFocusBorder : noFocusBorder);
            return this;
        }
    }

    private static class BeanSelector
    extends JPanel {
        static final long serialVersionUID = -6038414545631774041L;
        private JList list;

        public BeanSelector(Collection collection) {
            this.list = new JList<Object>(collection.toArray());
            this.list.setCellRenderer(new FileObjectRenderer());
            this.setBorder(new EmptyBorder(12, 12, 0, 11));
            this.setLayout(new BorderLayout(0, 2));
            JLabel jLabel = new JLabel(CPManager.getBundle().getString("CTL_SelectBeans"));
            jLabel.setLabelFor(this.list);
            jLabel.setDisplayedMnemonic(CPManager.getBundle().getString("CTL_SelectBeans_Mnemonic").charAt(0));
            this.list.getAccessibleContext().setAccessibleDescription(CPManager.getBundle().getString("ACSD_CTL_SelectBeans"));
            this.getAccessibleContext().setAccessibleDescription(CPManager.getBundle().getString("ACSD_SelectBeansDialog"));
            this.add((Component)jLabel, "North");
            this.add((Component)new JScrollPane(this.list), "Center");
        }

        Collection getSelectedBeans() {
            Object[] objectArray = this.list.getSelectedValues();
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            int n = 0;
            while (n < objectArray.length) {
                arrayList.add(objectArray[n]);
                ++n;
            }
            return arrayList;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = Math.max(dimension.width, 350);
            dimension.height = Math.max(dimension.height, 250);
            return dimension;
        }
    }

    private static class CategorySelector
    extends JPanel {
        private JList list;
        private String[] catNames;
        static final long serialVersionUID = 936459317386043582L;

        public CategorySelector() {
            Node node;
            DataObject[] dataObjectArray = PaletteNode.getPaletteFolder().getChildren();
            ArrayList<String> arrayList = new ArrayList<String>(dataObjectArray.length);
            ArrayList<String> arrayList2 = new ArrayList<String>(dataObjectArray.length);
            int n = 0;
            while (n < dataObjectArray.length) {
                if (dataObjectArray[n] instanceof DataFolder && (node = dataObjectArray[n].getNodeDelegate()) != null) {
                    arrayList.add(node.getDisplayName());
                    arrayList2.add(node.getName());
                }
                ++n;
            }
            node = new String[arrayList.size()];
            arrayList.toArray((T[])node);
            this.catNames = new String[arrayList2.size()];
            arrayList2.toArray(this.catNames);
            this.list = new JList((E[])node);
            this.list.setSelectionMode(0);
            this.setLayout(new BorderLayout(0, 5));
            JLabel jLabel = new JLabel(CPManager.getBundle().getString("CTL_PaletteCategories"));
            jLabel.setDisplayedMnemonic(CPManager.getBundle().getString("CTL_PaletteCategories_Mnemonic").charAt(0));
            jLabel.setLabelFor(this.list);
            this.list.getAccessibleContext().setAccessibleDescription(CPManager.getBundle().getString("ACSD_CTL_PaletteCategories"));
            this.getAccessibleContext().setAccessibleDescription(CPManager.getBundle().getString("ACSD_PaletteCategoriesSelector"));
            this.add((Component)jLabel, "North");
            this.add((Component)new JScrollPane(this.list), "Center");
            this.setBorder(new EmptyBorder(12, 12, 0, 11));
        }

        public String getSelectedCategory() {
            int n = this.list.getSelectedIndex();
            return n >= 0 ? this.catNames[n] : null;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = Math.max(dimension.width, 350);
            dimension.height = Math.max(dimension.height, 250);
            return dimension;
        }
    }
}

