/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.form.actions.TestAction;
import org.netbeans.modules.form.palette.AlignedList;
import org.netbeans.modules.form.palette.CPComponent;
import org.netbeans.modules.form.palette.CPManager;
import org.netbeans.modules.form.palette.CPManagerInterface;
import org.netbeans.modules.form.palette.CPManagerListener;
import org.netbeans.modules.form.palette.CategoryPopupMenu;
import org.netbeans.modules.form.palette.ItemPopupMenu;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PalettePopupMenu;
import org.openide.awt.MouseUtils;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

public class CPComponentLarge
extends CPComponent {
    protected static CPComponent instance;
    protected JTabbedPane tabbedPane;
    protected ArrayList alignedLists = new ArrayList();
    private Listener listener;
    private Set categories = new HashSet();
    private static String SHOW_NAMES;
    private PaletteListRenderer listRenderer;
    static /* synthetic */ Class class$org$netbeans$modules$form$actions$TestAction;

    private CPComponentLarge(CPManagerInterface cPManagerInterface) {
        super(cPManagerInterface);
        this.createControls();
        this.setStatusLabelSize();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add((Component)this.selectionButton);
        jPanel.add((Component)this.connectionButton);
        jPanel.add(Box.createHorizontalStrut(5));
        TestAction testAction = (TestAction)SystemAction.get((Class)(class$org$netbeans$modules$form$actions$TestAction == null ? (class$org$netbeans$modules$form$actions$TestAction = CPComponentLarge.class$("org.netbeans.modules.form.actions.TestAction")) : class$org$netbeans$modules$form$actions$TestAction));
        jPanel.add(testAction.getToolbarPresenter());
        jPanel.add(Box.createHorizontalStrut(5));
        this.add(jPanel);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setPreferredSize(new Dimension(410, 50));
        this.tabbedPane.getAccessibleContext().setAccessibleName(CPManager.getBundle().getString("ACS_PaletteTabbedPane"));
        this.tabbedPane.getAccessibleContext().setAccessibleDescription(CPManager.getBundle().getString("ACSD_PaletteTabbedPane"));
        this.add(this.tabbedPane);
        this.setLayout(new PaletteLayout(jPanel, this.tabbedPane));
    }

    public void addNotify() {
        super.addNotify();
        if (this.listener == null) {
            this.listener = new Listener();
            this.manager.addPropertyChangeListener(this.listener);
            this.manager.addManagerListener(this.listener);
            this.tabbedPane.addChangeListener(this.listener);
            this.tabbedPane.addMouseListener(this.listener);
        }
        this.fillTabbedPane();
        this.updateShowNames(this.manager.getShowComponentsNames());
    }

    private void fillTabbedPane() {
        this.tabbedPane.removeAll();
        this.alignedLists.clear();
        this.categories.clear();
        Node[] nodeArray = this.manager.getCategoryNodes();
        int n = 0;
        while (n < nodeArray.length) {
            Node node = nodeArray[n];
            this.categories.add(node);
            Component component = this.createPaletteTab(n, node);
            this.tabbedPane.addTab(node.getDisplayName(), null, component);
            ++n;
        }
    }

    private Component createPaletteTab(int n, Node node) {
        CPComponent.t("creating palette tab");
        AlignedList alignedList = this.createCategoryList(node);
        this.alignedLists.add(n, alignedList);
        JScrollPane jScrollPane = new JScrollPane(){

            public void setBorder(Border border) {
            }
        };
        jScrollPane.setViewportView(alignedList);
        return jScrollPane;
    }

    private AlignedList createCategoryList(Node node) {
        AlignedList alignedList = new AlignedList();
        alignedList.setListData(this.manager.getItemNodes(node));
        alignedList.setOpaque(false);
        alignedList.setAlignStyle(0);
        alignedList.setVisibleRowCount(2);
        alignedList.setSelectionMode(0);
        alignedList.addListSelectionListener(this.listener);
        alignedList.addMouseListener(this.listener);
        if (this.listRenderer == null) {
            this.listRenderer = new PaletteListRenderer();
            this.listRenderer.setShowNames(this.manager.getShowComponentsNames());
        }
        alignedList.setCellRenderer(this.listRenderer);
        ToolTipManager.sharedInstance().registerComponent(alignedList);
        alignedList.getAccessibleContext().setAccessibleName(MessageFormat.format(CPManager.getBundle().getString("ACS_PaletteBeansList"), node.getDisplayName()));
        alignedList.getAccessibleContext().setAccessibleDescription(CPManager.getBundle().getString("ACSD_PaletteBeansList"));
        return alignedList;
    }

    private void clearSelection() {
        int n = 0;
        while (n < this.alignedLists.size()) {
            ((AlignedList)this.alignedLists.get(n)).clearSelection();
            ++n;
        }
    }

    protected void updateSelectedItem(PaletteItem paletteItem) {
        super.updateSelectedItem(paletteItem);
        if (paletteItem == null) {
            this.clearSelection();
        } else {
            List<Node> list = Arrays.asList(this.manager.getCategoryNodes());
            int n = list.indexOf(paletteItem.getCategoryNode());
            if (n > -1) {
                this.tabbedPane.removeChangeListener(this.listener);
                this.tabbedPane.setSelectedIndex(n);
                this.tabbedPane.addChangeListener(this.listener);
                ((AlignedList)this.alignedLists.get(n)).setSelectedValue(paletteItem.getItemNode(), true);
            }
        }
    }

    void showMenuOnCategory(Component component, Point point) {
        int n = this.tabbedPane.getSelectedIndex();
        Node[] nodeArray = this.manager.getCategoryNodes();
        if (n < 0 || nodeArray == null || n >= nodeArray.length) {
            return;
        }
        new CategoryPopupMenu(nodeArray[n]).show(component, point.x, point.y);
    }

    void showMenuOnPalette(Component component, Point point) {
        new PalettePopupMenu().show(component, point.x, point.y);
    }

    void showMenuOnItem(Node node, Component component, Point point) {
        ItemPopupMenu itemPopupMenu = new ItemPopupMenu(node);
        ((Container)((Object)itemPopupMenu)).add(new JSeparator());
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(CPManager.getBundle().getString("CTL_ShowNames"));
        jCheckBoxMenuItem.setSelected(this.listRenderer.isShowNames());
        jCheckBoxMenuItem.setActionCommand(SHOW_NAMES);
        jCheckBoxMenuItem.addActionListener(this.listener);
        ((JPopupMenu)((Object)itemPopupMenu)).add(jCheckBoxMenuItem);
        ((JPopupMenu)((Object)itemPopupMenu)).show(component, point.x, point.y);
    }

    public static boolean isCreated() {
        return instance != null;
    }

    public static synchronized JComponent getComponent(CPManagerInterface cPManagerInterface) {
        CPComponent.t("Large: getComponent");
        if (instance == null) {
            instance = new CPComponentLarge(cPManagerInterface);
        }
        return instance;
    }

    private void revalidateLists() {
        int n = 0;
        while (n < this.alignedLists.size()) {
            AlignedList alignedList = (AlignedList)this.alignedLists.get(n);
            alignedList.setSize(0, 0);
            ++n;
        }
        int n2 = this.tabbedPane.getSelectedIndex();
        AlignedList alignedList = (AlignedList)this.alignedLists.get(n2);
        alignedList.revalidate();
        alignedList.repaint();
    }

    private void updateShowNames(boolean bl) {
        if (this.listRenderer != null) {
            this.listRenderer.setShowNames(bl);
            this.revalidateLists();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        SHOW_NAMES = "SHOW_NAMES";
    }

    private static class PaletteLayout
    implements LayoutManager {
        Component buttons;
        Component tabs;

        public PaletteLayout(Component component, Component component2) {
            this.buttons = component;
            this.tabs = component2;
        }

        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Insets insets = container.getInsets();
                int n = insets.top;
                int n2 = container.getHeight() - insets.bottom;
                int n3 = insets.left;
                int n4 = container.getWidth() - insets.right;
                int n5 = n2 - n;
                int n6 = n4 - n3;
                if (this.buttons != null) {
                    Dimension dimension = this.buttons.getPreferredSize();
                    if (dimension.width * n5 >= dimension.height * n6) {
                        this.buttons.setBounds(n3, n, n6, dimension.height);
                        n += dimension.height;
                        n5 -= dimension.height;
                    } else {
                        this.buttons.setBounds(n3, n + 5, dimension.width, n5 - 5);
                        n3 += dimension.width;
                        n6 -= dimension.width;
                    }
                }
                if (this.tabs != null) {
                    this.tabs.setBounds(n3, n, n6, n5);
                }
            }
        }

        public Dimension preferredLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Cloneable cloneable;
                Dimension dimension = new Dimension();
                if (this.buttons != null) {
                    cloneable = this.buttons.getPreferredSize();
                    dimension.width += cloneable.width;
                }
                if (this.tabs != null) {
                    cloneable = this.tabs.getPreferredSize();
                    dimension.width += cloneable.width;
                    dimension.height = cloneable.height;
                }
                cloneable = container.getInsets();
                dimension.width += ((Insets)cloneable).left + ((Insets)cloneable).right;
                dimension.height += ((Insets)cloneable).top + ((Insets)cloneable).bottom;
                Dimension dimension2 = dimension;
                return dimension2;
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    ListSelectionListener,
    ChangeListener,
    PropertyChangeListener,
    CPManagerListener {
        private Listener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JList jList = (JList)listSelectionEvent.getSource();
            int n = jList.getSelectedIndex();
            if (n == -1) {
                if (CPComponentLarge.this.tabbedPane.getSelectedIndex() == CPComponentLarge.this.alignedLists.indexOf(jList)) {
                    CPComponentLarge.this.manager.setSelectedItem(null);
                    CPComponentLarge.this.manager.setMode(0);
                }
            } else if (!listSelectionEvent.getValueIsAdjusting()) {
                Node node = (Node)jList.getModel().getElementAt(n);
                PaletteItem paletteItem = CPManager.createPaletteItem(node);
                CPComponentLarge.this.manager.setSelectedItem(paletteItem);
                CPComponentLarge.this.manager.setMode(2);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!MouseUtils.isRightMouseButton((MouseEvent)mouseEvent)) {
                return;
            }
            if (mouseEvent.getSource() == CPComponentLarge.this.tabbedPane) {
                int n = CPComponentLarge.this.tabbedPane.getSelectedIndex();
                if (n >= 0) {
                    Rectangle rectangle = CPComponentLarge.this.tabbedPane.getBoundsAt(n);
                    Point point = mouseEvent.getPoint();
                    if (point.y < rectangle.y || point.y < rectangle.y + rectangle.height && (point.x < rectangle.x || point.x >= rectangle.x + rectangle.width)) {
                        CPComponentLarge.this.showMenuOnPalette(mouseEvent.getComponent(), point);
                        return;
                    }
                }
                CPComponentLarge.this.showMenuOnCategory(mouseEvent.getComponent(), mouseEvent.getPoint());
            } else if (mouseEvent.getSource() instanceof AlignedList) {
                AlignedList alignedList = (AlignedList)mouseEvent.getSource();
                int n = alignedList.locationToIndex(mouseEvent.getPoint());
                if (n == -1) {
                    CPComponentLarge.this.showMenuOnCategory(mouseEvent.getComponent(), mouseEvent.getPoint());
                } else {
                    CPComponentLarge.this.showMenuOnItem((Node)alignedList.getModel().getElementAt(n), mouseEvent.getComponent(), mouseEvent.getPoint());
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            if (actionEvent.getActionCommand().equals(SHOW_NAMES)) {
                CPComponentLarge.this.listRenderer.setShowNames(jCheckBoxMenuItem.isSelected());
                CPComponentLarge.this.manager.setShowComponentsNames(jCheckBoxMenuItem.isSelected());
            }
            CPComponentLarge.this.revalidateLists();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            CPComponentLarge.this.manager.setSelectedItem(null);
            CPComponentLarge.this.manager.setMode(0);
            int n = CPComponentLarge.this.tabbedPane.getSelectedIndex();
            if (n >= 0) {
                JList jList = (JList)CPComponentLarge.this.alignedLists.get(n);
                jList.setListData(CPComponentLarge.this.manager.getItemNodes(CPComponentLarge.this.manager.getCategoryNodes()[n]));
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("showComponentsNames".equals(propertyChangeEvent.getPropertyName())) {
                CPComponentLarge.this.updateShowNames((Boolean)propertyChangeEvent.getNewValue());
            }
        }

        public void categoriesAdded(Node[] nodeArray, int[] nArray) {
            CPComponentLarge.this.manager.setSelectedItem(null);
            CPComponentLarge.this.manager.setMode(0);
            int n = 0;
            while (n < nodeArray.length) {
                Node node = nodeArray[n];
                if (!CPComponentLarge.this.categories.contains(node)) {
                    int n2 = nArray[n];
                    if (n2 > CPComponentLarge.this.tabbedPane.getTabCount()) {
                        n2 = CPComponentLarge.this.tabbedPane.getTabCount();
                    }
                    Component component = CPComponentLarge.this.createPaletteTab(n2, node);
                    CPComponentLarge.this.tabbedPane.insertTab(node.getDisplayName(), null, component, null, n2);
                }
                ++n;
            }
            CPComponentLarge.this.revalidate();
            CPComponentLarge.this.repaint();
        }

        public void categoriesRemoved(Node[] nodeArray, int[] nArray) {
            CPComponentLarge.this.manager.setSelectedItem(null);
            CPComponentLarge.this.manager.setMode(0);
            int n = nodeArray.length - 1;
            while (n >= 0) {
                int n2 = nArray[n];
                CPComponentLarge.this.tabbedPane.removeTabAt(n2);
                CPComponentLarge.this.alignedLists.remove(n2);
                CPComponentLarge.this.categories.remove(nodeArray[n]);
                --n;
            }
            CPComponentLarge.this.revalidate();
            CPComponentLarge.this.repaint();
        }

        public void categoriesReordered() {
            CPComponentLarge.this.manager.setSelectedItem(null);
            CPComponentLarge.this.manager.setMode(0);
            int n = CPComponentLarge.this.tabbedPane.getSelectedIndex();
            String string = n >= 0 ? CPComponentLarge.this.tabbedPane.getTitleAt(n) : null;
            CPComponentLarge.this.fillTabbedPane();
            if (string != null) {
                int n2 = 0;
                int n3 = CPComponentLarge.this.tabbedPane.getTabCount();
                while (n2 < n3) {
                    if (string.equals(CPComponentLarge.this.tabbedPane.getTitleAt(n2))) {
                        CPComponentLarge.this.tabbedPane.setSelectedIndex(n2);
                        break;
                    }
                    ++n2;
                }
            }
            CPComponentLarge.this.tabbedPane.revalidate();
            CPComponentLarge.this.tabbedPane.repaint();
        }

        public void categoryChanged(Node node) {
            Node[] nodeArray = CPComponentLarge.this.manager.getCategoryNodes();
            int n = 0;
            while (n < nodeArray.length) {
                if (node == nodeArray[n]) {
                    CPComponentLarge.this.manager.setSelectedItem(null);
                    CPComponentLarge.this.manager.setMode(0);
                    CPComponentLarge.this.tabbedPane.setTitleAt(n, node.getDisplayName());
                    JList jList = (JList)CPComponentLarge.this.alignedLists.get(n);
                    jList.setListData(CPComponentLarge.this.manager.getItemNodes(node));
                    CPComponentLarge.this.tabbedPane.revalidate();
                    CPComponentLarge.this.tabbedPane.repaint();
                    break;
                }
                ++n;
            }
        }
    }

    private static class PaletteListRenderer
    implements ListCellRenderer {
        private JToggleButton button = new JToggleButton();
        private Border buttonBorder;
        private Border emptyBorder;
        private int iconSize;
        private boolean showNames = false;

        public PaletteListRenderer() {
            this.button.setMargin(new Insets(1, 1, 1, 1));
            this.buttonBorder = this.button.getBorder();
            if (this.buttonBorder != null) {
                this.emptyBorder = new EmptyBorder(this.buttonBorder.getBorderInsets(this.button));
            }
            this.setIconSize(1);
            this.setShowNames(false);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl || n == ((AlignedList)jList).getRolloverIndex()) {
                this.button.setBorder(this.buttonBorder);
            } else {
                this.button.setBorder(this.emptyBorder);
            }
            Node node = (Node)object;
            if (this.showNames) {
                this.button.setText(node.getDisplayName());
            }
            this.button.setIcon(new ImageIcon(node.getIcon(this.iconSize)));
            this.button.setSelected(bl);
            this.button.setToolTipText(node.getShortDescription().replace('-', '.'));
            return this.button;
        }

        public void setIconSize(int n) {
            if (n == 1) {
                this.button.setHorizontalAlignment(this.isShowNames() ? 2 : 0);
                this.button.setVerticalTextPosition(0);
                this.button.setHorizontalTextPosition(4);
            } else {
                this.button.setHorizontalAlignment(0);
                this.button.setVerticalTextPosition(3);
                this.button.setHorizontalTextPosition(0);
            }
            this.iconSize = n;
        }

        public int getIconSize() {
            return this.iconSize;
        }

        public void setShowNames(boolean bl) {
            if (!bl) {
                this.button.setText(null);
            }
            this.showNames = bl;
            this.setIconSize(this.getIconSize());
        }

        public boolean isShowNames() {
            return this.showNames;
        }
    }
}

