/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.beans.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.xml.tax.beans.customizer.AbstractTreeCustomizer;
import org.netbeans.modules.xml.tax.beans.customizer.Util;
import org.netbeans.modules.xml.tax.beans.editor.EncodingEditor;
import org.netbeans.modules.xml.tax.beans.editor.StandaloneEditor;
import org.netbeans.modules.xml.tax.beans.editor.VersionEditor;
import org.netbeans.modules.xml.tax.util.TAXUtil;
import org.netbeans.tax.TreeDocument;
import org.netbeans.tax.TreeException;

public class TreeDocumentCustomizer
extends AbstractTreeCustomizer {
    private static final long serialVersionUID = 8592875472261625357L;
    private JLabel standaloneLabel;
    private JComboBox cbVersion;
    private JLabel versionLabel;
    private JComboBox cbEncoding;
    private JComboBox cbStandalone;
    private JLabel encodingLabel;
    private JPanel fillPanel;

    public TreeDocumentCustomizer() {
        this.initComponents();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeDocumentCustomizer::init");
        }
        this.versionLabel.setDisplayedMnemonic(Util.THIS.getChar("MNE_document_version"));
        this.encodingLabel.setDisplayedMnemonic(Util.THIS.getChar("MNE_document_encoding"));
        this.standaloneLabel.setDisplayedMnemonic(Util.THIS.getChar("MNE_document_standalone"));
        this.initAccessibility();
    }

    protected final TreeDocument getDocument() {
        return (TreeDocument)this.getTreeObject();
    }

    protected final void safePropertyChange(PropertyChangeEvent pche) {
        super.safePropertyChange(pche);
        if (pche.getPropertyName().equals("version")) {
            this.updateVersionComponent();
        } else if (pche.getPropertyName().equals("encoding")) {
            this.updateEncodingComponent();
        } else if (pche.getPropertyName().equals("standalone")) {
            this.updateStandaloneComponent();
        }
    }

    protected final void updateDocumentVersion() {
        if (this.cbVersion.getSelectedItem() == null) {
            return;
        }
        try {
            this.getDocument().setVersion(AbstractTreeCustomizer.text2null((String)this.cbVersion.getSelectedItem()));
        }
        catch (TreeException exc) {
            this.updateVersionComponent();
            TAXUtil.notifyTreeException(exc);
        }
    }

    protected final void updateVersionComponent() {
        this.cbVersion.setSelectedItem(AbstractTreeCustomizer.null2text(this.getDocument().getVersion()));
    }

    protected final void updateDocumentEncoding() {
        if (this.cbEncoding.getSelectedItem() == null) {
            return;
        }
        try {
            this.getDocument().setEncoding(AbstractTreeCustomizer.text2null((String)this.cbEncoding.getSelectedItem()));
        }
        catch (TreeException exc) {
            this.updateEncodingComponent();
            TAXUtil.notifyTreeException(exc);
        }
    }

    protected final void updateEncodingComponent() {
        this.cbEncoding.setSelectedItem(AbstractTreeCustomizer.null2text(this.getDocument().getEncoding()));
    }

    protected final void updateDocumentStandalone() {
        if (this.cbStandalone.getSelectedItem() == null) {
            return;
        }
        try {
            this.getDocument().setStandalone(AbstractTreeCustomizer.text2null((String)this.cbStandalone.getSelectedItem()));
        }
        catch (TreeException exc) {
            this.updateStandaloneComponent();
            TAXUtil.notifyTreeException(exc);
        }
    }

    protected final void updateStandaloneComponent() {
        this.cbStandalone.setSelectedItem(AbstractTreeCustomizer.null2text(this.getDocument().getStandalone()));
    }

    protected final void initComponentValues() {
        this.updateVersionComponent();
        this.updateEncodingComponent();
        this.updateStandaloneComponent();
    }

    protected final void updateReadOnlyStatus(boolean editable) {
        this.cbVersion.setEnabled(editable);
        this.cbEncoding.setEnabled(editable);
        this.cbStandalone.setEnabled(editable);
    }

    private void initComponents() {
        this.versionLabel = new JLabel();
        this.cbVersion = new JComboBox();
        this.encodingLabel = new JLabel();
        this.cbEncoding = new JComboBox();
        this.standaloneLabel = new JLabel();
        this.cbStandalone = new JComboBox();
        this.fillPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.versionLabel.setText(Util.THIS.getString("PROP_document_version"));
        this.versionLabel.setLabelFor(this.cbVersion);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.versionLabel, gridBagConstraints);
        this.cbVersion.setModel(new DefaultComboBoxModel<String>(VersionEditor.getItems()));
        this.cbVersion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeDocumentCustomizer.this.cbVersionActionPerformed(evt);
            }
        });
        this.cbVersion.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                TreeDocumentCustomizer.this.cbVersionFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.cbVersion, gridBagConstraints);
        this.encodingLabel.setText(Util.THIS.getString("PROP_document_encoding"));
        this.encodingLabel.setLabelFor(this.cbEncoding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.encodingLabel, gridBagConstraints);
        this.cbEncoding.setModel(new DefaultComboBoxModel<String>(EncodingEditor.getItems()));
        this.cbEncoding.setEditable(true);
        this.cbEncoding.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeDocumentCustomizer.this.cbEncodingActionPerformed(evt);
            }
        });
        this.cbEncoding.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                TreeDocumentCustomizer.this.cbEncodingFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        gridBagConstraints.anchor = 11;
        this.add((Component)this.cbEncoding, gridBagConstraints);
        this.standaloneLabel.setText(Util.THIS.getString("PROP_document_standalone"));
        this.standaloneLabel.setLabelFor(this.cbStandalone);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.standaloneLabel, gridBagConstraints);
        this.cbStandalone.setModel(new DefaultComboBoxModel<String>(StandaloneEditor.getItems()));
        this.cbStandalone.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeDocumentCustomizer.this.cbStandaloneActionPerformed(evt);
            }
        });
        this.cbStandalone.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                TreeDocumentCustomizer.this.cbStandaloneFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        gridBagConstraints.anchor = 11;
        this.add((Component)this.cbStandalone, gridBagConstraints);
        this.fillPanel.setPreferredSize(new Dimension(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fillPanel, gridBagConstraints);
    }

    private void cbStandaloneFocusLost(FocusEvent evt) {
        this.updateDocumentStandalone();
    }

    private void cbStandaloneActionPerformed(ActionEvent evt) {
        this.updateDocumentStandalone();
    }

    private void cbEncodingFocusLost(FocusEvent evt) {
        this.updateDocumentEncoding();
    }

    private void cbEncodingActionPerformed(ActionEvent evt) {
        this.updateDocumentEncoding();
    }

    private void cbVersionFocusLost(FocusEvent evt) {
        this.updateDocumentVersion();
    }

    private void cbVersionActionPerformed(ActionEvent evt) {
        this.updateDocumentVersion();
    }

    public void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_TreeDocumentCustomizer"));
        this.cbVersion.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_cbVersion"));
        this.cbEncoding.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_cbEncoding1"));
        this.cbStandalone.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_cbStandalone"));
    }
}

