/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.beans.customizer;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.modules.xml.tax.beans.customizer.AbstractTreeCustomizer;
import org.netbeans.modules.xml.tax.beans.customizer.Util;
import org.netbeans.modules.xml.tax.util.TAXUtil;
import org.netbeans.tax.TreeEntityDecl;
import org.netbeans.tax.TreeException;

public class TreeEntityDeclCustomizer
extends AbstractTreeCustomizer {
    private static final long serialVersionUID = -4905667144375255810L;
    private static final String TYPE_GENERAL = "General";
    private static final String TYPE_PARAMETER = "Parameter";
    private static final String[] typeItems = new String[]{"General", "Parameter"};
    private JTextField unparsedSystemField;
    private JLabel nameLabel;
    private JLabel externSystemLabel;
    private JRadioButton internalRadio;
    private JTextField nameField;
    private JTextField externSystemField;
    private JLabel typeLabel;
    private JPanel internalPanel;
    private JLabel unparsedPublicLabel;
    private JLabel internValueLabel;
    private JTextField unparsedPublicField;
    private JLabel externPublicLabel;
    private JRadioButton unparsedRadio;
    private JTextField internValueField;
    private JTextField externPublicField;
    private JPanel entityTypePanel;
    private JLabel unparsedNotationLabel;
    private JPanel unparsedPanel;
    private JRadioButton externalRadio;
    private ButtonGroup buttonGroup;
    private JTextField unparsedNotationField;
    private JPanel typeCardPanel;
    private JLabel unparsedSystemLabel;
    private JPanel externalPanel;
    private JComboBox typeCombo;

    public TreeEntityDeclCustomizer() {
        this.initComponents();
        this.nameLabel.setDisplayedMnemonic(Util.THIS.getChar("LAB_ElementName_mn"));
        this.typeLabel.setDisplayedMnemonic(Util.THIS.getChar("LAB_EntityType_mn"));
        this.internalRadio.setMnemonic(Util.THIS.getChar("RAD_Internal_mn"));
        this.externalRadio.setMnemonic(Util.THIS.getChar("RAD_External_mn"));
        this.unparsedRadio.setMnemonic(Util.THIS.getChar("RAD_Unparsed_mn"));
        this.internValueLabel.setDisplayedMnemonic(Util.THIS.getChar("LAB_internValue_mn"));
        this.externPublicLabel.setDisplayedMnemonic(Util.THIS.getChar("LAB_externPublic_mn"));
        this.externSystemLabel.setDisplayedMnemonic(Util.THIS.getChar("LAB_externSystem_mn"));
        this.unparsedPublicLabel.setDisplayedMnemonic(Util.THIS.getChar("LAB_unparsedPublic_mn"));
        this.unparsedSystemLabel.setDisplayedMnemonic(Util.THIS.getChar("LAB_unparsedSystem_mn"));
        this.unparsedNotationLabel.setDisplayedMnemonic(Util.THIS.getChar("LAB_unparsedNotation_mn"));
        this.initAccessibility();
    }

    protected final TreeEntityDecl getEntityDecl() {
        return (TreeEntityDecl)this.getTreeObject();
    }

    protected void safePropertyChange(PropertyChangeEvent pche) {
        super.safePropertyChange(pche);
        if (pche.getPropertyName().equals("parameter")) {
            this.updateParameterComponent();
        } else if (pche.getPropertyName().equals("name")) {
            this.updateNameComponent();
        } else if (pche.getPropertyName().equals("internalText")) {
            this.updateInternalTextComponent();
        } else if (pche.getPropertyName().equals("publicId")) {
            this.updatePublicIdComponent();
        } else if (pche.getPropertyName().equals("systemId")) {
            this.updateSystemIdComponent();
        } else if (pche.getPropertyName().equals("notationName")) {
            this.updateNotationComponent();
        } else if (pche.getPropertyName().equals("type")) {
            this.updateTypeComponent();
        }
    }

    protected final void updateEntityDeclParameter() {
        if (this.typeCombo.getSelectedItem() == null) {
            return;
        }
        try {
            this.getEntityDecl().setParameter(this.typeCombo.getSelectedItem() == TYPE_PARAMETER);
        }
        catch (TreeException exc) {
            this.updateParameterComponent();
            TAXUtil.notifyTreeException(exc);
        }
    }

    protected final void updateParameterComponent() {
        if (this.getEntityDecl().isParameter()) {
            this.typeCombo.setSelectedItem(TYPE_PARAMETER);
        } else {
            this.typeCombo.setSelectedItem(TYPE_GENERAL);
        }
    }

    protected final void updateEntityDeclName() {
        try {
            this.getEntityDecl().setName(this.nameField.getText());
        }
        catch (TreeException exc) {
            this.updateNameComponent();
            TAXUtil.notifyTreeException(exc);
        }
    }

    protected final void updateNameComponent() {
        this.nameField.setText(this.getEntityDecl().getName());
    }

    protected final void updateEntityDeclInternalText() {
        try {
            this.getEntityDecl().setInternalText(AbstractTreeCustomizer.text2null(this.internValueField.getText()));
        }
        catch (TreeException exc) {
            this.updateInternalTextComponent();
            TAXUtil.notifyTreeException(exc);
        }
    }

    protected final void updateInternalTextComponent() {
        this.internValueField.setText(AbstractTreeCustomizer.null2text(this.getEntityDecl().getInternalText()));
    }

    protected final void updateEntityDeclPublicId() {
        try {
            if (this.externalRadio.isSelected()) {
                this.getEntityDecl().setPublicId(AbstractTreeCustomizer.text2null(this.externPublicField.getText()));
            } else if (this.unparsedRadio.isSelected()) {
                this.getEntityDecl().setPublicId(AbstractTreeCustomizer.text2null(this.unparsedPublicField.getText()));
            }
        }
        catch (TreeException exc) {
            this.updatePublicIdComponent();
            TAXUtil.notifyTreeException(exc);
        }
    }

    protected final void updatePublicIdComponent() {
        this.externPublicField.setText(AbstractTreeCustomizer.null2text(this.getEntityDecl().getPublicId()));
        this.unparsedPublicField.setText(AbstractTreeCustomizer.null2text(this.getEntityDecl().getPublicId()));
    }

    protected final void updateEntityDeclSystemId() {
        try {
            if (this.externalRadio.isSelected()) {
                this.getEntityDecl().setSystemId(AbstractTreeCustomizer.text2null(this.externSystemField.getText()));
            } else if (this.unparsedRadio.isSelected()) {
                this.getEntityDecl().setSystemId(AbstractTreeCustomizer.text2null(this.unparsedSystemField.getText()));
            }
        }
        catch (TreeException exc) {
            this.updateSystemIdComponent();
            TAXUtil.notifyTreeException(exc);
        }
    }

    protected final void updateSystemIdComponent() {
        this.externSystemField.setText(AbstractTreeCustomizer.null2text(this.getEntityDecl().getSystemId()));
        this.unparsedSystemField.setText(AbstractTreeCustomizer.null2text(this.getEntityDecl().getSystemId()));
    }

    protected final void updateEntityDeclNotationName() {
        try {
            this.getEntityDecl().setNotationName(AbstractTreeCustomizer.text2null(this.unparsedNotationField.getText()));
        }
        catch (TreeException exc) {
            this.updateNotationComponent();
            TAXUtil.notifyTreeException(exc);
        }
    }

    protected final void updateNotationComponent() {
        this.unparsedNotationField.setText(AbstractTreeCustomizer.null2text(this.getEntityDecl().getNotationName()));
    }

    protected final void updateTypeComponent() {
        CardLayout cl = (CardLayout)this.typeCardPanel.getLayout();
        if (this.getEntityDecl().getType() == 1) {
            this.internalRadio.setSelected(true);
            cl.show(this.typeCardPanel, "internalPanel");
        } else if (this.getEntityDecl().getType() == 2) {
            this.externalRadio.setSelected(true);
            cl.show(this.typeCardPanel, "externalPanel");
        } else {
            this.unparsedRadio.setSelected(true);
            cl.show(this.typeCardPanel, "unparsedPanel");
        }
    }

    protected final void initComponentValues() {
        this.updateParameterComponent();
        this.updateNameComponent();
        this.updateInternalTextComponent();
        this.updatePublicIdComponent();
        this.updateSystemIdComponent();
        this.updateNotationComponent();
        this.updateTypeComponent();
    }

    protected void updateReadOnlyStatus(boolean editable) {
        this.nameField.setEditable(editable);
        this.typeCombo.setEnabled(editable);
        this.internalRadio.setEnabled(editable);
        this.externalRadio.setEnabled(editable);
        this.unparsedRadio.setEnabled(editable);
        this.internValueField.setEditable(editable);
        this.externPublicField.setEditable(editable);
        this.externSystemField.setEditable(editable);
        this.unparsedPublicField.setEditable(editable);
        this.unparsedSystemField.setEditable(editable);
        this.unparsedNotationField.setEditable(editable);
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.typeLabel = new JLabel();
        this.typeCombo = new JComboBox<String>(typeItems);
        this.entityTypePanel = new JPanel();
        this.internalRadio = new JRadioButton();
        this.externalRadio = new JRadioButton();
        this.unparsedRadio = new JRadioButton();
        this.typeCardPanel = new JPanel();
        this.internalPanel = new JPanel();
        this.internValueLabel = new JLabel();
        this.internValueField = new JTextField();
        this.externalPanel = new JPanel();
        this.externPublicLabel = new JLabel();
        this.externPublicField = new JTextField();
        this.externSystemLabel = new JLabel();
        this.externSystemField = new JTextField();
        this.unparsedPanel = new JPanel();
        this.unparsedPublicLabel = new JLabel();
        this.unparsedPublicField = new JTextField();
        this.unparsedSystemLabel = new JLabel();
        this.unparsedSystemField = new JTextField();
        this.unparsedNotationLabel = new JLabel();
        this.unparsedNotationField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.nameLabel.setText(Util.THIS.getString("LAB_ElementName"));
        this.nameLabel.setLabelFor(this.nameField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.nameField.setColumns(20);
        this.nameField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeEntityDeclCustomizer.this.nameFieldActionPerformed(evt);
            }
        });
        this.nameField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                TreeEntityDeclCustomizer.this.nameFieldFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                TreeEntityDeclCustomizer.this.nameFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.nameField, gridBagConstraints);
        this.typeLabel.setText(Util.THIS.getString("LAB_EntityType"));
        this.typeLabel.setLabelFor(this.typeCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.typeLabel, gridBagConstraints);
        this.typeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeEntityDeclCustomizer.this.typeComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.typeCombo, gridBagConstraints);
        this.entityTypePanel.setLayout(new GridBagLayout());
        this.entityTypePanel.setBorder(new TitledBorder(new EmptyBorder(new Insets(0, 0, 0, 0))));
        this.internalRadio.setSelected(true);
        this.internalRadio.setText(Util.THIS.getString("RAD_Internal"));
        this.buttonGroup.add(this.internalRadio);
        this.internalRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeEntityDeclCustomizer.this.internalRadioActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.entityTypePanel.add((Component)this.internalRadio, gridBagConstraints);
        this.externalRadio.setText(Util.THIS.getString("RAD_External"));
        this.buttonGroup.add(this.externalRadio);
        this.externalRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeEntityDeclCustomizer.this.externalRadioActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.entityTypePanel.add((Component)this.externalRadio, gridBagConstraints);
        this.unparsedRadio.setText(Util.THIS.getString("RAD_Unparsed"));
        this.buttonGroup.add(this.unparsedRadio);
        this.unparsedRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeEntityDeclCustomizer.this.unparsedRadioActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.entityTypePanel.add((Component)this.unparsedRadio, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.entityTypePanel, gridBagConstraints);
        this.typeCardPanel.setLayout(new CardLayout());
        this.internalPanel.setLayout(new GridBagLayout());
        this.internValueLabel.setText(Util.THIS.getString("LAB_Internal_Text"));
        this.internValueLabel.setLabelFor(this.internValueField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.internalPanel.add((Component)this.internValueLabel, gridBagConstraints);
        this.internValueField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeEntityDeclCustomizer.this.internValueFieldActionPerformed(evt);
            }
        });
        this.internValueField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                TreeEntityDeclCustomizer.this.internValueFieldFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                TreeEntityDeclCustomizer.this.internValueFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.internalPanel.add((Component)this.internValueField, gridBagConstraints);
        this.typeCardPanel.add((Component)this.internalPanel, "internalPanel");
        this.externalPanel.setLayout(new GridBagLayout());
        this.externPublicLabel.setText(Util.THIS.getString("LAB_External_PublicId"));
        this.externPublicLabel.setLabelFor(this.externPublicField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.externalPanel.add((Component)this.externPublicLabel, gridBagConstraints);
        this.externPublicField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeEntityDeclCustomizer.this.externPublicFieldActionPerformed(evt);
            }
        });
        this.externPublicField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                TreeEntityDeclCustomizer.this.externPublicFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.externalPanel.add((Component)this.externPublicField, gridBagConstraints);
        this.externSystemLabel.setText(Util.THIS.getString("LAB_External_SystemId"));
        this.externSystemLabel.setLabelFor(this.externSystemField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.externalPanel.add((Component)this.externSystemLabel, gridBagConstraints);
        this.externSystemField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeEntityDeclCustomizer.this.externSystemFieldActionPerformed(evt);
            }
        });
        this.externSystemField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                TreeEntityDeclCustomizer.this.externSystemFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.externalPanel.add((Component)this.externSystemField, gridBagConstraints);
        this.typeCardPanel.add((Component)this.externalPanel, "externalPanel");
        this.unparsedPanel.setLayout(new GridBagLayout());
        this.unparsedPublicLabel.setText(Util.THIS.getString("LAB_Unparsed_PublicId"));
        this.unparsedPublicLabel.setLabelFor(this.unparsedPublicField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.unparsedPanel.add((Component)this.unparsedPublicLabel, gridBagConstraints);
        this.unparsedPublicField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeEntityDeclCustomizer.this.unparsedPublicFieldActionPerformed(evt);
            }
        });
        this.unparsedPublicField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                TreeEntityDeclCustomizer.this.unparsedPublicFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.unparsedPanel.add((Component)this.unparsedPublicField, gridBagConstraints);
        this.unparsedSystemLabel.setText(Util.THIS.getString("LAB_Unparsed_SystemId"));
        this.unparsedSystemLabel.setLabelFor(this.unparsedSystemField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.unparsedPanel.add((Component)this.unparsedSystemLabel, gridBagConstraints);
        this.unparsedSystemField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeEntityDeclCustomizer.this.unparsedSystemFieldActionPerformed(evt);
            }
        });
        this.unparsedSystemField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                TreeEntityDeclCustomizer.this.unparsedSystemFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.unparsedPanel.add((Component)this.unparsedSystemField, gridBagConstraints);
        this.unparsedNotationLabel.setText(Util.THIS.getString("LAB_Unparsed_NotationName"));
        this.unparsedNotationLabel.setLabelFor(this.unparsedNotationField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.unparsedPanel.add((Component)this.unparsedNotationLabel, gridBagConstraints);
        this.unparsedNotationField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeEntityDeclCustomizer.this.unparsedNotationFieldActionPerformed(evt);
            }
        });
        this.unparsedNotationField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                TreeEntityDeclCustomizer.this.unparsedNotationFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.unparsedPanel.add((Component)this.unparsedNotationField, gridBagConstraints);
        this.typeCardPanel.add((Component)this.unparsedPanel, "unparsedPanel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.typeCardPanel, gridBagConstraints);
    }

    private void internValueFieldFocusGained(FocusEvent evt) {
        this.internValueField.selectAll();
    }

    private void nameFieldFocusGained(FocusEvent evt) {
        this.nameField.selectAll();
    }

    private void unparsedNotationFieldFocusLost(FocusEvent evt) {
        this.updateEntityDeclNotationName();
    }

    private void unparsedNotationFieldActionPerformed(ActionEvent evt) {
        this.updateEntityDeclNotationName();
    }

    private void unparsedSystemFieldFocusLost(FocusEvent evt) {
        this.updateEntityDeclSystemId();
    }

    private void unparsedSystemFieldActionPerformed(ActionEvent evt) {
        this.updateEntityDeclSystemId();
    }

    private void unparsedPublicFieldFocusLost(FocusEvent evt) {
        this.updateEntityDeclPublicId();
    }

    private void unparsedPublicFieldActionPerformed(ActionEvent evt) {
        this.updateEntityDeclPublicId();
    }

    private void externSystemFieldFocusLost(FocusEvent evt) {
        this.updateEntityDeclSystemId();
    }

    private void externSystemFieldActionPerformed(ActionEvent evt) {
        this.updateEntityDeclSystemId();
    }

    private void externPublicFieldActionPerformed(ActionEvent evt) {
        this.updateEntityDeclPublicId();
    }

    private void externPublicFieldFocusLost(FocusEvent evt) {
        this.updateEntityDeclPublicId();
    }

    private void internValueFieldFocusLost(FocusEvent evt) {
        this.updateEntityDeclInternalText();
    }

    private void internValueFieldActionPerformed(ActionEvent evt) {
        this.updateEntityDeclInternalText();
    }

    private void nameFieldFocusLost(FocusEvent evt) {
        this.updateEntityDeclName();
    }

    private void nameFieldActionPerformed(ActionEvent evt) {
        this.updateEntityDeclName();
    }

    private void unparsedRadioActionPerformed(ActionEvent evt) {
        CardLayout cl = (CardLayout)this.typeCardPanel.getLayout();
        cl.show(this.typeCardPanel, "unparsedPanel");
    }

    private void externalRadioActionPerformed(ActionEvent evt) {
        CardLayout cl = (CardLayout)this.typeCardPanel.getLayout();
        cl.show(this.typeCardPanel, "externalPanel");
    }

    private void internalRadioActionPerformed(ActionEvent evt) {
        CardLayout cl = (CardLayout)this.typeCardPanel.getLayout();
        cl.show(this.typeCardPanel, "internalPanel");
    }

    private void typeComboActionPerformed(ActionEvent evt) {
        this.unparsedRadio.setEnabled(this.typeCombo.getSelectedIndex() != 1);
        if (this.unparsedRadio.isSelected()) {
            this.internalRadio.setSelected(true);
            this.internalRadioActionPerformed(evt);
        }
        this.updateEntityDeclParameter();
    }

    public void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_TreeEntityDeclCustomizer"));
        this.nameField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_nameField2"));
        this.typeCombo.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_typeCombo"));
        this.internValueField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_internValueField"));
        this.internValueField.selectAll();
        this.externPublicField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_externPublicField"));
        this.externSystemField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_externSystemField"));
        this.unparsedPublicField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_unparsedPublicField"));
        this.unparsedSystemField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_unparsedSystemField"));
        this.unparsedNotationField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_unparsedNotationField"));
    }
}

