/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.beans.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.xml.tax.beans.editor.Util;
import org.netbeans.modules.xml.tax.util.TAXUtil;
import org.netbeans.tax.traversal.TreeNodeFilter;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.HelpCtx;

public class TreeNodeFilterCustomEditor
extends JPanel
implements EnhancedCustomPropertyEditor {
    private static final long serialVersionUID = 1767193347881681541L;
    private static final Map publicNodeTypeNamesMap = new HashMap();
    private final TreeNodeFilter filter;
    private final List nodeTypesList;
    private NodeTypesTableModel tableModel;
    private JRadioButton rejectRadioButton;
    private JPanel rbPanel;
    private JPanel acceptPolicyPanel;
    private JButton addButton;
    private JLabel acceptRejectLabel;
    private JScrollPane tableScrollPane;
    private JTable nodeTypesTable;
    private JRadioButton acceptRadioButton;
    private JPanel tablePanel;
    private ButtonGroup acceptPolicyGroup;
    private JButton removeButton;
    private static Vector publicNodeTypesInheritanceTree;
    static /* synthetic */ Class class$org$netbeans$tax$TreeNode;
    static /* synthetic */ Class class$org$netbeans$tax$TreeParentNode;
    static /* synthetic */ Class class$org$netbeans$tax$TreeCharacterData;
    static /* synthetic */ Class class$org$netbeans$tax$TreeReference;
    static /* synthetic */ Class class$org$netbeans$tax$TreeNodeDecl;
    static /* synthetic */ Class class$org$netbeans$tax$TreeComment;
    static /* synthetic */ Class class$org$netbeans$tax$TreeProcessingInstruction;
    static /* synthetic */ Class class$org$netbeans$tax$TreeText;
    static /* synthetic */ Class class$org$netbeans$tax$TreeCDATASection;
    static /* synthetic */ Class class$org$netbeans$tax$TreeElement;
    static /* synthetic */ Class class$org$netbeans$tax$TreeAttribute;
    static /* synthetic */ Class class$org$netbeans$tax$TreeConditionalSection;
    static /* synthetic */ Class class$org$netbeans$tax$TreeDocumentType;
    static /* synthetic */ Class class$org$netbeans$tax$TreeGeneralEntityReference;
    static /* synthetic */ Class class$org$netbeans$tax$TreeParameterEntityReference;
    static /* synthetic */ Class class$org$netbeans$tax$TreeElementDecl;
    static /* synthetic */ Class class$org$netbeans$tax$TreeEntityDecl;
    static /* synthetic */ Class class$org$netbeans$tax$TreeAttlistDecl;
    static /* synthetic */ Class class$org$netbeans$tax$TreeNotationDecl;

    public TreeNodeFilterCustomEditor(TreeNodeFilter filter) {
        this.filter = filter;
        this.nodeTypesList = new LinkedList<Class>(Arrays.asList(filter.getNodeTypes()));
        this.initComponents();
        this.ownInitComponents();
        this.initAccessibility();
        HelpCtx.setHelpIDString((JComponent)this, (String)this.getClass().getName());
    }

    private void ownInitComponents() {
        this.tableModel = (NodeTypesTableModel)this.nodeTypesTable.getModel();
        ListSelectionModel selModel = this.nodeTypesTable.getSelectionModel();
        selModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    TreeNodeFilterCustomEditor.this.removeButton.setEnabled(false);
                } else {
                    TreeNodeFilterCustomEditor.this.removeButton.setEnabled(true);
                }
            }
        });
        JComboBox cb = new JComboBox(TreeNodeFilterCustomEditor.getPublicNodeTypesInheritanceTree());
        cb.setEditable(false);
        DefaultCellEditor dce = new DefaultCellEditor(cb);
        this.nodeTypesTable.getColumnModel().getColumn(0).setCellEditor(dce);
    }

    public Object getPropertyValue() throws IllegalStateException {
        short acceptPolicy = this.acceptRadioButton.isSelected() ? (short)10 : 11;
        Class[] nodeTypes = this.nodeTypesList.toArray(new Class[0]);
        return new TreeNodeFilter(nodeTypes, acceptPolicy);
    }

    private void initComponents() {
        this.acceptPolicyGroup = new ButtonGroup();
        this.acceptPolicyPanel = new JPanel();
        this.acceptRejectLabel = new JLabel();
        this.rbPanel = new JPanel();
        this.acceptRadioButton = new JRadioButton();
        this.acceptRadioButton.setSelected(this.filter.getAcceptPolicy() == 10);
        this.rejectRadioButton = new JRadioButton();
        this.rejectRadioButton.setSelected(this.filter.getAcceptPolicy() == 11);
        this.tablePanel = new JPanel();
        this.tableScrollPane = new JScrollPane();
        this.nodeTypesTable = new JTable();
        this.nodeTypesTable.setSelectionMode(0);
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new BorderLayout());
        this.acceptPolicyPanel.setLayout(new GridBagLayout());
        this.acceptRejectLabel.setText(Util.THIS.getString("LBL_acceptReject"));
        this.acceptRejectLabel.setLabelFor(this.rbPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.acceptPolicyPanel.add((Component)this.acceptRejectLabel, gridBagConstraints);
        this.rbPanel.setLayout(new GridBagLayout());
        this.acceptRadioButton.setText(Util.THIS.getString("LBL_showItRadioButton"));
        this.acceptPolicyGroup.add(this.acceptRadioButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.rbPanel.add((Component)this.acceptRadioButton, gridBagConstraints);
        this.rejectRadioButton.setText(Util.THIS.getString("LBL_hideItRadioButton"));
        this.acceptPolicyGroup.add(this.rejectRadioButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.rbPanel.add((Component)this.rejectRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 11);
        this.acceptPolicyPanel.add((Component)this.rbPanel, gridBagConstraints);
        this.add((Component)this.acceptPolicyPanel, "North");
        this.tablePanel.setLayout(new GridBagLayout());
        this.nodeTypesTable.setModel(new NodeTypesTableModel());
        this.nodeTypesTable.setPreferredScrollableViewportSize(new Dimension(300, 200));
        this.tableScrollPane.setViewportView(this.nodeTypesTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.tablePanel.add((Component)this.tableScrollPane, gridBagConstraints);
        this.addButton.setText(Util.THIS.getString("LBL_addButton"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeNodeFilterCustomEditor.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.tablePanel.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setText(Util.THIS.getString("LBL_removeButton"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeNodeFilterCustomEditor.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 11, 11, 11);
        this.tablePanel.add((Component)this.removeButton, gridBagConstraints);
        this.add((Component)this.tablePanel, "Center");
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int sel = this.nodeTypesTable.getSelectedRow();
        if (sel != -1) {
            this.tableModel.removeRow(sel);
            int numRows = this.nodeTypesTable.getModel().getRowCount();
            if (numRows > 0) {
                sel = Math.min(sel, numRows - 1);
                this.nodeTypesTable.getSelectionModel().setSelectionInterval(sel, sel);
            }
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.nodeTypesList.add(class$org$netbeans$tax$TreeNode == null ? (class$org$netbeans$tax$TreeNode = TreeNodeFilterCustomEditor.class$("org.netbeans.tax.TreeNode")) : class$org$netbeans$tax$TreeNode);
        this.tableModel.fireTableDataChanged();
    }

    private static Vector getPublicNodeTypesInheritanceTree() {
        if (publicNodeTypesInheritanceTree == null) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Init Set");
            }
            Item rootItem = new Item();
            Object[] array = publicNodeTypeNamesMap.keySet().toArray();
            int i = 0;
            while (i < array.length) {
                Class clazz = (Class)array[i];
                Item.insertItemIntoLayer(rootItem.layer, Item.getItem(clazz));
                if (clazz.isInterface()) {
                    int j = 0;
                    while (j < i) {
                        Item.insertItemIntoLayer(rootItem.layer, Item.getItem((Class)array[j]));
                        ++j;
                    }
                }
                ++i;
            }
            publicNodeTypesInheritanceTree = new Vector();
            TreeNodeFilterCustomEditor.fillPublicNodeTypesInheritanceTree(rootItem.layer, "");
            Item.itemMap.clear();
            Item.itemMap = null;
            Object var0 = null;
        }
        return publicNodeTypesInheritanceTree;
    }

    private static void fillPublicNodeTypesInheritanceTree(Set layer, String prefix) {
        Iterator it = layer.iterator();
        while (it.hasNext()) {
            Item item = (Item)it.next();
            String itemPrefix = "";
            if (prefix.length() != 0) {
                itemPrefix = it.hasNext() ? prefix + "|- " : prefix + "`- ";
            }
            Item newItem = new Item(item, itemPrefix);
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(">>" + newItem.toString() + "<<");
            }
            publicNodeTypesInheritanceTree.add(newItem);
            String newPrefix = prefix.length() == 0 ? "   " : (it.hasNext() ? prefix + "|   " : prefix + "    ");
            TreeNodeFilterCustomEditor.fillPublicNodeTypesInheritanceTree(item.layer, newPrefix);
        }
    }

    public void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_TreeNodeFilterCustomEditor"));
        this.acceptRadioButton.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_acceptRejectLabel"));
        this.acceptRadioButton.setMnemonic(Util.THIS.getString("LBL_showItRadioButton_Mnem").charAt(0));
        this.rejectRadioButton.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_rejectRadioButton"));
        this.rejectRadioButton.setMnemonic(Util.THIS.getString("LBL_hideItRadioButton_Mnem").charAt(0));
        this.addButton.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_addButton1"));
        this.addButton.setMnemonic(Util.THIS.getString("LBL_addButton_Mnem").charAt(0));
        this.removeButton.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_removeButton1"));
        this.removeButton.setMnemonic(Util.THIS.getString("LBL_removeButton_Mnem").charAt(0));
        this.nodeTypesTable.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_nodeTypesTable"));
        this.nodeTypesTable.getAccessibleContext().setAccessibleName(Util.THIS.getString("ACSN_nodeTypesTable"));
    }

    public static final void main(String[] args) throws Exception {
        Vector vector = TreeNodeFilterCustomEditor.getPublicNodeTypesInheritanceTree();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        publicNodeTypeNamesMap.put(class$org$netbeans$tax$TreeNode == null ? (class$org$netbeans$tax$TreeNode = TreeNodeFilterCustomEditor.class$("org.netbeans.tax.TreeNode")) : class$org$netbeans$tax$TreeNode, Util.THIS.getString("NAME_Any_Node_Type"));
        publicNodeTypeNamesMap.put(class$org$netbeans$tax$TreeParentNode == null ? (class$org$netbeans$tax$TreeParentNode = TreeNodeFilterCustomEditor.class$("org.netbeans.tax.TreeParentNode")) : class$org$netbeans$tax$TreeParentNode, Util.THIS.getString("NAME_Any_Parent_Node_Type"));
        publicNodeTypeNamesMap.put(class$org$netbeans$tax$TreeCharacterData == null ? (class$org$netbeans$tax$TreeCharacterData = TreeNodeFilterCustomEditor.class$("org.netbeans.tax.TreeCharacterData")) : class$org$netbeans$tax$TreeCharacterData, Util.THIS.getString("NAME_Any_Character_Data_Node_Type"));
        publicNodeTypeNamesMap.put(class$org$netbeans$tax$TreeReference == null ? (class$org$netbeans$tax$TreeReference = TreeNodeFilterCustomEditor.class$("org.netbeans.tax.TreeReference")) : class$org$netbeans$tax$TreeReference, Util.THIS.getString("NAME_Any_Reference_Node_Type"));
        publicNodeTypeNamesMap.put(class$org$netbeans$tax$TreeNodeDecl == null ? (class$org$netbeans$tax$TreeNodeDecl = TreeNodeFilterCustomEditor.class$("org.netbeans.tax.TreeNodeDecl")) : class$org$netbeans$tax$TreeNodeDecl, Util.THIS.getString("NAME_Any_Declaration_Node_Type"));
        publicNodeTypeNamesMap.put(class$org$netbeans$tax$TreeComment == null ? (class$org$netbeans$tax$TreeComment = TreeNodeFilterCustomEditor.class$("org.netbeans.tax.TreeComment")) : class$org$netbeans$tax$TreeComment, Util.THIS.getString("NAME_Comment_Node_Type"));
        publicNodeTypeNamesMap.put(class$org$netbeans$tax$TreeProcessingInstruction == null ? (class$org$netbeans$tax$TreeProcessingInstruction = TreeNodeFilterCustomEditor.class$("org.netbeans.tax.TreeProcessingInstruction")) : class$org$netbeans$tax$TreeProcessingInstruction, Util.THIS.getString("NAME_Processing_Instruction_Node_Type"));
        publicNodeTypeNamesMap.put(class$org$netbeans$tax$TreeText == null ? (class$org$netbeans$tax$TreeText = TreeNodeFilterCustomEditor.class$("org.netbeans.tax.TreeText")) : class$org$netbeans$tax$TreeText, Util.THIS.getString("NAME_Text_Node_Type"));
        publicNodeTypeNamesMap.put(class$org$netbeans$tax$TreeCDATASection == null ? (class$org$netbeans$tax$TreeCDATASection = TreeNodeFilterCustomEditor.class$("org.netbeans.tax.TreeCDATASection")) : class$org$netbeans$tax$TreeCDATASection, Util.THIS.getString("NAME_CDATA_Section_Node_Type"));
        publicNodeTypeNamesMap.put(class$org$netbeans$tax$TreeElement == null ? (class$org$netbeans$tax$TreeElement = TreeNodeFilterCustomEditor.class$("org.netbeans.tax.TreeElement")) : class$org$netbeans$tax$TreeElement, Util.THIS.getString("NAME_Element_Node_Type"));
        publicNodeTypeNamesMap.put(class$org$netbeans$tax$TreeAttribute == null ? (class$org$netbeans$tax$TreeAttribute = TreeNodeFilterCustomEditor.class$("org.netbeans.tax.TreeAttribute")) : class$org$netbeans$tax$TreeAttribute, Util.THIS.getString("NAME_Attribute_Node_Type"));
        publicNodeTypeNamesMap.put(class$org$netbeans$tax$TreeConditionalSection == null ? (class$org$netbeans$tax$TreeConditionalSection = TreeNodeFilterCustomEditor.class$("org.netbeans.tax.TreeConditionalSection")) : class$org$netbeans$tax$TreeConditionalSection, Util.THIS.getString("NAME_Conditional_Section_Node_Type"));
        publicNodeTypeNamesMap.put(class$org$netbeans$tax$TreeDocumentType == null ? (class$org$netbeans$tax$TreeDocumentType = TreeNodeFilterCustomEditor.class$("org.netbeans.tax.TreeDocumentType")) : class$org$netbeans$tax$TreeDocumentType, Util.THIS.getString("NAME_Document_Type_Node_Type"));
        publicNodeTypeNamesMap.put(class$org$netbeans$tax$TreeGeneralEntityReference == null ? (class$org$netbeans$tax$TreeGeneralEntityReference = TreeNodeFilterCustomEditor.class$("org.netbeans.tax.TreeGeneralEntityReference")) : class$org$netbeans$tax$TreeGeneralEntityReference, Util.THIS.getString("NAME_General_Entity_Reference_Node_Type"));
        publicNodeTypeNamesMap.put(class$org$netbeans$tax$TreeParameterEntityReference == null ? (class$org$netbeans$tax$TreeParameterEntityReference = TreeNodeFilterCustomEditor.class$("org.netbeans.tax.TreeParameterEntityReference")) : class$org$netbeans$tax$TreeParameterEntityReference, Util.THIS.getString("NAME_Parameter_Entity_Reference_Node_Type"));
        publicNodeTypeNamesMap.put(class$org$netbeans$tax$TreeElementDecl == null ? (class$org$netbeans$tax$TreeElementDecl = TreeNodeFilterCustomEditor.class$("org.netbeans.tax.TreeElementDecl")) : class$org$netbeans$tax$TreeElementDecl, Util.THIS.getString("NAME_Element_Declaration_Node_Type"));
        publicNodeTypeNamesMap.put(class$org$netbeans$tax$TreeEntityDecl == null ? (class$org$netbeans$tax$TreeEntityDecl = TreeNodeFilterCustomEditor.class$("org.netbeans.tax.TreeEntityDecl")) : class$org$netbeans$tax$TreeEntityDecl, Util.THIS.getString("NAME_Entity_Declaration_Node_Type"));
        publicNodeTypeNamesMap.put(class$org$netbeans$tax$TreeAttlistDecl == null ? (class$org$netbeans$tax$TreeAttlistDecl = TreeNodeFilterCustomEditor.class$("org.netbeans.tax.TreeAttlistDecl")) : class$org$netbeans$tax$TreeAttlistDecl, Util.THIS.getString("NAME_Attlist_Declaration_Node_Type"));
        publicNodeTypeNamesMap.put(class$org$netbeans$tax$TreeNotationDecl == null ? (class$org$netbeans$tax$TreeNotationDecl = TreeNodeFilterCustomEditor.class$("org.netbeans.tax.TreeNotationDecl")) : class$org$netbeans$tax$TreeNotationDecl, Util.THIS.getString("NAME_Notation_Declaration_Node_Type"));
    }

    private static class Item {
        private static Map itemMap;
        private final NamedClass clazz;
        private final Set layer;
        private final String prefix;

        private Item(NamedClass clazz, Set layer, String prefix) {
            this.clazz = clazz;
            this.layer = layer;
            this.prefix = prefix;
        }

        private Item(Item item, String prefix) {
            this(item.clazz, null, prefix);
        }

        private Item(NamedClass clazz) {
            this(clazz, new TreeSet(new NamedClassComparator()), new String());
        }

        private Item() {
            this(new NamedClass(null));
        }

        public String toString() {
            return this.prefix + this.clazz.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Item)) {
                return false;
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("___ Item::equals: this = " + this);
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("___     ::equals: obj  = " + obj);
            }
            Item peer = (Item)obj;
            return this.clazz.equals(peer.clazz);
        }

        private static Item getItem(Class clazz) {
            Item item;
            if (itemMap == null) {
                itemMap = new HashMap();
            }
            if ((item = (Item)itemMap.get(clazz)) == null) {
                item = new Item(new NamedClass(clazz));
                itemMap.put(clazz, item);
            }
            return item;
        }

        private static void insertItemIntoLayer(Set layer, Item newItem) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("\n\nInsert newItem : " + newItem);
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("       Item : set = " + layer);
            }
            boolean inserted = false;
            Object[] array = layer.toArray();
            int i = 0;
            while (i < array.length) {
                Item item = (Item)array[i];
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("       Item : item [" + i + "] = " + item);
                }
                if (item.clazz.clazz == newItem.clazz.clazz) {
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("       Item : #1 -= [ ITEM.clazz.clazz == NEW_ITEM.clazz.clazz   => IGNORE insert ]=-");
                    }
                    inserted = true;
                } else if (item.clazz.clazz.isAssignableFrom(newItem.clazz.clazz)) {
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("       Item : #2 -= [ NEW_ITEM is subclass of actual ITEM   => insert to ITEM.LAYER ]=-");
                    }
                    Item.insertItemIntoLayer(item.layer, newItem);
                    inserted = true;
                } else if (newItem.clazz.clazz.isAssignableFrom(item.clazz.clazz)) {
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("       Item : #3 -= [ actual ITEM '" + item + "' is subclass of NEW_ITEM   => item REMOVED & insert to NEW_ITEM.LAYER ]=-");
                    }
                    if (!newItem.clazz.clazz.isInterface()) {
                        layer.remove(item);
                        Item.insertItemIntoLayer(newItem.layer, item);
                    }
                }
                ++i;
            }
            if (!inserted) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("       Item : #4 -= [ item '" + newItem + "' INSERTED into " + layer + " ] =-");
                }
                layer.add(newItem);
            }
        }
    }

    private static class NamedClassComparator
    implements Comparator {
        private NamedClassComparator() {
        }

        public int compare(Object obj1, Object obj2) throws ClassCastException {
            return obj1.toString().compareTo(obj2.toString());
        }

        public boolean equals(Object obj) {
            return obj instanceof NamedClassComparator;
        }
    }

    private static class NamedClass {
        private final Class clazz;

        public NamedClass(Class clazz) {
            this.clazz = clazz;
        }

        public String toString() {
            String name = (String)publicNodeTypeNamesMap.get(this.clazz);
            if (name == null) {
                name = this.clazz.getName();
            }
            return name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NamedClass)) {
                return false;
            }
            NamedClass peer = (NamedClass)obj;
            return this.clazz.equals(peer.clazz);
        }
    }

    private class NodeTypesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -1438087942670592779L;
        static /* synthetic */ Class class$java$lang$Class;

        private NodeTypesTableModel() {
        }

        public void removeRow(int row) {
            TreeNodeFilterCustomEditor.this.nodeTypesList.remove(row);
            this.fireTableDataChanged();
        }

        public int getRowCount() {
            return TreeNodeFilterCustomEditor.this.nodeTypesList.size();
        }

        public int getColumnCount() {
            return 1;
        }

        public Class getColumnClass(int index) {
            return class$java$lang$Class == null ? (class$java$lang$Class = NodeTypesTableModel.class$("java.lang.Class")) : class$java$lang$Class;
        }

        public Object getValueAt(int row, int column) {
            Item retVal = new Item(new NamedClass((Class)TreeNodeFilterCustomEditor.this.nodeTypesList.get(row)));
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("<-- getValue: row    = " + row);
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("<-- getValue: column = " + column);
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("<-- getValue: " + retVal.getClass().getName() + " -- '" + retVal + "'");
            }
            return retVal;
        }

        public void setValueAt(Object val, int row, int column) {
            if (row >= TreeNodeFilterCustomEditor.this.nodeTypesList.size()) {
                return;
            }
            Class type = null;
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("--> setValue: " + val.getClass().getName() + " -- '" + val + "'");
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("--> setValue: row    = " + row);
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("--> setValue: column = " + column);
            }
            if (val instanceof String) {
                try {
                    type = Class.forName(val.toString());
                }
                catch (ClassNotFoundException exc) {}
            } else if (val instanceof Item) {
                type = ((Item)val).clazz.clazz;
            } else if (val instanceof NamedClass) {
                type = ((NamedClass)val).clazz;
            }
            if (type == null || !TreeNodeFilter.isValidNodeType(type)) {
                TAXUtil.notifyWarning(Util.THIS.getString("MSG_invalidNodeType", val.toString()));
                return;
            }
            TreeNodeFilterCustomEditor.this.nodeTypesList.set(row, type);
        }

        public String getColumnName(int column) {
            return Util.THIS.getString("LBL_nodeType");
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class RowKeyListener
    extends KeyAdapter {
        private JTable table;

        public RowKeyListener(JTable table) {
            this.table = table;
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 127) {
                TreeNodeFilterCustomEditor.this.tableModel.removeRow(this.table.getSelectedRow());
            }
        }
    }
}

