/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.classpath;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.java.classpath.RepositoryL;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;

public abstract class ClassPath {
    public static final String EXECUTE = "classpath/execute";
    public static final String DEBUG = "classpath/debug";
    public static final String COMPILE = "classpath/compile";
    public static final String PROP_ROOTS = "roots";
    public static final String PROP_ENTRIES = "entries";
    private static final String REGISTRATION_PREFIX = "org-netbeans-modules-java/";
    private PropertyChangeSupport propSupport;

    public abstract FileObject[] getRoots();

    public abstract List entries();

    ClassPath() {
    }

    public final FileObject findResource(String string) {
        FileObject[] fileObjectArray = this.getRoots();
        return ClassPath.findResourceImpl(fileObjectArray, new int[]{0}, ClassPath.parseResourceName(string));
    }

    public final List findAllResources(String string) {
        FileObject[] fileObjectArray = this.getRoots();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(fileObjectArray.length);
        int[] nArray = new int[]{0};
        String[] stringArray = ClassPath.parseResourceName(string);
        while (nArray[0] < fileObjectArray.length) {
            FileObject fileObject = ClassPath.findResourceImpl(fileObjectArray, nArray, stringArray);
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        return arrayList;
    }

    public final String getResourceName(FileObject fileObject) {
        return this.getResourceName(fileObject, '/', true);
    }

    public final String getResourceName(FileObject fileObject, char c, boolean bl) {
        FileObject fileObject2 = this.findOwnerRoot(fileObject);
        if (fileObject2 == null) {
            return null;
        }
        if (fileObject2 == fileObject) {
            return "";
        }
        String string = fileObject2.toString();
        int n = string.length();
        String string2 = bl ? fileObject.getPackageNameExt('/', '.') : fileObject.getPackageName('/');
        return n == 0 ? string2 : string2.substring(n + 1);
    }

    public final FileObject findOwnerRoot(FileObject fileObject) {
        FileObject[] fileObjectArray = this.getRoots();
        LinkedList<FileObject> linkedList = new LinkedList<FileObject>();
        FileObject fileObject2 = fileObject;
        while (fileObject2 != null) {
            linkedList.add(fileObject2);
            fileObject2 = fileObject2.getParent();
        }
        int n = 0;
        while (n < fileObjectArray.length) {
            block6: {
                FileObject fileObject3;
                block5: {
                    fileObject3 = fileObjectArray[n];
                    try {
                        if (fileObject3.getFileSystem() == fileObject.getFileSystem()) break block5;
                        break block6;
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        // empty catch block
                    }
                }
                if (linkedList.contains(fileObject3)) {
                    return fileObject3;
                }
            }
            ++n;
        }
        return null;
    }

    public final boolean contains(FileObject fileObject) {
        return this.findOwnerRoot(fileObject) != null;
    }

    public final boolean isResourceVisible(FileObject fileObject) {
        String string = this.getResourceName(fileObject);
        if (string == null) {
            return false;
        }
        return this.findResource(string) == fileObject;
    }

    public final synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propSupport == null) {
            this.propSupport = new PropertyChangeSupport(this);
        }
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propSupport != null) {
            this.propSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public static ClassPath getClassPath(FileObject fileObject, String string) {
        return ClassPath.getClassPathImpl(string);
    }

    final void firePropertyChange(String string, Object object, Object object2) {
        if (this.propSupport == null) {
            return;
        }
        this.propSupport.firePropertyChange(string, object, object2);
    }

    private static ClassPath getClassPathImpl(String string) {
        return RepositoryL.get().getClassPath(string);
    }

    private static String[] parseResourceName(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(string.length() / 4);
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            switch (c) {
                case '.': {
                    n2 = n;
                    break;
                }
                case '/': {
                    if (n2 != -1) {
                        arrayList.add(string.substring(n3, n2));
                        arrayList.add(string.substring(n2 + 1, n));
                    } else {
                        arrayList.add(string.substring(n3, n));
                        arrayList.add(null);
                    }
                    n3 = n + 1;
                    n2 = -1;
                }
            }
            ++n;
        }
        if (n > n3) {
            if (n2 != -1) {
                arrayList.add(string.substring(n3, n2));
                arrayList.add(string.substring(n2 + 1, n));
            } else {
                arrayList.add(string.substring(n3, n));
                arrayList.add(null);
            }
        }
        if (arrayList.size() % 2 != 0) {
            System.err.println("parsed size is not even!!");
            System.err.println("input = " + string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static FileObject findPath(FileObject fileObject, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length && fileObject != null) {
            FileObject fileObject2 = fileObject.getFileObject(stringArray[n], stringArray[n + 1]);
            n += 2;
            fileObject = fileObject2;
        }
        return fileObject;
    }

    private static FileObject findResourceImpl(FileObject[] fileObjectArray, int[] nArray, String[] stringArray) {
        FileObject fileObject = null;
        int n = nArray[0];
        while (n < fileObjectArray.length && fileObject == null) {
            fileObject = ClassPath.findPath(fileObjectArray[n], stringArray);
            ++n;
        }
        nArray[0] = n;
        return fileObject;
    }

    public abstract class Entry {
        public abstract ClassPath getDefiningClassPath();

        public abstract FileObject getRoot();

        public abstract boolean isValid();

        public abstract IOException getError();

        Entry() {
        }
    }
}

