/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.RepositoryCP;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.util.WeakListener;

class RepositoryL
implements RepositoryListener,
PropertyChangeListener {
    Map classpathMap;
    Map capMap;
    PropertyChangeListener wL;
    static RepositoryL instance;

    public static synchronized RepositoryL get() {
        if (instance != null) {
            return instance;
        }
        instance = new RepositoryL();
        return instance;
    }

    private RepositoryL() {
        this.initialize();
    }

    void initialize() {
        FileSystem[] fileSystemArray = Repository.getDefault().toArray();
        this.capMap = new HashMap(fileSystemArray.length);
        int n = 0;
        while (n < fileSystemArray.length) {
            this.capMap.put(fileSystemArray[n].getCapability(), fileSystemArray[n]);
            ++n;
        }
        this.wL = WeakListener.propertyChange((PropertyChangeListener)this, null);
        RepositoryL repositoryL = this;
        synchronized (repositoryL) {
            Repository.getDefault().addRepositoryListener(WeakListener.repository((RepositoryListener)this, (Object)Repository.getDefault()));
            Iterator iterator = this.capMap.keySet().iterator();
            while (iterator.hasNext()) {
                ((FileSystemCapability)iterator.next()).addPropertyChangeListener(this.wL);
            }
        }
    }

    public void fileSystemAdded(RepositoryEvent repositoryEvent) {
        FileSystem fileSystem = repositoryEvent.getFileSystem();
        Collection collection = this.findAffectedPaths(fileSystem);
        RepositoryL repositoryL = this;
        synchronized (repositoryL) {
            this.capMap.put(fileSystem.getCapability(), fileSystem);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((RepositoryCP)iterator.next()).fileSystemAdded(fileSystem);
        }
        fileSystem.getCapability().addPropertyChangeListener(this.wL);
    }

    synchronized Collection findAffectedPaths(FileSystem fileSystem) {
        FileSystemCapability fileSystemCapability = fileSystem.getCapability();
        if (this.classpathMap == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList arrayList = new ArrayList(this.classpathMap.size());
        RepositoryL repositoryL = this;
        synchronized (repositoryL) {
            Iterator iterator = this.classpathMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Object t;
                Map.Entry entry = iterator.next();
                FileSystemCapability fileSystemCapability2 = (FileSystemCapability)entry.getKey();
                if (!fileSystemCapability.capableOf(fileSystemCapability2) || (t = ((Reference)entry.getValue()).get()) == null) continue;
                arrayList.add(t);
            }
        }
        return arrayList;
    }

    public void fileSystemPoolReordered(RepositoryReorderedEvent repositoryReorderedEvent) {
        ArrayList arrayList;
        RepositoryL repositoryL = this;
        synchronized (repositoryL) {
            if (this.classpathMap == null) {
                return;
            }
            arrayList = new ArrayList(this.classpathMap.values());
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Reference reference = (Reference)iterator.next();
            RepositoryCP repositoryCP = (RepositoryCP)reference.get();
            if (repositoryCP == null) continue;
            repositoryCP.fileSystemsReordered(repositoryReorderedEvent.getPermutation());
        }
    }

    public void fileSystemRemoved(RepositoryEvent repositoryEvent) {
        FileSystem fileSystem = repositoryEvent.getFileSystem();
        fileSystem.getCapability().removePropertyChangeListener(this.wL);
        Collection collection = this.findAffectedPaths(fileSystem);
        RepositoryL repositoryL = this;
        synchronized (repositoryL) {
            this.capMap.remove(fileSystem.getCapability());
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((RepositoryCP)iterator.next()).fileSystemRemoved(fileSystem);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        ArrayList arrayList;
        FileSystemCapability fileSystemCapability = (FileSystemCapability)propertyChangeEvent.getSource();
        FileSystem fileSystem = (FileSystem)this.capMap.get(fileSystemCapability);
        RepositoryL repositoryL = this;
        synchronized (repositoryL) {
            arrayList = new ArrayList(this.classpathMap.values());
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RepositoryCP repositoryCP = (RepositoryCP)((Reference)iterator.next()).get();
            if (repositoryCP == null) continue;
            repositoryCP.capsChanged(fileSystem);
        }
    }

    synchronized ClassPath createClassPath(FileSystemCapability fileSystemCapability) {
        ClassPath classPath;
        Reference reference;
        if (this.classpathMap != null) {
            reference = (Reference)this.classpathMap.get(fileSystemCapability);
        } else {
            reference = null;
            this.classpathMap = new HashMap(4);
        }
        if (reference != null && (classPath = (ClassPath)reference.get()) != null) {
            return classPath;
        }
        classPath = new RepositoryCP(fileSystemCapability);
        this.classpathMap.put(fileSystemCapability, new WeakReference<ClassPath>(classPath));
        return classPath;
    }

    public ClassPath getClassPath(String string) {
        if ("classpath/compile".equals(string)) {
            return this.createClassPath(FileSystemCapability.COMPILE);
        }
        if ("classpath/execute".equals(string)) {
            return this.createClassPath(FileSystemCapability.EXECUTE);
        }
        if ("classpath/debug".equals(string)) {
            return this.createClassPath(FileSystemCapability.DEBUG);
        }
        return null;
    }
}

