/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javadoc.ExternalOptionListProducer;
import org.netbeans.modules.javadoc.NotifyJavadocGenerated;
import org.netbeans.modules.javadoc.ResourceUtils;
import org.netbeans.modules.javadoc.settings.DocumentationSettings;
import org.netbeans.modules.javadoc.settings.ExternalJavadocSettingsService;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.execution.ExecInfo;
import org.openide.execution.ExecutorTask;
import org.openide.execution.NbClassPath;
import org.openide.execution.NbProcessDescriptor;
import org.openide.execution.ProcessExecutor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.MapFormat;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public class ExternalJavadocExecutor
extends ProcessExecutor {
    private static boolean running = false;
    private static final NbProcessDescriptor DEFAULT = new NbProcessDescriptor("{jdk.home}{/}bin{/}javadoc", " {params} -classpath {filesystems}{:}{classpath}{:}{bootclasspath}{:}{library} {files}");
    private ExecutorTask javadocProcess = null;
    private static List args;
    private static String files;
    static List pckList;
    private static final String PREFIX = "javadocparams";
    private static final String SUFFIX = "pms";
    private static final long serialVersionUID = 4377377355485697603L;
    static /* synthetic */ Class class$org$netbeans$modules$javadoc$settings$ExternalJavadocSettingsService;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$netbeans$modules$java$JavaDataObject;

    public ExternalJavadocExecutor() {
        this.setExternalExecutor(DEFAULT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(Node[] nodeArray) {
        boolean bl;
        block9: {
            if (ExternalJavadocExecutor.isRunning()) {
                return;
            }
            ExternalJavadocExecutor.setRunning(true);
            TopManager.getDefault().saveAll();
            files = ExternalJavadocExecutor.createLists(nodeArray);
            if (files == null) {
                TopManager.getDefault().setStatusText(ResourceUtils.getBundledString("MSG_NoFilesInList"));
                ExternalJavadocExecutor.setRunning(false);
                return;
            }
            args = new ArrayList();
            args.addAll(ExternalOptionListProducer.getOptionList(nodeArray));
            if (Boolean.getBoolean("netbeans.debug.javadoc")) {
                JavadocFormat javadocFormat = new JavadocFormat(ExternalJavadocExecutor.createParametersLine(), files);
                System.out.println(MapFormat.format((String)DEFAULT.getProcessName(), (Map)javadocFormat.getMap()) + " " + MapFormat.format((String)DEFAULT.getArguments(), (Map)javadocFormat.getMap()));
            }
            bl = true;
            try {
                try {
                    TopManager.getDefault().setStatusText(ResourceUtils.getBundledString("MSG_GeneratingJavadoc"));
                    this.javadocProcess = this.execute(new ExecInfo(ResourceUtils.getBundledString("CTL_Javadoc_IOTab")));
                    this.setIOTab(this.javadocProcess.getInputOutput());
                    this.javadocProcess.waitFinished();
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                    bl = false;
                    Object var5_5 = null;
                    ExternalJavadocExecutor.setRunning(false);
                    break block9;
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                ExternalJavadocExecutor.setRunning(false);
                throw throwable;
            }
            ExternalJavadocExecutor.setRunning(false);
        }
        if (DocumentationSettings.getDefault().getAskAfterGenerating() && bl && this.javadocProcess.result() == 0) {
            NotifyJavadocGenerated.showNotifyDialog();
        }
        if (this.javadocProcess.result() != 0 || !bl) {
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ResourceUtils.getBundledString("MSG_Error_When_Generating"), 0));
        }
        TopManager.getDefault().setStatusText(ResourceUtils.getBundledString("CTL_Javadoc_Finished"));
        this.javadocProcess = null;
    }

    public static boolean isRunning() {
        return running;
    }

    public static void setRunning(boolean bl) {
        running = bl;
    }

    public void stopJavadoc() {
        if (running) {
            this.javadocProcess.stop();
        }
    }

    void setIOTab(InputOutput inputOutput) {
        inputOutput.setErrSeparated(true);
        inputOutput.setOutputVisible(true);
        inputOutput.setErrVisible(true);
        inputOutput.setFocusTaken(true);
        inputOutput.select();
    }

    protected Process createProcess(ExecInfo execInfo) throws IOException {
        return this.getExternalExecutor().exec((Format)((Object)new JavadocFormat(ExternalJavadocExecutor.createParametersLine(), files)));
    }

    private static String createParametersLine() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = args.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static String createLists(Node[] nodeArray) {
        pckList = new ArrayList();
        ArrayList<String> arrayList = new ArrayList<String>();
        ExternalJavadocSettingsService externalJavadocSettingsService = (ExternalJavadocSettingsService)TopManager.getDefault().getServices().find(class$org$netbeans$modules$javadoc$settings$ExternalJavadocSettingsService == null ? (class$org$netbeans$modules$javadoc$settings$ExternalJavadocSettingsService = ExternalJavadocExecutor.class$("org.netbeans.modules.javadoc.settings.ExternalJavadocSettingsService")) : class$org$netbeans$modules$javadoc$settings$ExternalJavadocSettingsService);
        int n = 0;
        while (n < nodeArray.length) {
            String string;
            DataFolder dataFolder = (DataFolder)nodeArray[n].getCookie(class$org$openide$loaders$DataFolder == null ? ExternalJavadocExecutor.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder);
            if (dataFolder != null) {
                if (ExternalJavadocExecutor.isAvailableFile(dataFolder.getPrimaryFile())) {
                    string = dataFolder.getPrimaryFile().getPackageName('.');
                    if (ExternalJavadocExecutor.existsJdoFilesInFolder(dataFolder) && !pckList.contains(string)) {
                        pckList.add(string);
                        arrayList.add(string);
                    }
                    if (externalJavadocSettingsService == null || externalJavadocSettingsService.getRecursive()) {
                        arrayList.addAll(ExternalJavadocExecutor.parseFolders(dataFolder));
                    }
                }
            } else {
                JavaDataObject javaDataObject = (JavaDataObject)nodeArray[n].getCookie(class$org$netbeans$modules$java$JavaDataObject == null ? ExternalJavadocExecutor.class$("org.netbeans.modules.java.JavaDataObject") : class$org$netbeans$modules$java$JavaDataObject);
                if (javaDataObject != null && ExternalJavadocExecutor.isAvailableFile((FileObject)(string = javaDataObject.getPrimaryFile()))) {
                    String string2 = ExternalJavadocExecutor.getFileObjectPackage((FileObject)string);
                    if (string.hasExt("java") && !pckList.contains(string2)) {
                        try {
                            arrayList.add(FileUtil.toFile((FileObject)string).toString());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            ++n;
        }
        if (arrayList.size() != 0) {
            return ExternalJavadocExecutor.asParameterString(arrayList.toArray(new String[1]));
        }
        return null;
    }

    private static List parseFolders(DataFolder dataFolder) {
        ArrayList<String> arrayList = new ArrayList<String>();
        DataObject[] dataObjectArray = dataFolder.getChildren();
        int n = 0;
        while (n < dataObjectArray.length) {
            Object object;
            if (dataObjectArray[n] instanceof JavaDataObject) {
                object = (JavaDataObject)dataObjectArray[n];
                FileObject fileObject = object.getPrimaryFile();
                if (ExternalJavadocExecutor.isAvailableFile(fileObject)) {
                    String string = ExternalJavadocExecutor.getFileObjectPackage(fileObject);
                    if (fileObject.hasExt("java") && !pckList.contains(string)) {
                        try {
                            arrayList.add(FileUtil.toFile((FileObject)fileObject).toString());
                        }
                        catch (Exception exception) {}
                    }
                }
            } else if (dataObjectArray[n] instanceof DataFolder) {
                object = ((DataFolder)dataObjectArray[n]).getPrimaryFile().getPackageName('.');
                if (ExternalJavadocExecutor.isAvailableFile(dataFolder.getPrimaryFile())) {
                    if (!pckList.contains(object)) {
                        pckList.add(object);
                        if (ExternalJavadocExecutor.existsJdoFilesInFolder((DataFolder)dataObjectArray[n])) {
                            arrayList.add((String)object);
                        }
                    }
                    arrayList.addAll(ExternalJavadocExecutor.parseFolders((DataFolder)dataObjectArray[n]));
                }
            }
            ++n;
        }
        return arrayList;
    }

    private static boolean existsJdoFilesInFolder(DataFolder dataFolder) {
        DataObject[] dataObjectArray = dataFolder.getChildren();
        int n = 0;
        while (n < dataObjectArray.length) {
            if (dataObjectArray[n] instanceof JavaDataObject) {
                JavaDataObject javaDataObject = (JavaDataObject)dataObjectArray[n];
                Set set = javaDataObject.files();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    if (!((FileObject)iterator.next()).hasExt("java")) continue;
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    private static boolean isAvailableFile(FileObject fileObject) {
        try {
            FileUtil.toFile((FileObject)fileObject).toString();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static String getFileObjectPackage(FileObject fileObject) {
        String string = fileObject.getPackageName('.');
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    private static String asParameterString(String[] stringArray) {
        if (stringArray.length > 10 && Utilities.isWindows()) {
            File file = ExternalJavadocExecutor.constructFile(stringArray);
            if (file == null) {
                return null;
            }
            return "@" + file;
        }
        return ExternalJavadocExecutor.constructString(stringArray);
    }

    private static File constructFile(String[] stringArray) {
        try {
            File file = File.createTempFile(PREFIX, SUFFIX);
            file.deleteOnExit();
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(new FileOutputStream(file)));
            Iterator<String> iterator = Arrays.asList(stringArray).iterator();
            while (iterator.hasNext()) {
                printWriter.println(iterator.next());
            }
            printWriter.close();
            return file;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String constructString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(string);
            if (stringArray[n].indexOf(32) >= 0) {
                stringBuffer.append("\"");
                stringBuffer.append(stringArray[n]);
                stringBuffer.append("\"");
            } else {
                stringBuffer.append(stringArray[n]);
            }
            string = " ";
            ++n;
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        files = null;
        pckList = null;
    }

    private static class JavadocFormat
    extends MapFormat {
        public static final String TAG_CLASSPATH = "classpath";
        public static final String TAG_BOOTCLASSPATH = "bootclasspath";
        public static final String TAG_REPOSITORY = "filesystems";
        public static final String TAG_LIBRARY = "library";
        public static final String TAG_FILES = "files";
        public static final String TAG_PARAMS = "params";
        public static final String TAG_JDKHOME = "jdk.home";
        public static final String TAG_SEPARATOR = "/";
        public static final String TAG_PATHSEPARATOR = ":";
        private Map map = this.getMap();
        private static final long serialVersionUID = 7560001740739774352L;

        public JavadocFormat(String string, String string2) {
            super(new HashMap(9));
            this.map.put(TAG_CLASSPATH, NbClassPath.createClassPath().getClassPath());
            this.map.put(TAG_BOOTCLASSPATH, NbClassPath.createBootClassPath().getClassPath());
            this.map.put(TAG_REPOSITORY, NbClassPath.createRepositoryPath().getClassPath());
            this.map.put(TAG_LIBRARY, NbClassPath.createLibraryPath().getClassPath());
            this.map.put(TAG_JDKHOME, System.getProperty(TAG_JDKHOME));
            this.map.put(TAG_SEPARATOR, File.separator);
            this.map.put(TAG_PATHSEPARATOR, File.pathSeparator);
            this.map.put(TAG_PARAMS, string);
            this.map.put(TAG_FILES, string2);
        }
    }
}

