/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.javadoc.JavadocModule;
import org.netbeans.modules.javadoc.search.DocIndexItem;
import org.netbeans.modules.javadoc.search.IndexListCellRenderer;
import org.netbeans.modules.javadoc.search.JavadocSearchEngine;
import org.netbeans.modules.javadoc.search.NoJavadocException;
import org.netbeans.modules.javadoc.search.ResourceUtils;
import org.netbeans.modules.javadoc.search.SrcFinder;
import org.netbeans.modules.javadoc.settings.DocumentationSettings;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.SplittedPanel;
import org.openide.cookies.OpenCookie;
import org.openide.src.Element;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class IndexSearch
extends TopComponent
implements Externalizable {
    private static final String INDEX_SEARCH_HELP_CTX_KEY = "javadoc.search.window";
    private static ResourceBundle bundle = null;
    private static final Dimension PREFFERED_SIZE = new Dimension(580, 430);
    static final long serialVersionUID = 1200348578933093459L;
    private static IndexSearch indexSearch;
    private JavadocSearchEngine searchEngine = null;
    DocumentationSettings ds = DocumentationSettings.getDefault();
    private String quickFind;
    private static final ImageIcon refSortIcon;
    private static final ImageIcon typeSortIcon;
    private static final ImageIcon alphaSortIcon;
    private static final ImageIcon listOnlyIcon;
    private static final ImageIcon listHtmlIcon;
    private static final ImageIcon showSourceIcon;
    private static final String ICON_RESOURCE = "/org/netbeans/modules/javadoc/resources/searchDoc.gif";
    private static final Image windowIcon;
    private String currentSort = "A";
    private JScrollPane resultsScrollPane;
    private JList resultsList;
    private HtmlBrowser quickBrowser;
    private SplittedPanel splitPanel;
    private static final String STR_FIND;
    private static final String STR_STOP;
    private ArrayList results = new ArrayList();
    private DefaultListModel referenceModel = null;
    private DefaultListModel typeModel = null;
    private DefaultListModel alphaModel = null;
    private int oldSplit = DocumentationSettings.getDefault().getIdxSearchSplit();
    private static final DefaultListModel waitModel;
    private static final DefaultListModel notModel;
    RequestProcessor.Task task = null;
    private JButton searchButton;
    private JPanel jPanel1;
    private JButton sourceButton;
    private JComboBox searchComboBox;
    private JToggleButton byNameButton;
    private JButton helpButton;
    private JToggleButton byReferenceButton;
    private JToggleButton quickViewButton;
    private JToggleButton byTypeButton;
    static /* synthetic */ Class class$org$netbeans$modules$javadoc$search$IndexSearch;
    static /* synthetic */ Class class$org$openide$cookies$OpenCookie;

    public IndexSearch() {
        this.initComponents();
        ((JComponent)((Object)this)).putClientProperty("TabPolicy", "HideWhenAlone");
        ComboBoxEditor comboBoxEditor = this.searchComboBox.getEditor();
        comboBoxEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (IndexSearch.this.searchEngine == null) {
                    IndexSearch.this.searchButtonActionPerformed(actionEvent);
                }
            }
        });
        this.splitPanel = new SplittedPanel();
        this.splitPanel.setSplitType(1);
        this.splitPanel.setSplitAbsolute(false);
        this.splitPanel.setSplitPosition(this.oldSplit);
        this.splitPanel.setSplitDragable(true);
        this.splitPanel.setSplitTypeChangeEnabled(true);
        this.splitPanel.setPreferredSize(PREFFERED_SIZE);
        this.splitPanel.addSplitChangeListener(new SplittedPanel.SplitChangeListener(){

            public void splitChanged(SplittedPanel.SplitChangeEvent splitChangeEvent) {
                int n = splitChangeEvent.getNewValue();
                IndexSearch.this.ds.setIdxSearchSplit(n);
                if (n == 100) {
                    IndexSearch.this.quickViewButton.setSelected(false);
                    IndexSearch.this.ds.setIdxSearchNoHtml(true);
                } else {
                    IndexSearch.this.quickViewButton.setSelected(true);
                    IndexSearch.this.ds.setIdxSearchNoHtml(false);
                }
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        ((Container)((Object)this)).add((Component)this.splitPanel, gridBagConstraints);
        this.resultsScrollPane = new JScrollPane();
        this.resultsList = new JList();
        this.resultsList.setSelectionMode(0);
        this.resultsList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                IndexSearch.this.resultsListKeyPressed(keyEvent);
            }
        });
        this.resultsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                IndexSearch.this.resultsListMouseClicked(mouseEvent);
            }
        });
        this.resultsScrollPane.setViewportView(this.resultsList);
        this.splitPanel.add((Component)this.resultsScrollPane, SplittedPanel.ADD_FIRST);
        this.quickBrowser = new HtmlBrowser(true, false);
        this.quickBrowser.setEnableLocation(false);
        this.quickBrowser.setEnableHome(false);
        this.quickBrowser.setBorder(new EmptyBorder(new Insets(8, 0, 0, 0)));
        this.splitPanel.add((Component)this.quickBrowser, SplittedPanel.ADD_SECOND);
        DefaultListModel defaultListModel = new DefaultListModel();
        this.resultsList.setModel(defaultListModel);
        IndexListCellRenderer indexListCellRenderer = new IndexListCellRenderer();
        this.resultsList.setCellRenderer(indexListCellRenderer);
        this.resultsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                IndexSearch.this.showHelp(true);
            }
        });
        this.resultsScrollPane.validate();
        this.searchButton.setText(STR_FIND);
        this.sourceButton.setIcon(showSourceIcon);
        this.byReferenceButton.setIcon(refSortIcon);
        this.byTypeButton.setIcon(typeSortIcon);
        this.byNameButton.setIcon(alphaSortIcon);
        this.quickViewButton.setIcon(listHtmlIcon);
        this.quickViewButton.setSelectedIcon(listOnlyIcon);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.byReferenceButton);
        buttonGroup.add(this.byTypeButton);
        buttonGroup.add(this.byNameButton);
        this.searchButton.setToolTipText(ResourceUtils.getBundledString("CTL_SEARCH_search_ToolTip"));
        this.byReferenceButton.setToolTipText(ResourceUtils.getBundledString("CTL_SEARCH_byReference_ToolTip"));
        this.byReferenceButton.setMnemonic(ResourceUtils.getBundledString("CTL_SEARCH_byReference_Mnemonic").charAt(0));
        this.byTypeButton.setToolTipText(ResourceUtils.getBundledString("CTL_SEARCH_byType_ToolTip"));
        this.byTypeButton.setMnemonic(ResourceUtils.getBundledString("CTL_SEARCH_byType_Mnemonic").charAt(0));
        this.byNameButton.setToolTipText(ResourceUtils.getBundledString("CTL_SEARCH_byName_ToolTip"));
        this.byNameButton.setMnemonic(ResourceUtils.getBundledString("CTL_SEARCH_byName_Mnemonic").charAt(0));
        this.quickViewButton.setToolTipText(ResourceUtils.getBundledString("CTL_SEARCH_quickView_ToolTip"));
        this.quickViewButton.setMnemonic(ResourceUtils.getBundledString("CTL_SEARCH_quickView_Mnemonic").charAt(0));
        this.sourceButton.setToolTipText(ResourceUtils.getBundledString("CTL_SEARCH_showSource_ToolTip"));
        this.sourceButton.setMnemonic(ResourceUtils.getBundledString("CTL_SEARCH_showSource_Mnemonic").charAt(0));
        this.searchComboBox.setToolTipText(ResourceUtils.getBundledString("ACS_SEARCH_SearchComboBoxA11yDesc"));
        this.resultsList.setToolTipText(ResourceUtils.getBundledString("ACS_SEARCH_ResultsListA11yDesc"));
        this.quickBrowser.setToolTipText(ResourceUtils.getBundledString("ACS_SEARCH_QuickBrowserA11yDesc"));
        this.searchButton.setMnemonic(ResourceUtils.getBundledString("CTL_SEARCH_ButtonFind_Mnemonic").charAt(0));
        this.helpButton.setMnemonic(ResourceUtils.getBundledString("CTL_SEARCH_ButtonHelp_Mnemonic").charAt(0));
        this.initAccessibility();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(INDEX_SEARCH_HELP_CTX_KEY);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(ResourceUtils.getBundledString("ACS_SEARCH_PanelA11yName"));
        this.getAccessibleContext().setAccessibleDescription(ResourceUtils.getBundledString("ACS_SEARCH_PanelA11yDesc"));
        this.searchComboBox.getAccessibleContext().setAccessibleName(ResourceUtils.getBundledString("ACS_SEARCH_SearchComboBoxA11yName"));
        this.resultsList.getAccessibleContext().setAccessibleName(ResourceUtils.getBundledString("ACS_SEARCH_ResultsListA11yName"));
        this.quickBrowser.getAccessibleContext().setAccessibleName(ResourceUtils.getBundledString("ACS_SEARCH_QuickBrowserA11yName"));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.searchComboBox = new JComboBox();
        this.searchButton = new JButton();
        this.sourceButton = new JButton();
        this.byNameButton = new JToggleButton();
        this.byReferenceButton = new JToggleButton();
        this.byTypeButton = new JToggleButton();
        this.quickViewButton = new JToggleButton();
        this.helpButton = new JButton();
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        ((JComponent)((Object)this)).setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
        this.jPanel1.setLayout(new GridBagLayout());
        this.searchComboBox.setEditable(true);
        this.searchComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IndexSearch.this.searchComboBoxActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        this.jPanel1.add((Component)this.searchComboBox, gridBagConstraints);
        this.searchButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$javadoc$search$IndexSearch == null ? (class$org$netbeans$modules$javadoc$search$IndexSearch = IndexSearch.class$("org.netbeans.modules.javadoc.search.IndexSearch")) : class$org$netbeans$modules$javadoc$search$IndexSearch)).getString("IndexSearch.searchButton.text"));
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IndexSearch.this.searchButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.jPanel1.add((Component)this.searchButton, gridBagConstraints);
        this.sourceButton.setMinimumSize(new Dimension(25, 25));
        this.sourceButton.setPreferredSize(new Dimension(25, 25));
        this.sourceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IndexSearch.this.showSource(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.jPanel1.add((Component)this.sourceButton, gridBagConstraints);
        this.byNameButton.setSelected(true);
        this.byNameButton.setActionCommand("A");
        this.byNameButton.setMinimumSize(new Dimension(25, 25));
        this.byNameButton.setPreferredSize(new Dimension(25, 25));
        this.byNameButton.setRequestFocusEnabled(false);
        this.byNameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IndexSearch.this.sortButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add((Component)this.byNameButton, new GridBagConstraints());
        this.byReferenceButton.setActionCommand("R");
        this.byReferenceButton.setMinimumSize(new Dimension(25, 25));
        this.byReferenceButton.setPreferredSize(new Dimension(25, 25));
        this.byReferenceButton.setRequestFocusEnabled(false);
        this.byReferenceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IndexSearch.this.sortButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add((Component)this.byReferenceButton, new GridBagConstraints());
        this.byTypeButton.setActionCommand("T");
        this.byTypeButton.setMinimumSize(new Dimension(25, 25));
        this.byTypeButton.setPreferredSize(new Dimension(25, 25));
        this.byTypeButton.setRequestFocusEnabled(false);
        this.byTypeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IndexSearch.this.sortButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add((Component)this.byTypeButton, new GridBagConstraints());
        this.quickViewButton.setSelected(true);
        this.quickViewButton.setRequestFocusEnabled(false);
        this.quickViewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IndexSearch.this.quickViewButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel1.add((Component)this.quickViewButton, gridBagConstraints);
        this.helpButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$javadoc$search$IndexSearch == null ? (class$org$netbeans$modules$javadoc$search$IndexSearch = IndexSearch.class$("org.netbeans.modules.javadoc.search.IndexSearch")) : class$org$netbeans$modules$javadoc$search$IndexSearch)).getString("CTL_SEARCH_ButtonHelp"));
        this.helpButton.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$modules$javadoc$search$IndexSearch == null ? (class$org$netbeans$modules$javadoc$search$IndexSearch = IndexSearch.class$("org.netbeans.modules.javadoc.search.IndexSearch")) : class$org$netbeans$modules$javadoc$search$IndexSearch)).getString("CTL_SEARCH_ButtonHelp_tooltip"));
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IndexSearch.this.helpButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel1.add((Component)this.helpButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        ((Container)((Object)this)).add(this.jPanel1, gridBagConstraints);
    }

    private void helpButtonActionPerformed(ActionEvent actionEvent) {
        TopManager.getDefault().showHelp(this.getHelpCtx());
    }

    private void showSource(ActionEvent actionEvent) {
        this.showSource();
    }

    private void sortButtonActionPerformed(ActionEvent actionEvent) {
        this.currentSort = actionEvent.getActionCommand();
        this.ds.setIdxSearchSort(this.currentSort);
        this.sortResults();
    }

    private void quickViewButtonActionPerformed(ActionEvent actionEvent) {
        if (this.quickViewButton.isSelected()) {
            this.splitPanel.setSplitPosition(this.oldSplit == 100 ? 50 : this.oldSplit);
            this.ds.setIdxSearchSplit(this.oldSplit == 100 ? 50 : this.oldSplit);
            this.ds.setIdxSearchNoHtml(false);
            this.showHelp(true);
        } else {
            this.oldSplit = this.splitPanel.getSplitPosition();
            this.splitPanel.setSplitPosition(100);
            this.ds.setIdxSearchSplit(100);
            this.ds.setIdxSearchNoHtml(true);
        }
    }

    private void resultsListKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32) {
            this.showHelp();
        }
    }

    private void resultsListMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            if (mouseEvent.isShiftDown()) {
                this.showSource();
                mouseEvent.consume();
            } else {
                this.showHelp();
            }
        }
    }

    private void showHelp() {
        this.showHelp(false);
    }

    private void showHelp(boolean bl) {
        if (bl && this.splitPanel.getSplitPosition() == 100) {
            return;
        }
        if (this.resultsList.getMinSelectionIndex() < 0) {
            return;
        }
        DocIndexItem docIndexItem = (DocIndexItem)this.resultsList.getModel().getElementAt(this.resultsList.getMinSelectionIndex());
        try {
            URL uRL = docIndexItem.getURL();
            if (uRL == null) {
                return;
            }
            String string = uRL.toString();
            if (string.startsWith("nbfs:") && string.charAt(5) != '/') {
                uRL = new URL("nbfs:/" + string.substring(5));
            }
            if (bl) {
                final URL uRL2 = uRL;
                if (this.task != null) {
                    this.task.cancel();
                }
                this.task = RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        IndexSearch.this.quickBrowser.setURL(uRL2);
                    }
                }, 100);
            } else {
                TopManager.getDefault().showUrl(uRL);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void showSource() {
        if (this.resultsList.getMinSelectionIndex() < 0) {
            return;
        }
        DocIndexItem docIndexItem = (DocIndexItem)this.resultsList.getModel().getElementAt(this.resultsList.getMinSelectionIndex());
        try {
            Element element = SrcFinder.findSource(docIndexItem.getPackage(), docIndexItem.getURL());
            if (element != null) {
                OpenCookie openCookie = (OpenCookie)element.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = IndexSearch.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
                if (openCookie != null) {
                    openCookie.open();
                } else {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)ResourceUtils.getBundledString("MSG_SEARCH_SrcNotFound"));
                    TopManager.getDefault().notify((NotifyDescriptor)message);
                }
            } else {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)ResourceUtils.getBundledString("MSG_SEARCH_SrcNotFound"));
                TopManager.getDefault().notify((NotifyDescriptor)message);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void searchComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void searchButtonActionPerformed(ActionEvent actionEvent) {
        if (this.searchEngine == null) {
            if (this.searchComboBox.getEditor().getItem().toString() != null && this.searchComboBox.getEditor().getItem().toString().length() > 0) {
                this.searchEngine = JavadocSearchEngine.getDefault();
                this.go();
            }
        } else {
            this.searchEngine.stop();
            this.searchEngine = null;
        }
    }

    private void searchStoped() {
        this.searchEngine = null;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IndexSearch.this.searchButton.setText(STR_FIND);
                IndexSearch.this.searchButton.setMnemonic(ResourceUtils.getBundledString("CTL_SEARCH_ButtonFind_Mnemonic").charAt(0));
                if (IndexSearch.this.resultsList.getModel().getSize() > 0) {
                    IndexSearch.this.resultsList.setSelectedIndex(0);
                    IndexSearch.this.resultsList.grabFocus();
                }
                IndexSearch.this.referenceModel = (IndexSearch.this.typeModel = (IndexSearch.this.alphaModel = null));
                IndexSearch.this.sortResults();
            }
        });
    }

    void setTextToFind(String string) {
        this.quickFind = string;
    }

    public void open() {
        super.open();
        if (this.quickFind != null) {
            this.searchComboBox.getEditor().setItem(this.quickFind);
            if (this.searchEngine == null) {
                this.searchButtonActionPerformed(null);
            }
        }
        this.quickFind = null;
        this.searchComboBox.getEditor().selectAll();
    }

    Dimension getPrefferedSize() {
        return PREFFERED_SIZE;
    }

    public static IndexSearch getDefault() {
        if (indexSearch == null) {
            indexSearch = new IndexSearch();
            Workspace workspace = WindowManager.getDefault().getCurrentWorkspace();
            JavadocModule.registerTopComponent(indexSearch);
            indexSearch.setName(ResourceUtils.getBundledString("CTL_SEARCH_WindowTitle"));
        }
        indexSearch.setIcon(windowIcon);
        return indexSearch;
    }

    public void resolveButtonState() {
        final String string = this.ds.getIdxSearchSort();
        final boolean bl = this.ds.isIdxSearchNoHtml();
        final int n = this.ds.getIdxSearchSplit();
        this.currentSort = string;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IndexSearch.this.byNameButton.setSelected(string.equals("A"));
                IndexSearch.this.byReferenceButton.setSelected(string.equals("R"));
                IndexSearch.this.byTypeButton.setSelected(string.equals("T"));
                IndexSearch.this.quickViewButton.setSelected(!bl);
                IndexSearch.this.splitPanel.setSplitPosition(n);
            }
        });
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        indexSearch = this;
        this.resolveButtonState();
        indexSearch = IndexSearch.getDefault();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
    }

    void go() {
        String string = new String(this.searchComboBox.getEditor().getItem().toString());
        this.results = new ArrayList();
        this.referenceModel = null;
        this.typeModel = null;
        this.alphaModel = null;
        int n = 0;
        while (n < this.searchComboBox.getItemCount()) {
            if (this.searchComboBox.getItemAt(n).toString().equals(string) || n >= 10) {
                this.searchComboBox.removeItemAt(n);
            }
            ++n;
        }
        this.searchComboBox.insertItemAt(string, 0);
        this.searchComboBox.getEditor().setItem(string);
        this.resultsList.setModel(waitModel);
        try {
            this.searchEngine.search(new String[]{string}, new JavadocSearchEngine.SearchEngineCallback(){

                public void finished() {
                    IndexSearch.this.searchStoped();
                }

                public void addItem(DocIndexItem docIndexItem) {
                    IndexSearch.this.results.add(docIndexItem);
                }
            });
        }
        catch (NoJavadocException noJavadocException) {
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)noJavadocException.getMessage()));
            this.searchStoped();
            return;
        }
        this.searchButton.setText(STR_STOP);
        this.searchButton.setMnemonic(ResourceUtils.getBundledString("CTL_SEARCH_ButtonStop_Mnemonic").charAt(0));
    }

    DefaultListModel generateModel(Comparator comparator) {
        DefaultListModel<DocIndexItem> defaultListModel = new DefaultListModel<DocIndexItem>();
        Collections.sort(this.results, comparator);
        Iterator iterator = ((AbstractList)this.results).iterator();
        String string = null;
        while (iterator.hasNext()) {
            DocIndexItem docIndexItem = (DocIndexItem)iterator.next();
            if (comparator == DocIndexItem.REFERENCE_COMPARATOR && !docIndexItem.getPackage().equals(string) && docIndexItem.getIconIndex() != 1) {
                DocIndexItem docIndexItem2 = new DocIndexItem("PACKAGE ", docIndexItem.getPackage(), null, "");
                docIndexItem2.setIconIndex(1);
                defaultListModel.addElement(docIndexItem2);
                string = docIndexItem.getPackage();
            }
            defaultListModel.addElement(docIndexItem);
        }
        return defaultListModel;
    }

    void sortResults() {
        if (this.results.size() < 1) {
            this.resultsList.setModel(notModel);
        } else if (this.currentSort.equals("R")) {
            if (this.referenceModel == null) {
                this.resultsList.setModel(waitModel);
                this.resultsList.invalidate();
                this.resultsList.revalidate();
                this.referenceModel = this.generateModel(DocIndexItem.REFERENCE_COMPARATOR);
            }
            this.resultsList.setModel(this.referenceModel);
        } else if (this.currentSort.equals("T")) {
            if (this.typeModel == null) {
                this.resultsList.setModel(waitModel);
                this.resultsList.invalidate();
                this.resultsList.revalidate();
                this.typeModel = this.generateModel(DocIndexItem.TYPE_COMPARATOR);
            }
            this.resultsList.setModel(this.typeModel);
        } else if (this.currentSort.equals("A")) {
            if (this.alphaModel == null) {
                this.resultsList.setModel(waitModel);
                this.resultsList.invalidate();
                this.resultsList.revalidate();
                this.alphaModel = this.generateModel(DocIndexItem.ALPHA_COMPARATOR);
            }
            this.resultsList.setModel(this.alphaModel);
        }
        this.resultsList.invalidate();
        this.resultsList.revalidate();
        this.resultsList.repaint();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        refSortIcon = new ImageIcon((class$org$netbeans$modules$javadoc$search$IndexSearch == null ? (class$org$netbeans$modules$javadoc$search$IndexSearch = IndexSearch.class$("org.netbeans.modules.javadoc.search.IndexSearch")) : class$org$netbeans$modules$javadoc$search$IndexSearch).getResource("/org/netbeans/modules/javadoc/resources/refSort.gif"));
        typeSortIcon = new ImageIcon((class$org$netbeans$modules$javadoc$search$IndexSearch == null ? (class$org$netbeans$modules$javadoc$search$IndexSearch = IndexSearch.class$("org.netbeans.modules.javadoc.search.IndexSearch")) : class$org$netbeans$modules$javadoc$search$IndexSearch).getResource("/org/netbeans/modules/javadoc/resources/typeSort.gif"));
        alphaSortIcon = new ImageIcon((class$org$netbeans$modules$javadoc$search$IndexSearch == null ? (class$org$netbeans$modules$javadoc$search$IndexSearch = IndexSearch.class$("org.netbeans.modules.javadoc.search.IndexSearch")) : class$org$netbeans$modules$javadoc$search$IndexSearch).getResource("/org/netbeans/modules/javadoc/resources/alphaSort.gif"));
        listOnlyIcon = new ImageIcon((class$org$netbeans$modules$javadoc$search$IndexSearch == null ? (class$org$netbeans$modules$javadoc$search$IndexSearch = IndexSearch.class$("org.netbeans.modules.javadoc.search.IndexSearch")) : class$org$netbeans$modules$javadoc$search$IndexSearch).getResource("/org/netbeans/modules/javadoc/resources/list_only.gif"));
        listHtmlIcon = new ImageIcon((class$org$netbeans$modules$javadoc$search$IndexSearch == null ? (class$org$netbeans$modules$javadoc$search$IndexSearch = IndexSearch.class$("org.netbeans.modules.javadoc.search.IndexSearch")) : class$org$netbeans$modules$javadoc$search$IndexSearch).getResource("/org/netbeans/modules/javadoc/resources/list_html.gif"));
        showSourceIcon = new ImageIcon((class$org$netbeans$modules$javadoc$search$IndexSearch == null ? (class$org$netbeans$modules$javadoc$search$IndexSearch = IndexSearch.class$("org.netbeans.modules.javadoc.search.IndexSearch")) : class$org$netbeans$modules$javadoc$search$IndexSearch).getResource("/org/netbeans/modules/javadoc/resources/showSource.gif"));
        windowIcon = Toolkit.getDefaultToolkit().getImage((class$org$netbeans$modules$javadoc$search$IndexSearch == null ? (class$org$netbeans$modules$javadoc$search$IndexSearch = IndexSearch.class$("org.netbeans.modules.javadoc.search.IndexSearch")) : class$org$netbeans$modules$javadoc$search$IndexSearch).getResource(ICON_RESOURCE));
        STR_FIND = ResourceUtils.getBundledString("CTL_SEARCH_ButtonFind");
        STR_STOP = ResourceUtils.getBundledString("CTL_SEARCH_ButtonStop");
        waitModel = new DefaultListModel();
        notModel = new DefaultListModel();
        DocIndexItem docIndexItem = new DocIndexItem(ResourceUtils.getBundledString("CTL_SEARCH_Wait"), "", null, "");
        docIndexItem.setIconIndex(12);
        waitModel.addElement(docIndexItem);
        DocIndexItem docIndexItem2 = new DocIndexItem(ResourceUtils.getBundledString("CTL_SEARCH_NotFound"), "", null, "");
        docIndexItem2.setIconIndex(11);
        notModel.addElement(docIndexItem2);
    }
}

