/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.util.StringTokenizer;
import org.netbeans.modules.javadoc.search.DocIndexItem;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public abstract class IndexSearchThread
extends Thread {
    protected FileObject fo;
    private DocIndexItemConsumer ddiConsumer;
    RequestProcessor.Task rpTask = null;
    protected boolean caseSensitive;
    protected String lastField = "";
    protected String middleField = "";
    protected String reminder = "";
    private int tokens = 0;
    private String lastAdd = "";
    private String lastDeclaring = "";

    abstract void stopSearch();

    public IndexSearchThread(String string, FileObject fileObject, DocIndexItemConsumer docIndexItemConsumer, boolean bl) {
        this.ddiConsumer = docIndexItemConsumer;
        this.fo = fileObject;
        this.caseSensitive = bl;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        this.tokens = stringTokenizer.countTokens();
        if (this.tokens > 1) {
            if (this.tokens == 2) {
                this.middleField = stringTokenizer.nextToken();
                this.lastField = stringTokenizer.nextToken();
            } else {
                int n = 0;
                while (n < this.tokens - 2) {
                    this.reminder = this.reminder + stringTokenizer.nextToken();
                    if (n + 1 < this.tokens - 2) {
                        this.reminder = this.reminder + '.';
                    }
                    ++n;
                }
                this.middleField = stringTokenizer.nextToken();
                this.lastField = stringTokenizer.nextToken();
            }
        } else {
            this.lastField = string;
        }
        if (!bl) {
            this.reminder = this.reminder.toUpperCase();
            this.middleField = this.middleField.toUpperCase();
            this.lastField = this.lastField.toUpperCase();
        }
    }

    protected synchronized void insertDocIndexItem(DocIndexItem docIndexItem) {
        String string = docIndexItem.getField();
        String string2 = docIndexItem.getDeclaringClass();
        String string3 = docIndexItem.getPackage();
        if (!this.caseSensitive) {
            string = string.toUpperCase();
            string2 = string2.toUpperCase();
            string3 = string3.toUpperCase();
        }
        if (this.tokens < 2) {
            if (string.startsWith(this.lastField)) {
                if (!this.lastAdd.equals(string) || !this.lastDeclaring.equals(string2)) {
                    this.ddiConsumer.addDocIndexItem(docIndexItem);
                    this.lastAdd = string;
                    this.lastDeclaring = string2;
                }
            } else if (string2.startsWith(this.lastField) && docIndexItem.getIconIndex() == 2) {
                if (!this.lastAdd.equals(string2)) {
                    this.ddiConsumer.addDocIndexItem(docIndexItem);
                    this.lastAdd = string2;
                }
            } else if (string3.startsWith(this.lastField + '.') && docIndexItem.getIconIndex() == 1 && !this.lastAdd.equals(string3)) {
                this.ddiConsumer.addDocIndexItem(docIndexItem);
                this.lastAdd = string3;
            }
        } else if (this.tokens == 2) {
            if (string.startsWith(this.lastField) && string2.equals(this.middleField)) {
                this.ddiConsumer.addDocIndexItem(docIndexItem);
            } else if (string3.startsWith(this.middleField) && string2.equals(this.lastField)) {
                this.ddiConsumer.addDocIndexItem(docIndexItem);
            } else if (string3.startsWith(this.middleField + '.' + this.lastField) && docIndexItem.getIconIndex() == 1) {
                this.ddiConsumer.addDocIndexItem(docIndexItem);
            }
        } else if (string.startsWith(this.lastField) && string2.equals(this.middleField) && string3.startsWith(this.reminder)) {
            this.ddiConsumer.addDocIndexItem(docIndexItem);
        } else if (string2.startsWith(this.lastField) && string3.equals(this.reminder + '.' + this.middleField + '.')) {
            this.ddiConsumer.addDocIndexItem(docIndexItem);
        } else if (string3.startsWith(this.reminder + '.' + this.middleField + '.' + this.lastField) && docIndexItem.getIconIndex() == 1) {
            this.ddiConsumer.addDocIndexItem(docIndexItem);
        }
    }

    public void go() {
        this.rpTask = RequestProcessor.getDefault().post((Runnable)this, 0, 5);
    }

    public void finish() {
        if (!this.rpTask.isFinished() && !this.rpTask.cancel()) {
            this.stopSearch();
        }
        this.taskFinished();
    }

    public void taskFinished() {
        this.ddiConsumer.indexSearchThreadFinished(this);
    }

    public static interface DocIndexItemConsumer {
        public void addDocIndexItem(DocIndexItem var1);

        public void indexSearchThreadFinished(IndexSearchThread var1);
    }
}

