/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.generator;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.netbeans.modules.xml.core.XMLDataObject;
import org.netbeans.modules.xml.tools.generator.SelectFileDialog;
import org.netbeans.modules.xml.tools.generator.Util;
import org.netbeans.modules.xml.tools.generator.XMLGenerateCookie;
import org.netbeans.modules.xml.tools.lib.GuiUtil;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeCDATASection;
import org.netbeans.tax.TreeDocument;
import org.netbeans.tax.TreeDocumentType;
import org.netbeans.tax.TreeElement;
import org.netbeans.tax.TreeEntityReference;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeNamedObjectMap;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeText;
import org.netbeans.tax.TreeUtilities;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.UserCancelException;

public class GenerateDTDSupport
implements XMLGenerateCookie {
    static final String DTD_EXT = "dtd";
    DataObject DO;
    TreeElement element;

    public GenerateDTDSupport(XMLDataObject DO) {
        this.DO = DO;
        this.element = null;
    }

    public void generate() {
        try {
            FileLock lock;
            FileObject generFile;
            String name;
            block15: {
                TreeDocument treeDoc = (TreeDocument)((XMLDataObject)this.DO).getDocumentRoot();
                if (treeDoc == null) {
                    return;
                }
                if (this.element == null) {
                    this.element = treeDoc.getDocumentElement();
                }
                if (this.element == null) {
                    return;
                }
                FileObject primFile = this.DO.getPrimaryFile();
                name = primFile.getName() + "_" + this.element.getLocalName();
                FileObject folder = primFile.getParent();
                generFile = new SelectFileDialog(folder, name, DTD_EXT).getFileObject();
                name = generFile.getName();
                String encoding = null;
                try {
                    encoding = this.element.getOwnerDocument().getEncoding();
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                String dtd = this.xml2dtd(this.element, name, encoding);
                lock = null;
                Writer writer = null;
                try {
                    lock = generFile.lock();
                    encoding = TreeUtilities.iana2java((String)(encoding == null ? "UTF-8" : encoding));
                    OutputStream output = generFile.getOutputStream(lock);
                    try {
                        writer = new OutputStreamWriter(output, encoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        writer = new OutputStreamWriter(output);
                    }
                    writer = new PrintWriter(writer);
                    writer.write(dtd.toString());
                    lock.releaseLock();
                    Object var13_15 = null;
                    if (writer == null) break block15;
                }
                catch (Throwable throwable) {
                    Object var13_16 = null;
                    if (writer != null) {
                        writer.close();
                    }
                    if (lock != null) {
                        lock.releaseLock();
                    }
                    throw throwable;
                }
                writer.close();
            }
            if (lock != null) {
                lock.releaseLock();
            }
            this.trySetDocumentType(name);
            GuiUtil.performDefaultAction(generFile);
        }
        catch (UserCancelException e) {
        }
        catch (Exception exc) {
            GuiUtil.notifyException(exc);
        }
    }

    private void trySetDocumentType(String fileName) {
        if (this.element.getParentNode() instanceof TreeDocument) {
            TreeDocument document = (TreeDocument)this.element.getParentNode();
            if (GuiUtil.confirmAction(Util.THIS.getString("MSG_use_dtd_as_document_type?"))) {
                try {
                    TreeDocumentType newDoctype = new TreeDocumentType(this.element.getQName(), null, fileName + "." + DTD_EXT);
                    document.setDocumentType(newDoctype);
                }
                catch (TreeException exc) {
                    GuiUtil.notifyTreeException(exc);
                }
            }
        }
    }

    String xml2dtd(TreeElement element, String name, String encoding) {
        StringBuffer sb = new StringBuffer();
        if (encoding != null) {
            sb.append("<?xml version='1.0' encoding='").append(encoding).append("'?>\n\n");
        }
        String tagName = element.getQName();
        sb.append("<!--\n").append("    Typical usage:\n\n").append("    <?xml version=\"1.0\"?>\n\n").append("    <!DOCTYPE ").append(tagName).append(" SYSTEM \"").append(name).append(".").append(DTD_EXT).append("\">\n\n").append("    <").append(tagName).append(">\n    ...\n").append("    </").append(tagName).append(">\n").append("-->\n");
        TreeMap table = new TreeMap();
        this.fillTable(element, table);
        Iterator I = table.values().iterator();
        while (I.hasNext()) {
            sb.append("\n");
            DTDElement elem = (DTDElement)I.next();
            sb.append(Util.THIS.getString("FMT_DTDDoc") + "\n");
            sb.append("<!ELEMENT ").append(elem.name).append(" ");
            if (elem.empty) {
                sb.append("EMPTY");
            } else {
                Collection collect = elem.children.values();
                if (elem.pcdata || collect.size() == 0) {
                    Vector vect = new Vector(collect);
                    vect.insertElementAt(new String("#PCDATA"), 0);
                    collect = vect;
                }
                Iterator I2 = collect.iterator();
                String elemName = (String)I2.next();
                sb.append("(").append(elemName);
                while (I2.hasNext()) {
                    elemName = (String)I2.next();
                    sb.append("|").append(elemName);
                }
                if (!sb.toString().endsWith("#PCDATA")) {
                    sb.append(")*");
                } else {
                    sb.append(")");
                }
            }
            sb.append(">\n");
            if (elem.attributes.size() == 0) continue;
            sb.append("<!ATTLIST ").append(elem.name).append("\n");
            Iterator I3 = elem.attributes.values().iterator();
            while (I3.hasNext()) {
                String attName = (String)I3.next();
                sb.append("    ").append(attName).append(" CDATA #IMPLIED\n");
            }
            sb.append("  >\n");
        }
        return sb.toString();
    }

    void fillTable(TreeElement element, Map table) {
        String name = element.getQName();
        Iterator nodes = element.getChildNodes().iterator();
        TreeNamedObjectMap attrs = element.getAttributes();
        DTDElement dtdElem = (DTDElement)table.get(name);
        if (dtdElem == null) {
            dtdElem = new DTDElement(name);
            table.put(name, dtdElem);
        }
        int i = 0;
        while (i < attrs.size()) {
            dtdElem.addAttribute(((TreeAttribute)attrs.get(i)).getQName());
            ++i;
        }
        if (nodes.hasNext()) {
            dtdElem.notEmpty();
            while (nodes.hasNext()) {
                TreeText text;
                String data;
                TreeNode node = (TreeNode)nodes.next();
                if (node instanceof TreeElement) {
                    TreeElement elem = (TreeElement)node;
                    dtdElem.addChild(elem.getQName());
                    this.fillTable(elem, table);
                    continue;
                }
                if (node instanceof TreeCDATASection) {
                    dtdElem.hasPCDATA();
                    continue;
                }
                if (node instanceof TreeEntityReference) {
                    dtdElem.hasPCDATA();
                    continue;
                }
                if (!(node instanceof TreeText) || dtdElem.isTextAllowed() || this.wsOnly(data = (text = (TreeText)node).getData())) continue;
                dtdElem.hasPCDATA();
            }
        }
    }

    private boolean wsOnly(String s) {
        if (s == null) {
            return true;
        }
        char[] data = s.toCharArray();
        int i = 0;
        while (i < data.length) {
            if (!Character.isWhitespace(data[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private class DTDElement {
        String name;
        HashMap children;
        HashMap attributes;
        boolean pcdata;
        boolean empty;

        public DTDElement(String name) {
            this.name = name;
            this.children = new HashMap();
            this.attributes = new HashMap();
            this.pcdata = false;
            this.empty = true;
        }

        public void hasPCDATA() {
            this.pcdata = true;
        }

        public void notEmpty() {
            this.empty = false;
        }

        public boolean isTextAllowed() {
            return this.pcdata;
        }

        public void addChild(String child) {
            this.children.put(child, child);
        }

        public void addAttribute(String attr) {
            this.attributes.put(attr, attr);
        }
    }
}

