/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.generator;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.xml.tools.generator.Util;
import org.netbeans.modules.xml.tools.lib.GuiUtil;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.UserCancelException;

public class SelectFileDialog
extends JPanel {
    private static final long serialVersionUID = 4699298946223454165L;
    private Util.NameCheck check;
    private JLabel fileLabel;
    private JTextField fileField;
    private JPanel fillPanel;
    DialogDescriptor selectDD;
    FileObject folder;
    String name;
    String ext;

    public SelectFileDialog(FileObject folder, String name, String ext) {
        this(folder, name, ext, Util.JAVA_CHECK);
    }

    public SelectFileDialog(FileObject folder, String name, String ext, Util.NameCheck check) {
        this.folder = folder;
        this.name = name;
        this.ext = ext;
        this.check = check;
        this.selectDD = new DialogDescriptor((Object)this, Util.THIS.getString("PROP_fileNameTitle") + " *." + ext, true, 2, NotifyDescriptor.OK_OPTION, 0, null, null);
        this.initComponents();
        this.fileLabel.setDisplayedMnemonic(Util.THIS.getChar("PROP_fileName_mne"));
        this.ownInitComponents();
        this.initAccessibility();
    }

    private void ownInitComponents() {
        this.fileField.setText(this.name);
        this.updateDialogUI();
    }

    private void initComponents() {
        this.fileLabel = new JLabel();
        this.fileField = new JTextField();
        this.fillPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.fileLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/xml/tools/generator/Bundle").getString("PROP_fileName"));
        this.fileLabel.setLabelFor(this.fileField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.fileLabel, gridBagConstraints);
        this.fileField.setColumns(20);
        this.fileField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectFileDialog.this.fileFieldActionPerformed(evt);
            }
        });
        this.fileField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                SelectFileDialog.this.fileFieldFocusGained(evt);
            }
        });
        this.fileField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                SelectFileDialog.this.fileFieldKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.fileField, gridBagConstraints);
        this.fillPanel.setPreferredSize(new Dimension(0, 0));
        this.fillPanel.setMinimumSize(new Dimension(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fillPanel, gridBagConstraints);
    }

    private void fileFieldFocusGained(FocusEvent evt) {
        this.fileField.selectAll();
    }

    private void fileFieldKeyReleased(KeyEvent evt) {
        this.updateDialogUI();
    }

    private void fileFieldActionPerformed(ActionEvent evt) {
        this.updateDialogUI();
    }

    private void updateDialogUI() {
    }

    private void enableOkOption(boolean enable) {
    }

    public FileObject getFileObject() throws IOException {
        FileObject newFO = null;
        while (newFO == null) {
            TopManager.getDefault().createDialog(this.selectDD).show();
            if (this.selectDD.getValue() != NotifyDescriptor.OK_OPTION) {
                throw new UserCancelException();
            }
            final String newName = this.fileField.getText();
            newFO = this.folder.getFileObject(newName, this.ext);
            if (newFO == null || newFO.isVirtual()) {
                FileSystem fs = this.folder.getFileSystem();
                final FileObject tempFile = newFO;
                fs.runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        block3: {
                            if (tempFile != null && tempFile.isVirtual()) {
                                tempFile.delete();
                            }
                            try {
                                SelectFileDialog.this.folder.createData(newName, SelectFileDialog.this.ext);
                            }
                            catch (IOException exc) {
                                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)Util.THIS.getString("MSG_cannot_create_data", newName + "." + SelectFileDialog.this.ext), 2);
                                TopManager.getDefault().notify((NotifyDescriptor)desc);
                                if (!Util.THIS.isLoggable()) break block3;
                                Util.THIS.debug(exc);
                            }
                        }
                    }
                });
                newFO = this.folder.getFileObject(newName, this.ext);
                continue;
            }
            if (newFO == null || GuiUtil.confirmAction(MessageFormat.format(Util.THIS.getString("PROP_replaceMsg"), newName, this.ext))) continue;
            throw new UserCancelException();
        }
        return newFO;
    }

    public void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_SelectFileDialog"));
        this.fileField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_fileField"));
    }
}

