/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.netbeans.modules.welcome.WelcomeEditor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class TipPanel
extends JPanel {
    static final long serialVersionUID = 6021472310161012572L;
    private ResourceBundle bundle;
    private List tips;
    private WelcomeEditor tipsBrowser;
    private JScrollPane scroll;
    private int index;
    private static final String TIPS_FOLDER = "TipsOfTheDay";
    static /* synthetic */ Class class$org$netbeans$modules$welcome$HelpPanel;
    static /* synthetic */ Class class$org$netbeans$modules$welcome$TipPanel;

    public TipPanel() {
        super(new BorderLayout());
        this.setSize(148, 180);
        this.scroll = new JScrollPane();
        this.tipsBrowser = new WelcomeEditor();
        this.tipsBrowser.setEditable(false);
        this.tipsBrowser.setBackground(new Color(231, 236, 251));
        this.tipsBrowser.setEditorKit(new TipHtmlEditorKit());
        this.tipsBrowser.setBorder(new EmptyBorder(2, 4, 2, 2));
        this.tipsBrowser.setSize(148, 180);
        this.tipsBrowser.setPreferredSize(new Dimension(148, 180));
        this.findTips();
        this.showTip(this.getTipIndex());
        this.scroll.setViewportView(this.tipsBrowser);
        this.scroll.setSize(148, 180);
        this.scroll.setPreferredSize(new Dimension(148, 180));
        this.scroll.setVerticalScrollBarPolicy(20);
        this.add((Component)this.scroll, "Center");
        JButton jButton = new JButton("Next");
        jButton.setFont(new Font("Lucida Sans", 0, 10));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TipPanel.this.setNext();
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jButton, "East");
        jPanel.setBackground(Color.white);
        this.add((Component)jPanel, "South");
        this.bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$welcome$HelpPanel == null ? (class$org$netbeans$modules$welcome$HelpPanel = TipPanel.class$("org.netbeans.modules.welcome.HelpPanel")) : class$org$netbeans$modules$welcome$HelpPanel));
        this.initAccessibility();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$welcome$TipPanel == null ? (class$org$netbeans$modules$welcome$TipPanel = TipPanel.class$("org.netbeans.modules.welcome.TipPanel")) : class$org$netbeans$modules$welcome$TipPanel), (String)"ACS_Tip_DESC"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$modules$welcome$TipPanel == null ? (class$org$netbeans$modules$welcome$TipPanel = TipPanel.class$("org.netbeans.modules.welcome.TipPanel")) : class$org$netbeans$modules$welcome$TipPanel), (String)"ACS_Tip"));
    }

    private void findTips() {
        block6: {
            this.tips = new ArrayList(50);
            try {
                FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(TIPS_FOLDER);
                if (fileObject == null) break block6;
                DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
                DataObject[] dataObjectArray = dataFolder.getChildren();
                int n = 0;
                while (n < dataObjectArray.length) {
                    FileObject fileObject2 = dataObjectArray[n].getPrimaryFile();
                    if (fileObject2.hasExt("html")) {
                        try {
                            this.tips.add(fileObject2.getURL());
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {
                            this.tipsBrowser.setText(fileStateInvalidException.getMessage());
                        }
                    }
                    ++n;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private void showTip(int n) {
        URL uRL = (URL)this.tips.get(n);
        try {
            this.tipsBrowser.setPage(uRL);
        }
        catch (Exception exception) {
            this.tipsBrowser.setText(exception.getMessage());
        }
    }

    private int getTipIndex() {
        this.index = 0;
        do {
            this.index = (int)((double)this.index + (double)this.tips.size() * Math.random());
        } while (this.index > this.tips.size());
        return this.index;
    }

    public void setNext() {
        this.index = this.index == this.tips.size() - 1 ? 0 : ++this.index;
        this.showTip(this.index);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TipHtmlEditorKit
    extends HTMLEditorKit {
        private StyleSheet defaultStyles = null;

        public TipHtmlEditorKit() {
            StyleSheet styleSheet = new StyleSheet();
            styleSheet.addStyleSheet(super.getStyleSheet());
            styleSheet.importStyleSheet(this.getClass().getResource("tip.css"));
            this.setStyleSheet(styleSheet);
        }

        public void setStyleSheet(StyleSheet styleSheet) {
            this.defaultStyles = styleSheet;
        }

        public StyleSheet getStyleSheet() {
            return this.defaultStyles;
        }
    }
}

