/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import org.openide.TopManager;

public class TrailingFileInputStream
extends FileInputStream {
    static final long DEFAULT_POLLING_INTERVAL = 500L;
    private long pollingInterval = 500L;

    public void setPollingInterval(long l) {
        this.pollingInterval = l;
    }

    public long getPollingInterval() {
        return this.pollingInterval;
    }

    public TrailingFileInputStream(String string) throws FileNotFoundException {
        super(string);
        try {
            while (this.available() > 1) {
                this.skip(this.available() - 1);
            }
        }
        catch (IOException iOException) {
            TopManager.getDefault().getErrorManager().notify(4096, (Throwable)iOException);
        }
    }

    public TrailingFileInputStream(File file) throws FileNotFoundException {
        super(file);
        try {
            while (this.available() > 1) {
                this.skip(this.available() - 1);
            }
        }
        catch (IOException iOException) {
            TopManager.getDefault().getErrorManager().notify(4096, (Throwable)iOException);
        }
    }

    public int read() throws IOException {
        try {
            while (this.available() <= 1) {
                Thread.sleep(this.pollingInterval);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return super.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            while (this.available() <= 1) {
                Thread.sleep(this.pollingInterval);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n3 = this.available() - 1;
        if (n3 > byArray.length - n) {
            n3 = byArray.length - n;
        }
        if (n3 > n2) {
            n3 = n2;
        }
        return super.read(byArray, n, n3);
    }

    public static void main(String[] stringArray) {
        try {
            TrailingFileInputStream trailingFileInputStream = new TrailingFileInputStream(new File("/tmp/Test.txt"));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(trailingFileInputStream));
            while (true) {
                String string = bufferedReader.readLine();
                System.out.println(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

