/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.text.syntax.javacc.lib;

import java.io.EOFException;
import java.io.IOException;
import org.netbeans.modules.css.text.syntax.javacc.lib.CharStream;

public class StringParserInput
implements CharStream {
    private char[] buffer;
    private int pos;
    private int begin;
    private int len;
    private int end;

    public void setString(String s) {
        this.buffer = s.toCharArray();
        this.pos = 0;
        this.begin = 0;
        this.end = this.len = s.length();
    }

    public void setBuffer(char[] buf, int offset, int len) {
        this.buffer = buf;
        this.begin = this.pos = offset;
        this.len = len;
        this.end = offset + len;
    }

    public char readChar() throws IOException {
        if (this.pos >= this.end) {
            throw new EOFException();
        }
        return this.buffer[this.pos++];
    }

    public int getColumn() {
        return 0;
    }

    public int getLine() {
        return 0;
    }

    public int getEndColumn() {
        return 0;
    }

    public int getEndLine() {
        return 0;
    }

    public int getBeginColumn() {
        return 0;
    }

    public int getBeginLine() {
        return 0;
    }

    public void backup(int amount) {
        if (this.pos > 1) {
            this.pos -= amount;
        }
    }

    public char BeginToken() throws IOException {
        this.begin = this.pos;
        return this.readChar();
    }

    public String GetImage() {
        return new String(this.buffer, this.begin, this.pos - this.begin);
    }

    public int getLength() {
        return this.pos - this.begin;
    }

    public char[] GetSuffix(int l) {
        char[] ret = new char[l];
        System.arraycopy(this.buffer, this.pos - l, ret, 0, l);
        return ret;
    }

    public void Done() {
    }

    public String toString() {
        return "StringParserInput\n Pos:" + this.pos + " len:" + this.len + " #################\n" + this.buffer;
    }
}

