/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dtd;

import java.util.Hashtable;
import org.apache.xerces.impl.dtd.Grammar;
import org.apache.xerces.impl.dtd.XMLAttributeDecl;
import org.apache.xerces.impl.dtd.XMLContentSpec;
import org.apache.xerces.impl.dtd.XMLElementDecl;
import org.apache.xerces.impl.dtd.XMLEntityDecl;
import org.apache.xerces.impl.dtd.XMLNotationDecl;
import org.apache.xerces.impl.dtd.XMLSimpleType;
import org.apache.xerces.impl.dv.dtd.DatatypeValidatorFactory;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLDTDContentModelHandler;
import org.apache.xerces.xni.XMLDTDHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;

public class DTDGrammar
extends Grammar
implements XMLDTDHandler,
XMLDTDContentModelHandler {
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int CHUNK_MASK = 255;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private static final boolean DEBUG = false;
    protected DatatypeValidatorFactory fDatatypeValidatorFactory;
    protected int fCurrentElementIndex;
    protected int fCurrentAttributeIndex;
    protected boolean fReadingExternalDTD = false;
    private boolean fMixed;
    private XMLElementDecl fElementDecl = new XMLElementDecl();
    private XMLAttributeDecl fAttributeDecl = new XMLAttributeDecl();
    private QName fQName = new QName();
    private XMLEntityDecl fEntityDecl = new XMLEntityDecl();
    private XMLSimpleType fSimpleType = new XMLSimpleType();
    private XMLContentSpec fContentSpec = new XMLContentSpec();
    Hashtable fAttributeDeclTab = new Hashtable();
    Hashtable fElementDeclTab = new Hashtable();
    Hashtable fNotationDeclTab = new Hashtable();
    Hashtable fSimpleTypeTab = new Hashtable();
    Hashtable fEntityDeclTab = new Hashtable();
    private short[] fOpStack = null;
    private int[] fNodeIndexStack = null;
    private int[] fPrevNodeIndexStack = null;
    private int fDepth = 0;
    private boolean[] fPEntityStack = new boolean[4];
    private int fPEDepth = 0;
    private int[][] fElementDeclIsExternal = new int[4][];
    private int[][] fAttributeDeclIsExternal = new int[4][];
    int valueIndex = -1;
    int prevNodeIndex = -1;
    int nodeIndex = -1;

    public DTDGrammar(SymbolTable symbolTable) {
        super(symbolTable);
        this.setTargetNamespace("");
    }

    public void setDatatypeValidatorFactory(DatatypeValidatorFactory datatypeValidatorFactory) {
        this.fDatatypeValidatorFactory = datatypeValidatorFactory;
    }

    public boolean getElementDeclIsExternal(int n) {
        if (n < 0) {
            return false;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fElementDeclIsExternal[n2][n3] != 0;
    }

    public boolean getAttributeDeclIsExternal(int n) {
        if (n < 0) {
            return false;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fAttributeDeclIsExternal[n2][n3] != 0;
    }

    public int getAttributeDeclIndex(int n, String string) {
        if (n == -1) {
            return -1;
        }
        int n2 = this.getFirstAttributeDeclIndex(n);
        while (n2 != -1) {
            this.getAttributeDecl(n2, this.fAttributeDecl);
            if (this.fAttributeDecl.name.rawname == string || string.equals(this.fAttributeDecl.name.rawname)) {
                return n2;
            }
            n2 = this.getNextAttributeDeclIndex(n2);
        }
        return -1;
    }

    public void startDTD(XMLLocator xMLLocator) throws XNIException {
        this.fOpStack = null;
        this.fNodeIndexStack = null;
        this.fPrevNodeIndexStack = null;
    }

    public void startEntity(String string, String string2, String string3, String string4, String string5) throws XNIException {
        if (string.startsWith("%")) {
            if (this.fPEDepth == this.fPEntityStack.length) {
                boolean[] blArray = new boolean[this.fPEntityStack.length * 2];
                System.arraycopy(this.fPEntityStack, 0, blArray, 0, this.fPEntityStack.length);
                this.fPEntityStack = blArray;
            }
            this.fPEntityStack[this.fPEDepth] = this.fReadingExternalDTD;
            ++this.fPEDepth;
        }
        if (string.equals("[dtd]") || string.startsWith("%") && string3 != null) {
            this.fReadingExternalDTD = true;
        }
    }

    public void endEntity(String string) throws XNIException {
        if (string.equals("[dtd]")) {
            this.fReadingExternalDTD = false;
        }
        if (string.startsWith("%")) {
            --this.fPEDepth;
            this.fReadingExternalDTD = this.fPEntityStack[this.fPEDepth];
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void elementDecl(String string, String string2) throws XNIException {
        int n;
        XMLElementDecl xMLElementDecl = (XMLElementDecl)this.fElementDeclTab.get(string);
        if (xMLElementDecl != null) {
            if (xMLElementDecl.type != -1) return;
            this.fCurrentElementIndex = this.getElementDeclIndex(string, -1);
        } else {
            this.fCurrentElementIndex = this.createElementDecl();
        }
        XMLElementDecl xMLElementDecl2 = new XMLElementDecl();
        QName qName = new QName(null, string, string, null);
        xMLElementDecl2.name.setValues(qName);
        xMLElementDecl2.contentModelValidator = null;
        xMLElementDecl2.scope = -1;
        if (string2.equals("EMPTY")) {
            xMLElementDecl2.type = 1;
        } else if (string2.equals("ANY")) {
            xMLElementDecl2.type = 0;
        } else if (string2.startsWith("(")) {
            xMLElementDecl2.type = string2.indexOf("#PCDATA") > 0 ? (short)2 : (short)3;
        }
        this.fElementDeclTab.put(string, xMLElementDecl2);
        this.fElementDecl = xMLElementDecl2;
        if ((this.fDepth == 0 || this.fDepth == 1 && xMLElementDecl2.type == 2) && this.fNodeIndexStack != null) {
            if (xMLElementDecl2.type == 2) {
                n = this.addUniqueLeafNode(null);
                this.fNodeIndexStack[0] = this.fNodeIndexStack[0] == -1 ? n : this.addContentSpecNode((short)4, n, this.fNodeIndexStack[0]);
            }
            this.setContentSpecIndex(this.fCurrentElementIndex, this.fNodeIndexStack[this.fDepth]);
        }
        this.setElementDecl(this.fCurrentElementIndex, this.fElementDecl);
        n = this.fCurrentElementIndex >> 8;
        int n2 = this.fCurrentElementIndex & 0xFF;
        this.ensureElementDeclCapacity(n);
        this.fElementDeclIsExternal[n][n2] = this.fReadingExternalDTD ? 1 : 0;
    }

    public void attributeDecl(String string, String string2, String string3, String[] stringArray, String string4, XMLString xMLString) throws XNIException {
        if (!this.fElementDeclTab.containsKey(string)) {
            this.fCurrentElementIndex = this.createElementDecl();
            XMLElementDecl xMLElementDecl = new XMLElementDecl();
            xMLElementDecl.name.setValues(null, string, string, null);
            xMLElementDecl.scope = -1;
            this.fElementDeclTab.put(string, xMLElementDecl);
            this.setElementDecl(this.fCurrentElementIndex, xMLElementDecl);
        }
        int n = this.getElementDeclIndex(string, -1);
        if (this.getAttributeDeclIndex(n, string2) != -1) {
            return;
        }
        this.fCurrentAttributeIndex = this.createAttributeDecl();
        this.fSimpleType.clear();
        if (string4 != null) {
            if (string4.equals("#FIXED")) {
                this.fSimpleType.defaultType = 1;
            } else if (string4.equals("#IMPLIED")) {
                this.fSimpleType.defaultType = 0;
            } else if (string4.equals("#REQUIRED")) {
                this.fSimpleType.defaultType = (short)2;
            }
        }
        this.fSimpleType.defaultValue = xMLString != null ? xMLString.toString() : null;
        this.fSimpleType.enumeration = stringArray;
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        if (string3.equals("CDATA")) {
            this.fSimpleType.type = 0;
        } else if (string3.equals("ID")) {
            this.fSimpleType.type = (short)3;
        } else if (string3.startsWith("IDREF")) {
            this.fSimpleType.type = (short)4;
            if (string3.indexOf("S") > 0) {
                this.fSimpleType.list = true;
            }
        } else if (string3.equals("ENTITIES")) {
            this.fSimpleType.type = 1;
            this.fSimpleType.list = true;
        } else if (string3.equals("ENTITY")) {
            this.fSimpleType.type = 1;
        } else if (string3.equals("NMTOKENS")) {
            this.fSimpleType.type = (short)5;
            this.fSimpleType.list = true;
        } else if (string3.equals("NMTOKEN")) {
            this.fSimpleType.type = (short)5;
        } else if (string3.startsWith("NOTATION")) {
            this.fSimpleType.type = (short)6;
            hashtable.put("enumeration", this.fSimpleType.enumeration);
        } else if (string3.startsWith("ENUMERATION")) {
            this.fSimpleType.type = (short)2;
            hashtable.put("enumeration", this.fSimpleType.enumeration);
        } else {
            System.err.println("!!! unknown attribute type " + string3);
        }
        this.fQName.setValues(null, string2, string2, null);
        this.fAttributeDecl.setValues(this.fQName, this.fSimpleType, false);
        this.setAttributeDecl(n, this.fCurrentAttributeIndex, this.fAttributeDecl);
        int n2 = this.fCurrentAttributeIndex >> 8;
        int n3 = this.fCurrentAttributeIndex & 0xFF;
        this.ensureAttributeDeclCapacity(n2);
        this.fAttributeDeclIsExternal[n2][n3] = this.fReadingExternalDTD ? 1 : 0;
    }

    public void internalEntityDecl(String string, XMLString xMLString, XMLString xMLString2) throws XNIException {
        XMLEntityDecl xMLEntityDecl = new XMLEntityDecl();
        boolean bl = string.startsWith("%");
        boolean bl2 = this.fReadingExternalDTD;
        xMLEntityDecl.setValues(string, null, null, null, null, xMLString.toString(), bl, bl2);
        int n = this.getEntityDeclIndex(string);
        if (n == -1) {
            n = this.createEntityDecl();
            this.setEntityDecl(n, xMLEntityDecl);
        }
    }

    public void externalEntityDecl(String string, String string2, String string3, String string4) throws XNIException {
        XMLEntityDecl xMLEntityDecl = new XMLEntityDecl();
        boolean bl = string.startsWith("%");
        boolean bl2 = this.fReadingExternalDTD;
        xMLEntityDecl.setValues(string, string2, string3, string4, null, null, bl, bl2);
        int n = this.getEntityDeclIndex(string);
        if (n == -1) {
            n = this.createEntityDecl();
            this.setEntityDecl(n, xMLEntityDecl);
        }
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws XNIException {
        XMLEntityDecl xMLEntityDecl = new XMLEntityDecl();
        boolean bl = string.startsWith("%");
        boolean bl2 = this.fReadingExternalDTD;
        xMLEntityDecl.setValues(string, string2, string3, null, string4, null, bl, bl2);
        int n = this.getEntityDeclIndex(string);
        if (n == -1) {
            n = this.createEntityDecl();
            this.setEntityDecl(n, xMLEntityDecl);
        }
    }

    public void notationDecl(String string, String string2, String string3) throws XNIException {
        XMLNotationDecl xMLNotationDecl = new XMLNotationDecl();
        xMLNotationDecl.setValues(string, string2, string3);
        int n = this.getNotationDeclIndex(string);
        if (n == -1) {
            n = this.createNotationDecl();
            this.setNotationDecl(n, xMLNotationDecl);
        }
    }

    public void endDTD() throws XNIException {
    }

    public void textDecl(String string, String string2) throws XNIException {
    }

    public void comment(XMLString xMLString) throws XNIException {
    }

    public void processingInstruction(String string, XMLString xMLString) throws XNIException {
    }

    public void startAttlist(String string) throws XNIException {
    }

    public void endAttlist() throws XNIException {
    }

    public void startConditional(short s) throws XNIException {
    }

    public void characters(XMLString xMLString) throws XNIException {
    }

    public void endConditional() throws XNIException {
    }

    public void startContentModel(String string) throws XNIException {
        XMLElementDecl xMLElementDecl = (XMLElementDecl)this.fElementDeclTab.get(string);
        if (xMLElementDecl != null) {
            this.fElementDecl = xMLElementDecl;
        }
        this.fDepth = 0;
        this.initializeContentModelStack();
    }

    public void startGroup() throws XNIException {
        ++this.fDepth;
        this.initializeContentModelStack();
        this.fMixed = false;
    }

    public void pcdata() throws XNIException {
        this.fMixed = true;
    }

    public void element(String string) throws XNIException {
        this.fNodeIndexStack[this.fDepth] = this.fMixed ? (this.fNodeIndexStack[this.fDepth] == -1 ? this.addUniqueLeafNode(string) : this.addContentSpecNode((short)4, this.fNodeIndexStack[this.fDepth], this.addUniqueLeafNode(string))) : this.addContentSpecNode((short)0, string);
    }

    public void separator(short s) throws XNIException {
        if (!this.fMixed) {
            if (this.fOpStack[this.fDepth] != 5 && s == 0) {
                if (this.fPrevNodeIndexStack[this.fDepth] != -1) {
                    this.fNodeIndexStack[this.fDepth] = this.addContentSpecNode(this.fOpStack[this.fDepth], this.fPrevNodeIndexStack[this.fDepth], this.fNodeIndexStack[this.fDepth]);
                }
                this.fPrevNodeIndexStack[this.fDepth] = this.fNodeIndexStack[this.fDepth];
                this.fOpStack[this.fDepth] = 4;
            } else if (this.fOpStack[this.fDepth] != 4 && s == 1) {
                if (this.fPrevNodeIndexStack[this.fDepth] != -1) {
                    this.fNodeIndexStack[this.fDepth] = this.addContentSpecNode(this.fOpStack[this.fDepth], this.fPrevNodeIndexStack[this.fDepth], this.fNodeIndexStack[this.fDepth]);
                }
                this.fPrevNodeIndexStack[this.fDepth] = this.fNodeIndexStack[this.fDepth];
                this.fOpStack[this.fDepth] = 5;
            }
        }
    }

    public void occurrence(short s) throws XNIException {
        if (!this.fMixed) {
            if (s == 2) {
                this.fNodeIndexStack[this.fDepth] = this.addContentSpecNode((short)1, this.fNodeIndexStack[this.fDepth], -1);
            } else if (s == 3) {
                this.fNodeIndexStack[this.fDepth] = this.addContentSpecNode((short)2, this.fNodeIndexStack[this.fDepth], -1);
            } else if (s == 4) {
                this.fNodeIndexStack[this.fDepth] = this.addContentSpecNode((short)3, this.fNodeIndexStack[this.fDepth], -1);
            }
        }
    }

    public void endGroup() throws XNIException {
        if (!this.fMixed) {
            int n;
            if (this.fPrevNodeIndexStack[this.fDepth] != -1) {
                this.fNodeIndexStack[this.fDepth] = this.addContentSpecNode(this.fOpStack[this.fDepth], this.fPrevNodeIndexStack[this.fDepth], this.fNodeIndexStack[this.fDepth]);
            }
            this.fNodeIndexStack[this.fDepth] = n = this.fNodeIndexStack[this.fDepth--];
        }
    }

    public void any() throws XNIException {
    }

    public void empty() throws XNIException {
    }

    public void endContentModel() throws XNIException {
    }

    public boolean isNamespaceAware() {
        return false;
    }

    public int getElementDeclIndex(QName qName, int n) {
        return this.getElementDeclIndex(qName.rawname, n);
    }

    protected int addContentSpecNode(short s, String string) {
        int n = this.createContentSpec();
        this.fContentSpec.setValues(s, string, null);
        this.setContentSpec(n, this.fContentSpec);
        return n;
    }

    protected int addUniqueLeafNode(String string) {
        int n = this.createContentSpec();
        this.fContentSpec.setValues((short)0, string, null);
        this.setContentSpec(n, this.fContentSpec);
        return n;
    }

    protected int addContentSpecNode(short s, int n, int n2) {
        int n3 = this.createContentSpec();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        nArray[0] = n;
        nArray2[0] = n2;
        this.fContentSpec.setValues(s, nArray, nArray2);
        this.setContentSpec(n3, this.fContentSpec);
        return n3;
    }

    protected void initializeContentModelStack() {
        if (this.fOpStack == null) {
            this.fOpStack = new short[8];
            this.fNodeIndexStack = new int[8];
            this.fPrevNodeIndexStack = new int[8];
        } else if (this.fDepth == this.fOpStack.length) {
            short[] sArray = new short[this.fDepth * 2];
            System.arraycopy(this.fOpStack, 0, sArray, 0, this.fDepth);
            this.fOpStack = sArray;
            int[] nArray = new int[this.fDepth * 2];
            System.arraycopy(this.fNodeIndexStack, 0, nArray, 0, this.fDepth);
            this.fNodeIndexStack = nArray;
            nArray = new int[this.fDepth * 2];
            System.arraycopy(this.fPrevNodeIndexStack, 0, nArray, 0, this.fDepth);
            this.fPrevNodeIndexStack = nArray;
        }
        this.fOpStack[this.fDepth] = -1;
        this.fNodeIndexStack[this.fDepth] = -1;
        this.fPrevNodeIndexStack[this.fDepth] = -1;
    }

    protected boolean ensureElementDeclCapacity(int n) {
        try {
            return this.fElementDeclIsExternal[n][0] == 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.fElementDeclIsExternal = this.resize(this.fElementDeclIsExternal, this.fElementDeclIsExternal.length * 2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.fElementDeclIsExternal[n] = new int[256];
        return true;
    }

    protected boolean ensureAttributeDeclCapacity(int n) {
        try {
            return this.fAttributeDeclIsExternal[n][0] == 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.fAttributeDeclIsExternal = this.resize(this.fAttributeDeclIsExternal, this.fAttributeDeclIsExternal.length * 2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.fAttributeDeclIsExternal[n] = new int[256];
        return true;
    }

    protected int[][] resize(int[][] nArray, int n) {
        int[][] nArrayArray = new int[n][];
        System.arraycopy(nArray, 0, nArrayArray, 0, nArray.length);
        return nArrayArray;
    }
}

