/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.dtd;

import java.text.Collator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.xerces.impl.dv.dtd.AbstractDatatypeValidator;
import org.apache.xerces.impl.dv.dtd.DatatypeValidator;
import org.apache.xerces.impl.dv.dtd.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.dtd.InvalidDatatypeValueException;

public class StringDatatypeValidator
extends AbstractDatatypeValidator {
    private Locale fLocale = null;
    DatatypeValidator fBaseValidator = null;
    private int fLength = 0;
    private int fMaxLength = Integer.MAX_VALUE;
    private int fMinLength = 0;
    private String fPattern = null;
    private Vector fEnumeration = null;
    private short fWhiteSpace = 0;
    private int fFacetsDefined = 0;
    private boolean isMaxExclusiveDefined = false;
    private boolean isMaxInclusiveDefined = false;
    private boolean isMinExclusiveDefined = false;
    private boolean isMinInclusiveDefined = false;

    public StringDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public StringDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        this.setBasetype(datatypeValidator);
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string;
                String string2 = (String)enumeration.nextElement();
                if (string2.equals("length")) {
                    ++this.fFacetsDefined;
                    string = (String)hashtable.get(string2);
                    try {
                        this.fLength = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException("Length value '" + string + "' is invalid.");
                    }
                    if (this.fLength >= 0) continue;
                    throw new InvalidDatatypeFacetException("Length value '" + string + "'  must be a nonNegativeInteger.");
                }
                if (string2.equals("minlength")) {
                    this.fFacetsDefined += 2;
                    string = (String)hashtable.get(string2);
                    try {
                        this.fMinLength = Integer.parseInt(string);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException("minLength value '" + string + "' is invalid.");
                    }
                }
                if (string2.equals("maxlength")) {
                    this.fFacetsDefined += 4;
                    string = (String)hashtable.get(string2);
                    try {
                        this.fMaxLength = Integer.parseInt(string);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException("maxLength value '" + string + "' is invalid.");
                    }
                }
                if (string2.equals("enumeration")) {
                    this.fFacetsDefined += 16;
                    this.fEnumeration = (Vector)hashtable.get(string2);
                    continue;
                }
                if (string2.equals("whitespace")) {
                    string = (String)hashtable.get(string2);
                    this.fFacetsDefined += 32;
                    if (string.equals("preserve")) {
                        this.fWhiteSpace = 1;
                        continue;
                    }
                    if (string.equals("replace")) {
                        this.fWhiteSpace = (short)2;
                        continue;
                    }
                    if (!string.equals("collapse")) continue;
                    this.fWhiteSpace = (short)3;
                    continue;
                }
                throw new InvalidDatatypeFacetException("invalid facet tag : " + string2);
            }
            if ((this.fFacetsDefined & 1) != 0) {
                if ((this.fFacetsDefined & 4) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both length and maxLength to be members of facets.");
                }
                if ((this.fFacetsDefined & 2) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both length and minLength to be members of facets.");
                }
            }
            if ((this.fFacetsDefined & 6) != 0 && this.fMinLength > this.fMaxLength) {
                throw new InvalidDatatypeFacetException("Value of minLength = '" + this.fMinLength + "'must be less than the value of maxLength = '" + this.fMaxLength + "'.");
            }
            this.isMaxExclusiveDefined = (this.fFacetsDefined & 0x80) != 0;
            this.isMaxInclusiveDefined = (this.fFacetsDefined & 0x40) != 0;
            this.isMinExclusiveDefined = (this.fFacetsDefined & 0x200) != 0;
            boolean bl2 = this.isMinInclusiveDefined = (this.fFacetsDefined & 0x100) != 0;
            if (this.isMaxExclusiveDefined && this.isMaxInclusiveDefined) {
                throw new InvalidDatatypeFacetException("It is an error for both maxInclusive and maxExclusive to be specified for the same datatype.");
            }
            if (this.isMinExclusiveDefined && this.isMinInclusiveDefined) {
                throw new InvalidDatatypeFacetException("It is an error for both minInclusive and minExclusive to be specified for the same datatype.");
            }
        }
    }

    public void validate(String string, Object object) throws InvalidDatatypeValueException {
        this.checkContent(string, object);
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Hashtable getFacets() {
        return null;
    }

    private void checkContent(String string, Object object) throws InvalidDatatypeValueException {
        if (this.fBaseValidator != null) {
            this.fBaseValidator.validate(string, object);
        }
        if ((this.fFacetsDefined & 4) != 0 && string.length() > this.fMaxLength) {
            throw new InvalidDatatypeValueException("Value '" + string + "' with length '" + string.length() + "' exceeds maximum length facet of '" + this.fMaxLength + "'.");
        }
        if ((this.fFacetsDefined & 2) != 0 && string.length() < this.fMinLength) {
            throw new InvalidDatatypeValueException("Value '" + string + "' with length '" + string.length() + "' is less than minimum length facet of '" + this.fMinLength + "'.");
        }
        if ((this.fFacetsDefined & 1) != 0 && string.length() != this.fLength) {
            throw new InvalidDatatypeValueException("Value '" + string + "' with length '" + string.length() + "' is not equal to length facet '" + this.fLength + "'.");
        }
        if ((this.fFacetsDefined & 0x10) != 0 && !this.fEnumeration.contains(string)) {
            throw new InvalidDatatypeValueException("Value '" + string + "' must be one of " + this.fEnumeration);
        }
    }

    public int compare(String string, String string2) {
        Locale locale = Locale.getDefault();
        Collator collator = Collator.getInstance(locale);
        return collator.compare(string, string2);
    }

    public Object clone() throws CloneNotSupportedException {
        StringDatatypeValidator stringDatatypeValidator = null;
        try {
            stringDatatypeValidator = new StringDatatypeValidator();
            stringDatatypeValidator.fLocale = this.fLocale;
            stringDatatypeValidator.fBaseValidator = this.fBaseValidator;
            stringDatatypeValidator.fLength = this.fLength;
            stringDatatypeValidator.fMaxLength = this.fMaxLength;
            stringDatatypeValidator.fMinLength = this.fMinLength;
            stringDatatypeValidator.fPattern = this.fPattern;
            stringDatatypeValidator.fEnumeration = this.fEnumeration;
            stringDatatypeValidator.fFacetsDefined = this.fFacetsDefined;
            stringDatatypeValidator.isMaxExclusiveDefined = this.isMaxExclusiveDefined;
            stringDatatypeValidator.isMaxInclusiveDefined = this.isMaxInclusiveDefined;
            stringDatatypeValidator.isMinExclusiveDefined = this.isMinExclusiveDefined;
            stringDatatypeValidator.isMinInclusiveDefined = this.isMinInclusiveDefined;
        }
        catch (InvalidDatatypeFacetException invalidDatatypeFacetException) {
            invalidDatatypeFacetException.printStackTrace();
        }
        return stringDatatypeValidator;
    }

    private void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = datatypeValidator;
    }
}

