/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.xs.AbstractStringValidator;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeValueException;
import org.apache.xerces.impl.xs.util.Base64;

public class Base64BinaryDatatypeValidator
extends AbstractStringValidator {
    public Base64BinaryDatatypeValidator() {
        super(null, null, false, null);
    }

    public Base64BinaryDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl, XMLErrorReporter xMLErrorReporter) {
        super(datatypeValidator, hashtable, bl, xMLErrorReporter);
    }

    protected void assignAdditionalFacets(String string, Hashtable hashtable) throws InvalidDatatypeFacetException {
        String string2 = "base64Binary datatype, facet " + string + " with value " + (String)hashtable.get(string);
        throw new InvalidDatatypeFacetException(string2);
    }

    protected void checkValueSpace(String string) throws InvalidDatatypeValueException {
        if (this.getLength(string) < 0) {
            throw new InvalidDatatypeValueException("Value '" + string + "' is not encoded in Base64");
        }
    }

    protected int getLength(String string) {
        int n = 0;
        try {
            try {
                n = Base64.getDecodedDataLength(string.getBytes("utf-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Object var5_4 = null;
                return n;
            }
            Object var5_3 = null;
            return n;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            return n;
        }
    }

    public int compare(String string, String string2) {
        if (string == null || string2 == null) {
            return -1;
        }
        if (string == string2 || string.equals(string2)) {
            return 0;
        }
        byte[] byArray = Base64.decode(string.getBytes());
        byte[] byArray2 = Base64.decode(string2.getBytes());
        if (byArray == null || byArray2 == null) {
            return -1;
        }
        int n = 0;
        while (n < Math.min(byArray.length, byArray2.length)) {
            if (byArray[n] < byArray2[n]) {
                return -1;
            }
            if (byArray[n] > byArray2[n]) {
                return 1;
            }
            ++n;
        }
        if (byArray.length == byArray2.length) {
            return 0;
        }
        return byArray.length > byArray2.length ? 1 : -1;
    }
}

