/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.xs.AbstractDatatypeValidator;
import org.apache.xerces.impl.dv.xs.AnySimpleType;
import org.apache.xerces.impl.dv.xs.DatatypeMessageProvider;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeValueException;
import org.apache.xerces.impl.validation.ValidationContext;
import org.apache.xerces.impl.xpath.regex.RegularExpression;
import org.apache.xerces.impl.xs.SchemaSymbols;

public class BooleanDatatypeValidator
extends AbstractDatatypeValidator {
    private static final String[] fValueSpace = new String[]{"false", "true", "0", "1"};

    public BooleanDatatypeValidator() {
        this(null, null, false, null);
    }

    public BooleanDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl, XMLErrorReporter xMLErrorReporter) {
        this.fErrorReporter = xMLErrorReporter;
        this.fBaseValidator = datatypeValidator;
        if (bl) {
            return;
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.equals(SchemaSymbols.ELT_PATTERN)) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
                    this.fPattern = (String)hashtable.get(string);
                    if (this.fPattern == null) continue;
                    this.fRegex = new RegularExpression(this.fPattern, "X");
                    continue;
                }
                String string2 = this.getErrorString(DatatypeMessageProvider.fgMessageKeys[DatatypeMessageProvider.ILLEGAL_BOOLEAN_FACET], new Object[]{string});
                if (this.fErrorReporter == null) {
                    throw new RuntimeException("InternalDatatype error BDV.");
                }
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "DatatypeFacetError", new Object[]{string2}, (short)1);
            }
        }
    }

    public Object validate(String string, ValidationContext validationContext) throws InvalidDatatypeValueException {
        this.checkContent(string, false);
        return null;
    }

    public int compare(String string, String string2) {
        Boolean bl;
        if (string.equals(string2)) {
            return 0;
        }
        Boolean bl2 = Boolean.valueOf(string);
        return bl2.equals(bl = Boolean.valueOf(string2)) ? 0 : 1;
    }

    public Hashtable getFacets() {
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    protected void checkContent(String string, boolean bl) throws InvalidDatatypeValueException {
        if (this.fBaseValidator != null && !(this.fBaseValidator instanceof AnySimpleType)) {
            ((BooleanDatatypeValidator)this.fBaseValidator).checkContent(string, true);
        }
        if (!((this.fFacetsDefined & 8) == 0 || this.fRegex != null && this.fRegex.matches(string))) {
            throw new InvalidDatatypeValueException("Value'" + string + "does not match regular expression facet" + this.fPattern);
        }
        if (bl) {
            return;
        }
        boolean bl2 = false;
        int n = 0;
        while (n < fValueSpace.length) {
            if (string.equals(fValueSpace[n])) {
                bl2 = true;
            }
            ++n;
        }
        if (!bl2) {
            String string2 = this.getErrorString(DatatypeMessageProvider.fgMessageKeys[DatatypeMessageProvider.NOT_BOOLEAN], new Object[]{string});
            throw new InvalidDatatypeValueException(string2);
        }
    }
}

