/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.xs.AbstractNumericValidator;
import org.apache.xerces.impl.dv.xs.AnySimpleType;
import org.apache.xerces.impl.dv.xs.DatatypeMessageProvider;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeValueException;
import org.apache.xerces.impl.validation.ValidationContext;

public class FloatDatatypeValidator
extends AbstractNumericValidator {
    public FloatDatatypeValidator() {
        this(null, null, false, null);
    }

    public FloatDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl, XMLErrorReporter xMLErrorReporter) {
        super(datatypeValidator, hashtable, bl, xMLErrorReporter);
    }

    public int compare(String string, String string2) {
        try {
            float f = FloatDatatypeValidator.fValueOf(string).floatValue();
            float f2 = FloatDatatypeValidator.fValueOf(string2).floatValue();
            return this.compareFloats(f, f2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected void assignAdditionalFacets(String string, Hashtable hashtable) throws InvalidDatatypeFacetException {
        String string2 = "float datatype, facet " + string + " with value " + (String)hashtable.get(string);
        throw new InvalidDatatypeFacetException(string2);
    }

    protected int compareValues(Object object, Object object2) {
        float f = ((Float)object).floatValue();
        float f2 = ((Float)object2).floatValue();
        return this.compareFloats(f, f2);
    }

    protected void setMaxInclusive(String string) {
        this.fMaxInclusive = FloatDatatypeValidator.fValueOf(string);
    }

    protected void setMinInclusive(String string) {
        this.fMinInclusive = FloatDatatypeValidator.fValueOf(string);
    }

    protected void setMaxExclusive(String string) {
        this.fMaxExclusive = FloatDatatypeValidator.fValueOf(string);
    }

    protected void setMinExclusive(String string) {
        this.fMinExclusive = FloatDatatypeValidator.fValueOf(string);
    }

    protected void setEnumeration(Vector vector) throws InvalidDatatypeValueException {
        if (vector != null) {
            this.fEnumeration = new Float[vector.size()];
            Object var2_2 = null;
            int n = 0;
            while (n < vector.size()) {
                this.fEnumeration[n] = FloatDatatypeValidator.fValueOf((String)vector.elementAt(n));
                ((FloatDatatypeValidator)this.fBaseValidator).validate((String)vector.elementAt(n), null);
                ++n;
            }
        }
    }

    protected String getMaxInclusive(boolean bl) {
        return bl ? ((FloatDatatypeValidator)this.fBaseValidator).fMaxInclusive.toString() : ((Float)this.fMaxInclusive).toString();
    }

    protected String getMinInclusive(boolean bl) {
        return bl ? ((FloatDatatypeValidator)this.fBaseValidator).fMinInclusive.toString() : ((Float)this.fMinInclusive).toString();
    }

    protected String getMaxExclusive(boolean bl) {
        return bl ? ((FloatDatatypeValidator)this.fBaseValidator).fMaxExclusive.toString() : ((Float)this.fMaxExclusive).toString();
    }

    protected String getMinExclusive(boolean bl) {
        return bl ? ((FloatDatatypeValidator)this.fBaseValidator).fMinExclusive.toString() : ((Float)this.fMinExclusive).toString();
    }

    protected void checkContent(String string, ValidationContext validationContext, Vector vector, boolean bl) throws InvalidDatatypeValueException {
        if (this.fBaseValidator != null && !(this.fBaseValidator instanceof AnySimpleType)) {
            ((FloatDatatypeValidator)this.fBaseValidator).checkContent(string, validationContext, vector, true);
        }
        if (!((this.fFacetsDefined & 8) == 0 || this.fRegex != null && this.fRegex.matches(string))) {
            throw new InvalidDatatypeValueException("Value'" + string + "does not match regular expression facet" + this.fPattern);
        }
        if (bl) {
            return;
        }
        Float f = null;
        try {
            f = FloatDatatypeValidator.fValueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = this.getErrorString(DatatypeMessageProvider.fgMessageKeys[DatatypeMessageProvider.NOT_FLOAT], new Object[]{string});
            throw new InvalidDatatypeValueException(string2);
        }
        if (vector != null) {
            int n = vector.size();
            Float[] floatArray = new Float[n];
            int n2 = 0;
            try {
                while (n2 < n) {
                    floatArray[n2] = FloatDatatypeValidator.fValueOf((String)vector.elementAt(n2));
                    ++n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                String string3 = this.getErrorString(DatatypeMessageProvider.fgMessageKeys[DatatypeMessageProvider.INVALID_ENUM_VALUE], new Object[]{vector.elementAt(n2)});
                throw new InvalidDatatypeValueException(string3);
            }
            this.enumCheck(f.floatValue(), floatArray);
        }
        this.boundsCheck(f);
        if ((this.fFacetsDefined & 0x10) != 0 && this.fEnumeration != null) {
            this.enumCheck(f.floatValue(), (Float[])this.fEnumeration);
        }
    }

    protected int getInvalidFacetMsg() {
        return DatatypeMessageProvider.ILLEGAL_FLOAT_FACET;
    }

    private void enumCheck(float f, Float[] floatArray) throws InvalidDatatypeValueException {
        int n = 0;
        while (n < floatArray.length) {
            if (f == floatArray[n].floatValue()) {
                return;
            }
            ++n;
        }
        String string = this.getErrorString(DatatypeMessageProvider.fgMessageKeys[DatatypeMessageProvider.NOT_ENUM_VALUE], new Object[]{new Float(f)});
        throw new InvalidDatatypeValueException(string);
    }

    private static Float fValueOf(String string) throws NumberFormatException {
        Float f = null;
        try {
            f = Float.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equals("INF")) {
                f = new Float(Float.POSITIVE_INFINITY);
            }
            if (string.equals("-INF")) {
                f = new Float(Float.NEGATIVE_INFINITY);
            }
            if (string.equals("NaN")) {
                f = new Float(Float.NaN);
            }
            throw numberFormatException;
        }
        return f;
    }

    private int compareFloats(float f, float f2) {
        int n = Float.floatToIntBits(f);
        int n2 = Float.floatToIntBits(f2);
        if (f > f2) {
            return 1;
        }
        if (f < f2) {
            return -1;
        }
        if (n == n2) {
            return 0;
        }
        return n < n2 ? -1 : 1;
    }
}

