/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.text.Collator;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.xs.AbstractStringValidator;
import org.apache.xerces.impl.dv.xs.DatatypeMessageProvider;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeValueException;

public class QNameDatatypeValidator
extends AbstractStringValidator {
    private static DatatypeValidator fgStrValidator = null;

    public QNameDatatypeValidator() {
        this(null, null, false, null);
    }

    public QNameDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl, XMLErrorReporter xMLErrorReporter) {
        super(datatypeValidator, hashtable, bl, xMLErrorReporter);
    }

    protected void assignAdditionalFacets(String string, Hashtable hashtable) throws InvalidDatatypeFacetException {
        String string2 = this.getErrorString(DatatypeMessageProvider.fgMessageKeys[DatatypeMessageProvider.ILLEGAL_STRING_FACET], new Object[]{string});
        throw new InvalidDatatypeFacetException(string2);
    }

    protected void checkValueSpace(String string) throws InvalidDatatypeValueException {
        try {
            int n = string.indexOf(58);
            if (n >= 0) {
                fgStrValidator.validate(string.substring(0, n), null);
            }
            fgStrValidator.validate(string.substring(n + 1), null);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new InvalidDatatypeValueException("Value '" + string + "' is not a valid QName");
        }
    }

    public int compare(String string, String string2) {
        Locale locale = Locale.getDefault();
        Collator collator = Collator.getInstance(locale);
        return collator.compare(string, string2);
    }

    public static void setNCNameValidator(DatatypeValidator datatypeValidator) {
        if (fgStrValidator == null) {
            fgStrValidator = datatypeValidator;
        }
    }
}

