/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs_new;

import org.apache.xerces.impl.dv.xs_new.SchemaDateTimeException;
import org.apache.xerces.impl.dv.xs_new.TypeValidator;

public abstract class AbstractDateTimeDV
extends TypeValidator {
    private static final boolean DEBUG = false;
    protected static final int CY = 0;
    protected static final int M = 1;
    protected static final int D = 2;
    protected static final int h = 3;
    protected static final int m = 4;
    protected static final int s = 5;
    protected static final int ms = 6;
    protected static final int utc = 7;
    protected static final int hh = 0;
    protected static final int mm = 1;
    protected static final int TOTAL_SIZE = 8;
    protected static final int MONTH_SIZE = 6;
    private static final int YEARMONTH_SIZE = 7;
    protected static final int YEAR = 2001;
    protected static final int MONTH = 1;
    protected static final int DAY = 15;
    protected int[] timeZone;
    protected int fEnumSize;
    protected int fEnd;
    protected int fStart;
    protected StringBuffer fBuffer;
    protected int[] fDateValue;
    private int[] fTempDate;
    protected StringBuffer message;

    public AbstractDateTimeDV() {
        this.initializeValues();
    }

    protected void initializeValues() {
        this.fDateValue = new int[8];
        this.fTempDate = new int[8];
        this.fEnd = 30;
        this.fStart = 0;
        this.message = new StringBuffer(8);
        this.fBuffer = new StringBuffer(this.fEnd);
        this.timeZone = new int[2];
    }

    public short getAllowedFacets() {
        return 1016;
    }

    public boolean isEqual(Object object, Object object2) {
        if (!(object instanceof int[]) || !(object2 instanceof int[])) {
            return false;
        }
        return this.compareDates((int[])object, (int[])object2, true) == 0;
    }

    public int compare(Object object, Object object2) {
        return this.compareDates((int[])object, (int[])object2, true);
    }

    protected abstract int[] parse(String var1, int[] var2) throws SchemaDateTimeException;

    protected short compareDates(int[] nArray, int[] nArray2, boolean bl) {
        if (nArray[7] == nArray2[7]) {
            return this.compareOrder(nArray, nArray2);
        }
        if (nArray[7] == 90) {
            this.cloneDate(nArray2);
            this.timeZone[0] = 14;
            this.timeZone[1] = 0;
            this.fTempDate[7] = 43;
            this.normalize(this.fTempDate);
            short s = this.compareOrder(nArray, this.fTempDate);
            this.cloneDate(nArray2);
            this.timeZone[0] = 14;
            this.timeZone[1] = 0;
            this.fTempDate[7] = 45;
            this.normalize(this.fTempDate);
            short s2 = this.compareOrder(nArray, this.fTempDate);
            if (s < 0 && s2 > 0 || s == 0 && s2 == 0) {
                return 2;
            }
            return s != 2 ? s : s2;
        }
        if (nArray2[7] == 90) {
            this.cloneDate(nArray);
            this.timeZone[0] = 14;
            this.timeZone[1] = 0;
            this.fTempDate[7] = 45;
            this.normalize(this.fTempDate);
            short s = this.compareOrder(this.fTempDate, nArray2);
            this.cloneDate(nArray);
            this.timeZone[0] = 14;
            this.timeZone[1] = 0;
            this.fTempDate[7] = 43;
            this.normalize(this.fTempDate);
            short s3 = this.compareOrder(this.fTempDate, nArray2);
            if (s < 0 && s3 > 0 || s == 0 && s3 == 0) {
                return 2;
            }
            return s != 2 ? s : s3;
        }
        return 2;
    }

    protected short compareOrder(int[] nArray, int[] nArray2) {
        int n = 0;
        while (n < 8) {
            if (nArray[n] < nArray2[n]) {
                return -1;
            }
            if (nArray[n] > nArray2[n]) {
                return 1;
            }
            ++n;
        }
        return 0;
    }

    protected void getTime(int n, int n2, int[] nArray) throws RuntimeException {
        int n3 = n + 2;
        nArray[3] = this.parseInt(n, n3);
        if (this.fBuffer.charAt(n3++) != ':') {
            throw new RuntimeException("Error in parsing time zone");
        }
        n = n3;
        nArray[4] = this.parseInt(n, n3 += 2);
        if (this.fBuffer.charAt(n3++) != ':') {
            throw new RuntimeException("Error in parsing time zone");
        }
        n = n3;
        nArray[5] = this.parseInt(n, n3 += 2);
        int n4 = this.indexOf(n, n2, '.');
        int n5 = this.findUTCSign(n4 != -1 ? n4 : n, n2);
        if (n4 != -1) {
            nArray[6] = n5 < 0 ? this.parseInt(n4 + 1, this.fEnd) : this.parseInt(n4 + 1, n5);
        }
        if (n5 > 0) {
            this.getTimeZone(nArray, n5);
        }
    }

    protected void getDate(int n, int n2, int[] nArray) throws RuntimeException {
        this.getYearMonth(n, n2, nArray);
        if (this.fBuffer.charAt(this.fStart++) != '-') {
            throw new RuntimeException("CCYY-MM must be followed by '-' sign");
        }
        int n3 = this.fStart + 2;
        nArray[2] = this.parseInt(this.fStart, n3);
        this.fStart = n3;
    }

    protected void getYearMonth(int n, int n2, int[] nArray) throws RuntimeException {
        int n3;
        if (this.fBuffer.charAt(0) == '-') {
            ++n;
        }
        if ((n3 = this.indexOf(n, n2, '-')) == -1) {
            throw new RuntimeException("Year separator is missing or misplaced");
        }
        int n4 = n3 - n;
        if (n4 < 4) {
            throw new RuntimeException("Year must have 'CCYY' format");
        }
        if (n4 > 4 && this.fBuffer.charAt(n) == '0') {
            throw new RuntimeException("Leading zeros are required if the year value would otherwise have fewer than four digits; otherwise they are forbidden");
        }
        nArray[0] = this.parseIntYear(n3);
        if (this.fBuffer.charAt(n3) != '-') {
            throw new RuntimeException("CCYY must be followed by '-' sign");
        }
        n = ++n3;
        n3 = n + 2;
        nArray[1] = this.parseInt(n, n3);
        this.fStart = n3;
    }

    protected void parseTimeZone(int n, int[] nArray) throws RuntimeException {
        if (this.fStart < this.fEnd) {
            int n2 = this.findUTCSign(this.fStart, this.fEnd);
            if (n2 < 0) {
                throw new RuntimeException("Error in month parsing");
            }
            this.getTimeZone(nArray, n2);
        }
    }

    protected void getTimeZone(int[] nArray, int n) throws RuntimeException {
        nArray[7] = this.fBuffer.charAt(n);
        if (this.fBuffer.charAt(n) == 'Z') {
            if (this.fEnd > ++n) {
                throw new RuntimeException("Error in parsing time zone");
            }
            return;
        }
        if (n <= this.fEnd - 6) {
            int n2 = ++n + 2;
            this.timeZone[0] = this.parseInt(n, n2);
            if (this.fBuffer.charAt(n2++) != ':') {
                throw new RuntimeException("Error in parsing time zone");
            }
            this.timeZone[1] = this.parseInt(n2, n2 + 2);
            if (n2 + 2 != this.fEnd) {
                throw new RuntimeException("Error in parsing time zone");
            }
        } else {
            throw new RuntimeException("Error in parsing time zone");
        }
    }

    protected int indexOf(int n, int n2, char c) {
        int n3 = n;
        while (n3 < n2) {
            if (this.fBuffer.charAt(n3) == c) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    protected void validateDateTime(int[] nArray) {
        if (nArray[0] == 0) {
            throw new RuntimeException("The year \"0000\" is an illegal year value");
        }
        if (nArray[1] < 1 || nArray[1] > 12) {
            throw new RuntimeException("The month must have values 1 to 12");
        }
        if (nArray[2] > this.maxDayInMonthFor(nArray[0], nArray[1]) || nArray[2] < 1) {
            throw new RuntimeException("The day must have values 1 to 31");
        }
        if (nArray[3] > 23 || nArray[3] < 0) {
            throw new RuntimeException("Hour must have values 0-23");
        }
        if (nArray[4] > 59 || nArray[4] < 0) {
            throw new RuntimeException("Minute must have values 0-59");
        }
        if (nArray[5] > 60 || nArray[5] < 0) {
            throw new RuntimeException("Second must have values 0-60");
        }
        if (this.timeZone[0] > 14 || this.timeZone[0] < -14) {
            throw new RuntimeException("Time zone should have range -14..+14");
        }
        if (this.timeZone[1] > 59 || this.timeZone[1] < -59) {
            throw new RuntimeException("Minute must have values 0-59");
        }
    }

    protected int findUTCSign(int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            char c = this.fBuffer.charAt(n3);
            if (c == 'Z' || c == '+' || c == '-') {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    protected int parseInt(int n, int n2) throws NumberFormatException {
        int n3 = 10;
        int n4 = 0;
        int n5 = 0;
        int n6 = -2147483647;
        int n7 = n6 / n3;
        int n8 = n;
        do {
            if ((n5 = Character.digit(this.fBuffer.charAt(n8), n3)) < 0) {
                throw new NumberFormatException("'" + this.fBuffer.toString() + "' has wrong format");
            }
            if (n4 < n7) {
                throw new NumberFormatException("'" + this.fBuffer.toString() + "' has wrong format");
            }
            if ((n4 *= n3) < n6 + n5) {
                throw new NumberFormatException("'" + this.fBuffer.toString() + "' has wrong format");
            }
            n4 -= n5;
        } while (++n8 < n2);
        return -n4;
    }

    protected int parseIntYear(int n) {
        int n2;
        int n3 = 10;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        if (this.fBuffer.charAt(0) == '-') {
            bl = true;
            n2 = Integer.MIN_VALUE;
            ++n5;
        } else {
            n2 = -2147483647;
        }
        int n7 = n2 / n3;
        while (n5 < n) {
            if ((n6 = Character.digit(this.fBuffer.charAt(n5++), n3)) < 0) {
                throw new NumberFormatException("'" + this.fBuffer.toString() + "' has wrong format");
            }
            if (n4 < n7) {
                throw new NumberFormatException("'" + this.fBuffer.toString() + "' has wrong format");
            }
            if ((n4 *= n3) < n2 + n6) {
                throw new NumberFormatException("'" + this.fBuffer.toString() + "' has wrong format");
            }
            n4 -= n6;
        }
        if (bl) {
            if (n5 > 1) {
                return n4;
            }
            throw new NumberFormatException("'" + this.fBuffer.toString() + "' has wrong format");
        }
        return -n4;
    }

    protected void normalize(int[] nArray) {
        int n = 1;
        if (nArray[7] == 43) {
            n = -1;
        }
        int n2 = nArray[4] + n * this.timeZone[1];
        int n3 = this.fQuotient(n2, 60);
        nArray[4] = this.mod(n2, 60, n3);
        n2 = nArray[3] + n * this.timeZone[0] + n3;
        n3 = this.fQuotient(n2, 24);
        nArray[3] = this.mod(n2, 24, n3);
        nArray[2] = nArray[2] + n3;
        while (true) {
            n2 = this.maxDayInMonthFor(nArray[0], nArray[1]);
            if (nArray[2] < 1) {
                nArray[2] = nArray[2] + this.maxDayInMonthFor(nArray[0], nArray[1] - 1);
                n3 = -1;
            } else {
                if (nArray[2] <= n2) break;
                nArray[2] = nArray[2] - n2;
                n3 = 1;
            }
            n2 = nArray[1] + n3;
            nArray[1] = this.modulo(n2, 1, 13);
            nArray[0] = nArray[0] + this.fQuotient(n2, 1, 13);
        }
        nArray[7] = 90;
    }

    protected void resetBuffer(String string) {
        this.fBuffer.setLength(0);
        this.fEnd = 0;
        this.fStart = 0;
        this.timeZone[1] = 0;
        this.timeZone[0] = 0;
        this.fBuffer.append(string);
        this.fEnd = this.fBuffer.length();
    }

    protected void resetDateObj(int[] nArray) {
        int n = 0;
        while (n < 8) {
            nArray[n] = 0;
            ++n;
        }
    }

    protected int maxDayInMonthFor(int n, int n2) {
        if (n2 == 4 || n2 == 6 || n2 == 9 || n2 == 11) {
            return 30;
        }
        if (n2 == 2) {
            if (this.isLeapYear(n)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    private boolean isLeapYear(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    protected int mod(int n, int n2, int n3) {
        return n - n3 * n2;
    }

    protected int fQuotient(int n, int n2) {
        return (int)Math.floor((float)n / (float)n2);
    }

    protected int modulo(int n, int n2, int n3) {
        int n4 = n - n2;
        int n5 = n3 - n2;
        return this.mod(n4, n5, this.fQuotient(n4, n5)) + n2;
    }

    protected int fQuotient(int n, int n2, int n3) {
        return this.fQuotient(n - n2, n3 - n2);
    }

    protected String dateToString(int[] nArray) {
        this.message.setLength(0);
        this.message.append(nArray[0]);
        this.message.append('-');
        this.message.append(nArray[1]);
        this.message.append('-');
        this.message.append(nArray[2]);
        this.message.append('T');
        this.message.append(nArray[3]);
        this.message.append(':');
        this.message.append(nArray[4]);
        this.message.append(':');
        this.message.append(nArray[5]);
        this.message.append('.');
        this.message.append(nArray[6]);
        this.message.append((char)nArray[7]);
        return this.message.toString();
    }

    protected void reportError(String string, String string2) {
        System.err.println("[Error]: " + string + ": Value  '" + string2 + "' is not legal for current datatype");
    }

    private void cloneDate(int[] nArray) {
        this.resetDateObj(this.fTempDate);
        int n = 0;
        while (n < 8) {
            this.fTempDate[n] = nArray[n];
            ++n;
        }
    }
}

