/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs_new;

import java.math.BigDecimal;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs_new.TypeValidator;
import org.apache.xerces.impl.validation.ValidationContext;

public class DecimalDV
extends TypeValidator {
    public short getAllowedFacets() {
        return 4088;
    }

    public Object getActualValue(String string, ValidationContext validationContext) throws InvalidDatatypeValueException {
        try {
            return new BigDecimal(DecimalDV.stripPlusIfPresent(string));
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException("'" + string + "' is not a valid decimal value");
        }
    }

    public boolean isEqual(Object object, Object object2) {
        if (!(object instanceof BigDecimal) || !(object2 instanceof BigDecimal)) {
            return false;
        }
        return ((BigDecimal)object).compareTo((BigDecimal)object2) == 0;
    }

    public int compare(Object object, Object object2) {
        return ((BigDecimal)object).compareTo((BigDecimal)object2);
    }

    public int getTotalDigits(Object object) {
        return ((BigDecimal)object).movePointRight(((BigDecimal)object).scale()).toString().length() - (((BigDecimal)object).signum() < 0 ? 1 : 0);
    }

    public int getFractionDigits(Object object) {
        return ((BigDecimal)object).scale();
    }

    private static String stripPlusIfPresent(String string) {
        String string2 = string;
        if (string.length() >= 2 && string.charAt(0) == '+' && string.charAt(1) != '-') {
            string2 = string.substring(1);
        }
        return string2;
    }
}

