/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeUse;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;

class XSDAttributeTraverser
extends XSDAbstractTraverser {
    public XSDAttributeTraverser(XSDHandler xSDHandler, XSAttributeChecker xSAttributeChecker) {
        super(xSDHandler, xSAttributeChecker);
    }

    protected XSAttributeUse traverseLocal(Element element, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, false, xSDocumentInfo);
        String string = (String)objectArray[XSAttributeChecker.ATTIDX_DEFAULT];
        String string2 = (String)objectArray[XSAttributeChecker.ATTIDX_FIXED];
        String string3 = (String)objectArray[XSAttributeChecker.ATTIDX_NAME];
        QName qName = (QName)objectArray[XSAttributeChecker.ATTIDX_REF];
        XInt xInt = (XInt)objectArray[XSAttributeChecker.ATTIDX_USE];
        XSAttributeDecl xSAttributeDecl = null;
        if (element.getAttributeNode(SchemaSymbols.ATT_REF) != null) {
            if (qName != null) {
                xSAttributeDecl = (XSAttributeDecl)this.fSchemaHandler.getGlobalDecl(xSDocumentInfo, 1, qName);
                Element element2 = DOMUtil.getFirstChildElement(element);
                if (element2 != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    this.traverseAnnotationDecl(element2, objectArray, false, xSDocumentInfo);
                    element2 = DOMUtil.getNextSiblingElement(element2);
                }
                if (element2 != null) {
                    this.reportSchemaError("src-attribute.3.2", new Object[]{qName});
                }
                string3 = qName.localpart;
            } else {
                xSAttributeDecl = null;
            }
        } else {
            xSAttributeDecl = this.traverseNamedAttr(element, objectArray, xSDocumentInfo, schemaGrammar, false);
        }
        int n = 0;
        if (string != null) {
            n = 1;
        } else if (string2 != null) {
            n = 2;
            string = string2;
            string2 = null;
        }
        XSAttributeUse xSAttributeUse = null;
        if (xSAttributeDecl != null) {
            xSAttributeUse = new XSAttributeUse();
            xSAttributeUse.fAttrDecl = xSAttributeDecl;
            xSAttributeUse.fUse = xInt.shortValue();
            xSAttributeUse.fConstraintType = (short)n;
            if (string != null) {
                xSAttributeUse.fDefault = new ValidatedInfo();
                xSAttributeUse.fDefault.normalizedValue = string;
            }
        }
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        if (string != null && string2 != null) {
            this.reportSchemaError("src-attribute.1", new Object[]{string3});
        }
        if (n == 1 && xInt != null && xInt.intValue() != 0) {
            this.reportSchemaError("src-attribute.2", new Object[]{string3});
        }
        if (string != null && xSAttributeUse != null) {
            this.fValidationState.setNamespaceSupport(xSDocumentInfo.fNamespaceSupport);
            if (!this.checkDefaultValid(xSAttributeUse)) {
                this.reportSchemaError("a-props-correct.2", new Object[]{string3, string});
            }
            if (xSAttributeDecl.fType.isIDType()) {
                this.reportSchemaError("a-props-correct.3", new Object[]{string3});
            }
            if (xSAttributeUse.fAttrDecl.getConstraintType() == 2 && xSAttributeUse.fConstraintType != 0 && (xSAttributeUse.fConstraintType != 2 || xSAttributeUse.fAttrDecl.fType.isEqual(xSAttributeUse.fAttrDecl.fDefault.actualValue, xSAttributeUse.fDefault.actualValue))) {
                this.reportSchemaError("au-props-correct.2", new Object[]{string3});
            }
        }
        return xSAttributeUse;
    }

    protected XSAttributeDecl traverseGlobal(Element element, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, true, xSDocumentInfo);
        XSAttributeDecl xSAttributeDecl = this.traverseNamedAttr(element, objectArray, xSDocumentInfo, schemaGrammar, true);
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        if (xSAttributeDecl != null) {
            xSAttributeDecl.setIsGlobal();
        }
        return xSAttributeDecl;
    }

    XSAttributeDecl traverseNamedAttr(Element element, Object[] objectArray, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar, boolean bl) {
        Object object;
        Element element2;
        String string = (String)objectArray[XSAttributeChecker.ATTIDX_DEFAULT];
        String string2 = (String)objectArray[XSAttributeChecker.ATTIDX_FIXED];
        XInt xInt = (XInt)objectArray[XSAttributeChecker.ATTIDX_FORM];
        String string3 = (String)objectArray[XSAttributeChecker.ATTIDX_NAME];
        QName qName = (QName)objectArray[XSAttributeChecker.ATTIDX_TYPE];
        XSAttributeDecl xSAttributeDecl = new XSAttributeDecl();
        if (string3 != null) {
            xSAttributeDecl.fName = this.fSymbolTable.addSymbol(string3);
        }
        xSAttributeDecl.fTargetNamespace = bl ? xSDocumentInfo.fTargetNamespace : (xInt != null ? (xInt.intValue() == 1 ? xSDocumentInfo.fTargetNamespace : null) : (xSDocumentInfo.fAreLocalAttributesQualified ? xSDocumentInfo.fTargetNamespace : null));
        if (bl) {
            if (string2 != null) {
                xSAttributeDecl.fDefault = new ValidatedInfo();
                xSAttributeDecl.fDefault.normalizedValue = string2;
                xSAttributeDecl.setConstraintType((short)2);
            } else if (string != null) {
                xSAttributeDecl.fDefault = new ValidatedInfo();
                xSAttributeDecl.fDefault.normalizedValue = string;
                xSAttributeDecl.setConstraintType((short)1);
            } else {
                xSAttributeDecl.setConstraintType((short)0);
            }
        }
        if ((element2 = DOMUtil.getFirstChildElement(element)) != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(element2, objectArray, false, xSDocumentInfo);
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
        XSSimpleType xSSimpleType = null;
        boolean bl2 = false;
        if (element2 != null && ((String)(object = DOMUtil.getLocalName(element2))).equals(SchemaSymbols.ELT_SIMPLETYPE)) {
            xSSimpleType = this.fSchemaHandler.fSimpleTypeTraverser.traverseLocal(element2, xSDocumentInfo, schemaGrammar);
            bl2 = true;
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
        if (xSSimpleType == null && qName != null) {
            object = (XSTypeDecl)this.fSchemaHandler.getGlobalDecl(xSDocumentInfo, 7, qName);
            if (object != null && object.getXSType() == 2) {
                xSSimpleType = (XSSimpleType)object;
            } else {
                this.reportGenericSchemaError("the type for attribute '" + string3 + "' must be a simpleType");
            }
        }
        if (xSSimpleType == null) {
            xSSimpleType = SchemaGrammar.fAnySimpleType;
        }
        xSAttributeDecl.fType = xSSimpleType;
        if (bl && string3 != null) {
            schemaGrammar.addGlobalAttributeDecl(xSAttributeDecl);
        }
        if (string3 == null) {
            if (bl) {
                this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_ATTRIBUTE, SchemaSymbols.ATT_NAME});
            } else {
                this.reportSchemaError("src-attribute.3.1", null);
            }
            string3 = "(no name)";
        }
        if (element2 != null) {
            this.reportSchemaError("s4s-elt-must-match", new Object[]{string3, "(annotation?, (simpleType?))"});
        }
        if (string != null && string2 != null) {
            this.reportSchemaError("src-attribute.1", new Object[]{string3});
        }
        if (bl2 && qName != null) {
            this.reportSchemaError("src-attribute.4", new Object[]{string3});
        }
        this.checkNotationType(string3, xSSimpleType);
        if (xSAttributeDecl.fDefault != null) {
            this.fValidationState.setNamespaceSupport(xSDocumentInfo.fNamespaceSupport);
            if (!this.checkDefaultValid(xSAttributeDecl)) {
                this.reportSchemaError("a-props-correct.2", new Object[]{string3, string});
            }
        }
        if (xSAttributeDecl.fDefault != null && xSSimpleType.isIDType()) {
            this.reportSchemaError("a-props-correct.3", new Object[]{string3});
        }
        if (string3 != null && string3.equals(SchemaSymbols.XMLNS)) {
            this.reportSchemaError("no-xmlns", null);
        }
        if (xSAttributeDecl.fTargetNamespace != null && xSAttributeDecl.fTargetNamespace.equals("http://www.w3.org/2001/XMLSchema-instance")) {
            this.reportSchemaError("no-xsi", new Object[]{"http://www.w3.org/2001/XMLSchema-instance"});
        }
        return xSAttributeDecl;
    }

    boolean checkDefaultValid(XSAttributeDecl xSAttributeDecl) {
        boolean bl = true;
        try {
            xSAttributeDecl.fType.validate(xSAttributeDecl.fDefault.normalizedValue, this.fValidationState, xSAttributeDecl.fDefault);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            bl = false;
        }
        return bl;
    }

    boolean checkDefaultValid(XSAttributeUse xSAttributeUse) {
        boolean bl = true;
        try {
            xSAttributeUse.fAttrDecl.fType.validate(xSAttributeUse.fDefault.normalizedValue, this.fValidationState, xSAttributeUse.fDefault);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            bl = false;
        }
        return bl;
    }
}

