/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSNotationDecl;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.util.DOMUtil;
import org.w3c.dom.Element;

class XSDNotationTraverser
extends XSDAbstractTraverser {
    XSDNotationTraverser(XSDHandler xSDHandler, XSAttributeChecker xSAttributeChecker) {
        super(xSDHandler, xSAttributeChecker);
    }

    XSNotationDecl traverse(Element element, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, true, xSDocumentInfo);
        String string = (String)objectArray[XSAttributeChecker.ATTIDX_NAME];
        String string2 = (String)objectArray[XSAttributeChecker.ATTIDX_PUBLIC];
        String string3 = (String)objectArray[XSAttributeChecker.ATTIDX_SYSTEM];
        if (string == null) {
            this.reportGenericSchemaError("<notation> must have a name");
            this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
            return null;
        }
        if (string2 == null) {
            this.reportGenericSchemaError("<notation> must have 'public' attribute");
        }
        XSNotationDecl xSNotationDecl = new XSNotationDecl();
        xSNotationDecl.fName = string;
        xSNotationDecl.fTargetNamespace = xSDocumentInfo.fTargetNamespace;
        xSNotationDecl.fPublicId = string2;
        xSNotationDecl.fSystemId = string3;
        Element element2 = DOMUtil.getFirstChildElement(element);
        if (element2 != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(element2, objectArray, false, xSDocumentInfo);
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
        if (element2 != null) {
            Object[] objectArray2 = new Object[]{DOMUtil.getLocalName(element2)};
            this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "NotationContentRestricted", objectArray2, (short)1);
        }
        schemaGrammar.addGlobalNotationDecl(xSNotationDecl);
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        return xSNotationDecl;
    }
}

