/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.xni.parser;

import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;

public class XMLParseException
extends XNIException {
    protected String fPublicId;
    protected String fSystemId;
    protected String fBaseSystemId;
    protected int fLineNumber = -1;
    protected int fColumnNumber = -1;

    public XMLParseException(XMLLocator xMLLocator, String string) {
        super(string);
        if (xMLLocator != null) {
            this.fPublicId = xMLLocator.getPublicId();
            this.fSystemId = xMLLocator.getSystemId();
            this.fBaseSystemId = xMLLocator.getBaseSystemId();
            this.fLineNumber = xMLLocator.getLineNumber();
            this.fColumnNumber = xMLLocator.getColumnNumber();
        }
    }

    public XMLParseException(XMLLocator xMLLocator, String string, Exception exception) {
        super(string, exception);
        this.fPublicId = xMLLocator.getPublicId();
        this.fSystemId = xMLLocator.getSystemId();
        this.fBaseSystemId = xMLLocator.getBaseSystemId();
        this.fLineNumber = xMLLocator.getLineNumber();
        this.fColumnNumber = xMLLocator.getColumnNumber();
    }

    public String getPublicId() {
        return this.fPublicId;
    }

    public String getSystemId() {
        return this.fSystemId;
    }

    public String getBaseSystemId() {
        return this.fBaseSystemId;
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public int getColumnNumber() {
        return this.fColumnNumber;
    }

    public String toString() {
        Exception exception;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.fPublicId != null) {
            stringBuffer.append(this.fPublicId);
        }
        stringBuffer.append(':');
        if (this.fPublicId != null) {
            stringBuffer.append(this.fPublicId);
        }
        stringBuffer.append(':');
        if (this.fSystemId != null) {
            stringBuffer.append(this.fSystemId);
        }
        stringBuffer.append(':');
        if (this.fBaseSystemId != null) {
            stringBuffer.append(this.fBaseSystemId);
        }
        stringBuffer.append(':');
        stringBuffer.append(this.fLineNumber);
        stringBuffer.append(':');
        stringBuffer.append(this.fColumnNumber);
        stringBuffer.append(':');
        String string = this.getMessage();
        if (string == null && (exception = this.getException()) != null) {
            string = exception.getMessage();
        }
        if (string != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

