/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cvsclient.commands;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.modules.javacvs.util.Debug;
import org.netbeans.modules.vcscore.util.table.ColumnSortListener;
import org.netbeans.modules.vcscore.util.table.FileComparator;
import org.netbeans.modules.vcscore.util.table.TableInfoComparator;
import org.netbeans.modules.vcscore.util.table.TableInfoModel;
import org.openide.awt.SplittedPanel;
import org.openide.util.NbBundle;

public abstract class AbstractTreeInfoPanel
extends JPanel
implements TreeCellRenderer {
    private Debug E;
    private Debug D;
    protected String DEFAULT_FOLDER;
    protected String DEFAULT_OPEN_FOLDER;
    protected String DEFAULT_FILE;
    protected File topDirectory;
    private ArrayList files;
    private ArrayList filesBackup;
    protected TreeCellRenderer insideTreeRenderer;
    private boolean treeDisabled;
    private JPanel pnlStatus;
    private JPanel pnlTree;
    private JPanel pnlButtons;
    private JTabbedPane jTabbedPane1;
    private JScrollPane jScrollPane1;
    private JTree trDirStructure;
    private JScrollPane jScrollPane2;
    private SplittedPanel split;
    protected JTable tblTable;
    static /* synthetic */ Class class$org$netbeans$modules$cvsclient$commands$AbstractTreeInfoPanel;
    static /* synthetic */ Class class$org$netbeans$lib$cvsclient$command$FileInfoContainer;

    public AbstractTreeInfoPanel(File file) {
        this();
        this.topDirectory = file;
        this.insideTreeRenderer = new DefaultTreeCellRenderer();
        this.trDirStructure.setCellRenderer(this);
        this.trDirStructure.putClientProperty("JTree.lineStyle", "Angled");
        this.treeDisabled = false;
    }

    public void postInit() {
        this.pnlStatus.add((Component)this.initPanel(), "Center");
        this.split.setSplitDragable(true);
        this.split.setSplitAbsolute(false);
        this.split.setSplitTypeChangeEnabled(true);
        this.split.setSplitPosition(30);
    }

    public AbstractTreeInfoPanel() {
        this.D = this.E = new Debug("AbstractTreeInfoPanel", true);
        this.DEFAULT_FOLDER = "/org/openide/resources/defaultFolder.gif";
        this.DEFAULT_OPEN_FOLDER = "/org/openide/resources/defaultFolderOpen.gif";
        this.DEFAULT_FILE = "/org/openide/resources/defaultNode.gif";
        this.initComponents();
        this.split = new SplittedPanel();
        this.split.add((Component)this.initTree(), SplittedPanel.ADD_LEFT);
        this.split.add((Component)this.initRightPanel(), SplittedPanel.ADD_RIGHT);
        this.add((Component)this.split, "Center");
        this.tblTable.setSelectionMode(0);
        this.tblTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AbstractTreeInfoPanel.this.tblTableValueChanged(listSelectionEvent);
            }
        });
        this.treeDisabled = true;
    }

    private JComponent initTree() {
        this.pnlTree = new JPanel();
        this.pnlButtons = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.trDirStructure = new JTree();
        this.jScrollPane2 = new JScrollPane();
        this.tblTable = new JTable();
        this.pnlTree.setLayout(new BorderLayout());
        this.pnlTree.setPreferredSize(new Dimension(200, 300));
        this.pnlTree.setMinimumSize(new Dimension(200, 300));
        this.pnlButtons.setLayout(new BoxLayout(this.pnlButtons, 0));
        this.pnlTree.add((Component)this.pnlButtons, "North");
        this.jTabbedPane1.setTabPlacement(3);
        this.jTabbedPane1.setPreferredSize(new Dimension(500, 400));
        this.jScrollPane1.setMinimumSize(new Dimension(100, 70));
        this.jScrollPane1.setVerticalScrollBar(new JScrollBar(1));
        this.jScrollPane1.setHorizontalScrollBar(new JScrollBar(0));
        this.trDirStructure.setShowsRootHandles(true);
        this.trDirStructure.setMinimumSize(new Dimension(80, 60));
        this.trDirStructure.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                AbstractTreeInfoPanel.this.trDirStructureValueChanged(treeSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.trDirStructure);
        String string = NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$commands$AbstractTreeInfoPanel == null ? (class$org$netbeans$modules$cvsclient$commands$AbstractTreeInfoPanel = AbstractTreeInfoPanel.class$("org.netbeans.modules.cvsclient.commands.AbstractTreeInfoPanel")) : class$org$netbeans$modules$cvsclient$commands$AbstractTreeInfoPanel)).getString("AbstractTreeInfoPanel.treeTitle");
        this.jTabbedPane1.addTab(string, this.jScrollPane1);
        this.tblTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}){
            Class[] types = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = 3.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = 3.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = 3.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = 3.class$("java.lang.Object")) : class$java$lang$Object};
            static /* synthetic */ Class class$java$lang$Object;

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        this.jScrollPane2.setViewportView(this.tblTable);
        String string2 = NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$commands$AbstractTreeInfoPanel == null ? (class$org$netbeans$modules$cvsclient$commands$AbstractTreeInfoPanel = AbstractTreeInfoPanel.class$("org.netbeans.modules.cvsclient.commands.AbstractTreeInfoPanel")) : class$org$netbeans$modules$cvsclient$commands$AbstractTreeInfoPanel)).getString("AbstractTreeInfoPanel.tableTitle");
        this.jTabbedPane1.addTab(string2, this.jScrollPane2);
        this.pnlTree.add((Component)this.jTabbedPane1, "Center");
        return this.pnlTree;
    }

    public JComponent initRightPanel() {
        this.pnlStatus = new JPanel();
        this.pnlStatus.setLayout(new BorderLayout());
        return this.pnlStatus;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private void lstTableValueChanged(ListSelectionEvent listSelectionEvent) {
    }

    private void tblTableValueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.tblTable.getSelectedRow();
        TableInfoModel tableInfoModel = (TableInfoModel)this.tblTable.getModel();
        FileInfoContainer fileInfoContainer = (FileInfoContainer)tableInfoModel.getElementAt(n);
        if (fileInfoContainer != null) {
            this.setPanel(fileInfoContainer);
        } else {
            this.setClearPanel();
        }
    }

    private void trDirStructureValueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof File) {
            this.setClearPanel();
        } else {
            this.setPanel(object);
        }
    }

    private void dirStructureValueChanged(TreeSelectionEvent treeSelectionEvent) {
    }

    protected void disableTree() {
        this.treeDisabled = true;
        this.jTabbedPane1.remove(this.jScrollPane1);
        this.repaint();
    }

    protected boolean isTreeDisabled() {
        return this.treeDisabled;
    }

    protected JPanel getButtonPanel() {
        return this.pnlButtons;
    }

    protected void recreateModel() {
        this.files = new ArrayList(this.filesBackup);
        this.tblTable.clearSelection();
        TableInfoModel tableInfoModel = (TableInfoModel)this.createTable();
        this.tblTable.setModel((TableModel)tableInfoModel);
        if (!this.isTreeDisabled()) {
            this.trDirStructure.setModel(new DefaultTreeModel(this.createTree(this.topDirectory)));
        }
    }

    protected abstract void setPanel(Object var1);

    protected abstract void setClearPanel();

    protected abstract JComponent initPanel();

    protected TableInfoModel createTableModel() {
        TableInfoModel tableInfoModel = new TableInfoModel();
        Class clazz = class$org$netbeans$lib$cvsclient$command$FileInfoContainer == null ? (class$org$netbeans$lib$cvsclient$command$FileInfoContainer = AbstractTreeInfoPanel.class$("org.netbeans.lib.cvsclient.command.FileInfoContainer")) : class$org$netbeans$lib$cvsclient$command$FileInfoContainer;
        String string = NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$commands$AbstractTreeInfoPanel == null ? (class$org$netbeans$modules$cvsclient$commands$AbstractTreeInfoPanel = AbstractTreeInfoPanel.class$("org.netbeans.modules.cvsclient.commands.AbstractTreeInfoPanel")) : class$org$netbeans$modules$cvsclient$commands$AbstractTreeInfoPanel)).getString("TableInfoModel.fileName");
        try {
            Method method = clazz.getMethod("getFile", null);
            tableInfoModel.setColumnDefinition(0, string, method, true, (TableInfoComparator)new FileComparator());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Thread.dumpStack();
        }
        catch (SecurityException securityException) {
            Thread.dumpStack();
        }
        return tableInfoModel;
    }

    private DefaultMutableTreeNode createTree(File file) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(file);
        this.recursiveTreeNodes(defaultMutableTreeNode);
        this.addFiles(defaultMutableTreeNode);
        return defaultMutableTreeNode;
    }

    private TableModel createTable() {
        TableInfoModel tableInfoModel = this.createTableModel();
        Iterator iterator = ((AbstractList)this.files).iterator();
        while (iterator.hasNext()) {
            FileInfoContainer fileInfoContainer = (FileInfoContainer)iterator.next();
            if (!this.addToList(fileInfoContainer)) continue;
            tableInfoModel.addElement((Object)fileInfoContainer);
        }
        return tableInfoModel;
    }

    private void recursiveTreeNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        File file = (File)defaultMutableTreeNode.getUserObject();
        boolean bl = false;
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file2;
            if (fileArray[n].isDirectory() && fileArray[n].exists() && !(file2 = fileArray[n]).getName().equals("CVS")) {
                bl = true;
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new File(file2.getAbsolutePath()));
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                this.recursiveTreeNodes(defaultMutableTreeNode2);
            }
            ++n;
        }
    }

    private void addFiles(DefaultMutableTreeNode defaultMutableTreeNode) {
        Serializable serializable;
        Object object;
        if (defaultMutableTreeNode.getChildCount() > 0) {
            object = defaultMutableTreeNode.children();
            while (object.hasMoreElements()) {
                serializable = (DefaultMutableTreeNode)object.nextElement();
                this.addFiles((DefaultMutableTreeNode)serializable);
            }
        }
        if (this.files == null) {
            return;
        }
        object = ((AbstractList)this.files).iterator();
        serializable = (File)defaultMutableTreeNode.getUserObject();
        String string = ((File)serializable).getAbsolutePath();
        while (object.hasNext()) {
            FileInfoContainer fileInfoContainer = (FileInfoContainer)object.next();
            String string2 = fileInfoContainer.getFile().getParentFile().getAbsolutePath();
            if (!string2.equals(string)) continue;
            this.addFileNode(fileInfoContainer, defaultMutableTreeNode);
            object.remove();
        }
    }

    protected void addFileNode(FileInfoContainer fileInfoContainer, DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(fileInfoContainer);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    protected boolean addToList(FileInfoContainer fileInfoContainer) {
        return true;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Component component = this.insideTreeRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        if (component instanceof JLabel) {
            Object object2;
            JLabel jLabel = (JLabel)component;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            if (defaultMutableTreeNode != null && (object2 = defaultMutableTreeNode.getUserObject()) != null) {
                if (object2 instanceof File) {
                    jLabel.setText(((File)object2).getName());
                    if (!bl2) {
                        URL uRL = this.getClass().getResource(this.DEFAULT_FOLDER);
                        jLabel.setIcon(new ImageIcon(uRL));
                    } else {
                        URL uRL = this.getClass().getResource(this.DEFAULT_OPEN_FOLDER);
                        jLabel.setIcon(new ImageIcon(uRL));
                    }
                } else if (object2 instanceof FileInfoContainer) {
                    FileInfoContainer fileInfoContainer = (FileInfoContainer)object2;
                    jLabel.setText(fileInfoContainer.getFile().getName());
                    URL uRL = this.getClass().getResource(this.DEFAULT_FILE);
                    jLabel.setIcon(new ImageIcon(uRL));
                }
            }
        }
        return component;
    }

    public void setDataToDisplay(Collection collection) {
        this.filesBackup = new ArrayList(collection);
        this.recreateModel();
        JTableHeader jTableHeader = this.tblTable.getTableHeader();
        jTableHeader.setUpdateTableInRealTime(true);
        ColumnSortListener columnSortListener = new ColumnSortListener(this.tblTable);
        jTableHeader.addMouseListener((MouseListener)columnSortListener);
    }

    public void displayOutputData(int n, Object object) {
    }

    public void closeNotify() {
        Object object;
        this.files = null;
        this.filesBackup = null;
        if (this.tblTable.getModel() instanceof TableInfoModel) {
            object = (TableInfoModel)this.tblTable.getModel();
            object.clear();
        }
        object = (DefaultMutableTreeNode)this.trDirStructure.getModel().getRoot();
        ((DefaultMutableTreeNode)object).setUserObject(null);
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)object).depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            defaultMutableTreeNode.setUserObject(null);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

