/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.netbeans.modules.classfile.CPUTF8Info;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.ExceptionTableEntry;
import org.netbeans.modules.classfile.LocalVariableTableEntry;

public final class Code {
    private int maxStack;
    private int maxLocals;
    private byte[] byteCodes;
    private ExceptionTableEntry[] exceptionTable;
    private int[] lineNumberTable;
    private LocalVariableTableEntry[] localVariableTable;

    Code(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        if (dataInputStream == null) {
            throw new IllegalArgumentException("input stream not specified");
        }
        if (constantPool == null) {
            throw new IllegalArgumentException("constant pool not specified");
        }
        this.loadCode(dataInputStream, constantPool);
    }

    private void loadCode(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this.maxStack = dataInputStream.readUnsignedShort();
        this.maxLocals = dataInputStream.readUnsignedShort();
        int n = dataInputStream.readInt();
        this.byteCodes = new byte[n];
        dataInputStream.readFully(this.byteCodes);
        this.exceptionTable = ExceptionTableEntry.loadExceptionTable(dataInputStream, constantPool);
        this.loadCodeAttributes(dataInputStream, constantPool);
    }

    private void loadCodeAttributes(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        int n2 = 0;
        while (n2 < n) {
            CPUTF8Info cPUTF8Info = (CPUTF8Info)constantPool.get(dataInputStream.readUnsignedShort());
            int n3 = dataInputStream.readInt();
            String string = cPUTF8Info.getName();
            if (string.equals("LineNumberTable")) {
                this.loadLineNumberTable(dataInputStream, constantPool);
            } else if (string.equals("LocalVariableTable")) {
                this.localVariableTable = LocalVariableTableEntry.loadLocalVariableTable(dataInputStream, constantPool);
            } else {
                System.out.println("skipped unknown code attribute: " + string);
                ClassFile.skip(dataInputStream, n3);
            }
            ++n2;
        }
    }

    private void loadLineNumberTable(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        this.lineNumberTable = new int[n * 2];
        int n2 = 0;
        while (n2 < n) {
            this.lineNumberTable[n2 * 2] = dataInputStream.readUnsignedShort();
            this.lineNumberTable[n2 * 2 + 1] = dataInputStream.readUnsignedShort();
            ++n2;
        }
    }

    public final int getMaxStack() {
        return this.maxStack;
    }

    public final int getMaxLocals() {
        return this.maxLocals;
    }

    public final byte[] getByteCodes() {
        return this.byteCodes;
    }

    public final ExceptionTableEntry[] getExceptionTable() {
        return this.exceptionTable;
    }

    public final int[] getLineNumberTable() {
        return this.lineNumberTable;
    }

    public final LocalVariableTableEntry[] getLocalVariableTable() {
        return this.localVariableTable;
    }
}

