/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.netbeans.modules.classfile.Access;
import org.netbeans.modules.classfile.CPUTF8Info;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ConstantPool;

public abstract class Field {
    CPUTF8Info utfName;
    CPUTF8Info utfType;
    private String _name;
    private String _type;
    int access;
    ClassFile classFile;
    private boolean deprecated = false;
    private boolean synthetic = false;

    Field(DataInputStream dataInputStream, ConstantPool constantPool, ClassFile classFile) throws IOException {
        this.access = dataInputStream.readUnsignedShort();
        this.classFile = classFile;
        Object object = null;
        try {
            this.utfName = (CPUTF8Info)constantPool.get(dataInputStream.readUnsignedShort());
            this.utfType = (CPUTF8Info)constantPool.get(dataInputStream.readUnsignedShort());
        }
        catch (ClassCastException classCastException) {
            System.out.println("error looking up constant pool entry: wanted type CPUTF8Info, got " + object.getClass().getName() + "; e=" + classCastException);
            classCastException.printStackTrace();
            throw new IOException("internal error");
        }
    }

    final void loadAttributes(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        int n2 = 0;
        while (n2 < n) {
            CPUTF8Info cPUTF8Info = (CPUTF8Info)constantPool.get(dataInputStream.readUnsignedShort());
            int n3 = dataInputStream.readInt();
            String string = cPUTF8Info.getName();
            if (string.equals("Deprecated")) {
                this.deprecated = true;
            } else if (string.equals("Synthetic")) {
                this.synthetic = true;
            } else if (!this.loadAttribute(string, n3, dataInputStream, constantPool)) {
                ClassFile.skip(dataInputStream, n3);
            }
            ++n2;
        }
    }

    abstract boolean loadAttribute(String var1, int var2, DataInputStream var3, ConstantPool var4) throws IOException;

    public final String getName() {
        if (this._name == null) {
            this._name = this.utfName.getName();
            this.utfName = null;
        }
        return this._name;
    }

    public final String getDescriptor() {
        if (this._type == null) {
            this._type = this.utfType.getName();
            this.utfType = null;
        }
        return this._type;
    }

    public abstract String getDeclaration();

    public final int getAccess() {
        return this.access;
    }

    public final boolean isStatic() {
        return Access.isStatic(this.access);
    }

    public final boolean isPublic() {
        return Access.isPublic(this.access);
    }

    public final boolean isProtected() {
        return Access.isProtected(this.access);
    }

    public final boolean isPackagePrivate() {
        return Access.isPackagePrivate(this.access);
    }

    public final boolean isPrivate() {
        return Access.isPrivate(this.access);
    }

    public final boolean isDeprecated() {
        return this.deprecated;
    }

    public final boolean isSynthetic() {
        return this.synthetic;
    }

    public final ClassFile getClassFile() {
        return this.classFile;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName());
        if (this.synthetic) {
            stringBuffer.append(" (synthetic)");
        }
        if (this.deprecated) {
            stringBuffer.append(" (deprecated)");
        }
        stringBuffer.append(" type=");
        stringBuffer.append(this.getDescriptor());
        stringBuffer.append(", access=");
        stringBuffer.append(Access.toString(this.access));
        return stringBuffer.toString();
    }
}

